PATH_PROJECT = "D:/test1/DSP-CODE/DSS_Example2"; //·
PATH_OUT_FILE = (PATH_PROJECT + "/Debug/DSS_Example2.out"); //outļ·
PATH_CFG_FILE = (PATH_PROJECT + "/DSS_Example2.ccxml"); //ļ·
PATH_EnvMainProc = (PATH_PROJECT + "/hello.c"); //Դļ·

// ֧DSSе
importPackage(Packages.com.ti.debug.engine.scripting)
importPackage(Packages.com.ti.ccstudio.scripting.environment)
importPackage(Packages.com.ti.dvt.engine.scripting)
importPackage(Packages.java.lang)

// DSSж
script = ScriptingEnvironment.instance()

// Change timeout from the default (infinite) to 10 seconds
script.setScriptTimeout(20000);

// Create a log file in the current directory to log script execution
script.traceBegin("Run_DspProj_Dss_Log.xml", "DefaultStylesheet.xsl")

// Log everything
script.traceSetConsoleLevel(TraceLevel.ALL)
script.traceSetFileLevel(TraceLevel.ALL)

// Get the Debug Server and start a Debug Session
debugServer = script.getServer("DebugServer.1");
debugServer.setConfig(PATH_CFG_FILE);
debugSession = debugServer.openSession(".*");

dvtServer = script.getServer("DVTServer.1");
var profileAnalysisSession = dvtServer.openProfileAnalysisSession(debugSession, "CoverageProfile");

//profile
myProfileActivity = debugSession.profileSetup.getActivity("Collect Code Coverage and Exclusive Profile Data");
myProfileActivity.setStatus(true);

// жӵĿǷȷ 0x64 
if(debugSession.getMajorISA()!= 0x64) 
{
	//Requires a C64x (for now)
	script.traceSetConsoleLevel(TraceLevel.INFO)
	script.traceWrite("Test requires a C64x!")
	script.traceWrite("TEST FAILED!")
	script.traceEnd()
	java.lang.System.exit(1);
}
else
{
	script.traceWrite("ISA Correct!~~")
}

// Load a program 빤
debugSession.memory.loadProgram(PATH_OUT_FILE)
// ݵҪöϵ                                                         
var addressMain = debugSession.symbol.getAddress("main")                                                
var bp1 = debugSession.breakpoint.add(PATH_EnvMainProc, 51) //ָλüϵ

//ProfilepointProperties props;
var props = debugSession.breakpoint.createProperties();
props.setSourceLocation("Hardware Configuration.Location",PATH_EnvMainProc, 50)
props.setString("Miscellaneous.Name","Profile Control Point");
props.setString("Debugger Response.Action","Control Profiling");
props.setString("Debugger Response.Action.Type", "Terminate Profiling");     

var bp3 = debugSession.breakpoint.add(props);   

debugSession.profileSetup.printActivityList();
                                                        
//Restart, and go to main. If the target is configured to go to main on restart, then restarting
//should be sufficient. Otherwise we will need to also set a breakpoint at main and run to it.
//debugSession.target.restart()

var nPC = debugSession.expression.evaluate("PC")
if(nPC != addressMain)
{
	script.traceWrite("FAIlED: NOT Halted at correct location main")
	var bpMain = debugSession.breakpoint.add(addressMain)
	debugSession.target.run()
}
// жϳǷֹͣmain
var nPC = debugSession.expression.evaluate("PC")
if (nPC == addressMain)
{
	script.traceWrite("SUCCESS: Halted at correct location main")
	
}
else 
{
	script.traceWrite("FAIL: Expected halt at 0x"+Long.toHexString(main)+",actually halted at 0x"+Long.toHexString(nPC))
	script.traceSetConsoleLevel(TraceLevel.INFO)
	script.traceWrite("TEST FAILED!")
	script.traceEnd()
	java.lang.System.exit(1);
}

// Run again.  Should halt at Before DpdDataPreProc
debugSession.target.run()
var nPC = debugSession.expression.evaluate("PC")
//if(nPC != 0x800031A8)
if(nPC != 0x80005f40)
{
	script.traceWrite("FAIL: Dont Halted at correct location !!!")
}
else
{

	script.traceWrite("SUCCESS: Halted at Line 51~!!!")
	debugSession.profileSetup.printActivityList();
	profileAnalysisSession.waitUntilProfilingComplete();
	var exports = profileAnalysisSession.exportData();
	exports[0].save(PATH_PROJECT + "/myProfilingData.csv");
	//for (var i=0; i < exports.length; i++)
	//{
	//	var file = exports[i].save(PATH_PROJECT + exports[i].getName() + ".csv");
	//	System.out.println("Data exported to: " + file);
	//}
	script.traceWrite("Profile Success!!")
}

// All done

	profileAnalysisSession.terminate();
	dvtServer.stop();
			
	debugSession.terminate();
	debugServer.stop();
			
	script.traceEnd();
	System.err.println("DVTScript Done!");		
	System.exit(0);			
	java.lang.System.exit(1);

//function cnWait(second)
//{   
//  var startTime,endTimes,s;    
//  var d = new Date();    
//  startTime = d.getTime();    
//  while(true)
//  {   
//	  d = new Date();   
//	  endTime = d.getTime();   
//	  s = (endTime-startTime)/1000;   
//	  if (s >= second)break;
//	}   
//} 
