# ============================================================================
# Copyright (c) Texas Instruments Inc 2012
#
# Use of this software is controlled by the terms and conditions found in the
# license agreement under which this software has been supplied or provided.
# ============================================================================

IPNC_INSTALL_DIR    := $(shell pwd)/..

#SYSTEM := EVM
SYSTEM := IPNC

#IPNC_PLATFORM := DM365
IPNC_PLATFORM := DM368

#FILESYS_MODE := NFS
FILESYS_MODE := NAND

CONFIG :=

DVSDK_BASE_DIR 	  := $(IPNC_INSTALL_DIR)/dvsdk_ipnctools
IPNC_BASE_DIR 	  := $(IPNC_INSTALL_DIR)/ipnc_rdk

BUILD_TOOL_DIR 	  := $(DVSDK_BASE_DIR)/linux-devkit

include $(DVSDK_BASE_DIR)/Rules.make

BASE_DIR  	  := $(IPNC_BASE_DIR)/av_capture/build

FILESYS_BASE_DIR  := $(IPNC_BASE_DIR)/target
PSP_BASE_DIR 	  := $(DVSDK_BASE_DIR)/ipnc_psp_03_21_00_04

# The directory that points to the Linux Support Package
KERNELDIR 	:= $(PSP_BASE_DIR)/ti-davinci
KERNEL_CFGDIR 	:= $(KERNELDIR)/arch/arm/configs

# The directory that points to the u-boot Package
UBOOTDIR 	:= $(PSP_BASE_DIR)/u-boot

# The directory that points to where filesystem is mounted
TARGET_FS 	:= $(FILESYS_BASE_DIR)/filesys
UBIFS_PATH      := $(FILESYS_BASE_DIR)/mtd-utils

# Where to copy the resulting executables and data to (when executing 'make
# install') in a proper file structure. This EXEC_DIR should either be visible
# from the target, or you will have to copy this (whole) directory onto the
# target filesystem.
EXEC_DIR=$(TARGET_FS)/opt/ipnc

# The directory that points to the IPNC Application package
IPNC_DIR=$(IPNC_BASE_DIR)/ipnc_app

# The directory to application interface
IPNC_INTERFACE_DIR=$(IPNC_DIR)/interface

# The directory to application interface include files
PUBLIC_INCLUDE_DIR=$(IPNC_INTERFACE_DIR)/inc

# The directory to application interface library files
APP_LIB_DIR=$(IPNC_INTERFACE_DIR)/lib

# The directory to root file system
ROOT_FILE_SYS = $(TARGET_FS)

AEWB_LIBS :=

ifeq ($(SYSTEM), IPNC)
BOARD_ID := BOARD_AP_IPNC
#IMGS_ID := IMGS_MICRON_MT9P031_5MP
#IMGS_ID := IMGS_MICRON_MT9D131_2MP
IMGS_ID := IMGS_TVP514X
#IMGS_ID := IMGS_OV10630_1MP
#IMGS_ID := IMGS_MICRON_MT9M034_1.2MP
#IMGS_ID := IMGS_MICRON_MT9M031_1.2MP
#IMGS_ID := IMGS_OV2715_2MP
#IMGS_ID := IMGS_SONY_IMX035_1_3MP
#IMGS_ID := IMGS_SONY_IMX036_3MP
#IMGS_ID := IMGS_SONY_IMX104_1_3MP
#IMGS_ID := IMGS_SONY_IMX136_2_3MP
#IMGS_ID := IMGS_SONY_IMX122_2_3MP
#IMGS_ID := IMGS_AR0130_1.2MP
#IMGS_ID := IMGS_AR0330_3.1MP
#IMGS_ID := IMGS_AR0331_3.1MP
#IMGS_ID := IMGS_AR0331_3.1MP_WDR
#IMGS_ID := IMGS_PANASONIC_MN34041_2.1MP

AEWB_ID := AEWB_ENABLE
endif

ifeq ($(SYSTEM), EVM)
BOARD_ID := BOARD_TI_EVM
#IMGS_ID := IMGS_MICRON_MT9P031_5MP
#IMGS_ID := IMGS_MICRON_MT9D131_2MP
IMGS_ID := IMGS_TVP514X
AEWB_ID := AEWB_ENABLE
endif

ifeq ($(IPNC_PLATFORM), DM368)
HARDWARE := dm368
else
HARDWARE := dm365
endif

ifeq ($(FILESYS_MODE), NAND)
BUILD_CONFIG := nand
else
BUILD_CONFIG := nfs
endif

#Build warnings will be treated as errors for av_capture folder
TREAT_WARNINGS_AS_ERROR := no

TARGET_FS_DIR 	:= $(TARGET_FS)/opt/ipnc
TFTP_HOME 	:= $(IPNC_BASE_DIR)/tftp/$(HARDWARE)

export BUILD_TOOL_DIR
export IPNC_DIR
export PUBLIC_INCLUDE_DIR
export APP_LIB_DIR
export TARGET_FS
export SYSTEM
export LINUXKERNEL_INSTALL_DIR
export EXEC_DIR
export TARGET_FS_DIR
export SQUASHFS_PATH
export KERNELDIR
export UBOOTDIR
export BASE_DIR
export CONFIG
export DVSDK_BASE_DIR
export CMEM_INSTALL_DIR
export MVTOOL_PREFIX
export IMGS_ID
export BOARD_ID
export DVSDK_DEMOS_DIR
export AEWB_ID
export AEWB_LIBS
export FILESYS_MODE
export TFTP_HOME
export TREAT_WARNINGS_AS_ERROR
