#include <stdio.h>
#include <string.h>
#include <c6x.h>
#include <ti/csl/csl_psc.h>
#include <ti/csl/csl_pscAux.h>
#include <ti/csl/src/intc/csl_intc.h>
#include <ti/csl/tistdtypes.h>
#include <ti/csl/csl_cpIntcAux.h>

#include "typedef.h"
#include "tcp3dDrv.h"
#include "testvector_tc.h"
#include "testvector_hd.h"

/* Global variable declaration */
Uint32          glbCoreId;

void sysInit()
{   
	int error = 0;
    glbCoreId = DNUM;
    error += enable_tcp3dA();
    error += enable_tcp3dB();
    tcp3d_config (0);
    DEMO_initEDMA();
    DEMO_setupEDMA();
}
/*
 0 dummy REVT0   
 1 dummy REVT1   
 2 dummy TRIGGER 
 3 LINK_CFG0     
 4 LINK_LLR0     
 5 END_LLR0      
 6 LINK_CFG1     
 7 LINK_LLR1     
 8 END_LLR1      
 9 LINK_HD0      
10 END_HD0       
11 LINK_HD1      
12 END_HD1       
*/
#define LLR0_LINK_INDEX     (4)
#define LLR1_LINK_INDEX     (7)
#define HD0_LINK_INDEX      (9)
#define HD1_LINK_INDEX      (11)
#define TRIGGER_CH_INDEX    (2)

void test_tcp3d()
{
    Uint32  cblen, i, error;
    Uint8 * ptrByte1, * ptrByte2;
    Int8    tailBits[12];
    Int8    d0[4],d1[4],d2[4];
    EDMA_PARAM_SET_WORD * par;
    CSL_Edma3ChannelHandle  hEdmaCh;
    cblen = 5824;
    
    /* The tail bit sequence should be sys[0] */
    for( i = 0; i < 4; i++ )
    {
        d0[i] = tc_testvector[cblen*1+0+i];
        d1[i] = tc_testvector[cblen*2+4+i];
        d2[i] = tc_testvector[cblen*3+8+i];
    }

    /* prepare the TCP3d config */
    tailBits[0]  = d0[0];   //sys[0]
    tailBits[1]  = d1[0];   //par[0]
    tailBits[2]  = d2[0];   //sys[1]
    tailBits[3]  = d0[1];   //par[1]
    tailBits[4]  = d1[1];   //sys[2]
    tailBits[5]  = d2[1];   //par[2]
    tailBits[6]  = d0[2];   //sys1[0]
    tailBits[7]  = d1[2];   //par1[0]
    tailBits[8]  = d2[2];   //sys1[1]
    tailBits[9]  = d0[3];   //par1[1]
    tailBits[10] = d1[3];   //sys1[2]
    tailBits[11] = d2[3];   //par1[2]
    prepare_user_info ((BCP_userInfo *)tcp3d_cfg[0], tailBits, cblen);

    tailBits[0]  = -d0[0];   //sys[0]
    tailBits[1]  = -d1[0];   //par[0]
    tailBits[2]  = -d2[0];   //sys[1]
    tailBits[3]  = -d0[1];   //par[1]
    tailBits[4]  = -d1[1];   //sys[2]
    tailBits[5]  = -d2[1];   //par[2]
    tailBits[6]  = -d0[2];   //sys1[0]
    tailBits[7]  = -d1[2];   //par1[0]
    tailBits[8]  = -d2[2];   //sys1[1]
    tailBits[9]  = -d0[3];   //par1[1]
    tailBits[10] = -d1[3];   //sys1[2]
    tailBits[11] = -d2[3];   //par1[2]
    prepare_user_info ((BCP_userInfo *)tcp3d_cfg[1], tailBits, cblen);

    memset(tcp3d_hd,0xff,sizeof(tcp3d_hd));
    for( i = 0; i < (cblen*3+12); i++ )
    {
        tcp3d_llr[0][i] = tc_testvector[i];
        tcp3d_llr[1][i] = -tc_testvector[i];
    }
    
    /* setup LLR0 PaRAM fields aCnt, srcBidx, srcCidx */ 
    par = (EDMA_PARAM_SET_WORD *)DEMO_EdmaTbl[LLR0_LINK_INDEX].PaRAM_Addr;
    par->opt   |= 1<<23;  //itcchEn = 1
    par->abCnt |= cblen/2;
    par->bIdx  |= cblen/2;
    par->cIdx  |= cblen+4;
    
    /* setup LLR1 PaRAM fields aCnt, srcBidx, srcCidx */
    par = (EDMA_PARAM_SET_WORD *)DEMO_EdmaTbl[LLR1_LINK_INDEX].PaRAM_Addr;
    par->opt   |= 1<<23;  
    par->abCnt |= cblen/2;
    par->bIdx  |= cblen/2;
    par->cIdx  |= cblen+4;
    
    /* setup HD0 PaRAM field aCnt */
    par = (EDMA_PARAM_SET_WORD *)DEMO_EdmaTbl[HD0_LINK_INDEX].PaRAM_Addr;     
    par->opt   |= 1<<20;
    par->abCnt |= cblen/8;
    
    /* setup HD1 PaRAM field aCnt */
    par = (EDMA_PARAM_SET_WORD *)DEMO_EdmaTbl[HD1_LINK_INDEX].PaRAM_Addr;     
    par->opt   |= 1<<20;
    par->abCnt |= cblen/8;
    
    /* Trigger the EDMA */
    /* Trigger channel */ 
    hEdmaCh = (CSL_Edma3ChannelHandle)DEMO_EdmaTbl[TRIGGER_CH_INDEX].chHandler;
    CSL_edma3HwChannelControl(hEdmaCh,CSL_EDMA3_CMD_CHANNEL_SET,NULL);
    while( !(hEdmaCh->regs->TPCC_IPR&1) );
    
    CSL_edma3HwChannelControl(hEdmaCh,CSL_EDMA3_CMD_CHANNEL_SET,NULL);
    while( !(hEdmaCh->regs->TPCC_IPR&2) );
    error = 0;
    ptrByte1 = (Uint8 *)tcp3d_hd[0];
    ptrByte2 = (Uint8 *)tcp3d_hd[1];
    for( i = 0; i < (cblen/8); i++ )
    {
        if( hd_testvector[i] != ptrByte1[i] )
            error++;
        if( hd_testvector[i] != ((~ptrByte2[i])&0xff) )
        	error++;
    }
    if( error > 0 )
        printf("error %d\n",error);
    else
        printf("passed\n");
}

void main()
{
    sysInit();
    test_tcp3d();
    return;
}
