/*
 * GPIO_drv.h
 *
 *  Created on: 2012-7-5
 *      Author: ljy
 */

#ifndef GPIO_DRV_H_
#define GPIO_DRV_H_
	//#include "types.h"
    #define   GPIO_BASE_ADDR    0x02320000
    #define   BINTEN          (*(volatile unsigned int*)(GPIO_BASE_ADDR+0x08))
	#define   DIR             (*(volatile unsigned int*)(GPIO_BASE_ADDR+0x10))
	#define   OUT_DATA        (*(volatile unsigned int*)(GPIO_BASE_ADDR+0x14))
	#define   SET_DATA        (*(volatile unsigned int*)(GPIO_BASE_ADDR+0x18))
	#define   CLR_DATA        (*(volatile unsigned int*)(GPIO_BASE_ADDR+0x1c))
	#define   IN_DATA         (*(volatile unsigned int*)(GPIO_BASE_ADDR+0x20))
	#define   SET_RIS_TRIG    (*(volatile unsigned int*)(GPIO_BASE_ADDR+0x24))
    #define   CLR_RIS_TRIG    (*(volatile unsigned int*)(GPIO_BASE_ADDR+0x28))
	#define   SET_FAL_TRIG    (*(volatile unsigned int*)(GPIO_BASE_ADDR+0x2c))
    #define   CLR_FAL_TRIG    (*(volatile unsigned int*)(GPIO_BASE_ADDR+0x30))


    // GPIO operation
    #define   SET_OUT_DIR(a)   DIR&=~a;
    #define   SET_IN_DIR(a)    DIR|=a;
	//basic BIT
	#define		BIT_ALL	   (0xffff)
	//LED operation
	#define		SET_LED_DIR(num)	 SET_OUT_DIR(num)
	#define		LED_ON(num)          SET_DATA=num;
	#define 	LED_OFF(num)		 CLR_DATA=num;
    #define 	LED_FLASH(num)		 OUT_DATA^=num;
    //led
	#define		LED_ALL	   (0xffff)
    #define     LED0       (0x01<<0)
    #define     LED1       (0x01<<1)
    #define     LED2       (0x01<<2)
	#define     LED3       (0x01<<3)
	#define     LED4       (0x01<<4)
    #define     LED5       (0x01<<5)
    #define     LED6       (0x01<<6)
    #define     LED7       (0x01<<7)
    #define     LED8       (0x01<<8)
    #define     LED9       (0x01<<9)
    #define     LED10       (0x01<<10)
    #define     LED11       (0x01<<11)
    #define     LED12       (0x01<<12)
    #define     LED13       (0x01<<13)
    #define     LED14       (0x01<<14)
    #define     LED15       (0x01<<15)
#endif /* GPIO_DRV_H_ */
