

#include <stdio.h>
#include <ti/csl/csl_edma3.h>
#include <ti/csl/csl_edma3Aux.h>
#include <ti/csl/csl_cacheAux.h>
#include "GPIO_drv.h"
#include "TSC.h"
/**********************************************************************
 ************************** Global Variables **************************
 **********************************************************************/

/* Global Variables which are used to dump the TPCC register overlay in the 
 * debugger... */
CSL_TpccRegs*  gEDMACC0Regs  = (CSL_TpccRegs*)CSL_EDMA0CC_REGS;
CSL_TpccRegs*  gEDMACC1Regs  = (CSL_TpccRegs*)CSL_EDMA1CC_REGS;
CSL_TpccRegs*  gEDMACC2Regs  = (CSL_TpccRegs*)CSL_EDMA2CC_REGS;

#define N   (65536)
/* Global Buffers (Source and Destination) for PING-PONG */
#define  DST_ADDR1  (0x80000000)
#define  DST_ADDR2  (0x90000000)
#pragma DATA_SECTION(srcBuff1,".testMem");
#pragma DATA_ALIGN(srcBuff1, 8);
float srcBuff1[4*N];
#pragma DATA_SECTION(srcBuff2,".testMem");
#pragma DATA_ALIGN(srcBuff2, 8);
float srcBuff2[4*N];
Uint32 Row =16384;
Uint32 Column =65536;
/**********************************************************************
 ************************ EDMA TEST FUNCTIONS *************************
 **********************************************************************/
static Init_Data(void)
		{
            Uint32        loopIndex;
            float * dst_Buff1 = (float *)DST_ADDR1;
            float * dst_Buff2 = (float *)DST_ADDR2;
	          /* Initialize data  */
			for (loopIndex = 0; loopIndex < 4*N; loopIndex++)
			{
				srcBuff1[loopIndex] = loopIndex;
				srcBuff2[loopIndex] = 8192;
				dst_Buff1[loopIndex] = 0;
				dst_Buff2[loopIndex] = 0;
			}
		}

static Int32 qdma_link_xfer_region (Int32 instNum, Uint8 channelNum, Int32 regionNum)
{
    CSL_Edma3Handle             hModule;
    CSL_Edma3Obj                edmaObj;
    CSL_Edma3ParamHandle        hParamLink[64];
    CSL_Edma3ChannelObj         chObj;
    CSL_Edma3CmdIntr            regionIntr;
    CSL_Edma3CmdDrae            regionAccess;
    CSL_Edma3ChannelHandle      hChannel;
    CSL_Edma3ParamSetup         myParamSetup;
    CSL_Edma3Context            context;
    CSL_Edma3ChannelAttr        chAttr;
    CSL_Edma3CmdQrae            qraeSetup;
    CSL_Status                  status;   

    Uint32 i = 0;
    Uint32                cycles = 0;
    float                 Time,Bwith;
    Uint32                Byte_Per_Sample =8;
    /* Start the EDMA PING-PONG test over the SHADOW Region. */
    printf ("Debug: Testing EDMA(%d) Ping-Pong Test (Shadow) Region %d for QDMA Channel %d...\n", 
             instNum, regionNum, channelNum);
    Init_Data();
    cycles = TSCL; 	/*record start time*/
    /*************************/
    Uint32   Acent ,Bcent,step,step1, SBindex,DBindex;
    Acent = Byte_Per_Sample*8;
    SBindex = Acent;
   /* DBindex = Byte_Per_Sample*Column/64;*/
    DBindex = SBindex;
    Bcent = Row/64;
      /*  Դÿĵַ*/
    step1  = Acent*Bcent;
/*    ĿĶÿĵַ*/
   /* step  = Byte_Per_Sample*Column/64*Row/64;*/
    step  = Acent*Bcent;
   // printf("Acent =%d Bcent =%d SBindex=%d DBindex=%d step1=%d step=%d\n",Acent,Bcent ,SBindex, DBindex,step1,step);
    /* Module initialization */
    if (CSL_edma3Init(&context) != CSL_SOK)
    {
        printf ("Error: EDMA module initialization failed\n");
        return -1;
    }

    /* Module level open */
    hModule = CSL_edma3Open(&edmaObj,instNum,NULL,&status);
    if ((hModule == NULL) || (status != CSL_SOK))
    {
        printf ("Error: EDMA module open failed\n");
        return -1;
    }
    /* Is this for GLOBAL or SHADOW Region */
    if (regionNum != CSL_EDMA3_REGION_GLOBAL)
    {
        /* Shadow Region: Enable DRAE enable(Bits 0-15) it. */
        regionAccess.region = regionNum;
        regionAccess.drae   = 0xFFFF;   
        regionAccess.draeh  = 0x0000;
        if (CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_DMAREGION_ENABLE, &regionAccess) != CSL_SOK)
        {
             printf ("Error: EDMA region enable command failed\n");
             return -1;
        }
        /* Enable access for all QDMA channels in the SHADOW Region. */
        qraeSetup.region = regionNum;
        qraeSetup.qrae   = 0xFF;
        if (CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_QDMAREGION_ENABLE, &qraeSetup) != CSL_SOK)
            {
                 printf ("Error: EDMA QDMA region enable command failed\n");
                 return -1;
            }
    }

    /* QDMA Channel Open */
    chAttr.regionNum = regionNum;
    chAttr.chaNum    = channelNum;
    hChannel = CSL_edma3ChannelOpen(&chObj, instNum, &chAttr, &status);   
    if ((hChannel == NULL) || (status != CSL_SOK))
    {
        printf ("Error: EDMA channel open failed\n");
        return -1;
    }
    /* Map QDMA Channel to the PING Param Block i.e. 1 */
    CSL_edma3HwChannelSetupParam (hChannel, 1);

    /* Setup the trigger word for the QDMA Channel. */
    CSL_edma3HwChannelSetupTriggerWord(hChannel, 7);
        
    /* PING Parameter Entry Handle
    hParamPing = CSL_edma3GetParamHandle(hChannel, 1, &status);*/
 
    /* PONG Parameter Entry Handle
    hParamPong = CSL_edma3GetParamHandle(hChannel, 2, &status);*/
    
    for ( i = 0; i < 64; i++ )
    {
        /* LINK Parameter Entry Handle */
        hParamLink[i] = CSL_edma3GetParamHandle(hChannel, i+1, &status);
        if (hParamLink[i] == NULL)
        {
            printf ("Error: EDMA get handle for param entry 1 failed\n");
            return -1;
        }
    }

    for ( i = 0; i < 64; i++ )
    {
    	if ( i < 63 )
    	{
    		/* Setup param entry */
			myParamSetup.option = CSL_EDMA3_OPT_MAKE(CSL_EDMA3_ITCCH_DIS, \
													 CSL_EDMA3_TCCH_DIS, \
													 CSL_EDMA3_ITCINT_DIS, \
													 CSL_EDMA3_TCINT_DIS,\
													 0,CSL_EDMA3_TCC_NORMAL,\
													 CSL_EDMA3_FIFOWIDTH_NONE, \
													 CSL_EDMA3_STATIC_DIS, \
													 CSL_EDMA3_SYNC_AB, \
													 CSL_EDMA3_ADDRMODE_INCR, \
													 CSL_EDMA3_ADDRMODE_INCR);
			myParamSetup.srcAddr    = (Uint32)(srcBuff1)+ step1*i;
			myParamSetup.aCntbCnt   = CSL_EDMA3_CNT_MAKE(Acent,Bcent);
			myParamSetup.dstAddr    = (Uint32)(DST_ADDR1 + step*i);
			myParamSetup.srcDstBidx = CSL_EDMA3_BIDX_MAKE(SBindex,DBindex);
			myParamSetup.linkBcntrld= CSL_EDMA3_LINKBCNTRLD_MAKE(hParamLink[i+1],0);
			myParamSetup.srcDstCidx = CSL_EDMA3_CIDX_MAKE(0,1);
			myParamSetup.cCnt       = 1;
			/* Setup PING to operate with this PARAM Entry. */
		    if (CSL_edma3ParamSetup(hParamLink[i], &myParamSetup )!= CSL_SOK)
		    {
		         printf ("Error: EDMA param setup failed\n");
		         return -1;
		    }
			//	printf("srcAddr =0x%x  dstAddr =0x%x \n",myParamSetup.srcAddr,myParamSetup.dstAddr);
    	}
    	else
    	{
    	    /* Setting up the next entry */
    	    myParamSetup.option = CSL_EDMA3_OPT_MAKE(CSL_EDMA3_ITCCH_DIS, \
    	                                             CSL_EDMA3_TCCH_DIS, \
    	                                             CSL_EDMA3_ITCINT_DIS, \
    	                                             CSL_EDMA3_TCINT_EN,\
    	                                             1,CSL_EDMA3_TCC_NORMAL,\
    	                                             CSL_EDMA3_FIFOWIDTH_NONE, \
    	                                             CSL_EDMA3_STATIC_EN, \
    	                                             CSL_EDMA3_SYNC_AB, \
    	                                             CSL_EDMA3_ADDRMODE_INCR, \
    	                                             CSL_EDMA3_ADDRMODE_INCR);
    	    myParamSetup.srcAddr = (Uint32)(srcBuff1 )+ + step1* 63;
    	    myParamSetup.dstAddr = (Uint32)(DST_ADDR1 + step*63);
    	    /* Setup for the Pong buffer */
		    if (CSL_edma3ParamSetup(hParamLink[i], &myParamSetup )!= CSL_SOK)
		    {
		         printf ("Error: EDMA param setup failed\n");
		         return -1;
		    }
			//printf("srcAddr =0x%x  dstAddr =0x%x \n",myParamSetup.srcAddr,myParamSetup.dstAddr);
    	}
    }
    /* Enable Channel */
    if (CSL_edma3HwChannelControl(hChannel,CSL_EDMA3_CMD_CHANNEL_ENABLE, NULL) != CSL_SOK)
    {
         printf ("Error: EDMA channel enable command failed\n");
         return -1;
    }
    DIR = 0x0000;
    OUT_DATA = 0x0000;
    /* Trigger the word by writing to the trigger word... */
    if (CSL_edma3ParamWriteWord(hParamLink[0],7,1) != CSL_SOK) {
         printf ("Error: EDMA param write word failed\n");
         return -1;
    }
    
    /* Poll IPR bit */ 
    regionIntr.region = regionNum;
    do {
        CSL_edma3GetHwStatus(hModule,CSL_EDMA3_QUERY_INTRPEND,&regionIntr);
    } while (!(regionIntr.intr & 0x2));
    OUT_DATA = 0xffff;
    /* Clear pending interrupt */
    if (CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_INTRPEND_CLEAR, &regionIntr) != CSL_SOK)
    {
         printf ("Error: EDMA clear interrupt pend command failed\n");
         return -1;
    }
    /* Disable the channel */
    CSL_edma3HwChannelControl(hChannel,CSL_EDMA3_CMD_CHANNEL_DISABLE, NULL);

    /* Close channel */
    if (CSL_edma3ChannelClose(hChannel) != CSL_SOK)
    {
        printf("Error: EDMA channel close failed\n");
        return -1;
    }
    /* Close EDMA module */
    if (CSL_edma3Close(hModule) != CSL_SOK)
    {
        printf("Error: EDMA module close failed\n");
        return -1;
    }
    /* Test Passed. */
    cycles= TSC_delay_cycle(cycles);
    Time  = cycles/1000;
    Bwith =(Row*64*1000) /cycles;
    printf("Time =%f us,Bwith =%f MB/s\n",Time,Bwith);
    return 0;
}


static Int32 qdma_link_xfer_region_read (Int32 instNum, Uint8 channelNum, Int32 regionNum)
{
    CSL_Edma3Handle             hModule;
    CSL_Edma3Obj                edmaObj;
    CSL_Edma3ParamHandle        hParamLink[64];
    CSL_Edma3ChannelObj         chObj;
    CSL_Edma3CmdIntr            regionIntr;
    CSL_Edma3CmdDrae            regionAccess;
    CSL_Edma3ChannelHandle      hChannel;
    CSL_Edma3ParamSetup         myParamSetup;
    CSL_Edma3Context            context;
    CSL_Edma3ChannelAttr        chAttr;
    CSL_Edma3CmdQrae            qraeSetup;
    CSL_Status                  status;

    Uint32 i = 0;
    Uint32                cycles = 0;
    float                 Time,Bwith;
    Uint32                Byte_Per_Sample =8;
    /* Start the EDMA PING-PONG test over the SHADOW Region. */
    printf ("Debug: Testing EDMA(%d) Ping-Pong Test (Shadow) Region %d for QDMA Channel %d...\n",
             instNum, regionNum, channelNum);
//    Init_Data();
    cycles = TSCL; 	/*record start time*/
    /*************************/
    Int32   Acent ,Bcent,step,step1, SBindex,DBindex;
    Acent = Byte_Per_Sample*8;
    SBindex = Acent;
    DBindex = Acent;
    Bcent = Row/64;
    /*Դÿĵַ*/
    step1  = Acent*Bcent;
    /*ĿĶÿĵַ*/
    step  = Acent*Bcent;
    /* Module initialization */
    if (CSL_edma3Init(&context) != CSL_SOK)
    {
        printf ("Error: EDMA module initialization failed\n");
        return -1;
    }
    /* Module level open */
    hModule = CSL_edma3Open(&edmaObj,instNum,NULL,&status);
    if ((hModule == NULL) || (status != CSL_SOK))
    {
        printf ("Error: EDMA module open failed\n");
        return -1;
    }
    /* Is this for GLOBAL or SHADOW Region */
    if (regionNum != CSL_EDMA3_REGION_GLOBAL)
    {
        /* Shadow Region: Enable DRAE enable(Bits 0-15) it. */
        regionAccess.region = regionNum;
        regionAccess.drae   = 0xFFFF;
        regionAccess.draeh  = 0x0000;
        if (CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_DMAREGION_ENABLE, &regionAccess) != CSL_SOK)
        {
             printf ("Error: EDMA region enable command failed\n");
             return -1;
        }
        /* Enable access for all QDMA channels in the SHADOW Region. */
        qraeSetup.region = regionNum;
        qraeSetup.qrae   = 0xFF;
        if (CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_QDMAREGION_ENABLE, &qraeSetup) != CSL_SOK)
        {
             printf ("Error: EDMA QDMA region enable command failed\n");
             return -1;
        }
    }

    /* QDMA Channel Open */
    chAttr.regionNum = regionNum;
    chAttr.chaNum    = channelNum;
    hChannel = CSL_edma3ChannelOpen(&chObj, instNum, &chAttr, &status);
    if ((hChannel == NULL) || (status != CSL_SOK))
    {
        printf ("Error: EDMA channel open failed\n");
        return -1;
    }

    /* Map QDMA Channel to the PING Param Block i.e. 1 */
    CSL_edma3HwChannelSetupParam (hChannel, 1);

    /* Setup the trigger word for the QDMA Channel. */
    CSL_edma3HwChannelSetupTriggerWord(hChannel, 7);

    /* PING Parameter Entry Handle
    hParamPing = CSL_edma3GetParamHandle(hChannel, 1, &status);*/

    /* PONG Parameter Entry Handle
    hParamPong = CSL_edma3GetParamHandle(hChannel, 2, &status);*/

    for ( i = 0; i < 64; i++ )
    {
        /* LINK Parameter Entry Handle */
        hParamLink[i] = CSL_edma3GetParamHandle(hChannel, i+1, &status);
        if (hParamLink[i] == NULL)
        {
            printf ("Error: EDMA get handle for param entry 1 failed\n");
            return -1;
        }
    }

    for ( i = 0; i < 64; i++ )
    {
    	if ( i < 63 )
    	{
    		/* Setup param entry */
			myParamSetup.option = CSL_EDMA3_OPT_MAKE(CSL_EDMA3_ITCCH_DIS, \
													 CSL_EDMA3_TCCH_DIS, \
													 CSL_EDMA3_ITCINT_DIS, \
													 CSL_EDMA3_TCINT_DIS,\
													 0,CSL_EDMA3_TCC_NORMAL,\
													 CSL_EDMA3_FIFOWIDTH_NONE, \
													 CSL_EDMA3_STATIC_DIS, \
													 CSL_EDMA3_SYNC_AB, \
													 CSL_EDMA3_ADDRMODE_INCR, \
													 CSL_EDMA3_ADDRMODE_INCR);
			myParamSetup.srcAddr    = (Uint32)(DST_ADDR1 + step1*i);
			myParamSetup.aCntbCnt   = CSL_EDMA3_CNT_MAKE(Acent,Bcent);
			myParamSetup.dstAddr    = (Uint32)(srcBuff2 ) + step*i;
			myParamSetup.srcDstBidx = CSL_EDMA3_BIDX_MAKE(SBindex,DBindex);
			myParamSetup.linkBcntrld= CSL_EDMA3_LINKBCNTRLD_MAKE(hParamLink[i+1],0);
			myParamSetup.srcDstCidx = CSL_EDMA3_CIDX_MAKE(0,0);
			myParamSetup.cCnt       = 1;
			/* Setup PING to operate with this PARAM Entry. */
    	    if (CSL_edma3ParamSetup(hParamLink[i], &myParamSetup) != CSL_SOK)
    	    {
    	         printf ("Error: EDMA param setup failed\n");
    	         return -1;
    	    }
			//printf("i=%d srcAddr =0x%x  dstAddr =0x%x \n",i,myParamSetup.srcAddr,myParamSetup.dstAddr);
    	}
    	else
    	{
    	    /* Setting up the next entry */
    	    myParamSetup.option = CSL_EDMA3_OPT_MAKE(CSL_EDMA3_ITCCH_DIS, \
    	                                             CSL_EDMA3_TCCH_DIS, \
    	                                             CSL_EDMA3_ITCINT_DIS, \
    	                                             CSL_EDMA3_TCINT_EN,\
    	                                             1,CSL_EDMA3_TCC_NORMAL,\
    	                                             CSL_EDMA3_FIFOWIDTH_NONE, \
    	                                             CSL_EDMA3_STATIC_EN, \
    	                                             CSL_EDMA3_SYNC_AB, \
    	                                             CSL_EDMA3_ADDRMODE_INCR, \
    	                                             CSL_EDMA3_ADDRMODE_INCR);
    	    myParamSetup.srcAddr = (Uint32)(DST_ADDR1 + step1* 63);
    	    myParamSetup.dstAddr = (Uint32)(srcBuff2 )+ step* 63;
			myParamSetup.aCntbCnt   = CSL_EDMA3_CNT_MAKE(Acent,Bcent);
			myParamSetup.srcDstBidx = CSL_EDMA3_BIDX_MAKE(SBindex,DBindex);
			myParamSetup.srcDstCidx = CSL_EDMA3_CIDX_MAKE(0,0);
    	    myParamSetup.linkBcntrld= CSL_EDMA3_LINKBCNTRLD_MAKE(0xffff,0);
    	    /* Setup for the Pong buffer */

    	    if (CSL_edma3ParamSetup(hParamLink[i], &myParamSetup) != CSL_SOK)
    	    {
    	         printf ("Error: EDMA param setup failed\n");
    	         return -1;
    	    }
    		//printf("i=%d srcAddr =0x%x  dstAddr =0x%x \n",i,myParamSetup.srcAddr,myParamSetup.dstAddr);
    	}
    }
    /* Enable Channel */
    if (CSL_edma3HwChannelControl(hChannel,CSL_EDMA3_CMD_CHANNEL_ENABLE, NULL) != CSL_SOK)
    {
         printf ("Error: EDMA channel enable command failed\n");
         return -1;
    }
    DIR = 0x0000;
    OUT_DATA = 0x0000;
    /* Trigger the word by writing to the trigger word... */

    if (CSL_edma3ParamWriteWord(hParamLink[0],7,1)!= CSL_SOK)
    {
          printf ("Error: EDMA param write word failed\n");
          return -1;
     }
    /* Poll IPR bit */
    regionIntr.region = regionNum;
    do {
        CSL_edma3GetHwStatus(hModule,CSL_EDMA3_QUERY_INTRPEND,&regionIntr);
    } while (!(regionIntr.intr & 0x2));
    OUT_DATA = 0xffff;
    /* Clear pending interrupt */
    if (CSL_edma3HwControl(hModule,CSL_EDMA3_CMD_INTRPEND_CLEAR, &regionIntr) != CSL_SOK)
    {
         printf ("Error: EDMA clear interrupt pend command failed\n");
         return -1;
    }

    /* Disable the channel */
    CSL_edma3HwChannelControl(hChannel,CSL_EDMA3_CMD_CHANNEL_DISABLE, NULL);

    /* Close channel */
    if (CSL_edma3ChannelClose(hChannel) != CSL_SOK)
    {
        printf("Error: EDMA channel close failed\n");
        return -1;
    }
    /* Close EDMA module */
    if (CSL_edma3Close(hModule) != CSL_SOK)
    {
        printf("Error: EDMA module close failed\n");
        return -1;
    }
    /* Test Passed. */
    cycles= TSC_delay_cycle(cycles);
    Time  = cycles/1000;
    Bwith =(Row*64*1000) /cycles;
    printf("Time =%f us,Bwith =%f MB/s\n",Time,Bwith);
    return 0;
}


/**
 *  @b Description
 *  @n
 *      Entry point for the test code.
 *
 *  @retval
 *      Not Applicable.
 */
void main (void)
{
    Uint8  channelNum;
    Int32  regionNum;
    Uint8  instNum = 0;
    printf ("**************************************************\n");
    printf ("******************* EDMA Testing *****************\n");
    printf ("**************************************************\n");
    SET_OUT_DIR(0xffff);
    OUT_DATA = 0xffff;
    Uint32   count =0,count1=0;
    TSC_init();
    /* EDMA Instance 0: Supports only 16 DMA Channels.*/
/*    for (regionNum = CSL_EDMA3_REGION_GLOBAL; regionNum <= CSL_EDMA3_REGION_7; regionNum++)
    {
        for (channelNum = 16; channelNum < 24; channelNum++)
        {
            if (qdma_link_xfer_region_read(instNum, channelNum, regionNum) < 0)
            {
                printf ("Error: Testing EDMA(%d) Ping-Pong Test (Shadow) Region %d for QDMA Channel %d FAILED\n",
                        instNum, regionNum, channelNum);
                return;
            }
            printf ("Debug: Testing EDMA(%d) Ping-Pong Test (Shadow) Region %d for QDMA Channel %d Passed\n",
                    instNum, regionNum, channelNum);
        }
    }*/
   qdma_link_xfer_region(instNum, 16, 1);
    qdma_link_xfer_region_read(instNum, 16, 1);
    ///////////////////ͳƶд////////////////////////
    float temp=0;
    for(count=0;count<4*N;count++)
    {
    	temp=srcBuff1[count]-srcBuff2[count];
    	if(temp)
		count1=count1+1;
    }
    if(count1>0)
    {
    printf("erro num: %d\n",count1);
    }
    else
    printf ("************* EDMA Testing Successful ************\n");
    return;
}
