#ifndef _APP_MAIN_H
#define _APP_MAIN_H
#include <std.h>
#include <que.h>
#include <scom.h>

#if _NTSC

#define VIDEO_FORMAT    NTSC
#define VIDEO_RES       RES_NTSC_FULL
#define FRM_WIDTH       720
#define FRM_HEIGHT      480
#define IMG_WIDTH       720
#define IMG_HEIGHT      480

#elif _PAL

#define VIDEO_FORMAT    PAL
#define VIDEO_RES       RES_PAL_FULL
#define FRM_WIDTH       720
#define FRM_HEIGHT      576
#define IMG_WIDTH       720
#define IMG_HEIGHT      576

#endif

#define FRAME_BUF_SIZE (FRM_WIDTH*FRM_HEIGHT*2)  /* 4:2:2 format 16-bit/pixel */


extern void tskVideoOutputInit();

typedef struct _ScomMessage {
    QUE_Elem queElem;                    // must be first field.
    void *bufY;
    void *bufU;
    void *bufV;
	int  width;
	int  hight;
} ScomMessage;

typedef struct _MAC_Address{
    Char cVersion[4];//MAC
    unsigned char bMacAddr[8];
}MACAddress;

#endif /*_APP_MAIN_H */
