/*
 *  Copyright 2003 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *  
 */
/* "@(#) DDK 1.11.00.00 11-04-03 (ddk-b13)" */
#ifndef _EDC_H
#define _EDC_H

#include <std.h>                                 
#ifdef __cplusplus
extern "C" {
#endif

/* EDC control commands */
#define EDC_CONFIG         0x00000001
#define EDC_RESET          0x00000002
#define EDC_START          0x00000003
#define EDC_STOP           0x00000004
#define EDC_GET_CONFIG     0x00000005
#define EDC_GET_STATUS     0x00000006

/* base of user defined commands */
#define EDC_USER           0x10000000


/* EDC return codes */
#define EDC_SUCCESS             0
#define EDC_FAILED              -1

typedef void*  EDC_Handle;
/*
 *  ======== EDC_Fxns ========
 *      edcOpen()      required, open the device 
 *      edcClose()      required, close the device
 *      edcCtrl()       required, control/query device
 */
typedef struct EDC_Fxns {
    EDC_Handle  (*open)(String name, Arg optArg);
    Int (*close)(Ptr devHandle);
    Int (*ctrl)(Ptr devHandle, Uns cmd, Arg arg);
} EDC_Fxns;


#ifdef __cplusplus
{
#endif
#endif /* _EDC_H */
