/*
 *  Copyright 2003 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *  
 */
/* "@(#) DDK 1.11.00.00 11-04-03 (ddk-b13)" */
/*
 * 
 *  ======== fvid.h ========
 */


#ifndef FVID_
#define FVID_

#include <gio.h>
#include <iom.h>


#ifdef __cplusplus
extern "C" {
#endif


/*
 *  -------- command codes for IOM_Packet --------
 */

#define FVID_BASE       IOM_USER

#define FVID_ALLOC      (FVID_BASE + 0)
#define FVID_FREE       (FVID_BASE + 1)
#define FVID_EXCHANGE   (FVID_BASE + 2)

typedef GIO_Handle FVID_Handle;
/* defination of interlaced frame */
typedef struct FVID_IFrame{
    Char* y1;
    Char* cb1;
    Char* cr1;
    Char* y2;
    Char* cb2;
    Char* cr2;
}FVID_IFrame;

/* progressive frame */
typedef struct FVID_PFrame {
    Char* y;
    Char* cb;
    Char* cr;
} FVID_PFrame; 

/* Raw frame. Could be RGB, monochrome  or any type of data*/
/* interleaved Y/C frame etc. */
typedef struct FVID_RawIFrame{
    Char* buf1;    
    Char* buf2;    
} FVID_RawIFrame; 

typedef struct FVID_RawPFrame{
    Char* buf;    
} FVID_RawPFrame; 

/* FVID frame buffer descriptor */
typedef struct FVID_Frame {
    QUE_Elem        queElement; /* for queuing */
    union {
        FVID_IFrame     iFrm;     /* y/c frame buffer         */
        FVID_PFrame     pFrm;     /* y/c frame buffer         */
        FVID_RawIFrame  riFrm;    /* raw frame buffer         */
        FVID_RawPFrame  rpFrm;    /* raw frame buffer         */
    } frame;    
} FVID_Frame;

/*
 *  ======== FVID_alloc ========
 *  FVID_alloc() is used for device drivers that manage their own buffers.
 *  FVID_alloc() returns a pointer to a device driver allocated buffer and
 *  also sets the size.
 */
#define FVID_alloc(gioChan, bufp) \
        GIO_submit(gioChan, FVID_ALLOC, bufp, NULL, NULL)


/*
 *  ======== FVID_control ========
 *  This is a direct call down into the mini driver.
 */
#define FVID_control(gioChan, cmd, args) \
        GIO_control(gioChan, cmd, args)


/*
 *  ======== FVID_create ========
 *  FVID_create() allocates and initializes an GIO_Obj structure. FVID_create()
 *  returns a non-NULL GIO_Handle object on success and NULL for failure.
 *  The 'name' parameter is used to find a matching name in the device
 *  table.  Associated IOM_Fxns table and params structure are then used
 *  to create a channel for that device.   The 'attrs->nPackets' parameter
 *  specifies the number of asynchronous I/O calls that can be outstanding.
 *  The status field is the address where a device status is returned, ignored
 *  if status is specified as NULL.
 */
#define  FVID_create(name, mode, status, optArgs, attrs) \
        GIO_create(name, mode, status, optArgs, attrs)


/*
 *  ======== FVID_delete ========
 *  FVID_delete() frees up channel resources.
 */
#define FVID_delete(giochan) \
        GIO_delete(gioChan)


/*
 *  ======== FVID_exchange ========
 *  Exchange one driver-managed buffer for another driver-managed buffer.
 *  This operation is similar to an FVID_free()/alloc() pair but has less
 *  overhead since it involves only one call into the driver.
 */
#define FVID_exchange(gioChan, bufp) \
        GIO_submit(gioChan, FVID_EXCHANGE, bufp, NULL, NULL)



/*
 *  ======== FVID_free ========
 *  FVID_free() returns a device-driver allocated buffer back to the driver.
 */
#define FVID_free(gioChan, bufp) \
        GIO_submit(gioChan, FVID_FREE, bufp, NULL, NULL)


#ifdef __cplusplus
}
#endif /* extern "C" */

#endif /* FVID_ */
