//--------------------------------------------------------------------------
// Network Control Library
//--------------------------------------------------------------------------
// NETCTRL.H
//
// Shell functions for simplified net startup and shutdown
//
// The idea behind this API is to hide the user callable HAL/STACK functions
//
// Author: Michael A. Denio
// Copyright 1999, 2000 by Texas Instruments Inc.
//--------------------------------------------------------------------------

#ifndef _C_NETCTRL_INC
#define _C_NETCTRL_INC

//
// NETCTRL is used to initialize the stack and maintain services. To
// accomplish this, it makes use of the configuration manager provided
// in the NETTOOLS library. Note that the configuration definitions and
// structures defined here are specific to NETCTRL, not CONFIG.
//

//
// NETCTRL Access Functions
//

// Initialize the run-time environment
_extern void NC_SystemOpen();

// Close down the run-time environment
_extern void NC_SystemClose();

// Start the network using the supplied configuration
_extern int NC_NetStart( HANDLE hCfg, void (*NetStart)(),
                        void (*NetStop)(), void (*NetIP)(IPN,uint,uint) );

// Stop the network
_extern void NC_NetStop( int rc );

// Called when Boot thread has completed
_extern void NC_BootComplete();

// Called when IP address is added or removed
_extern void NC_IPUpdate( IPN IPAddr, uint IfIdx, uint fAdd );

#endif
