//--------------------------------------------------------------------------
// Network Tools Library
//--------------------------------------------------------------------------
// HTTPIF.H
//
// Interface to the tools available in NETTOOL.LIB
//
// Author: Michael Hanrahan
// Copyright 1999, 2000 by Texas Instruments Inc.
//-------------------------------------------------------------------------

#ifndef _HTTPIF_H_
#define _HTTPIF_H_

//
// HTTP SERVER SERVICE
//

//
// HttpOpen
//
// Create an instance of the Http Server based on a specific interface
// or IP addres (IPAddr=0 is a wildcard that matches any installed address).
//
// Compatible with NT_MODE_IFIDX and NT_MODE_IPADDR.
//
// Returns a HANDLE to the Http instance
//
_extern HANDLE httpOpen( NTARGS *pNTA );

//
// HttpClose
//
// Destroy an instance of the Http Server
//
_extern void  httpClose(HANDLE h);

//
// Public String Definitions
//
/*
char *CONTENT_TYPE_APPLET  = "application/octet-stream ";
char *CONTENT_TYPE_AU      = "audio/au ";
char *CONTENT_TYPE_DOC     = "application/msword ";
char *CONTENT_TYPE_GIF     = "image/gif ";
char *CONTENT_TYPE_HTML    = "text/html ";
char *CONTENT_TYPE_JPG     = "image/jpeg ";
char *CONTENT_TYPE_MPEG    = "video/mpeg ";
char *CONTENT_TYPE_PDF     = "application/pdf ";
char *CONTENT_TYPE_WAV     = "audio/wav ";
char *CONTENT_TYPE_ZIP     = "application/zip ";
char *CONTENT_TYPE         = "Content-type: ";
char *CONTENT_LENGTH       = "Content-length: ";
char *CRLF                 = "\r\n";
char *DEFAULT_NAME         = "index.html";
char *HTTP_VER             = "HTTP/1.0 ";
char *SPACE                = " ";
*/
extern char *CONTENT_TYPE_APPLET;
extern char *CONTENT_TYPE_AU;
extern char *CONTENT_TYPE_DOC;
extern char *CONTENT_TYPE_GIF;
extern char *CONTENT_TYPE_HTML;
extern char *CONTENT_TYPE_JPG;
extern char *CONTENT_TYPE_MPEG;
extern char *CONTENT_TYPE_PDF;
extern char *CONTENT_TYPE_WAV;
extern char *CONTENT_TYPE_ZIP;
extern char *CONTENT_TYPE;
extern char *CONTENT_LENGTH;
extern char *CRLF;
extern char *DEFAULT_NAME;
extern char *HTTP_VER;
extern char *SPACE;

//
// Status codes for httpSendFullResponse() and httpSendStatusLine()
//
enum HTTP_STATUS_CODE
{
    HTTP_OK=200,
    HTTP_NO_CONTENT=204,
    HTTP_NOT_FOUND=404,
    HTTP_NOT_ALLOWED=405,
    HTTP_NOT_IMPLEMENTED=501,
    HTTP_STATUS_CODE_END
};

#define HTTPPORT           80
#define MAX_RESPONSE_SIZE  200

_extern int  httpVersion(void);

//
// httpSendClientStr
//
// Sends the indicated NULL terminated response string to
// the indicated client socket - i.e.: calls strlen() and send()
//
_extern void httpSendClientStr( int Sock, char *Response );

//
// httpSendStatusLine
//
// Sends a formatted response message to Sock with the given
// status code and content type. The value of ContentType can
// be NULL if no ContentType is required.
//
_extern void httpSendStatusLine( int Sock, int StatusCode, char *ContentType );

//
// httpSendFullResponse
//
// Sends a full formatted response message to Sock, including the
// file indicated by the filename in RequestedFile. The status code
// for this call is usually HTTP_OK.
//
_extern void httpSendFullResponse( int Sock, int StatusCode,
                                   char *RequestedFile );

//
// httpSendErrorResponse
//
// Sends a formatted error response message to Sock based on the
// status code.
//
_extern void httpSendErrorResponse( int Sock, int StatusCode );


//
// Common error responses
//
#define http404(Sock)  httpSendErrorResponse(Sock, HTTP_NOT_FOUND)
#define http405(Sock)  httpSendErrorResponse(Sock, HTTP_NOT_ALLOWED)
#define http501(Sock)  httpSendErrorResponse(Sock, HTTP_NOT_IMPLEMENTED)

#endif
