//--------------------------------------------------------------------------
// Network Tools Library
//--------------------------------------------------------------------------
// TELNETIF.H
//
// Interface to the tools available in NETTOOL.LIB
//
// Author: Michael A. Denio
// Copyright 1999, 2000 by Texas Instruments Inc.
//-------------------------------------------------------------------------

#ifndef _TELNETIF_H_
#define _TELNETIF_H_

//
// TELNET SERVICE
//

//
// Telnet Parameter Structure
//
typedef struct _ntparam_telnet {
        int     MaxCon;             // Max number of telnet connections
        int     (*Callback)(PSA);   // Connect function that returns local pipe
        } NTPARAM_TELNET;

//
// TelnetOpen
//
// Create an instance of the Telnet Server
//
// Compatible with NT_MODE_IFIDX and NT_MODE_IPADDR.
//
// Returns a HANDLE to the Telnet instance
//
_extern HANDLE TelnetOpen( NTARGS *pNTA, NTPARAM_TELNET *pNTP );

//
// TelnetClose
//
// Destroy an instance of the Telnet Server
//
_extern void TelnetClose( HANDLE h );

#endif

