//--------------------------------------------------------------------------
// SERIAL PORT SUPPORT LIBRARY
//--------------------------------------------------------------------------
// SERIAL.H
//
// Include file for serial port support layer
//
// Author: Michael A. Denio
// Copyright 2001 by Texas Instruments Inc.
//-------------------------------------------------------------------------

#ifndef _C_SERIAL_INC
#define _C_SERIAL_INC  /* #defined if this .h file has been included */

//-----------------------------------------------------------------------
//---[ LLSERIAL ]--------------------------------------------------------
//-----------------------------------------------------------------------

// Size of Serial Buffers
#define HAL_SERIAL_BUFFERSIZE           3052

// Mode values for SerialConfig
#define HAL_SERIAL_MODE_8N1             0x03
#define HAL_SERIAL_MODE_7E1             0x1a
#define HAL_SERIAL_FLOWCTRL_NONE        0
#define HAL_SERIAL_FLOWCTRL_HARDWARE    1

// Serial Driver Interface to the Operating System
_extern uint  _llSerialInit();
_extern void  _llSerialShutdown();
_extern uint  _llSerialServiceCheck();

// Serial Driver Interface to the Stack
_extern void  llSerialConfig( uint dev, uint baud, uint mode, uint flowctrl );
_extern uint  llSerialOpenCharmode( uint dev, void (*CmRxCb)( char c ) );
_extern void  llSerialCloseCharmode( uint dev );
_extern uint  llSerialOpenHDLC( uint dev, HANDLE hHDLC );
_extern void  llSerialCloseHDLC( uint dev );
_extern void  llSerialSend( uint dev, UINT8 *pb, uint offset, uint size );
_extern void  llSerialReturnBuffer( UINT8 *pbData );
_extern UINT8 *llSerialGetBuffer();
_extern void  llSerialService();

//-----------------------------------------------------------------------
//---[ HDLC Layer ]------------------------------------------------------
//-----------------------------------------------------------------------

// HDLC Common Functions
_extern void   hdlcInput( HANDLE hHDLC, UINT8 *pBuf, uint Size );

// HDLC Client Functions
_extern HANDLE hdlcNew( uint DevSerial, uint pppFlags, UINT32 ourcmap,
                       char *Username, char *Password );
_extern void   hdlcFree( HANDLE hHDLC );
_extern uint   hdlcGetStatus( HANDLE hHDLC );

// HDLC Server Functions
_extern HANDLE hdlcsNew( uint DevSerial, uint pppFlags, UINT32 ourcmap,
                        IPN IPServer, IPN IPMask, IPN IPClient );
#define hdlcsFree(x)       hdlcFree(x)
#define hdlcsGetStatus(x)  hdlcGetStatus(x)

#endif

