//----------------------------------------------------------------------
//  Ip Stack
//----------------------------------------------------------------------
//  File: fdtif.h
//   
//  File Descriptor Table and File Descriptor Handle Interface Functions
//
// Author: Michael A. Denio
// Copyright 1999 by Texas Instruments Inc.
//----------------------------------------------------------------------

#ifndef _FDTIF_INC_
#define _FDTIF_INC_

//
// FDT Functions
//
_extern HANDLE FDTNew( HANDLE hOwner );
_extern void   FDTFree( HANDLE hFDT );

//
// FD Events
//
#define FD_EVENT_READ   0x01
#define FD_EVENT_WRITE  0x02
#define FD_EVENT_EXCEPT 0x04

//
// FD Functions
//
_extern void   FDSignalEvent( HANDLE hFd, uint EventFlags );
_extern int    FDWaitEvent( HANDLE hFd, uint EventFlags, UINT32 timeout );

#endif


