//----------------------------------------------------------------------
//  Ip Stack
//----------------------------------------------------------------------
//  File: pipeif.h
//   
//  Pipe Object Public Include
//
// Author: Michael A. Denio
// Copyright 2000 by Texas Instruments Inc.
//----------------------------------------------------------------------

#ifndef _PIPEIF_INC_
#define _PIPEIF_INC_

//
// Pipe Access Functions
//

//------------------------------------------------------------------------
// General Access Functions (called from upper layers)
//
_extern int    PipeNew( HANDLE hFd1, HANDLE hFd2, HANDLE *phPipe1, HANDLE *phPipe2 );
_extern int    PipeClose( HANDLE hPipe );

_extern int    PipeCheck( HANDLE hSock, int IoType );
#define  PIPE_READ       0
#define  PIPE_WRITE      1

_extern int    PipeRecv( HANDLE hPipe, INT8 *pBuf, INT32 size,
                        int flags, INT32 *pRetSize );
_extern int    PipeSend( HANDLE hPipe, INT8 *pBuf, INT32 size,
                        int flags, INT32 *pRetSize );

#endif

