//----------------------------------------------------------------------
//  Ip Stack
//----------------------------------------------------------------------
//  File: resif.h
//
//  Basic Resource and Dispatch Functions
//
// Author: Michael A. Denio
// Copyright 1999 by Texas Instruments Inc.
//----------------------------------------------------------------------

#ifndef _C_RESIF_INC
#define _C_RESIF_INC  /* #defined if this .h file has been included */

//-----------------------------------------------------------------------
//----[ Configuration ]--------------------------------------------------
//-----------------------------------------------------------------------

typedef struct _ipconfig {
        uint    IcmpDoRedirect;     // Update RtTable on ICMP redirect (1=Yes)
        uint    IcmpTtl;            // TTL for ICMP messages RFC1700 says 64
        uint    IcmpTtlEcho;        // TTL for ICMP echo RFC1700 says 64
        uint    IpIndex;            // IP Start Index
        uint    IpForwarding;       // IP Forwarding (1 = Enabled)
        uint    IpNatEnable;        // IP NAT Enable (1 = Yes)
        uint    IpFilterEnable;     // IP Filtering Enable (1 = Yes)
        uint    IpReasmMaxTime;     // Max reassembly time in seconds
        uint    IpReasmMaxSize;     // Max reassembly packet size
        uint    IpDirectedBCast;    // Look for directed BCast IP addresses
        uint    TcpReasmMaxPkt;     // Max reasm pkts held by TCP socket
        uint    RtcEnableDebug;     // Enable Route Control Messages (1=On)
        uint    RtcAdvTime;         // Time in sec to send RtAdv (0=don't)
        uint    RtcAdvLife;         // Litetime of route in RtAdv
        int     RtcAdvPref;         // Preference Level (signed) in RtAdv
        uint    RtArpDownTime;      // Time 5 failed ARPs keep Rt down (sec)
        uint    RtKeepaliveTime;    // VALIDATED route timeout (sec)
        uint    RtCloneTimeout;     // INITIAL route timeout (sec)
        uint    RtDefaultMTU;       // Default MTU for internal routes
        uint    SockTtlDefault;     // Default Packet TTL
        uint    SockTosDefault;     // Default Packet TOS
        int     SockMaxConnect;     // Max Socket Connections
        uint    SockTimeConnect;    // Max time to connect (sec)
        uint    SockTimeIo;         // Default Socket IO timeout (sec)
        int     SockBufMax;         // Absolute max Socket buffer size
        int     SockBufMinTx;       // Min Tx space for "able to write"
        int     SockBufMinRx;       // Min Rx data for "able to read"
        uint    PipeTimeIo;         // Default Pipe IO timeout (sec)
        int     PipeBufSize;        // Pipe internal buffer size
        int     PipeBufMinTx;       // Min Tx space for "able to write"
        int     PipeBufMinRx;       // Min Rx data for "able to read"
        } IPCONFIG;

extern IPCONFIG _ipcfg;             // Configuration

#define ICMP_DO_REDIRECT        (_ipcfg.IcmpDoRedirect)
#define ICMP_TTL                (_ipcfg.IcmpTtl)
#define ICMP_TTL_ECHO           (_ipcfg.IcmpTtlEcho)
#define IP_INDEX                (_ipcfg.IpIndex)
#define IP_FORWARDING           (_ipcfg.IpForwarding)
#define IP_NATENABLE            (_ipcfg.IpNatEnable)
#define IP_FILTERENABLE         (_ipcfg.IpFilterEnable)
#define IP_REASM_MAXTIME        (_ipcfg.IpReasmMaxTime)
#define IP_REASM_MAXSIZE        (_ipcfg.IpReasmMaxSize)
#define IP_DIRECTED_BCAST       (_ipcfg.IpDirectedBCast)
#define TCP_REASM_MAXPKT        (_ipcfg.TcpReasmMaxPkt)
#define RTC_ENABLE_DEBUG        (_ipcfg.RtcEnableDebug)
#define RTC_RTADV_TIME          (_ipcfg.RtcAdvTime)
#define RTC_RTADV_LIFE          (_ipcfg.RtcAdvLife)
#define RTC_RTADV_PREF          (_ipcfg.RtcAdvPref)
#define LLI_ARP_DOWN_TIME       (_ipcfg.RtArpDownTime)
#define LLI_KEEPALIVE_TIMEOUT   (_ipcfg.RtKeepaliveTime)
#define ROUTE_CLONE_TIMEOUT     (_ipcfg.RtCloneTimeout)
#define ROUTE_DEFAULT_MTU       (_ipcfg.RtDefaultMTU)
#define SOCK_TTL_DEFAULT        (_ipcfg.SockTtlDefault)
#define SOCK_TOS_DEFAULT        (_ipcfg.SockTosDefault)
#define SOCK_MAXCONNECT         (_ipcfg.SockMaxConnect)
#define SOCK_TIMECONNECT        (_ipcfg.SockTimeConnect)
#define SOCK_TIMEIO             (_ipcfg.SockTimeIo)
#define SOCK_BUFMAX             (_ipcfg.SockBufMax)
#define SOCK_BUFMINTX           (_ipcfg.SockBufMinTx)
#define SOCK_BUFMINRX           (_ipcfg.SockBufMinRx)
#define PIPE_TIMEIO             (_ipcfg.PipeTimeIo)
#define PIPE_BUFSIZE            (_ipcfg.PipeBufSize)
#define PIPE_BUFMINTX           (_ipcfg.PipeBufMinTx)
#define PIPE_BUFMINRX           (_ipcfg.PipeBufMinRx)

// IP Stack Config Default Values
#define DEF_ICMP_DO_REDIRECT        1
#define DEF_ICMP_TTL                64
#define DEF_ICMP_TTL_ECHO           255
#define DEF_IP_INDEX                1
#define DEF_IP_FORWARDING           0
#define DEF_IP_NATENABLE            0
#define DEF_IP_FILTERENABLE         0
#define DEF_IP_REASM_MAXTIME        10
#define DEF_IP_REASM_MAXSIZE        3020
#define DEF_IP_DIRECTED_BCAST       1
#define DEF_TCP_REASM_MAXPKT        2
#define DEF_RTC_ENABLE_DEBUG        0
#define DEF_RTC_RTADV_TIME          0   // Normally 15 when "forwarding"
#define DEF_RTC_RTADV_LIFE          120
#define DEF_RTC_RTADV_PREF          0
#define DEF_LLI_ARP_DOWN_TIME       20
#define DEF_LLI_KEEPALIVE_TIMEOUT   1200
#define DEF_ROUTE_CLONE_TIMEOUT     120
#define DEF_ROUTE_DEFAULT_MTU       1500
#define DEF_SOCK_TTL_DEFAULT        64
#define DEF_SOCK_TOS_DEFAULT        0
#define DEF_SOCK_MAXCONNECT         8
#define DEF_SOCK_TIMECONNECT        80
#define DEF_SOCK_TIMEIO             0
#define DEF_SOCK_BUFMAX             4096
#define DEF_SOCK_BUFMINTX           2048
#define DEF_SOCK_BUFMINRX           1
#define DEF_PIPE_TIMEIO             0
#define DEF_PIPE_BUFSIZE            1024
#define DEF_PIPE_BUFMINTX           256
#define DEF_PIPE_BUFMINRX           1

//-----------------------------------------------------------------------
//----[ EXEC ]-----------------------------------------------------------
//-----------------------------------------------------------------------

// Global Task Identifiers
#define ID_NULL         0
#define ID_LLI          1
#define ID_IP           2
#define ID_ROUTE        3
#define ID_NAT          4
#define ID_RTC          5
#define ID_IGMP         6
//---
#define ID_LAST         6

// Size of message block assigned to each task
#define MSG_BLOCK                       50

// The first "MSG_BLOCK" messages are reserved
#define MSG_EXEC_SYSTEM_INIT            1
#define MSG_EXEC_SYSTEM_SHUTDOWN        2
#define MSG_EXEC_LOW_RESOURCES          3

#define ExecHType(x) (((HDATA*)x)->Type)

// Exec Functions
_extern void    ExecOpen();
_extern void    ExecClose();
_extern void    ExecTimer();        // 1/10th second timer
_extern void    ExecLowResource();
_extern void    ExecHRef( HANDLE );

//-----------------------------------------------------------------------
//----[ TIMER ]----------------------------------------------------------
//-----------------------------------------------------------------------

// Timer Access Functions
_extern void    TimerHSTick();
_extern HANDLE  TimerNew( void (*pHandler)(uint), uint HSCount, uint Msg );
_extern void    TimerFree(HANDLE);

//-----------------------------------------------------------------------
//----[ SB ]-------------------------------------------------------------
//-----------------------------------------------------------------------

// SB Structure
typedef struct _sb {
             uint       Type;           // Set to TYPE_SB
             uint       Mode;           // Set to LINEAR or ATOMIC
             INT32      Total;          // Total readable chars in buffer
             INT32      Max;            // High water mark
             INT32      Min;            // Low water mark
             INT32      Head;           // Head Ptr Offset (Linear)
             INT32      Tail;           // Tail Ptr Offset (Linear)
             UINT8      *pData;         // Data Buffer     (Linear)
             PBM_Pkt    *pPktFirst;     // First Pkt       (Atomic)
             PBM_Pkt    *pPktLast;      // Last Pkt        (Atomic)
           } SB;

// SB Modes
#define SB_MODE_LINEAR          1
#define SB_MODE_ATOMIC          2
#define SB_MODE_HYBRID          3

// Access functions
_extern HANDLE SBNew( INT32  Max, INT32  Min, uint wMode );
_extern void   SBFree( HANDLE h );
_extern void   SBFlush( HANDLE h, uint fFree );
_extern INT32  SBRead( HANDLE h, INT32 Size, INT32 Offset, UINT8 *pbDst,
                      IPN *pIPFrom, uint *pPortFrom, UINT8 flagPeek );
_extern PBM_Pkt *SBReadNC( HANDLE h, IPN *pIPFrom, uint *pPortFrom );
_extern INT32  SBWrite( HANDLE h, INT32 Size, void *pData, PBM_Pkt *pPkt );

#ifdef _STRONG_CHECKING
_extern INT32  SBGetTotal( HANDLE h );
_extern INT32  SBGetMax( HANDLE h );
_extern INT32  SBGetMin( HANDLE h );
_extern void   SBSetMin( HANDLE h, UINT32 value );
_extern INT32  SBGetSpace( HANDLE h );
#else
#define SBGetTotal( h )         (((SB *)h)->Total)
#define SBGetMax( h )           (((SB *)h)->Max )
#define SBGetMin( h )           (((SB *)h)->Min )
#define SBSetMin( h, x )        (((SB *)h)->Min = x)
#define SBGetSpace( h )         (((SB *)h)->Max - ((SB *)h)->Total )
#endif

//-----------------------------------------------------------------------
//----[ IF ]-------------------------------------------------------------
//-----------------------------------------------------------------------

//-------------------------------------------------------------------------
// Generic IF Device Structure
//

typedef struct _ifdev {
        uint        Type;                     // Set to HTYPE_ETH
        uint        llIndex;                  // Low-level Device Index
        uint        ProtMTU;                  // MTU of payload
       } IFDEV;

//-----------------------------------------------------------------------
//
// Generic IF Access Functions
//
_extern void    IFInit();
_extern uint    IFMaxIndex();
#define         IFGetType(h)              (((IFDEV*)h)->Type)
_extern PBM_Pkt *IFCreatePacket( uint Size );
_extern void    IFSetPad( uint Header, uint Trailer );
_extern uint    IFIndexNew( HANDLE hIF, uint Index );
_extern void    IFIndexFree( uint Index );
_extern HANDLE  IFIndexGetHandle( uint Index );

#ifdef _STRONG_CHECKING
_extern uint    IFGetIndex( HANDLE hIF );
_extern uint    IFGetMTU( HANDLE hIF );
#else
#define         IFGetIndex( h )           (((IFDEV *)h)->llIndex)
#define         IFGetMTU( h )             (((IFDEV *)h)->ProtMTU)
#endif

#endif
