//--------------------------------------------------------------------------
// IP Stack Library
//--------------------------------------------------------------------------
// STACKSYS.H
//
// These are the base include files required to build an application that
// uses the stack, but does not have visibility into it.
//
// Author: Michael A. Denio
// Copyright 1999, 2000 by Texas Instruments Inc.
//-------------------------------------------------------------------------

#ifndef _C_SYS_H_
#define _C_SYS_H_

// Prevent warning from poorly coded stdlib.h in 4.31 codegen tools
#define _LLONG_AVAILABLE 0

// Standard C includes
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <stddef.h>

// C++ / C Function Declarations
#ifdef __cplusplus
#define _extern extern "C"
#define _externfar extern "C" far
#else
#define _extern extern
#define _externfar extern far
#endif

// Additional usertypes for use by the Stack, OS, and Applications
#include "usertype.h"
#include "serrno.h"
#include "socket.h"

// Operating System
#include "os\osif.h"

// Hardware Driver Support
#include "hal\hal.h"

#endif

