//--------------------------------------------------------------------------
// IP Stack Library
//--------------------------------------------------------------------------
// USERTYPE.H
//
// - Basic C types
// - Some IP related equates
// - Data access macros
//
// Author: Michael A. Denio
// Copyright 1999, 2001 by Texas Instruments Inc.
//-------------------------------------------------------------------------

#ifndef _C_USERTYPE_INC
#define _C_USERTYPE_INC

typedef char           INT8;
typedef short          INT16;
typedef int            INT32;
typedef unsigned char  UINT8;
typedef unsigned short UINT16;
typedef unsigned int   UINT32;
typedef unsigned int   uint;
typedef void *         HANDLE;
typedef UINT32         IPN;             // IP Address in NETWORK format

//-----------------------------------------------------------------------
// Data Host/Network Byte Order Conversion
//
#define HNC16(a) ( (((a)>>8)&0xff) + (((a)<<8)&0xff00) )
#define HNC32(a) ( (((a)>>24)&0xff) + (((a)>>8)&0xff00) +   \
                 (((a)<<8)&0xff0000) + (((a)<<24)&0xff000000) )

//-----------------------------------------------------------------------
// 32 Bit Data Macros (from 16 bit aligned data)
//
//#define RdNet32(x)   (*(UINT32 *)(x))
//#define WrNet32(x,y) (*(UINT32 *)(x) = y)
#define RdNet32(x)   ((UINT32)(*(UINT16 *)(x))|((UINT32)(*(UINT16 *)(((UINT8 *)(x))+2))<<16))
#define WrNet32(x,y) *(UINT16 *)(x)=(UINT16)(y); *(UINT16 *)(((UINT8 *)(x))+2)=(UINT16)((y)>>16)

//-----------------------------------------------------------------------
// READ/WRITE Macros (aligned)
//
#define READ32(x)    (*(volatile unsigned int *)x)
#define WRITE32(x,y) (*(volatile unsigned int *)(x) = (y))

//-----------------------------------------------------------------------
// IP Address Related Equates
//
#define IN_CLASSA(x)            (((UINT32)(x) & 0x00000080l) == 0l)
#define IN_CLASSB(x)            (((UINT32)(x) & 0x000000c0l) == 0x00000080l)
#define IN_CLASSC(x)            (((UINT32)(x) & 0x000000e0l) == 0x000000c0l)
#define IN_CLASSD(x)            (((UINT32)(x) & 0x000000f0l) == 0x000000e0l)
#define IN_MULTICAST(x)         IN_CLASSD(x)
#define IN_EXPERIMENTAL(x)      (((UINT32)(x) & 0x000000f0l) == 0x000000f0l)
#define IN_LOOPBACK(x)          (((UINT32)(x) & 0x000000ffl) == 0x0000007fl)
#define INADDR_ANY              0x00000000l     // 0.0.0.0
#define INADDR_BROADCAST        0xffffffffl     // 255.255.255.255

#endif

