/*
 *  Copyright 2003 by Texas Instruments Incorporated.
 *  All rights reserved. Property of Texas Instruments Incorporated.
 *  Restricted rights to use, duplicate or disclose this code are
 *  granted through contract.
 *  
 */
/* "@(#) DDK 1.11.00.00 11-04-03 (ddk-b13)" */
#include <std.h>
#include <tsk.h>  
#include <sem.h>   
#include <gio.h>
#include <csl_gpio.h>
#include <csl_dat.h>
#include <csl_cache.h>

#include <fvid.h>
#include <edc.h>

#include "appData.h"
#include "scom.h"
#include "seeddm642.h"
#include "Tcpip_loopbackcfg.h" 

/* heap IDs defined in the BIOS configuration file */
extern Int EXTERNALHEAP;

void Led_glitter();

/*
 * ======== main ========
 */
main()
{
    /******************************************************/
    /* open CSL DAT module for fast copy                  */
    /******************************************************/
    CSL_init();                                                 
    CACHE_enableCaching(CACHE_EMIFA_CE00);
    CACHE_enableCaching(CACHE_EMIFA_CE01);
    DAT_open(DAT_CHAANY, DAT_PRI_LOW, DAT_OPEN_2D);
    
    SCOM_init();
   	
	// Glitter the indicator to indicate bootloader successfully
	Led_glitter();
	
	CACHE_setL2Queue(0x3, 0x7);
    CACHE_setL2Queue(0x1, 0x7);
    CACHE_setPriL2Req(CACHE_L2PRIHIGH);

    // create all SCOM and message objects                   
	SCOM_create("NETOK", NULL); 
}

void Timerdelay()
{
 	static unsigned int i,j,k;
 	
 	i=0;
 	for(j=0; j<0x800; j++)
 	{
 	 	for(k=0; k<0x2000; k++)
 	 	{
 	 		i=i+2;	
 	 		if(i>0x1000)
 	 		i=0;
 	 	}
 	 	i++;
 	 	if(i>0x1000)
 	 	i=0;
 	}
}


// ˸ָʾ	
void Led_glitter()
{
	unsigned int i;
	Uint32 vGpen, vGpdir;
	
	// SEEDVPM642LED
	vGpen = GPIO_RGET(GPEN);
	vGpdir = GPIO_RGET(GPDIR);
	
    GPIO_RSET(GPEN,0x108);
	GPIO_RSET(GPDIR,0x108);		
	
	for(i=0; i<4; i++)
	{
		// صָʾ
		GPIO_RSET(GPVAL,0x8);
		Timerdelay();
			
		// ָʾ
		GPIO_RSET(GPVAL,0x100);
		Timerdelay();
	}	
	GPIO_RSET(GPEN,vGpen);
	GPIO_RSET(GPDIR,vGpdir);	
}

