//--------------------------------------------------------------------------
// IP Stack Client Demo
//--------------------------------------------------------------------------
// dm642init.c
//
// Private initialization functions for EVMDM642
//
// Author: Michael A. Denio
// Copyright 2003 by Texas Instruments Inc.
//--------------------------------------------------------------------------
#include <stdio.h>

#include "..\ndk\inc\netmain.h"
#include <std.h>
#include <fvid.h>
#include <csl_dat.h>
#include <csl_cache.h>
#include <tsk.h>
#include <seeddm642.h>
#include <appmain.h>
#include <scom.h>
#include <utl.h>
#include <ialg.h>

// New CSL Functions in csl_mdio.c
CSLAPI uint MDIO_phyRegWrite( uint phyIdx, uint phyReg, Uint16 data );
CSLAPI uint MDIO_phyRegRead( uint, uint, UINT16 * );

extern int StackTest();

// This string array corresponds to link state as define in csl_mdio.h
static char *LinkStr[] = { "No Link",
                           "10Mb/s Half Duplex",
                           "10Mb/s Full Duplex",
                           "100Mb/s Half Duplex",
                           "100Mb/s Full Duplex" };

//static UINT8 bMacAddr[8]={0x08,0x00,0x28,0x34,0x0f,0x7f,0x00,0x0a};
static UINT8 bMacAddr[8]={0x08,0x00,0x28,0x34,0x0f,0x7f,0x00,0x0a};

MACAddress macaddress;
//gloable  link state
int  linkstatus = 0;

void dm642_init()
{
    // Init the EVM
	SEEDVPM642_init();
 	strcpy(macaddress.cVersion,"MAC");
	macaddress.bMacAddr[0] = 0xf1;
	macaddress.bMacAddr[1] = 0xf1;
	macaddress.bMacAddr[2] = 0xf1;
	
	macaddress.bMacAddr[3] = 0x0d;
	macaddress.bMacAddr[4] = 0x01;//λ
	macaddress.bMacAddr[5] = 0x01;//λ
	
	macaddress.bMacAddr[6] = 0x0e;
	macaddress.bMacAddr[7] = 0x0f;	
}

//
// This is a callback from the Ethernet driver. This function
// is used by the driver to get its 6 byte MAC address, and
// to determine which DSP interrupt the EMAC should be mapped to.
//
void DM642EMAC_getConfig( UINT8 *pMacAddr, uint *pIntVector )
{
       printf("Using MAC Address: %02x-%02x-%02x-%02x-%02x-%02x\n",
            macaddress.bMacAddr[0], macaddress.bMacAddr[1], macaddress.bMacAddr[2],
            macaddress.bMacAddr[3], macaddress.bMacAddr[4], macaddress.bMacAddr[5]);

    // We fill in the two pointers here. We'll use int 15 for EMAC
    mmCopy( pMacAddr, bMacAddr, 6 );
    *pIntVector = 15;
}

//
// DM642EMAC_linkStatus()
//
// This is a callback from the Ethernet driver. This function
// is called whenever there is a change in link state. The
// current PHY and current link state are passed as parameters.
//
void DM642EMAC_linkStatus( uint phy, uint linkStatus )
{
    SCOM_Handle hs_Netok;

    hs_Netok = SCOM_open("NETOK");

    printf("Link Status: %s\n",LinkStr[linkStatus]);
    
    if (linkStatus>0)
    {
	    linkstatus = 1;
	}
    else
    {
	    linkstatus = 0;
	}   	
	SCOM_putMsg(hs_Netok,NULL);
    // Since we know we're using the Intel PHY, we'll
    // go ahead and program the LEDs to make sense.
    MDIO_phyRegWrite( phy, 0x14, 0xd5d0 );
}





