/****************************************************************************/
/*  C6678_unified.cmd                                                       */
/*                        */
/*  Author: zx                                               */

/****************************************************************************/
-stack 0x20000
-heap 0x2000
MEMORY
{
	VECTORS: 	o = 0x10800000  l = 0x00000200
    LOCAL_L2_SRAM:  o = 0x10800200 l = 0x0007fe00   /* 512kB LOCAL L2/SRAM */

	mtd_back:			o = 0x0C000040  l = 0x00000020
	velcell:			o = 0x0C000060  l = 0x00000010

	mtd_result_data:	o = 0x0C000250  l=	0x00000040
	core5_num: 			o = 0x0C000290  l=	0x00000010
	cfar_mark:			o = 0x0C0002a0  l=	0x00000020

	work_mode:			o = 0x0C0002c8  l=	0x00000008
	wave_type:			o = 0x0C0002d0  l=	0x00000008
	cpi_cnt:			o = 0x0C0002d8  l=	0x00000008
	cpi_cnt_all:		o = 0x0C0002e0  l=	0x00000008
	mf_length:          o = 0x0C0002e8  l=	0x00000008
	srio_ok:           	o = 0x0C0002f0  l=	0x00000010
	data_ok:			o = 0x0C000300  l=	0x00000010
	share_flag:			o = 0x0C000310  l = 0x00000FF0 ////ģʽΡ롢ٶȡǶȵ״̬Ϣ
														////ܿݡָܿձ־

	MSMC0_bss:          o = 0x0C001300  l = 0x000001f0
	MSMC0_near:         o = 0x0C0014f0  l = 0x00000210
	MSMC0_wavesel:      o = 0x0C001700  l = 0x0000c000
	MSMC0:          	o = 0x0C00d700  l = 0x00073c00
	MSMC1:				o = 0x0C081300  l = 0x00080000
	MSMC2:				o = 0x0C101300  l = 0x00040000
	MSMC3:				o = 0x0C141300  l = 0x00040000
	MSMC4:				o = 0x0C181300  l = 0x00040000
	MSMC5:				o = 0x0C1c1300  l = 0x00040000


	MSMC7:				o = 0x0C201300  l = 0x00070000
	zk_back:      		o = 0x0C271300  l = 0x00000010
	zxinstr:			o = 0x0C271310  l = 0x00000010
	network_data:  		o = 0x0C271320  l = 0x00000190
	netdata_back:		o = 0x0C2714b0  l = 0x00000190

    uart_mem:			o = 0x0C271640  l = 0x000000d0
    cpiresult_mem:      o = 0x0C271710  l = 0x000000d0

	w_sp:    			o = 0x0C281300  l = 0x00010000
	MSMC6:       		o = 0x0C291300  l = 0x00080000
	MSM_RESERVR:       o = 0x0C311400  l = 0x0008ec00

    DDR3_DATA: 		o = 0x80000000 l = 0x20000000
    DDR3_RESERVE:   o = 0xA0000000 l = 0x60000000   /* 2GB CE0 and CE1 external DDR3 SDRAM */
}

SECTIONS
{
	vecs       	>    VECTORS
	.csl_vect      >  MSMC0
    .text          >  MSMC0
    .stack         >  MSMC0
    .bss           >  MSMC0_bss
    .cio           >  MSMC0
    .const         >  MSMC0
    .data          >  MSMC0
    .switch        >  MSMC0
    .sysmem        >  MSMC0
    .far           >  MSMC0
    .args          >  MSMC0
    /* COFF sections */
    .pinit         >  MSMC0
    .cinit         >  MSMC0
    /* EABI sections */
    .binit         >  MSMC0
    .init_array    >  MSMC0
    .neardata      >  MSMC0_near
    .fardata       >  MSMC0
    .rodata        >  MSMC0
    /*my data sections*/
    .zk_instr   >    zxinstr
	.mtd_back     >  mtd_back
	.zxback > zk_back
	.zkdata > network_data
	.result  > mtd_result_data
	.cfarmark > cfar_mark
	.zkdataback > netdata_back
	.workmode > work_mode
	.dataok >   data_ok
	.wavetype > wave_type
	.cpicnt  >  cpi_cnt
	.cpicntall >cpi_cnt_all
	.mflength > mf_length
	.sriook   >srio_ok
	.vel_cell  >velcell
	.core5num>  core5_num
	.wave_sel   >MSMC0_wavesel

	.uartdata >uart_mem
	.cpiresult >cpiresult_mem

	platform_lib  >MSMC0
}
