#include <TIMER_interrupt_armL138.h>


/* OMAPL138 EDMA3 test */
#define DIR8       *(unsigned int *)0x01E260B0
#define OUT_DATA8  *(unsigned int *)0x01E260B4
#define SET_DATA8  *(unsigned int *)0x01E260B8
#define CLR_DATA8  *(unsigned int *)0x01E260BC
#define  IN_DATA8  *(unsigned int *)0x01E260C0
#define SET_RIS_TRIG8  *(unsigned int *)0x01E260C4 
#define CLR_RIS_TRIG8  *(unsigned int *)0x01E260C8
#define SET_FAL_TRIG8  *(unsigned int *)0x01E260CC
#define CLR_FAL_TRIG8  *(unsigned int *)0x01E260D0
#define      INTSTAT8  *(unsigned int *)0x01E260D4

unsigned int SRCBuffer0[1024];
unsigned int DSTBuffer0[1024];

unsigned int SRCBuffer1[1024];
unsigned int DSTBuffer1[1024];

#define PINMUX18 *(unsigned int *)0x01C14168
void GPIO_init()
{

	 *(unsigned int *)0x01E26008 = 0x100;
	 PINMUX18  |= (8<<8);
	 DIR8 = 0x8000; //set GP8[15] as input.
	 INTSTAT8 = 0xffff; //clear pending interrupt
	 SET_RIS_TRIG8 = 0x8000; //set GP8[15] as rising edge interrupt.
}

//GP8 to trigger CC1 event 18, EDMA3_1_CC0_INT0 on Shadow Region 0.
//EDMA3_1 base 0x01E30200
#define    DRAE0_1 *(unsigned int *)0x01E30340
#define    EMCR_1  *(unsigned int *)0x01E30308 //Event Missed Clear Register
#define CCERRCLR_1 *(unsigned int *)0x01E3031C  //EDMA3CC Error Clear Register

#define EDMA_1_0_ER   *(unsigned int *)0x01E32000
#define EDMA_1_0_ECR  *(unsigned int *)0x01E32008
#define EDMA_1_0_ESR  *(unsigned int *)0x01E32010
#define EDMA_1_0_CER  *(unsigned int *)0x01E32018
#define EDMA_1_0_EER  *(unsigned int *)0x01E32020
#define EDMA_1_0_EECR  *(unsigned int *)0x01E32028
#define EDMA_1_0_EESR  *(unsigned int *)0x01E32030
#define EDMA_1_0_SER  *(unsigned int *)0x01E32038
#define EDMA_1_0_SECR  *(unsigned int *)0x01E32040
#define EDMA_1_0_IER  *(unsigned int *)0x01E32050
#define EDMA_1_0_IECR  *(unsigned int *)0x01E32058
#define EDMA_1_0_IESR  *(unsigned int *)0x01E32060
#define EDMA_1_0_IPR  *(unsigned int *)0x01E32068
#define EDMA_1_0_ICR  *(unsigned int *)0x01E32070
#define EDMA_1_0_IEVAR  *(unsigned int *)0x01E32078
#define ParameterBase_EDMA_1 0x01E34000 
#define ParameterBase_EDMA_1_18_OPT          *(unsigned int *)(0x01E34000+18*32)
#define ParameterBase_EDMA_1_18_SRC          *(unsigned int *)(0x01E34244)
#define ParameterBase_EDMA_1_18_A_B_CNT      *(unsigned int *)(0x01E34248)
#define ParameterBase_EDMA_1_18_DST          *(unsigned int *)(0x01E3424C)
#define ParameterBase_EDMA_1_18_SRC_DST_BIDX *(unsigned int *)(0x01E34250)
#define ParameterBase_EDMA_1_18_LINK_BCNTRLD *(unsigned int *)(0x01E34254)
#define ParameterBase_EDMA_1_18_SRC_DST_CIDX *(unsigned int *)(0x01E34258)
#define ParameterBase_EDMA_1_18_CCNT         *(unsigned int *)(0x01E3425C)

#define ParameterBase_EDMA_1_36_OPT          *(unsigned int *)(0x01E34000+36*32)
#define ParameterBase_EDMA_1_36_SRC          *(unsigned int *)(0x01E34484)
#define ParameterBase_EDMA_1_36_A_B_CNT      *(unsigned int *)(0x01E34488)
#define ParameterBase_EDMA_1_36_DST          *(unsigned int *)(0x01E3448C)
#define ParameterBase_EDMA_1_36_SRC_DST_BIDX *(unsigned int *)(0x01E34490)
#define ParameterBase_EDMA_1_36_LINK_BCNTRLD *(unsigned int *)(0x01E34494)
#define ParameterBase_EDMA_1_36_SRC_DST_CIDX *(unsigned int *)(0x01E34498)
#define ParameterBase_EDMA_1_36_CCNT         *(unsigned int *)(0x01E3449C)

void EDMA3_init()
{
	unsigned int i=0;
	//init buffer
	for (i = 0; i<1024; i++)
	{
		DSTBuffer0[i]=0;
	 	DSTBuffer1[i]=0;
		SRCBuffer0[i]=0x55555555;
		SRCBuffer1[i]=0xAAAAAAAA;
	}

	DRAE0_1 = 0x00040000; //Enable EDMA1 channel 18: GPIO_Bank8 Event on Region 0.
    EDMA_1_0_EECR = 0xFFFFFFFF; //Clear all event.
    EDMA_1_0_EESR = 0x00040000; //Enable Event 18

    EDMA_1_0_IECR = 0xFFFFFFFF; //Clear all interrupt
    EDMA_1_0_IESR = 0x00040000; //Enable interrupt 18

	EDMA_1_0_ICR = 0xFFFFFFFF; // Clear all pending interrupt


 // Initial Parameter for event/channel 18.
	ParameterBase_EDMA_1_18_OPT = ( 0<<23 | 0<<22 | 0<<21 | 1<<20 | 18<<12 | 0<<11 | 0<<3 | 1<<2 | 0); //OPT
    ParameterBase_EDMA_1_18_SRC = (unsigned int)SRCBuffer0;
    ParameterBase_EDMA_1_18_A_B_CNT = (4<<16 | 1024);
    ParameterBase_EDMA_1_18_DST = (unsigned int)DSTBuffer0;
	ParameterBase_EDMA_1_18_SRC_DST_BIDX = (1024<<16 |1024);
	ParameterBase_EDMA_1_18_LINK_BCNTRLD = (0<<16 | 0x480);
	ParameterBase_EDMA_1_18_SRC_DST_CIDX = 0;
	ParameterBase_EDMA_1_18_CCNT = 1;

	ParameterBase_EDMA_1_36_OPT = ( 0<<23 | 0<<22 | 0<<21 | 1<<20 | 18<<12 | 0<<11 | 0<<3 | 1<<2 | 0<<1 |0); //OPT
    ParameterBase_EDMA_1_36_SRC = (unsigned int)SRCBuffer1;
    ParameterBase_EDMA_1_36_A_B_CNT = (4<<16 | 1024);
    ParameterBase_EDMA_1_36_DST = (unsigned int)DSTBuffer1;
	ParameterBase_EDMA_1_36_SRC_DST_BIDX = (1024<<16 |1024);
	ParameterBase_EDMA_1_36_LINK_BCNTRLD = (0<<16 | 0x480);
	ParameterBase_EDMA_1_36_SRC_DST_CIDX = 0;
	ParameterBase_EDMA_1_36_CCNT = 1;

	printf("Pulse on GPIO bank 8 trigger EDMA;\n"
			"Note: Any pin on one Bank generate the same EDMA Event!\n");
}

unsigned int counter1=0;
void EDMA3_1_ISR()
{
	printf("\tEDMA Interrupt Count: %d\n", counter1);
	CSL_FINS(aintcRegs->SICR, AINTC_SICR_INDEX, AINTC_EVENTID_EDMA3_1_CC0_INT0); //Clear AINTC status.
	EDMA_1_0_ICR = EDMA_1_0_IPR; //Clear EDMA IPR
	counter1++;
}

