/* =========================================================================*
 * OMAPL138_ARM.cmd - Linker Command File for Linking OMAPL138 ARM Programs	*
 * 																			*
 * These linker options are for command line linking only. For IDE linking, *
 * you should set your linker options in Project Properties.				*
 * 		-c					Link Using C Conventions						*
 *		-stack 	0x1000		Software Stack Size								*
 *		-heap	0x1000		Heap Area Size									*
 * =========================================================================*/
-stack 0x1000
-heap 0x1000
-e _init_stack
--diag_remark=10063

/* =========================================================================*
 * 						Specify the System Memory Map						*
 * =========================================================================*/
MEMORY
{
	SHAREDRAM:		o = 0x80000000		l = 0x00020000
	ARMRAM:			o = 0xFFFF0000		l = 0x00002000
	DDR:            o = 0xC0000000      l = 0x1000000
}

/* =========================================================================*
 * 				Specify the Sections Allocation into Memory					*
 * =========================================================================*/
SECTIONS
{
	.cinit		>		DDR		/* Initialization Tables			*/
	.pinit		>		DDR		/* C++ Constructor Tables			*/
	.const		>		DDR		/* Constant Data					*/
	.switch		>		DDR		/* Jump Tables						*/
	.text		>		DDR		/* Executable Code					*/
	
	.bss		>		DDR		/* Global & Static Variables 		*/
	.far		>		DDR		/* Far Global & Static Variables	*/
	.stack		>		DDR		/* Software System Stack			*/
	.svcstack	>		DDR		/* Supervisor Mode Stack			*/
	.irqstack	>		DDR		/* IRQ Interrupt Stack				*/
	.fiqstack	>		DDR		/* FIQ Interrupt Stack				*/
	.sysmem		>		DDR		/* Dynamic Memory Allocation Area 	*/

	.cio		>		DDR		/* C I/O Buffer						*/
	.intvecs	>		ARMRAM			/* Interrupt Vectors				*/
	.data		>		DDR
}