/**
 * \file McASPEdma.c
 *
 * \brief  This is a sample application file which invokes 
 *         some APIs from the McASP device abstraction layer 
 *         and EDMA3 device abstraction layer to perform 
 *         configuration
 *
 */

/* Copyright (C) 2010 Texas Instruments Incorporated - http://www.ti.com/
 * ALL RIGHTS RESERVED
 */
#include "edma.h"
#include "types.h"
//#include "rk6748.h"
//#include "rk6748.c"
#include "stdio.h"
#include "mcasp_edma3.h"
#include "rk6748_mcasp.h"
#include "rk6748_aic3106.h"
#include "rk6748_i2c.h"
#include "edma_event.h"
/*
** This function configures the power supply for EDMA3 Channel Controller 0
** and Transfer Controller 0, registers the EDMA interrupts in AINTC.
*/
extern void RK6748_pinmuxConfig(UINT32 in_reg, UINT32 in_mask, UINT32 in_val);
extern void RK6748_lpscTransition(psc_regs_t *psc, UINT32 in_domain, UINT8 in_module, UINT8 in_next_state);
extern unsigned int  *input_audio_32bit;
unsigned int evtQ = 0;

static void EDMA3Initialize(void)
{
    /* Enabling the PSC for EDMA3CC_0).*/ 
      RK6748_lpscTransition(PSC0, DOMAIN0, LPSC_UART0, PSC_ENABLE);

    /* Initialization of EDMA3 */    
      EDMA3Init(SOC_EDMA30CC_0_REGS, evtQ);
   
}
/*
** This function is used to set the PaRAM entries of EDMA3 for the Transmit 
** Channel of McASP. The corresponding EDMA3 channel is also enabled for 
** reception.
*/
void setup_edma_pingpong_xmt(void *src_ping, void *src_pong, void *dst,
		Uint32 acnt, Uint32 bcnt)
{
     EDMA3CCPaRAMEntry paramSet;

    // 1. setup channel PaRAM slot
    paramSet.opt = (EDMA_XMT_PING_TCC << 12) | (1 << 20);      // transfer complete interrupt enabled
    paramSet.srcAddr = (Uint32)src_ping;                  //srcAddr holds address of memory location buffer
    paramSet.destAddr = (Uint32)dst;
    paramSet.aCnt = acnt;                                     //aCnt holds the number of bytes in an array
    paramSet.bCnt = bcnt;                                    // bCnt holds the number of such arrays to be transferred  
    paramSet.srcBIdx = 0;
    paramSet.destBIdx= (acnt << 16);
    paramSet.linkAddr =  (EDMA_XMTPONG * 0x20);  //Linking transfers in EDMA3 
    paramSet.bCntReload = (unsigned short)0;
    paramSet.srcCIdx = 0;                                 // actual format: DSTCIDX|SRCCIDX
    paramSet.destCIdx = 0; 
    paramSet.cCnt = 1;                                     //cCnt holds the number of frames of aCnt*bBcnt bytes to be transferred  
     
    // 2.Now write the PaRam Set to EDMA3
    EDMA3SetPaRAM(SOC_EDMA30CC_0_REGS, EDMA3_CHA_MCASP0_TX, &paramSet);
    
    // 3. setup ping PaRAM set (to be reloaded later)
    EDMA3SetPaRAM(SOC_EDMA30CC_0_REGS, EDMA_XMTPING, &paramSet);
    
    // 4. setup pong PaRAM set (to be loaded and reloaded later)
    paramSet.opt = (EDMA_XMT_PONG_TCC << 12) | (1 << 20);      // transfer complete interrupt enabled
    paramSet.linkAddr =  (EDMA_XMTPING * 0x20);  //Linking transfers in EDMA3 
    paramSet.bCntReload = (unsigned short)0;
    paramSet.srcAddr = (Uint32)src_pong;                  //srcAddr holds address of memory location buffer
    EDMA3SetPaRAM(SOC_EDMA30CC_0_REGS, EDMA_XMTPONG, &paramSet);
    
}
/*
** This function is used to set the PaRAM entries of EDMA3 for the Receive 
** Channel of McASP. The corresponding EDMA3 channel is also enabled for 
** reception.
*/
void setup_edma_pingpong_rcv(void *src, void *dst_ping, void *dst_pong,
		Uint32 acnt, Uint32 bcnt)
{
    EDMA3CCPaRAMEntry paramSet;

    // 1. setup channel PaRAM slot
    paramSet.opt = (EDMA_RCV_PING_TCC << 12) | (1 << 20);      // transfer complete interrupt enabled
    paramSet.srcAddr = (Uint32)src;                  //srcAddr holds address of memory location buffer
    paramSet.destAddr = (Uint32)dst_ping;
    paramSet.aCnt = acnt;                                     //aCnt holds the number of bytes in an array
    paramSet.bCnt = bcnt;                                    // bCnt holds the number of such arrays to be transferred  
    paramSet.srcBIdx = 0;
    paramSet.destBIdx= (acnt << 16);
    paramSet.linkAddr =  (EDMA_RCVPONG * 0x20);  //Linking transfers in EDMA3 
    paramSet.bCntReload = (unsigned short)0;
    paramSet.srcCIdx = 0;                                 // actual format: DSTCIDX|SRCCIDX
    paramSet.destCIdx = 0; 
    paramSet.cCnt = 1;                                     //cCnt holds the number of frames of aCnt*bBcnt bytes to be transferred 
    // 2.Now write the PaRam Set to EDMA3
    EDMA3SetPaRAM(SOC_EDMA30CC_0_REGS, EDMA3_CHA_MCASP0_RX, &paramSet);
    
    // 3. setup ping PaRAM set (to be reloaded later)
    EDMA3SetPaRAM(SOC_EDMA30CC_0_REGS, EDMA_RCVPING, &paramSet); 
    // 4. setup pong PaRAM set (to be loaded and reloaded later)
    paramSet.opt = (EDMA_RCV_PONG_TCC << 12) | (1 << 20);      // transfer complete interrupt enabled
    paramSet.linkAddr =  (EDMA_RCVPING * 0x20);  //Linking transfers in EDMA3 
    paramSet.bCntReload = (unsigned short)0;
    paramSet.destAddr = (Uint32)dst_pong;                  //srcAddr holds address of memory location buffer
    EDMA3SetPaRAM(SOC_EDMA30CC_0_REGS, EDMA_RCVPONG, &paramSet);
}

/*
** This function allocates EDMA3 channels to McASP for trasmisssion and
** reception purposes.
*/
static void RequestEDMA3Channels(void)
{
    /* Request DMA Channel and TCC for McASP Transmit*/
    EDMA3RequestChannel(SOC_EDMA30CC_0_REGS, EDMA3_CHANNEL_TYPE_DMA, 
                        EDMA3_CHA_MCASP0_TX, EDMA3_CHA_MCASP0_TX, evtQ);

    /* Request DMA Channel and TCC for McASP Receive*/
    EDMA3RequestChannel(SOC_EDMA30CC_0_REGS, EDMA3_CHANNEL_TYPE_DMA, 
                        EDMA3_CHA_MCASP0_RX, EDMA3_CHA_MCASP0_RX, evtQ); 
}

void shutdownAudio(void)
{
   // close codec.
   AIC3106_writeRegister(AIC3106_REG_PAGESELECT, 0);
   AIC3106_writeRegister(AIC3106_REG_RESET, 0x80);

   // close mcasp.
   MCASP->SRCTL0 = 0;
   MCASP->SRCTL1 = 0;
   MCASP->SRCTL2 = 0;
   MCASP->SRCTL3 = 0;
   MCASP->SRCTL5 = 0;
   MCASP->SRCTL11 = 0;
   MCASP->SRCTL12 = 0;
   MCASP->GBLCTL = 0;
}


static void audio_run(void)
{
    while (1)
    {
        // ping
   //     SEM_pend(&rcv_ping_sem, SYS_FOREVER);
   //     SEM_pend(&xmt_ping_sem, SYS_FOREVER);
        memcpy(xmt_ping, rcv_ping, BUF_SIZE); // (placeholder)

        // pong
   //     SEM_pend(&rcv_pong_sem, SYS_FOREVER);
   //     SEM_pend(&xmt_pong_sem, SYS_FOREVER);
        memcpy(xmt_pong, rcv_pong, BUF_SIZE); // (placeholder)
    }
}

void AudioLineIn(void)
{
   UINT32 rtn = ERR_NO_ERROR;
   UINT16 msec, sec, sample;
   UINT16 dat;
// loop audio
   for (sec = 0; sec < 30; sec++)
   {
      for (msec = 0; msec < 1000; msec++)
      {
         for (sample = 0; sample < 48; sample++)
         {
            // wait for recv ready and send a sample to the left channel.
            while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}
   			MCASP->XBUF12 = dat<<16;
            dat = MCASP->XBUF11;
            // wait for recv ready and send a sample to the right channel.
            while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}
   			MCASP->XBUF12 = dat<<16;
            dat = MCASP->XBUF11;

			//put_audio_32bit[sec*msec+sample]=dat<<16;

			/*

			       while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}
   			MCASP->XBUF12 = dat;
            dat = MCASP->XBUF11;

            // wait for recv ready and send a sample to the right channel.
            while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}
   			MCASP->XBUF12 = dat;
            dat = MCASP->XBUF11;

            */
         }
      }
   }

}



//-----------------------------------------------------------------------------
// Static TSK Function
//-----------------------------------------------------------------------------

void audio_tsk_fxn(void)
{
    printf("------------------------------------------------------------\r\n");
    printf("					  C6748 Audio CODEC Test\r\n\r\n");

    printf("Additional Equipment\r\n");
    printf("--------------------\r\n");
    printf("- 3.5mm pass through cable\r\n\r\n");
    printf("- 3.5mm headphones\r\n\r\n");

    printf("Test Description\r\n");
    printf("----------------\r\n");
    printf("The test will begin by playing a 5 second tone though the line\r\n");
    printf("out port. The 3.5mm pass through cable will not be needed for\r\n");
    printf("this portion of the test. After playing the tone, audio from the\n\r");
    printf("line in port will be played through the line out port for 15 seconds.\r\n");
    printf("--------------------------------------------------------------------\r\n\r\n");

     //------------------------------------
     // initialize the required bsl modules
     //------------------------------------
    printf("Initialize the Required BSL Modules\r\n");
    printf("-----------------------------------\r\n\r\n");
    printf("[audio TSK]: starting audio TSK...");
    
    // configure and start EDMA channels
    printf( "[audio TSK]: setting up EDMA...");
	

    setup_edma_pingpong_rcv(MCASP->RBUF0, rcv_ping, rcv_pong,
                            BYTES_PER_SAMPLE, N_CHANNELS);

    setup_edma_pingpong_xmt(xmt_ping, xmt_pong, MCASP->XBUF0,
                            BYTES_PER_SAMPLE, N_CHANNELS);

    RequestEDMA3Channels();

    EDMA3EnableEvtIntr(SOC_EDMA30CC_0_REGS, EDMA_RCV_PING_TCC);
    EDMA3EnableEvtIntr(SOC_EDMA30CC_0_REGS, EDMA_RCV_PONG_TCC);
    EDMA3EnableEvtIntr(SOC_EDMA30CC_0_REGS, EDMA_XMT_PING_TCC);
    EDMA3EnableEvtIntr(SOC_EDMA30CC_0_REGS, EDMA_XMT_PONG_TCC);

    // setup codec and McASP
    printf("[audio TSK]: initializing audio device...");
    I2C_init(I2C0, I2C_CLK_100K);
    AIC3106_init();
    MCASP_init();
    //AudioLineIn();//

    // run audio test
	printf("[audio TSK]: running audio processing loop...");
    //  audio_run();

    printf("\r\n--- audio Sound recording  test over! ---\r\n");
	
    // close codec and mcasp.
    //shutdownAudio();
    // close application
}

interrupt void EDMA3cc_ISR()
{
    unsigned int StatusVal = EDMA3GetIntrStatus(SOC_EDMA30CC_0_REGS);
    while(StatusVal)
    {
        if (StatusVal & (1 << EDMA_RCV_PING_TCC))    // receive channel (ping)
        {
            EDMA3ClrIntr(SOC_EDMA30CC_0_REGS, EDMA_RCV_PING_TCC);          
            //SEM_post(&rcv_ping_sem);
            //Printf( "[ISR]: receive ping!");
        }

        if (StatusVal & (1 << EDMA_RCV_PONG_TCC))    // receive channel (pong)
        {
            EDMA3ClrIntr(SOC_EDMA30CC_0_REGS, EDMA_RCV_PONG_TCC); 
            //SEM_post(&rcv_pong_sem);
            //Printf( "[ISR]: receive pong!");
        }

        if (StatusVal & (1 << EDMA_XMT_PING_TCC))    // transmit channel (ping)
        {
            EDMA3ClrIntr(SOC_EDMA30CC_0_REGS, EDMA_XMT_PING_TCC); 
            //SEM_post(&xmt_ping_sem);
            //Printf("[ISR]: transmit ping!");
        }

        if (StatusVal & (1 << EDMA_XMT_PONG_TCC))    // transmit channel (pong)
        {
            EDMA3ClrIntr(SOC_EDMA30CC_0_REGS, EDMA_XMT_PONG_TCC); 
            //SEM_post(&xmt_pong_sem);
            //Printf("[ISR]: transmit pong!");
        }
    }

    return;
}
