//------------------------------------------------------------------------------
// File mcasp_edma3.h
//------------------------------------------------------------------------------
// Copyright (c) 2010 Texas Instruments, Inc.
// All rights reserved
//------------------------------------------------------------------------------
#include "rk6748.h"
#define EDMA_RCV_PING_TCC     1
#define EDMA_RCV_PONG_TCC    2
#define EDMA_XMT_PING_TCC     3
#define EDMA_XMT_PONG_TCC    4

#define EDMA_XMTPING          12
#define EDMA_XMTPONG         13
#define EDMA_RCVPING           14
#define EDMA_RCVPONG          15

#define SAMPLES_PER_BUF     128
#define BYTES_PER_SAMPLE    4
#define N_CHANNELS          2

#define BUF_LENGTH          SAMPLES_PER_BUF * N_CHANNELS
#define BUF_SIZE            SAMPLES_PER_BUF * N_CHANNELS * BYTES_PER_SAMPLE

//-----------------------------------------------------------------------------
// Static Variable Declarations
//-----------------------------------------------------------------------------

static Uint32 rcv_ping[BUF_LENGTH], rcv_pong[BUF_LENGTH],
               xmt_ping[BUF_LENGTH], xmt_pong[BUF_LENGTH];
              
/****************************************************************************/
/*                         GLOBAL VARIABLES                                 */
/****************************************************************************/


/****************************************************************************/
/*                     API FUNCTION DEFINITIONS                             */
/****************************************************************************/
static void EDMA3Initialize(void);
void setup_edma_pingpong_xmt(void *src_ping, void *src_pong, void *dst,
		Uint32 acnt, Uint32 bcnt);
void setup_edma_pingpong_rcv(void *src, void *dst_ping, void *dst_pong,
		Uint32 acnt, Uint32 bcnt);
void audio_tsk_fxn(void);
static void audio_run(void);
static void RequestEDMA3Channels(void);
interrupt void EDMA3cc_ISR();

static void shutdownAudio(void);
