//-----------------------------------------------------------------------------
// \file    evmc6748_aic3106.c
// \brief   implementation of a aic3106 driver for the C6748 EVM.
//
//-----------------------------------------------------------------------------
#include "stdio.h"
#include "types.h"
#include "rk6748.h"
#include "rk6748_i2c.h"
#include "rk6748_aic3106.h"

//-----------------------------------------------------------------------------
// Private Defines and Macros
//-----------------------------------------------------------------------------

// i2c defines.
#define I2C_PORT_AIC3106         (I2C0)

//-----------------------------------------------------------------------------
// Private Function Prototypes
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Public Function Definitions
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// /brief Initialize the audio codec 
// 
// /param none
//
// /return UINT32 ERR_NO_ERROR on sucess
//
//-----------------------------------------------------------------------------
void AIC3106_init(void)
{
   // select page 0 and reset codec.
   AIC3106_writeRegister(AIC3106_REG_PAGESELECT, 0);
   AIC3106_writeRegister(AIC3106_REG_RESET, 0x80);

   // config codec regs. please see AIC3106 documentation for explination. 
   // Document Num: TLV320AIC3106
   AIC3106_writeRegister(3, 0x25);//0x22  P=4
   AIC3106_writeRegister(4, 0x08);//0x20  J=8
   AIC3106_writeRegister(5, 0x78);//0x6E D=1920=0X0780 D value 8 bits
   AIC3106_writeRegister(6, 0x00);//0x23  D value least six bits
   AIC3106_writeRegister(7, 0x0A);//Fsref=48khz 
   AIC3106_writeRegister(8, 0x00);
   AIC3106_writeRegister(9, 0x00);
   AIC3106_writeRegister(10, 0x00);
   AIC3106_writeRegister(15, 0);
   AIC3106_writeRegister(16, 0);

   
   
   AIC3106_writeRegister(27, 0);
   AIC3106_writeRegister(30, 0);
   AIC3106_writeRegister(37, 0xE0);
   AIC3106_writeRegister(38, 0x10);


   AIC3106_writeRegister(19, 0x04); 
   AIC3106_writeRegister(22, 0x04);

   
   AIC3106_writeRegister(43, 10);
   AIC3106_writeRegister(44, 10);
   AIC3106_writeRegister(58, 0);
   AIC3106_writeRegister(72, 0);
   AIC3106_writeRegister(82, 0x80);
   AIC3106_writeRegister(86, 0x09);
   AIC3106_writeRegister(92, 0x80);
   AIC3106_writeRegister(93, 0x09);
   AIC3106_writeRegister(101, 0x01);
   AIC3106_writeRegister(102, 0);	
   AIC3106_writeRegister(43, 0x28);			//turn down the L DAC gain
   AIC3106_writeRegister(44, 0x28);			//turn down the R DAC gain

}

//-----------------------------------------------------------------------------
// Private Function Prototypes
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Public Function Definitions
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// /brief Initialize the audio codec 
// 
// /param none
//
// /return UINT32 ERR_NO_ERROR on sucess
//
//-----------------------------------------------------------------------------
UINT32 AIC3106_init1(void)
{
   // select page 0 and reset codec.
   AIC3106_writeRegister(AIC3106_REG_PAGESELECT, 0);
   AIC3106_writeRegister(AIC3106_REG_RESET, 0x80);

   // config codec regs. please see AIC3106 documentation for explination. 
   // Document Num: TLV320AIC3106
   AIC3106_writeRegister(3, 0x22);  
   AIC3106_writeRegister(4, 0x20);
   AIC3106_writeRegister(5, 0x6E);
   AIC3106_writeRegister(6, 0x23);
   AIC3106_writeRegister(7, 0x0A);
   AIC3106_writeRegister(8, 0x00);
   AIC3106_writeRegister(9, 0x00);
   AIC3106_writeRegister(10, 0x00);
   AIC3106_writeRegister(15, 0);
   AIC3106_writeRegister(16, 0);

   
   
   AIC3106_writeRegister(27, 0);
   AIC3106_writeRegister(30, 0);
   AIC3106_writeRegister(37, 0xE0);
   AIC3106_writeRegister(38, 0x10);


   AIC3106_writeRegister(19, 0x04); 
   AIC3106_writeRegister(22, 0x04);

   
   AIC3106_writeRegister(43, 10);
   AIC3106_writeRegister(44, 10);
   AIC3106_writeRegister(58, 0);
   AIC3106_writeRegister(72, 0);
   AIC3106_writeRegister(82, 0x80);
   AIC3106_writeRegister(86, 0x09);
   AIC3106_writeRegister(92, 0x80);
   AIC3106_writeRegister(93, 0x09);
   AIC3106_writeRegister(101, 0x01);
   AIC3106_writeRegister(102, 0);	
   AIC3106_writeRegister(43, 0x28);			//turn down the L DAC gain
   AIC3106_writeRegister(44, 0x28);			//turn down the R DAC gain

   return (ERR_NO_ERROR);
}

//-----------------------------------------------------------------------------
// /brief Read data from a register on the AIC3106.
// 
// /param UINT8 in_reg_addr: The address of the register to be read from.
//
// /param UINT8 * dest_buffer: Pointer to buffer to store retrieved data.
//
// /return UINT32 ERR_NO_ERROR on sucess
//
//-----------------------------------------------------------------------------
UINT32 AIC3106_readRegister(UINT8 in_reg_addr, UINT8 *dest_buffer)
{
   UINT32 rtn;

   // write the register address that we want to read.
   rtn = I2C_write(I2C_PORT_AIC3106, I2C_ADDR_AIC3106, &in_reg_addr, 1, SKIP_STOP_BIT_AFTER_WRITE);
   if (rtn != ERR_NO_ERROR)
      return (rtn);

   // clock out the register data.
   rtn = I2C_read(I2C_PORT_AIC3106, I2C_ADDR_AIC3106, dest_buffer, 1, SKIP_BUSY_BIT_CHECK);
   
   return (rtn);
}

//-----------------------------------------------------------------------------
// /brief Write a register on the AIC3106.
// 
// /param UINT8 in_reg_addr: The address of the register to be written to.
//
// /param UINT8 data: Data to be written to the register
//
// /return UINT32 ERR_NO_ERROR on sucess
//
//-----------------------------------------------------------------------------
UINT32 AIC3106_writeRegister(UINT8 in_reg_addr, UINT8 in_data)
{
   UINT32 rtn;
   UINT8 i2c_data[2];
   
   i2c_data[0] = in_reg_addr;
   i2c_data[1] = in_data;

   // write the register that we want to read.
   rtn = I2C_write(I2C_PORT_AIC3106, I2C_ADDR_AIC3106, i2c_data, 2, SET_STOP_BIT_AFTER_WRITE);

   return (rtn);
}


void AIC3106_printAllRegs(void)
{
   UINT32 rtn;
   UINT32 i;
   UINT8 reg_u8;
   UINT8 printfbuf[100];
   
   printf("\r\nAIC3106_printAllRegs:\r\n");

   for (i = 0; i <= 0x8; i++)
   {
      rtn = AIC3106_readRegister(i, &reg_u8);
	  sprintf(printfbuf,"0x%02X: 0x%02X,\r\n",i, reg_u8,rtn);
	  printf(printfbuf);
   }
 
}

//-----------------------------------------------------------------------------
// Private Function Definitions
//-----------------------------------------------------------------------------
