//-----------------------------------------------------------------------------
// \file    rk6748_mcasp.c
// \brief   implementation of a mcasp driver for the C6748 EVM.
//
//-----------------------------------------------------------------------------
#include "stdio.h"
#include "types.h"
#include "rk6748.h"
//#include "rk6748.c"
#include "rk6748_mcasp.h"

//-----------------------------------------------------------------------------
// Private Defines and Macros
//-----------------------------------------------------------------------------
// pinmux defines.
#define PINMUX_MCASP_REG_0       (0)
#define PINMUX_MCASP_MASK_0      (0x00FFFFFF)
#define PINMUX_MCASP_VAL_0       (0x00111111)
#define PINMUX_MCASP_REG_1       (1)
#define PINMUX_MCASP_MASK_1      (0x000FF000)
#define PINMUX_MCASP_VAL_1       (0x00011000)

//-----------------------------------------------------------------------------
// Private Function Prototypes
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Public Function Definitions
//-----------------------------------------------------------------------------
extern void RK6748_pinmuxConfig(UINT32 in_reg, UINT32 in_mask, UINT32 in_val);
extern void RK6748_lpscTransition(psc_regs_t *psc, UINT32 in_domain, UINT8 in_module, UINT8 in_next_state);

void MCASP_init(void)
{
   // enable the psc and config pinmux for mcasp.
   RK6748_lpscTransition(PSC1, DOMAIN0, LPSC_MCASP0, PSC_ENABLE);
   RK6748_pinmuxConfig(PINMUX_MCASP_REG_0, PINMUX_MCASP_MASK_0, PINMUX_MCASP_VAL_0);
   RK6748_pinmuxConfig(PINMUX_MCASP_REG_1, PINMUX_MCASP_MASK_1, PINMUX_MCASP_VAL_1);
   
   // reset mcasp.
   MCASP->GBLCTL  = 0;

   // configure receive registers.
   MCASP->RMASK      = 0xFFFFFFFF;
   MCASP->RFMT       = 0x00008078;//0x8070  Reads from XRBUF[n] originate on DMA port
   MCASP->AFSRCTL    = 0x00000112;// 2 slot, Internally FS, 1 word sync
   MCASP->ACLKRCTL   = 0x000000AF;//Rising sampling receive data, Internally clock.
   MCASP->AHCLKRCTL  = 0x00000000;// INT CLK (from tx side)
   MCASP->RTDM       = 0x00000003;// 2 Slots
   MCASP->RINTCTL    = 0x00000000;// Not used
   MCASP->RCLKCHK    = 0x00FF0008;// 255-MAX 0-MIN, div-by-256

   // configure transmit registers.
   MCASP->XMASK      = 0xFFFFFFFF;
   MCASP->XFMT       = 0x00008078;//0x8070  transmit from XRBUF[n] originate on DMA port
   MCASP->AFSXCTL    = 0x00000112;
   MCASP->ACLKXCTL   = 0x000000AF;
   MCASP->AHCLKXCTL  = 0x00000000;
   MCASP->XTDM       = 0x00000003;
   MCASP->XINTCTL    = 0x00000000;
   MCASP->XCLKCHK    = 0x00FF0008;

   // config serializers (11 = xmit, 12 = rcv).
//   MCASP->SRCTL11    = 0x000D;
//   MCASP->SRCTL12    = 0x000E;

   
   MCASP->SRCTL11    = 0x000E;
   MCASP->SRCTL12    = 0x000D;

   // config pin function and direction.
   MCASP->PFUNC      = 0;// All MCASPs  Pin functions as McASP pin
//   MCASP->PDIR       = 0x14000800;
   MCASP->PDIR       = 0x14001000;

   //
   MCASP->DITCTL     = 0x00000000;// TDM mode
   MCASP->DLBCTL     = 0x00000000;// Loopback mode is disabled.
   MCASP->AMUTE      = 0x00000000;// AMUTE mode is disabled

   MCASP->XSTAT = 0x0000FFFF;        // Clear all
   MCASP->RSTAT = 0x0000FFFF;        // Clear all
   
   // enable the audio clocks, verifying each bit is properly set.
   SETBIT(MCASP->XGBLCTL, XHCLKRST);
   while (!CHKBIT(MCASP->XGBLCTL, XHCLKRST)) {}
   SETBIT(MCASP->RGBLCTL, RHCLKRST);
   while (!CHKBIT(MCASP->RGBLCTL, RHCLKRST)) {}

   SETBIT(MCASP->XGBLCTL, XCLKRST);
   while (!CHKBIT(MCASP->XGBLCTL, XCLKRST)) {}
   SETBIT(MCASP->RGBLCTL, RCLKRST);
   while (!CHKBIT(MCASP->RGBLCTL, RCLKRST)) {}

   SETBIT(MCASP->XGBLCTL, XSRCLR);
   while (!CHKBIT(MCASP->XGBLCTL, XSRCLR)) {}
   SETBIT(MCASP->RGBLCTL, RSRCLR);
   while (!CHKBIT(MCASP->RGBLCTL, RSRCLR)) {}

  /* Write a 0, so that no underrun occurs after releasing the state machine */
   MCASP->XBUF12 = 0;

   SETBIT(MCASP->XGBLCTL, XSMRST);
   while (!CHKBIT(MCASP->XGBLCTL, XSMRST)) {}
   SETBIT(MCASP->RGBLCTL, RSMRST);
   while (!CHKBIT(MCASP->RGBLCTL, RSMRST)) {}

   SETBIT(MCASP->XGBLCTL, XFRST);
   while (!CHKBIT(MCASP->XGBLCTL, XFRST)) {}
   SETBIT(MCASP->RGBLCTL, RFRST);
   while (!CHKBIT(MCASP->RGBLCTL, RFRST)) {}

   // wait for transmit ready and send a dummy byte.
   while(!CHKBIT(MCASP->SRCTL12, XRDY)) {}
   MCASP->XBUF12 = 0;
}

//-----------------------------------------------------------------------------
// Private Function Definitions
//-----------------------------------------------------------------------------
