//-----------------------------------------------------------------------------
// \file    rk6748_mcasp.h
// \brief   C6748 mcasp registers, bit definitions, and
//          function prototypes.
//
//-----------------------------------------------------------------------------

#ifndef RK6748_MCASP_H
#define RK6748_MCASP_H

//-----------------------------------------------------------------------------
// Register Structure & Defines
//-----------------------------------------------------------------------------
typedef struct
{
   volatile UINT32 REVID;         // 0x0000
   volatile UINT32 RSVD0[3];      // 0x0004
   volatile UINT32 PFUNC;         // 0x0010
   volatile UINT32 PDIR;          // 0x0014
   volatile UINT32 PDOUT;         // 0x0018
   volatile UINT32 PDIN;          // 0x001C
   //volatile UINT32 PDSET;         // 0x001C
   volatile UINT32 PDCLR;         // 0x0020
   volatile UINT32 RSVD1[8];      // 0x0024
   volatile UINT32 GBLCTL;        // 0x0044
   volatile UINT32 AMUTE;         // 0x0048
   volatile UINT32 DLBCTL;        // 0x004C
   volatile UINT32 DITCTL;        // 0x0050
   volatile UINT32 RSVD2[3];      // 0x0054
   volatile UINT32 RGBLCTL;       // 0x0060
   volatile UINT32 RMASK;         // 0x0064
   volatile UINT32 RFMT;          // 0x0068
   volatile UINT32 AFSRCTL;       // 0x006C
   volatile UINT32 ACLKRCTL;      // 0x0070
   volatile UINT32 AHCLKRCTL;     // 0x0074
   volatile UINT32 RTDM;          // 0x0078
   volatile UINT32 RINTCTL;       // 0x007C
   volatile UINT32 RSTAT;         // 0x0080
   volatile UINT32 RSLOT;         // 0x0084
   volatile UINT32 RCLKCHK;       // 0x0088
   volatile UINT32 REVTCTL;       // 0x008C
   volatile UINT32 RSVD3[4];      // 0x0090
   volatile UINT32 XGBLCTL;       // 0x00A0
   volatile UINT32 XMASK;         // 0x00A4
   volatile UINT32 XFMT;          // 0x00A8
   volatile UINT32 AFSXCTL;       // 0x00AC
   volatile UINT32 ACLKXCTL;      // 0x00B0
   volatile UINT32 AHCLKXCTL;     // 0x00B4
   volatile UINT32 XTDM;          // 0x00B8
   volatile UINT32 XINTCTL;       // 0x00BC
   volatile UINT32 XSTAT;         // 0x00C0
   volatile UINT32 XSLOT;         // 0x00C4
   volatile UINT32 XCLKCHK;       // 0x00C8
   volatile UINT32 XEVTCTL;       // 0x00CC
   volatile UINT32 RSVD4[12];     // 0x00D0
   volatile UINT32 DITCSRA0;      // 0x0100
   volatile UINT32 DITCSRA1;      // 0x0104
   volatile UINT32 DITCSRA2;      // 0x0108
   volatile UINT32 DITCSRA3;      // 0x010C
   volatile UINT32 DITCSRA4;      // 0x0110
   volatile UINT32 DITCSRA5;      // 0x0114
   volatile UINT32 DITCSRB0;      // 0x0118
   volatile UINT32 DITCSRB1;      // 0x011C
   volatile UINT32 DITCSRB2;      // 0x0120
   volatile UINT32 DITCSRB3;      // 0x0124
   volatile UINT32 DITCSRB4;      // 0x0128
   volatile UINT32 DITCSRB5;      // 0x012C
   volatile UINT32 DITUDRA0;      // 0x0130
   volatile UINT32 DITUDRA1;      // 0x0134
   volatile UINT32 DITUDRA2;      // 0x0138
   volatile UINT32 DITUDRA3;      // 0x013C
   volatile UINT32 DITUDRA4;      // 0x0140
   volatile UINT32 DITUDRA5;      // 0x0144
   volatile UINT32 DITUDRB0;      // 0x0148
   volatile UINT32 DITUDRB1;      // 0x014C
   volatile UINT32 DITUDRB2;      // 0x0150
   volatile UINT32 DITUDRB3;      // 0x0154
   volatile UINT32 DITUDRB4;      // 0x0158
   volatile UINT32 DITUDRB5;      // 0x015C
   volatile UINT32 RSVD5[8];      // 0x0160
   volatile UINT32 SRCTL0;        // 0x0180
   volatile UINT32 SRCTL1;        // 0x0184
   volatile UINT32 SRCTL2;        // 0x0188
   volatile UINT32 SRCTL3;        // 0x018C
   volatile UINT32 SRCTL4;        // 0x0190
   volatile UINT32 SRCTL5;        // 0x0194
   volatile UINT32 SRCTL6;        // 0x0198
   volatile UINT32 SRCTL7;        // 0x019C
   volatile UINT32 SRCTL8;        // 0x01A0
   volatile UINT32 SRCTL9;        // 0x01A4
   volatile UINT32 SRCTL10;       // 0x01A8
   volatile UINT32 SRCTL11;       // 0x01AC
   volatile UINT32 SRCTL12;       // 0x01B0
   volatile UINT32 SRCTL13;       // 0x01B4
   volatile UINT32 SRCTL14;       // 0x01B8
   volatile UINT32 SRCTL15;       // 0x01BC
   volatile UINT32 RSVD6[16];     // 0x01C0
   volatile UINT32 XBUF0;         // 0x0200
   volatile UINT32 XBUF1;         // 0x0204
   volatile UINT32 XBUF2;         // 0x0208
   volatile UINT32 XBUF3;         // 0x020C
   volatile UINT32 XBUF4;         // 0x0210
   volatile UINT32 XBUF5;         // 0x0214
   volatile UINT32 XBUF6;         // 0x0218
   volatile UINT32 XBUF7;         // 0x021C
   volatile UINT32 XBUF8;         // 0x0220
   volatile UINT32 XBUF9;         // 0x0224
   volatile UINT32 XBUF10;        // 0x0228
   volatile UINT32 XBUF11;        // 0x022C
   volatile UINT32 XBUF12;        // 0x0230
   volatile UINT32 XBUF13;        // 0x0234
   volatile UINT32 XBUF14;        // 0x0238
   volatile UINT32 XBUF15;        // 0x023C
   volatile UINT32 RSVD7[16];     // 0x0240
   volatile UINT32 RBUF0;         // 0x0280
   volatile UINT32 RBUF1;         // 0x0284
   volatile UINT32 RBUF2;         // 0x0288
   volatile UINT32 RBUF3;         // 0x028C
   volatile UINT32 RBUF4;         // 0x0290
   volatile UINT32 RBUF5;         // 0x0294
   volatile UINT32 RBUF6;         // 0x0298
   volatile UINT32 RBUF7;         // 0x029C
   volatile UINT32 RBUF8;         // 0x02A0
   volatile UINT32 RBUF9;         // 0x02A4
   volatile UINT32 RBUF10;        // 0x02A8
   volatile UINT32 RBUF11;        // 0x02AC
   volatile UINT32 RBUF12;        // 0x02B0
   volatile UINT32 RBUF13;        // 0x02B4
   volatile UINT32 RBUF14;        // 0x02B8
   volatile UINT32 RBUF15;        // 0x02BC
} mcasp_regs_t;

#define MCASP        ((mcasp_regs_t *)MCASP_REG_BASE)

// bitmask defines for GBLCTL.
#define XFRST        (0x00001000)   // bit 12
#define XSMRST       (0x00000800)   // bit 11
#define XSRCLR       (0x00000400)   // bit 10
#define XHCLKRST     (0x00000200)   // bit 9
#define XCLKRST      (0x00000100)   // bit 8
#define RFRST        (0x00000010)   // bit 4
#define RSMRST       (0x00000008)   // bit 3
#define RSRCLR       (0x00000004)   // bit 2
#define RHCLKRST     (0x00000002)   // bit 1
#define RCLKRST      (0x00000001)   // bit 0

// bitmask defines for SRCTL.
#define RRDY         (0x00000020)   // bit 5
#define XRDY         (0x00000010)   // bit 4

//-----------------------------------------------------------------------------
// Public Typedefs
//-----------------------------------------------------------------------------


//-----------------------------------------------------------------------------
// Public Function Prototypes
//-----------------------------------------------------------------------------

void MCASP_init(void);

#endif

