//------------------------------------------------------------------------------
// \file    test_audio.c
// \brief   implementation of C6748 audio test.
//
//-----------------------------------------------------------------------------

#include "stdio.h"
#include "types.h"
#include "rk6748.h"
#include "rk6748_mcasp.h"
#include "rk6748_aic3106.h"
#include "test_audio.h"
#include "rk6748_i2c.h"


//-----------------------------------------------------------------------------
// Private Defines and Macros
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Static Variable Declarations
//-----------------------------------------------------------------------------

static UINT16 sinetable[48] = {
    0x0000, 0x10b4, 0x2120, 0x30fb, 0x3fff, 0x4dea, 0x5a81, 0x658b,
    0x6ed8, 0x763f, 0x7ba1, 0x7ee5, 0x7ffd, 0x7ee5, 0x7ba1, 0x76ef,
    0x6ed8, 0x658b, 0x5a81, 0x4dea, 0x3fff, 0x30fb, 0x2120, 0x10b4,
    0x0000, 0xef4c, 0xdee0, 0xcf06, 0xc002, 0xb216, 0xa57f, 0x9a75,
    0x9128, 0x89c1, 0x845f, 0x811b, 0x8002, 0x811b, 0x845f, 0x89c1,
    0x9128, 0x9a76, 0xa57f, 0xb216, 0xc002, 0xcf06, 0xdee0, 0xef4c
};


unsigned int *input_audio_32bit;


//-----------------------------------------------------------------------------
// Private Function Prototypes
//-----------------------------------------------------------------------------
static UINT32 testAudioLineOut(void);
void testAudioLineIn(void);
static void shutdownAudio(void);

//-----------------------------------------------------------------------------
// Private Function Definitions
//-----------------------------------------------------------------------------

UINT32 testAudioLineOut(void)
{
   UINT32 rtn = ERR_NO_ERROR;
   UINT16 msec, sec;
   UINT16 sample;

   input_audio_32bit=(unsigned int *)0xc1000000;
   
   for(sample = 0; sample < 48; sample++)
   		input_audio_32bit[sample]=(sinetable[sample]<< 16)| 0x00000000;
   		
   // enable the audio clocks, verifying each bit is properly set.
   SETBIT(MCASP->XGBLCTL, XHCLKRST);
   while (!CHKBIT(MCASP->XGBLCTL, XHCLKRST)) {}
   SETBIT(MCASP->RGBLCTL, RHCLKRST);
   while (!CHKBIT(MCASP->RGBLCTL, RHCLKRST)) {}

   SETBIT(MCASP->XGBLCTL, XCLKRST);
   while (!CHKBIT(MCASP->XGBLCTL, XCLKRST)) {}
   SETBIT(MCASP->RGBLCTL, RCLKRST);
   while (!CHKBIT(MCASP->RGBLCTL, RCLKRST)) {}

   SETBIT(MCASP->XGBLCTL, XSRCLR);
   while (!CHKBIT(MCASP->XGBLCTL, XSRCLR)) {}
   SETBIT(MCASP->RGBLCTL, RSRCLR);
   while (!CHKBIT(MCASP->RGBLCTL, RSRCLR)) {}

   /* Write a 0, so that no underrun occurs after releasing the state machine */
   MCASP->XBUF12 = 0;

   SETBIT(MCASP->XGBLCTL, XSMRST);
   while (!CHKBIT(MCASP->XGBLCTL, XSMRST)) {}
   SETBIT(MCASP->RGBLCTL, RSMRST);
   while (!CHKBIT(MCASP->RGBLCTL, RSMRST)) {}

   SETBIT(MCASP->XGBLCTL, XFRST);
   while (!CHKBIT(MCASP->XGBLCTL, XFRST)) {}
   SETBIT(MCASP->RGBLCTL, RFRST);
   while (!CHKBIT(MCASP->RGBLCTL, RFRST)) {}

   // wait for transmit ready and send a dummy byte.
   while(!CHKBIT(MCASP->SRCTL12, XRDY)) {}
   MCASP->XBUF12 = 0;

   // transmit beep.
   for (sec = 0; sec < 5; sec++)
   {
      for (msec = 0; msec < 1000; msec++)
      {
         for (sample = 0; sample < 48; sample++)
         {
     
			   // wait for xmit ready and send a sample to the left channel.
			   while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}

			   MCASP->XBUF12 = input_audio_32bit[sample];
			   // wait for xmit ready and send a sample to the left channel.
			   while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}
			   MCASP->XBUF12 = input_audio_32bit[sample];
			}
      }
   }
   return (rtn);
}

void testAudioLineIn(void)
{
   UINT32 rtn = ERR_NO_ERROR;
   UINT16 msec, sec, sample;
   UINT16 dat;

   input_audio_32bit=(unsigned int *)0xc1000000;
	


   // loop audio
   for (sec = 0; sec < 30; sec++)
   {
      for (msec = 0; msec < 1000; msec++)
      {
         for (sample = 0; sample < 48; sample++)
         {
            // wait for recv ready and send a sample to the left channel.
            while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}
   			MCASP->XBUF12 = dat<<16;
            dat = MCASP->XBUF11;

			*input_audio_32bit++=(dat<<16);
				
            // wait for recv ready and send a sample to the right channel.
            while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}
   			MCASP->XBUF12 = dat<<16;
            dat = MCASP->XBUF11;

			//put_audio_32bit[sec*msec+sample]=dat<<16;
			
			/*

			       while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}
   			MCASP->XBUF12 = dat;
            dat = MCASP->XBUF11;

            // wait for recv ready and send a sample to the right channel.
            while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}
   			MCASP->XBUF12 = dat;
            dat = MCASP->XBUF11;

            */
         }
      }
   }

}


//-----------------------------------------------------------------------------
// Private Function Definitions
//-----------------------------------------------------------------------------

UINT32 testAudioLineInOut(void)
{
   UINT32 rtn = ERR_NO_ERROR;
   UINT16 msec, sec;
   UINT16 sample;

   input_audio_32bit=(unsigned int *)0xc1000000;
   
   		
   // enable the audio clocks, verifying each bit is properly set.
   SETBIT(MCASP->XGBLCTL, XHCLKRST);
   while (!CHKBIT(MCASP->XGBLCTL, XHCLKRST)) {}
   SETBIT(MCASP->RGBLCTL, RHCLKRST);
   while (!CHKBIT(MCASP->RGBLCTL, RHCLKRST)) {}

   SETBIT(MCASP->XGBLCTL, XCLKRST);
   while (!CHKBIT(MCASP->XGBLCTL, XCLKRST)) {}
   SETBIT(MCASP->RGBLCTL, RCLKRST);
   while (!CHKBIT(MCASP->RGBLCTL, RCLKRST)) {}

   SETBIT(MCASP->XGBLCTL, XSRCLR);
   while (!CHKBIT(MCASP->XGBLCTL, XSRCLR)) {}
   SETBIT(MCASP->RGBLCTL, RSRCLR);
   while (!CHKBIT(MCASP->RGBLCTL, RSRCLR)) {}

   /* Write a 0, so that no underrun occurs after releasing the state machine */
//   MCASP->XBUF11 = 0;
   MCASP->XBUF12 = 0;

   SETBIT(MCASP->XGBLCTL, XSMRST);
   while (!CHKBIT(MCASP->XGBLCTL, XSMRST)) {}
   SETBIT(MCASP->RGBLCTL, RSMRST);
   while (!CHKBIT(MCASP->RGBLCTL, RSMRST)) {}

   SETBIT(MCASP->XGBLCTL, XFRST);
   while (!CHKBIT(MCASP->XGBLCTL, XFRST)) {}
   SETBIT(MCASP->RGBLCTL, RFRST);
   while (!CHKBIT(MCASP->RGBLCTL, RFRST)) {}

   // wait for transmit ready and send a dummy byte.
   while(!CHKBIT(MCASP->SRCTL12, XRDY)) {}
   MCASP->XBUF12 = 0;

   // transmit beep.
   for (sec = 0; sec < 30; sec++)
   {
      for (msec = 0; msec < 1000; msec++)
      {
         for (sample = 0; sample < 48; sample++)
         {
     
			   // wait for xmit ready and send a sample to the left channel.
			   while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}
			   //MCASP->XBUF12 = (sinetable[sample] << 15) | 0x00000000;
			   //MCASP->XBUF12 = (input_audio_32bit[sample]<< 15)  | 0x00000000;
			   MCASP->XBUF12 = *input_audio_32bit;
			   // wait for xmit ready and send a sample to the left channel.
			   while (!CHKBIT(MCASP->SRCTL12, XRDY)) {}
			   //MCASP->XBUF12 = (sinetable[sample] << 15) | 0x00000000;
			   //MCASP->XBUF12 = (input_audio_32bit[sample]<< 15)  | 0x00000000;
			   MCASP->XBUF12 = *input_audio_32bit++;
			} 
      }
   }
   return (rtn);
}

void shutdownAudio(void)
{
   // close codec.
   AIC3106_writeRegister(AIC3106_REG_PAGESELECT, 0);
   AIC3106_writeRegister(AIC3106_REG_RESET, 0x80);

   // close mcasp.
   MCASP->SRCTL0 = 0;
   MCASP->SRCTL1 = 0;
   MCASP->SRCTL2 = 0;
   MCASP->SRCTL3 = 0;
   MCASP->SRCTL5 = 0;
   MCASP->SRCTL11 = 0;
   MCASP->SRCTL12 = 0;
   MCASP->GBLCTL = 0;
}




//-----------------------------------------------------------------------------
// Public Function Definitions
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// \brief   tests the AIC3106 CODEC
//
// \param   none.
//
// \return  UINT32
//-----------------------------------------------------------------------------
void TEST_audio(void)
{
	UINT32 rtn = ERR_NO_ERROR;

	printf("------------------------------------------------------------\r\n");
	printf("					  C6748 Audio CODEC Test\r\n\r\n");

	printf("Additional Equipment\r\n");
	printf("--------------------\r\n");
	printf("- 3.5mm pass through cable\r\n\r\n");
	printf("- 3.5mm headphones\r\n\r\n");
    
	printf("Test Description\r\n");
	printf("----------------\r\n");
	printf("The test will begin by playing a 5 second tone though the line\r\n");
	printf("out port. The 3.5mm pass through cable will not be needed for\r\n");
	printf("this portion of the test. After playing the tone, audio from the\n\r");
	printf("line in port will be played through the line out port for 15 seconds.\r\n");
	printf("--------------------------------------------------------------------\r\n\r\n");
 
 	//------------------------------------
 	// initialize the required bsl modules
 	//------------------------------------
	printf("Initialize the Required BSL Modules\r\n");
	printf("-----------------------------------\r\n\r\n");

	input_audio_32bit	 = (unsigned int *)0xc1000000;

    I2C_init(I2C0, I2C_CLK_100K);
  //  AIC3106_printAllRegs();
/*
	//Ƶ:5볤
    printf("\r\n--- audio out test:playing a 5 second tone ---\r\n");
    printf("\r\n--- wait for 5 second ... \r\n");
	MCASP_init();
	AIC3106_init();
	rtn = testAudioLineOut();
	printf("\r\n--- audio out test over! ---\r\n");
*/

	//¼:¼15룬洢15¼ݣ¼߷
    printf("\r\n--- audio Sound recording test:Sound recording 15 second audio ---\r\n");
    printf("\r\n--- wait for 15 second...\r\n");
    AIC3106_init();
    MCASP_init();
	testAudioLineIn();
	printf("\r\n--- audio Sound recording  test over! ---\r\n");
/*
	//¼طŲ:ط15¼
	printf("\r\n--- audio playback test:playback 15 second audio ---\r\n");
	printf("\r\n--- wait for 15 second...\r\n");
	rtn = MCASP_init();
	rtn = AIC3106_init();
	testAudioLineInOut();
	printf("\r\n--- audio playback test over! ---\r\n");
*/
    // kill codec and mcasp.
    shutdownAudio();
 
 
    printf("\r\n");
    printf("					 C6748 Audio CODEC TEST OK!\r\n\r\n");
    printf("--------------------------------------------------------\r\n");

}


