module hpi(sysclk,locked,hrdy,hint,rw,hds1,hds2,hcs,has,hcntl,hd,step);

inout  [31:0] hd;

input  hrdy;
input  hint;
input  locked;
input  sysclk;

output  rw;
output  hds1;
output  hds2;
output  hcs;
output  has;
output  [1:0] hcntl;
output  [7:0]step;


reg  [31:0] tdata;
reg  [31:0] hd_reg;
reg  [31:0] data;
reg  [31:0] data1;
reg  hcs;
reg  has;
reg  hds1;
reg  hds2;
reg  rw;
reg  wrcontrol;
reg  [1:0]hcntl;
reg  [1:0]control;
reg  [1:0]cnt;
reg  [7:0]step;


parameter HPIC=2'b00;// control HPI control register
parameter HPIA=2'b01;// address HPI address register
parameter HPIDS=2'b10;// successive write 
parameter HPID=2'b11;// fix address write 

parameter state1=8'b00000001;// state 
parameter state2=8'b00000010;
parameter state3=8'b00000100;
parameter state4=8'b00001000;
parameter state5=8'b00010000;
parameter state6=8'b00100000;
parameter state7=8'b01000000;
parameter state8=8'b10000000;



parameter  DPIC=32'h00000000;// control data 
parameter  DPIA=32'h000D223C;// address data 
parameter  DPID=32'h05050505;// write or read data 

parameter  write=1'b0;
parameter  read=1'b1;

wire  ready;
wire  plllocked;

assign   ready=hrdy;
assign   plllocked=locked;
assign   hd=(rw==0)?hd_reg:32'bz;

always @ (posedge sysclk)
begin
    tdata<=data1;
end

always @ (posedge sysclk )
begin
   if(plllocked)//PLL locked go
   	begin
			case (step)
               state1:
						begin
							 rw<=wrcontrol;  
							 hcs<=0;
						    has<=1;
							 hds1<=1;
							 hds2<=1;
							 step<=state2;
							 hcntl<=control;
						end
					state2:
                   begin
						    hds2<=0;
                      step<=state4;
                   end
						 
             //  state3:
					//      begin 
					//			cnt1<=cnt1+1;
						//		   if(cnt1<3'd4)
						//				step<=state3;
						//			else 
						//				step<=state4;
                  //      end
					state4:
                   begin
						    if(ready==0)
								begin 
                              step<=state6;
                                  if(rw==0)
                                       begin
                                           hd_reg<=data;//当写控制寄存器或者地址寄存器的时候将要发给DSP寄存器的数据给hd_reg
											      end
                                  else
                                       begin
                                           data1<=hd;//当读的时候将DSP中的数据传到data1中
                                       end
                        end
                       else
                         begin
                            step<=state4;
								 end
                                                           
                    end
                state6:
                    begin
                        hds2<=1; 
								step<=state7;
                    end
					 state7:
                    begin
							   hcs<=1;
								step<=state8;
								if(cnt==2'b10)
									begin
										 cnt<=2'b00;
									end
								else
									begin
										 cnt<=cnt+1;
									end										 
						   end
                state8:
                     begin
                         step<=state1;
                     end        
					default :
				      	begin
                          step<=state1;
                     end
         endcase
                        
      end
    else// PLL unlock wait 
		begin
           cnt<=2'b00;
           step<=state1;           
			  hcs<=1;
           hds1<=1;
           hds2<=1;
	   end
end

always @ (posedge sysclk)
begin
   if(plllocked)
		begin
          if(cnt==2'b10)
               begin
						wrcontrol<=read;
               end
          else
					begin
                   wrcontrol<=write;
               end
		end
   else
		begin
         wrcontrol<=write;
      end
          
end
always @ (posedge sysclk)
begin
   if(plllocked)
		begin
          if(cnt==2'b00)
               begin 
						control<=2'b00;
						data<=32'h00080008;
				   end
			 else if(cnt==2'b01)
					begin
						control<=2'b01;
						data<=32'h00000001;
				   end
			 else if(cnt==2'b10)
					begin
						control<=2'b11;
				   end
			 else
					begin
						control<=2'b00;
						data<=32'h00000000;
				   end				  
		end
  else
       begin
          control<=2'b00;
          data<=32'h00000000;
       end
end
endmodule
