/****************************************************************************/
/*                                                                          */
/*              ݴӿƼ޹˾                                    */
/*                                                                          */
/*              Copyright 2014 Tronlong All rights reserved                 */
/*                                                                          */
/****************************************************************************/
/****************************************************************************/
/*                                                                          */
/*              UPP                                                */
/*                                                                          */
/*              20140625                                              */
/*                                                                          */
/****************************************************************************/

#include "hw_types.h"				// 
#include "hw_syscfg0_C6748.h"	    // ϵͳģĴ
#include "soc_C6748.h"			    // DSP C6748 Ĵ
#include "psc.h"			        // Դ˯߿ƺ꼰豸㺯
#include "interrupt.h"             	// DSP C6748 жӦóӿںϵͳ¼Ŷ
#include "uartStdio.h"             	// ڱ׼ն˺

// CSLR header files
#include <soc_OMAPL138.h>
#include <cslr_upp.h>
#include <cslr_syscfg0_OMAPL138.h>

#include "TL6748.h"                 //  DSP6748 
#include "uart.h"                   // ͨ첽ں꼰豸㺯
#include "gpio.h"                   // ͨں꼰豸㺯

#include "dspcache.h"               // DSP Ӧóӿڼ

/****************************************************************************/
/*                                                                          */
/*              궨                                                      */
/*                                                                          */
/****************************************************************************/
// CSL register handles
CSL_UppRegs *upp_reg_hdl       = (CSL_UppRegs *)CSL_UPP_0_REGS;
CSL_SyscfgRegs *syscfg_reg_hdl = (CSL_SyscfgRegs *)CSL_SYSCFG_0_REGS;

// local macros
#define upp_isr_bit_eolq    (CSL_UPP_UPISR_EOLQ_MASK)
#define upp_isr_bit_eowq    (CSL_UPP_UPISR_EOWQ_MASK)
#define upp_isr_bit_errq    (CSL_UPP_UPISR_ERRQ_MASK)
#define upp_isr_bit_uorq    (CSL_UPP_UPISR_UORQ_MASK)
#define upp_isr_bit_dpeq    (CSL_UPP_UPISR_DPEQ_MASK)
#define upp_isr_bit_eoli    (CSL_UPP_UPISR_EOLI_MASK)
#define upp_isr_bit_eowi    (CSL_UPP_UPISR_EOWI_MASK)
#define upp_isr_bit_erri    (CSL_UPP_UPISR_ERRI_MASK)
#define upp_isr_bit_uori    (CSL_UPP_UPISR_UORI_MASK)
#define upp_isr_bit_dpei    (CSL_UPP_UPISR_DPEI_MASK)
#define upp_isr_bit_all     (upp_isr_bit_eolq | upp_isr_bit_eowq | \
                             upp_isr_bit_errq | upp_isr_bit_uorq | \
                             upp_isr_bit_dpeq | upp_isr_bit_eoli | \
                             upp_isr_bit_eowi | upp_isr_bit_erri | \
                             upp_isr_bit_uori | upp_isr_bit_dpei)

// inline functions
#define upp_int_clear(a)    upp_reg_hdl->UPIER = a
#define upp_int_status()    upp_reg_hdl->UPIER
#define upp_int_enable(a)   upp_reg_hdl->UPIES = a
#define upp_int_disable(a)  upp_reg_hdl->UPIEC = a

// configuration macros
#define single_line			1	// 
#if single_line
#define UPP_LINE_SIZE        (256)
#define UPP_LINE_COUNT       (1)
#define UPP_FRAME_SIZE       (UPP_LINE_SIZE * UPP_LINE_COUNT)
#define UPP_LINE_OFFSET      (0)
#else
#define UPP_LINE_SIZE        (1024)
#define UPP_LINE_COUNT       (4)
#define UPP_FRAME_SIZE       (UPP_LINE_SIZE * UPP_LINE_COUNT)
#define UPP_LINE_OFFSET      (UPP_LINE_SIZE)
#endif	// single_line
#define UPP_CLOCK_DIV        (10)               // UPPƵϵ

typedef unsigned char	u8;
typedef unsigned short	u16;
typedef unsigned int	u32;

/****************************************************************************/
/*                                                                          */
/*              ȫֱ                                                    */
/*                                                                          */
/****************************************************************************/
// global variables
unsigned int upp_interrupt_count = 0;

#pragma DATA_SECTION(upp_buffer, ".DataDDR2");
#pragma DATA_ALIGN(upp_buffer, 64);
Uint8 upp_buffer[UPP_FRAME_SIZE];


volatile unsigned int led_flag = 0;

/****************************************************************************/
/*                                                                          */
/*                                                                  */
/*                                                                          */
/****************************************************************************/
// ϵͳʼ
void sys_init(void);

// PSCʼ
void PSCInit(void);
// DSPжϳʼ
void InterruptInit(void);

// GPIOܽŸ
void GPIOBankPinMuxSet(void);
// GPIOܽųʼ
void GPIOBankPinInit(void);

// UPPùܽųʼ
void UPPPinMuxSetup(void);
// UPPʼ
void UPPInit(void);
// UPPжϳʼ
void UPPInterruptInit(void);
// UPPжϷ.
void uPPIsr(void);
// UPPʹ
void UPPEnable(void);
// UPPλ
void UPPReset(void);

// ʱ
void Delay(volatile unsigned int count);



/****************************************************************************/
/*                                                                          */
/*                                                                    */
/*                                                                          */
/****************************************************************************/
int main(void)
{
	//CacheEnableMAR((unsigned int)0xC0000000, (unsigned int)0x20000000);
	//CacheEnable(L1DCFG_L1DMODE_32K | L1PCFG_L1PMODE_32K | L2CFG_L2MODE_256K);

	int i;

	// ϵͳʼ
	sys_init();

	// ʼҪ͵
	UARTPuts("\tInitialize data buffers...\r\n", -2);
	// Initialize data buffers
	//upp_buffer[0] = 0x68;
	for (i = 0; i < UPP_FRAME_SIZE; i++)
	{
	   upp_buffer[i] = i % 2;
	}
	//upp_buffer[UPP_FRAME_SIZE - 1] = 0x0;

	upp_reg_hdl->UPID0 = (Uint32)upp_buffer;
	upp_reg_hdl->UPID1 = ((Uint32)UPP_LINE_COUNT << 16) | (Uint32)UPP_FRAME_SIZE * sizeof(Int8);
	upp_reg_hdl->UPID2 = (Uint32)UPP_LINE_OFFSET * sizeof(Int8);
	while(1);
}



// ϵͳʼ
void sys_init(void)
{
	// ʼնˣʹô2
	UARTStdioInit();

	// PSCʼ
	PSCInit();

	// GPIOܽŸ
	GPIOBankPinMuxSet();
	// GPIOܽųʼ
	GPIOBankPinInit();

	// UPPùܽųʼ
	UPPPinMuxSetup();
	// UPPʼ
	UPPInit();

	// DSPжϳʼ
	InterruptInit();
	// UPPжϳʼ
	UPPInterruptInit();

	//UPPDisable();
	// UPPλ
	UPPReset();
}

/****************************************************************************/
/*                                                                          */
/*              PSCʼ 	                                          */
/*                                                                          */
/****************************************************************************/
void PSCInit(void)
{
	// ӦģʹҲ BootLoader 
	// ʹ GPIO ģ
    PSCModuleControl(SOC_PSC_1_REGS, HW_PSC_GPIO, PSC_POWERDOMAIN_ALWAYS_ON, PSC_MDCTL_NEXT_ENABLE);
	// ʹ UPP ģ
	PSCModuleControl(SOC_PSC_1_REGS, HW_PSC_UPP, PSC_POWERDOMAIN_ALWAYS_ON, PSC_MDCTL_NEXT_ENABLE);
}

/****************************************************************************/
/*                                                                          */
/*              DSP жϳʼ                                              */
/*                                                                          */
/****************************************************************************/
void InterruptInit(void)
{
	// ʼ DSP жϿ
	IntDSPINTCInit();

	// ʹ DSP ȫж
	IntGlobalEnable();
}

/****************************************************************************/
/*                                                                          */
/*              GPIO ܽŸ                                           */
/*                                                                          */
/****************************************************************************/
void GPIOBankPinMuxSet(void)
{
	// İ LED
	GPIOBank6Pin12PinMuxSetup();
	GPIOBank6Pin13PinMuxSetup();
}

/****************************************************************************/
/*                                                                          */
/*              GPIO ܽųʼ                                             */
/*                                                                          */
/****************************************************************************/
void GPIOBankPinInit(void)
{
	// İ LED
    GPIODirModeSet(SOC_GPIO_0_REGS, 109, GPIO_DIR_OUTPUT);  // GPIO6[12]
    GPIODirModeSet(SOC_GPIO_0_REGS, 110, GPIO_DIR_OUTPUT);  // GPIO6[13]
}

/****************************************************************************/
/*                                                                          */
/*              UPP ùܽųʼ                                          */
/*                                                                          */
/****************************************************************************/
void UPPPinMuxSetup(void)
{
	unsigned int savePinmux13 = 0;
	unsigned int savePinmux14 = 0;
	unsigned int savePinmux15 = 0;
	unsigned int savePinmux16 = 0;
	unsigned int savePinmux17 = 0;
	unsigned int savePinmux18 = 0;

	/* all pins (channel A, channel B, DATA, and XDATA)*/
	savePinmux13 = (HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(13)) & 0x0000FFFF);
	savePinmux14 = (HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(14)) & 0x000000FF);
	savePinmux15 = (HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(15)) & 0x00000000);
	savePinmux16 = (HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(16)) & 0x00000000);
	savePinmux17 = (HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(17)) & 0x00000000);
	savePinmux18 = (HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(18)) & 0xFF000000);

	HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(13)) = (0x44440000 | savePinmux13);
	HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(14)) = (0x44444400 | savePinmux14);
	HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(15)) = (0x44444444 | savePinmux15);
	HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(16)) = (0x44444444 | savePinmux16);
	HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(17)) = (0x44444444 | savePinmux17);
	HWREG(SOC_SYSCFG_0_REGS + SYSCFG0_PINMUX(18)) = (0x00444444 | savePinmux18);
}

/****************************************************************************/
/*                                                                          */
/*              UPPʼ                                              */
/*                                                                          */
/****************************************************************************/
void UPPInit(void)
{
	unsigned int temp_reg = 0;

	// configure registers: CTL, ICR, IVR

	/***************************** 1. CTL************************/
	// Channel A params
	CSL_FINST(temp_reg, UPP_UPCTL_DPFA, LJZF);		// Left-justified, zero filled
	CSL_FINST(temp_reg, UPP_UPCTL_IWA, 8BIT);		// 8-bit interface
	CSL_FINST(temp_reg, UPP_UPCTL_DPWA, FULL);		// Channel A bit width = 8
	CSL_FINST(temp_reg, UPP_UPCTL_DRA, SINGLE);		// Single data rate

	CSL_FINST(temp_reg, UPP_UPCTL_CHN, ONE);		// Channel A is active.
	CSL_FINST(temp_reg, UPP_UPCTL_MODE, TRANSMIT);	// All transmit mode

	upp_reg_hdl->UPCTL = temp_reg;

	temp_reg = 0;

	/****************** 2. ICR*********************/
	// Channel A params
	if (UPP_CLOCK_DIV > 0x0F)
		UARTPuts("Clock divisor error.\n", -2);
	else
		CSL_FINS(temp_reg, UPP_UPICR_CLKDIVA, UPP_CLOCK_DIV);	// Clock divisor
	//CSL_FINST(temp_reg, UPP_UPICR_STARTA, ENABLE);	// Channel A START Signal Enable.
	//CSL_FINST(temp_reg, UPP_UPICR_ENAA, ENABLE);		// Channel A ENABLE Signal Enable
	//CSL_FINST(temp_reg, UPP_UPICR_WAITA, ENABLE);		// Channel A ENABLE Signal Enable
	CSL_FINST(temp_reg, UPP_UPICR_TRISA, DISABLE);		// Channel A data pins are in a high-impedance state while idle

	// apply all fields in one shot
	upp_reg_hdl->UPICR = temp_reg;

	temp_reg = 0;

	/******************************** 3. IVR******************************/
	CSL_FINS(temp_reg, UPP_UPIVR_VALA, 0x0102);		// Channel A idle value

	// apply all fields in one shot
	upp_reg_hdl->UPIVR = temp_reg;
}

/****************************************************************************/
/*                                                                          */
/*              UPPжϳʼ                                          */
/*                                                                          */
/****************************************************************************/
void UPPInterruptInit(void)
{
	// Initialize interrupt
	upp_int_enable(upp_isr_bit_eowi);

	IntRegister(C674X_MASK_INT5, uPPIsr);
	IntEventMap(C674X_MASK_INT5, SYS_INT_UPP_INT);
	IntEnable(C674X_MASK_INT5);
}

/****************************************************************************/
/*                                                                          */
/*              жϷ                                                */
/*                                                                          */
/****************************************************************************/
void uPPIsr(void)
{
	Uint32 intr_status = upp_int_status();
	while (intr_status != 0)
	{
		if (intr_status & upp_isr_bit_eowi)
		{
			upp_int_clear(upp_isr_bit_eowi);
			upp_interrupt_count++;

			upp_reg_hdl->UPID0 = (Uint32)upp_buffer;
			upp_reg_hdl->UPID1 = ((Uint32)UPP_LINE_COUNT << 16) | (Uint32)UPP_FRAME_SIZE * sizeof(Int8);
			upp_reg_hdl->UPID2 = (Uint32)UPP_LINE_OFFSET * sizeof(Int8);
		}

		intr_status = upp_int_status();
	}

	// finally: write 0 to EOI register
	upp_reg_hdl->UPEOI = 0;
}

/****************************************************************************/
/*                                                                          */
/*              UPPʹ 	                                          */
/*                                                                          */
/****************************************************************************/
void UPPEnable(void)
{
	// set the EN bit (turn on peripheral)
	CSL_FINST(upp_reg_hdl->UPPCR, UPP_UPPCR_EN, ENABLE);
}

/****************************************************************************/
/*                                                                          */
/*              UPPλ                                              */
/*                                                                          */
/****************************************************************************/
void UPPReset(void)
{
	// clear the EN bit (turn off peripheral)
	CSL_FINST(upp_reg_hdl->UPPCR, UPP_UPPCR_EN, DISABLE);
	// poll the DB bit to make sure the DMA is idle
	while(upp_reg_hdl->UPPCR & CSL_UPP_UPPCR_DB_MASK);
	// set the EN bit (turn on peripheral)
	CSL_FINST(upp_reg_hdl->UPPCR, UPP_UPPCR_EN, ENABLE);

	// toggle reset with short delay
	CSL_FINST(upp_reg_hdl->UPPCR, UPP_UPPCR_SWRST, RESET);
	Delay(0xfff);
	CSL_FINST(upp_reg_hdl->UPPCR, UPP_UPPCR_SWRST, RUNNING);
}

/****************************************************************************/
/*                                                                          */
/*              ʱ                                                        */
/*                                                                          */
/****************************************************************************/
void Delay(volatile unsigned int count)
{
    while(count--);
}

