#ifndef _CSLR_RTI_H_
#define _CSLR_RTI_H_
/*********************************************************************
 * Copyright (C) 2003-2004, 2005 Texas Instruments Incorporated. 
 * All Rights Reserved 
 *********************************************************************/
 /** \file cslr_rti.h
 * 
 * \brief This file contains the Register Desciptions for RTI
 * 
 *********************************************************************/

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 RTIGCTRL;
    volatile Uint32 RSVD0[1];
    volatile Uint32 RTICAPCTRL;
    volatile Uint32 RTICOMPCTRL;
    volatile Uint32 RTIFRC0;
    volatile Uint32 RTIUC0;
    volatile Uint32 RTICPUC0;
    volatile Uint32 RSVD1[1];
    volatile Uint32 RTICAFRC0;
    volatile Uint32 RTICAUC0;
    volatile Uint32 RSVD2[2];
    volatile Uint32 RTIFRC1;
    volatile Uint32 RTIUC1;
    volatile Uint32 RTICPUC1;
    volatile Uint32 RSVD3[1];
    volatile Uint32 RTICAFRC1;
    volatile Uint32 RTICAUC1;
    volatile Uint32 RSVD4[2];
    volatile Uint32 RTICOMP0;
    volatile Uint32 RTIUDCP0;
    volatile Uint32 RTICOMP1;
    volatile Uint32 RTIUDCP1;
    volatile Uint32 RTICOMP2;
    volatile Uint32 RTIUDCP2;
    volatile Uint32 RTICOMP3;
    volatile Uint32 RTIUDCP3;
    volatile Uint32 RSVD5[4];
    volatile Uint32 RTISETINT;
    volatile Uint32 RTICLEARINT;
    volatile Uint32 RTIINTFLAG;
    volatile Uint32 RSVD6[1];
    volatile Uint32 RTIDWDCTRL;
    volatile Uint32 RTIDWDPRLD;
    volatile Uint32 RTIWDSTATUS;
    volatile Uint32 RTIWDKEY;
    volatile Uint32 RTIDWDCNTR;
} CSL_RtiRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* RTIGCTRL */

#define CSL_RTI_RTIGCTRL_COS_MASK        (0x00008000u)
#define CSL_RTI_RTIGCTRL_COS_SHIFT       (0x0000000Fu)
#define CSL_RTI_RTIGCTRL_COS_RESETVAL    (0x00000000u)

#define CSL_RTI_RTIGCTRL_CNT1EN_MASK     (0x00000002u)
#define CSL_RTI_RTIGCTRL_CNT1EN_SHIFT    (0x00000001u)
#define CSL_RTI_RTIGCTRL_CNT1EN_RESETVAL (0x00000000u)

/*----CNT1EN Tokens----*/
#define CSL_RTI_RTIGCTRL_CNT1EN_STOPBLK1 (0x00000000u)
#define CSL_RTI_RTIGCTRL_CNT1EN_STARTBLK1 (0x00000001u)

#define CSL_RTI_RTIGCTRL_CNT0EN_MASK     (0x00000001u)
#define CSL_RTI_RTIGCTRL_CNT0EN_SHIFT    (0x00000000u)
#define CSL_RTI_RTIGCTRL_CNT0EN_RESETVAL (0x00000000u)

/*----CNT0EN Tokens----*/
#define CSL_RTI_RTIGCTRL_CNT0EN_STOPBLK0 (0x00000000u)
#define CSL_RTI_RTIGCTRL_CNT0EN_STARTBLK0 (0x00000001u)

#define CSL_RTI_RTIGCTRL_RESETVAL        (0x00000000u)

/* RTICAPCTRL */

#define CSL_RTI_RTICAPCTRL_CAPCNTR1_MASK (0x00000002u)
#define CSL_RTI_RTICAPCTRL_CAPCNTR1_SHIFT (0x00000001u)
#define CSL_RTI_RTICAPCTRL_CAPCNTR1_RESETVAL (0x00000000u)

#define CSL_RTI_RTICAPCTRL_CAPCNTR0_MASK (0x00000001u)
#define CSL_RTI_RTICAPCTRL_CAPCNTR0_SHIFT (0x00000000u)
#define CSL_RTI_RTICAPCTRL_CAPCNTR0_RESETVAL (0x00000000u)

#define CSL_RTI_RTICAPCTRL_RESETVAL      (0x00000000u)

/* RTICOMPCTRL */

#define CSL_RTI_RTICOMPCTRL_COMPSEL3_MASK (0x00001000u)
#define CSL_RTI_RTICOMPCTRL_COMPSEL3_SHIFT (0x0000000Cu)
#define CSL_RTI_RTICOMPCTRL_COMPSEL3_RESETVAL (0x00000000u)

#define CSL_RTI_RTICOMPCTRL_COMPSEL2_MASK (0x00000100u)
#define CSL_RTI_RTICOMPCTRL_COMPSEL2_SHIFT (0x00000008u)
#define CSL_RTI_RTICOMPCTRL_COMPSEL2_RESETVAL (0x00000000u)

#define CSL_RTI_RTICOMPCTRL_COMPSEL1_MASK (0x00000010u)
#define CSL_RTI_RTICOMPCTRL_COMPSEL1_SHIFT (0x00000004u)
#define CSL_RTI_RTICOMPCTRL_COMPSEL1_RESETVAL (0x00000000u)

#define CSL_RTI_RTICOMPCTRL_COMPSEL0_MASK (0x00000001u)
#define CSL_RTI_RTICOMPCTRL_COMPSEL0_SHIFT (0x00000000u)
#define CSL_RTI_RTICOMPCTRL_COMPSEL0_RESETVAL (0x00000000u)

#define CSL_RTI_RTICOMPCTRL_RESETVAL     (0x00000000u)

/* RTIFRC0 */

#define CSL_RTI_RTIFRC0_FRC0_MASK        (0xFFFFFFFFu)
#define CSL_RTI_RTIFRC0_FRC0_SHIFT       (0x00000000u)
#define CSL_RTI_RTIFRC0_FRC0_RESETVAL    (0x00000000u)

#define CSL_RTI_RTIFRC0_RESETVAL         (0x00000000u)

/* RTIUC0 */

#define CSL_RTI_RTIUC0_UC0_MASK          (0xFFFFFFFFu)
#define CSL_RTI_RTIUC0_UC0_SHIFT         (0x00000000u)
#define CSL_RTI_RTIUC0_UC0_RESETVAL      (0x00000000u)

#define CSL_RTI_RTIUC0_RESETVAL          (0x00000000u)

/* RTICPUC0 */

#define CSL_RTI_RTICPUC0_CPUC0_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTICPUC0_CPUC0_SHIFT     (0x00000000u)
#define CSL_RTI_RTICPUC0_CPUC0_RESETVAL  (0x00000000u)

#define CSL_RTI_RTICPUC0_RESETVAL        (0x00000000u)

/* RTICAFRC0 */

#define CSL_RTI_RTICAFRC0_CAFRC0_MASK    (0xFFFFFFFFu)
#define CSL_RTI_RTICAFRC0_CAFRC0_SHIFT   (0x00000000u)
#define CSL_RTI_RTICAFRC0_CAFRC0_RESETVAL (0x00000000u)

#define CSL_RTI_RTICAFRC0_RESETVAL       (0x00000000u)

/* RTICAUC0 */

#define CSL_RTI_RTICAUC0_CAUC0_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTICAUC0_CAUC0_SHIFT     (0x00000000u)
#define CSL_RTI_RTICAUC0_CAUC0_RESETVAL  (0x00000000u)

#define CSL_RTI_RTICAUC0_RESETVAL        (0x00000000u)

/* RTIFRC1 */

#define CSL_RTI_RTIFRC1_FRC1_MASK        (0xFFFFFFFFu)
#define CSL_RTI_RTIFRC1_FRC1_SHIFT       (0x00000000u)
#define CSL_RTI_RTIFRC1_FRC1_RESETVAL    (0x00000000u)

#define CSL_RTI_RTIFRC1_RESETVAL         (0x00000000u)

/* RTIUC1 */

#define CSL_RTI_RTIUC1_UC1_MASK          (0xFFFFFFFFu)
#define CSL_RTI_RTIUC1_UC1_SHIFT         (0x00000000u)
#define CSL_RTI_RTIUC1_UC1_RESETVAL      (0x00000000u)

#define CSL_RTI_RTIUC1_RESETVAL          (0x00000000u)

/* RTICPUC1 */

#define CSL_RTI_RTICPUC1_CPUC1_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTICPUC1_CPUC1_SHIFT     (0x00000000u)
#define CSL_RTI_RTICPUC1_CPUC1_RESETVAL  (0x00000000u)

#define CSL_RTI_RTICPUC1_RESETVAL        (0x00000000u)

/* RTICAFRC1 */

#define CSL_RTI_RTICAFRC1_CAFRC1_MASK    (0xFFFFFFFFu)
#define CSL_RTI_RTICAFRC1_CAFRC1_SHIFT   (0x00000000u)
#define CSL_RTI_RTICAFRC1_CAFRC1_RESETVAL (0x00000000u)

#define CSL_RTI_RTICAFRC1_RESETVAL       (0x00000000u)

/* RTICAUC1 */

#define CSL_RTI_RTICAUC1_CAUC1_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTICAUC1_CAUC1_SHIFT     (0x00000000u)
#define CSL_RTI_RTICAUC1_CAUC1_RESETVAL  (0x00000000u)

#define CSL_RTI_RTICAUC1_RESETVAL        (0x00000000u)

/* RTICOMP0 */

#define CSL_RTI_RTICOMP0_COMP0_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTICOMP0_COMP0_SHIFT     (0x00000000u)
#define CSL_RTI_RTICOMP0_COMP0_RESETVAL  (0x00000000u)

#define CSL_RTI_RTICOMP0_RESETVAL        (0x00000000u)

/* RTIUDCP0 */

#define CSL_RTI_RTIUDCP0_UDCP0_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTIUDCP0_UDCP0_SHIFT     (0x00000000u)
#define CSL_RTI_RTIUDCP0_UDCP0_RESETVAL  (0x00000000u)

#define CSL_RTI_RTIUDCP0_RESETVAL        (0x00000000u)

/* RTICOMP1 */

#define CSL_RTI_RTICOMP1_COMP1_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTICOMP1_COMP1_SHIFT     (0x00000000u)
#define CSL_RTI_RTICOMP1_COMP1_RESETVAL  (0x00000000u)

#define CSL_RTI_RTICOMP1_RESETVAL        (0x00000000u)

/* RTIUDCP1 */

#define CSL_RTI_RTIUDCP1_UDCP1_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTIUDCP1_UDCP1_SHIFT     (0x00000000u)
#define CSL_RTI_RTIUDCP1_UDCP1_RESETVAL  (0x00000000u)

#define CSL_RTI_RTIUDCP1_RESETVAL        (0x00000000u)

/* RTICOMP2 */

#define CSL_RTI_RTICOMP2_COMP2_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTICOMP2_COMP2_SHIFT     (0x00000000u)
#define CSL_RTI_RTICOMP2_COMP2_RESETVAL  (0x00000000u)

#define CSL_RTI_RTICOMP2_RESETVAL        (0x00000000u)

/* RTIUDCP2 */

#define CSL_RTI_RTIUDCP2_UDCP2_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTIUDCP2_UDCP2_SHIFT     (0x00000000u)
#define CSL_RTI_RTIUDCP2_UDCP2_RESETVAL  (0x00000000u)

#define CSL_RTI_RTIUDCP2_RESETVAL        (0x00000000u)

/* RTICOMP3 */

#define CSL_RTI_RTICOMP3_COMP3_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTICOMP3_COMP3_SHIFT     (0x00000000u)
#define CSL_RTI_RTICOMP3_COMP3_RESETVAL  (0x00000000u)

#define CSL_RTI_RTICOMP3_RESETVAL        (0x00000000u)

/* RTIUDCP3 */

#define CSL_RTI_RTIUDCP3_UDCP3_MASK      (0xFFFFFFFFu)
#define CSL_RTI_RTIUDCP3_UDCP3_SHIFT     (0x00000000u)
#define CSL_RTI_RTIUDCP3_UDCP3_RESETVAL  (0x00000000u)

#define CSL_RTI_RTIUDCP3_RESETVAL        (0x00000000u)

/* RTISETINT */

#define CSL_RTI_RTISETINT_SETOVL1INT_MASK (0x00040000u)
#define CSL_RTI_RTISETINT_SETOVL1INT_SHIFT (0x00000012u)
#define CSL_RTI_RTISETINT_SETOVL1INT_RESETVAL (0x00000000u)

#define CSL_RTI_RTISETINT_SETOVL0INT_MASK (0x00020000u)
#define CSL_RTI_RTISETINT_SETOVL0INT_SHIFT (0x00000011u)
#define CSL_RTI_RTISETINT_SETOVL0INT_RESETVAL (0x00000000u)

#define CSL_RTI_RTISETINT_SETDMA3_MASK   (0x00000800u)
#define CSL_RTI_RTISETINT_SETDMA3_SHIFT  (0x0000000Bu)
#define CSL_RTI_RTISETINT_SETDMA3_RESETVAL (0x00000000u)

#define CSL_RTI_RTISETINT_SETDMA2_MASK   (0x00000400u)
#define CSL_RTI_RTISETINT_SETDMA2_SHIFT  (0x0000000Au)
#define CSL_RTI_RTISETINT_SETDMA2_RESETVAL (0x00000000u)

#define CSL_RTI_RTISETINT_SETDMA1_MASK   (0x00000200u)
#define CSL_RTI_RTISETINT_SETDMA1_SHIFT  (0x00000009u)
#define CSL_RTI_RTISETINT_SETDMA1_RESETVAL (0x00000000u)

#define CSL_RTI_RTISETINT_SETDMA0_MASK   (0x00000100u)
#define CSL_RTI_RTISETINT_SETDMA0_SHIFT  (0x00000008u)
#define CSL_RTI_RTISETINT_SETDMA0_RESETVAL (0x00000000u)

#define CSL_RTI_RTISETINT_SETINT3_MASK   (0x00000008u)
#define CSL_RTI_RTISETINT_SETINT3_SHIFT  (0x00000003u)
#define CSL_RTI_RTISETINT_SETINT3_RESETVAL (0x00000000u)

#define CSL_RTI_RTISETINT_SETINT2_MASK   (0x00000004u)
#define CSL_RTI_RTISETINT_SETINT2_SHIFT  (0x00000002u)
#define CSL_RTI_RTISETINT_SETINT2_RESETVAL (0x00000000u)

#define CSL_RTI_RTISETINT_SETINT1_MASK   (0x00000002u)
#define CSL_RTI_RTISETINT_SETINT1_SHIFT  (0x00000001u)
#define CSL_RTI_RTISETINT_SETINT1_RESETVAL (0x00000000u)

#define CSL_RTI_RTISETINT_SETINT0_MASK   (0x00000001u)
#define CSL_RTI_RTISETINT_SETINT0_SHIFT  (0x00000000u)
#define CSL_RTI_RTISETINT_SETINT0_RESETVAL (0x00000000u)

#define CSL_RTI_RTISETINT_RESETVAL       (0x00000000u)

/* RTICLEARINT */

#define CSL_RTI_RTICLEARINT_CLEAROVL1INT_MASK (0x00040000u)
#define CSL_RTI_RTICLEARINT_CLEAROVL1INT_SHIFT (0x00000012u)
#define CSL_RTI_RTICLEARINT_CLEAROVL1INT_RESETVAL (0x00000000u)

#define CSL_RTI_RTICLEARINT_CLEAROVL0INT_MASK (0x00020000u)
#define CSL_RTI_RTICLEARINT_CLEAROVL0INT_SHIFT (0x00000011u)
#define CSL_RTI_RTICLEARINT_CLEAROVL0INT_RESETVAL (0x00000000u)

#define CSL_RTI_RTICLEARINT_CLEARDMA3_MASK (0x00000800u)
#define CSL_RTI_RTICLEARINT_CLEARDMA3_SHIFT (0x0000000Bu)
#define CSL_RTI_RTICLEARINT_CLEARDMA3_RESETVAL (0x00000000u)

#define CSL_RTI_RTICLEARINT_CLEARDMA2_MASK (0x00000400u)
#define CSL_RTI_RTICLEARINT_CLEARDMA2_SHIFT (0x0000000Au)
#define CSL_RTI_RTICLEARINT_CLEARDMA2_RESETVAL (0x00000000u)

#define CSL_RTI_RTICLEARINT_CLEARDMA1_MASK (0x00000200u)
#define CSL_RTI_RTICLEARINT_CLEARDMA1_SHIFT (0x00000009u)
#define CSL_RTI_RTICLEARINT_CLEARDMA1_RESETVAL (0x00000000u)

#define CSL_RTI_RTICLEARINT_CLEARDMA0_MASK (0x00000100u)
#define CSL_RTI_RTICLEARINT_CLEARDMA0_SHIFT (0x00000008u)
#define CSL_RTI_RTICLEARINT_CLEARDMA0_RESETVAL (0x00000000u)

#define CSL_RTI_RTICLEARINT_CLEARINT3_MASK (0x00000008u)
#define CSL_RTI_RTICLEARINT_CLEARINT3_SHIFT (0x00000003u)
#define CSL_RTI_RTICLEARINT_CLEARINT3_RESETVAL (0x00000000u)

#define CSL_RTI_RTICLEARINT_CLEARINT2_MASK (0x00000004u)
#define CSL_RTI_RTICLEARINT_CLEARINT2_SHIFT (0x00000002u)
#define CSL_RTI_RTICLEARINT_CLEARINT2_RESETVAL (0x00000000u)

#define CSL_RTI_RTICLEARINT_CLEARINT1_MASK (0x00000002u)
#define CSL_RTI_RTICLEARINT_CLEARINT1_SHIFT (0x00000001u)
#define CSL_RTI_RTICLEARINT_CLEARINT1_RESETVAL (0x00000000u)

#define CSL_RTI_RTICLEARINT_CLEARINT0_MASK (0x00000001u)
#define CSL_RTI_RTICLEARINT_CLEARINT0_SHIFT (0x00000000u)
#define CSL_RTI_RTICLEARINT_CLEARINT0_RESETVAL (0x00000000u)

#define CSL_RTI_RTICLEARINT_RESETVAL     (0x00000000u)

/* RTIINTFLAG */

#define CSL_RTI_RTIINTFLAG_OVL1INT_MASK  (0x00040000u)
#define CSL_RTI_RTIINTFLAG_OVL1INT_SHIFT (0x00000012u)
#define CSL_RTI_RTIINTFLAG_OVL1INT_RESETVAL (0x00000000u)

/*----OVL1INT Tokens----*/
#define CSL_RTI_RTIINTFLAG_OVL1INT_CLEAROVFINT1 (0x00000001u)

#define CSL_RTI_RTIINTFLAG_OVL0INT_MASK  (0x00020000u)
#define CSL_RTI_RTIINTFLAG_OVL0INT_SHIFT (0x00000011u)
#define CSL_RTI_RTIINTFLAG_OVL0INT_RESETVAL (0x00000000u)

/*----OVL0INT Tokens----*/
#define CSL_RTI_RTIINTFLAG_OVL0INT_CLEAROVFINT0 (0x00000001u)

#define CSL_RTI_RTIINTFLAG_INT3_MASK     (0x00000008u)
#define CSL_RTI_RTIINTFLAG_INT3_SHIFT    (0x00000003u)
#define CSL_RTI_RTIINTFLAG_INT3_RESETVAL (0x00000000u)

/*----INT3 Tokens----*/
#define CSL_RTI_RTIINTFLAG_INT3_CLEARINT3 (0x00000001u)

#define CSL_RTI_RTIINTFLAG_INT2_MASK     (0x00000004u)
#define CSL_RTI_RTIINTFLAG_INT2_SHIFT    (0x00000002u)
#define CSL_RTI_RTIINTFLAG_INT2_RESETVAL (0x00000000u)

/*----INT2 Tokens----*/
#define CSL_RTI_RTIINTFLAG_INT2_CLEARINT2 (0x00000001u)

#define CSL_RTI_RTIINTFLAG_INT1_MASK     (0x00000002u)
#define CSL_RTI_RTIINTFLAG_INT1_SHIFT    (0x00000001u)
#define CSL_RTI_RTIINTFLAG_INT1_RESETVAL (0x00000000u)

/*----INT1 Tokens----*/
#define CSL_RTI_RTIINTFLAG_INT1_CLEARINT1 (0x00000001u)

#define CSL_RTI_RTIINTFLAG_INT0_MASK     (0x00000001u)
#define CSL_RTI_RTIINTFLAG_INT0_SHIFT    (0x00000000u)
#define CSL_RTI_RTIINTFLAG_INT0_RESETVAL (0x00000000u)

/*----INT0 Tokens----*/
#define CSL_RTI_RTIINTFLAG_INT0_CLEARINT0 (0x00000001u)

#define CSL_RTI_RTIINTFLAG_RESETVAL      (0x00000000u)

/* RTIDWDCTRL */

#define CSL_RTI_RTIDWDCTRL_DWDCTRL_MASK  (0xFFFFFFFFu)
#define CSL_RTI_RTIDWDCTRL_DWDCTRL_SHIFT (0x00000000u)
#define CSL_RTI_RTIDWDCTRL_DWDCTRL_RESETVAL (0x5312ACEDu)

#define CSL_RTI_RTIDWDCTRL_RESETVAL      (0x5312ACEDu)

/* RTIDWDPRLD */

#define CSL_RTI_RTIDWDPRLD_DWDPRLD_MASK  (0x00001FFFu)
#define CSL_RTI_RTIDWDPRLD_DWDPRLD_SHIFT (0x00000000u)
#define CSL_RTI_RTIDWDPRLD_DWDPRLD_RESETVAL (0x00001FFFu)

#define CSL_RTI_RTIDWDPRLD_RESETVAL      (0x00001FFFu)

/* RTIWDSTATUS */

#define CSL_RTI_RTIWDSTATUS_KEYST_MASK   (0x00000004u)
#define CSL_RTI_RTIWDSTATUS_KEYST_SHIFT  (0x00000002u)
#define CSL_RTI_RTIWDSTATUS_KEYST_RESETVAL (0x00000000u)

#define CSL_RTI_RTIWDSTATUS_DWDST_MASK   (0x00000002u)
#define CSL_RTI_RTIWDSTATUS_DWDST_SHIFT  (0x00000001u)
#define CSL_RTI_RTIWDSTATUS_DWDST_RESETVAL (0x00000000u)

/*----DWDST Tokens----*/
#define CSL_RTI_RTIWDSTATUS_DWDST_CLEARDWD (0x00000001u)

#define CSL_RTI_RTIWDSTATUS_RESETVAL     (0x00000000u)

/* RTIWDKEY */

#define CSL_RTI_RTIWDKEY_WDKEY_MASK      (0x0000FFFFu)
#define CSL_RTI_RTIWDKEY_WDKEY_SHIFT     (0x00000000u)
#define CSL_RTI_RTIWDKEY_WDKEY_RESETVAL  (0x00000000u)

#define CSL_RTI_RTIWDKEY_RESETVAL        (0x00000000u)

/* RTIDWDCNTR */

#define CSL_RTI_RTIDWDCNTR_DWDCNTR_MASK  (0x01FFFFFFu)
#define CSL_RTI_RTIDWDCNTR_DWDCNTR_SHIFT (0x00000000u)
#define CSL_RTI_RTIDWDCNTR_DWDCNTR_RESETVAL (0x00000000u)

#define CSL_RTI_RTIDWDCNTR_RESETVAL      (0x00000000u)

#endif
