#ifndef _CSLR_SPI_H_
#define _CSLR_SPI_H_
/*********************************************************************
 * Copyright (C) 2003-2005 Texas Instruments Incorporated. 
 * All Rights Reserved 
 *********************************************************************/
 /** \file cslr_spi.h
 * 
 * \brief This file contains the Register Desciptions for SPI
 * 
 *********************************************************************/

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 SPIGCR0;
    volatile Uint32 SPIGCR1;
    volatile Uint32 SPIINT0;
    volatile Uint32 SPILVL;
    volatile Uint32 SPIFLG;
    volatile Uint32 SPIPC0;
    volatile Uint32 SPIPC1;
    volatile Uint32 SPIPC2;
    volatile Uint32 SPIPC3;
    volatile Uint32 SPIPC4;
    volatile Uint32 SPIPC5;
    volatile Uint32 RSVD0[3];
    volatile Uint32 SPIDAT0;
    volatile Uint32 SPIDAT1;
    volatile Uint32 SPIBUF;
    volatile Uint32 SPIEMU;
    volatile Uint32 SPIDELAY;
    volatile Uint32 SPIDEF;
    volatile Uint32 SPIFMT[4];
    volatile Uint32 TGINTVECT[2];
} CSL_SpiRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* SPIGCR0 */

#define CSL_SPI_SPIGCR0_RESET_MASK       (0x00000001u)
#define CSL_SPI_SPIGCR0_RESET_SHIFT      (0x00000000u)
#define CSL_SPI_SPIGCR0_RESET_RESETVAL   (0x00000000u)

/*----RESET Tokens----*/
#define CSL_SPI_SPIGCR0_RESET_YES        (0x00000000u)
#define CSL_SPI_SPIGCR0_RESET_NO         (0x00000001u)

#define CSL_SPI_SPIGCR0_RESETVAL         (0x00000000u)

/* SPIGCR1 */

#define CSL_SPI_SPIGCR1_ENABLE_MASK      (0x01000000u)
#define CSL_SPI_SPIGCR1_ENABLE_SHIFT     (0x00000018u)
#define CSL_SPI_SPIGCR1_ENABLE_RESETVAL  (0x00000000u)

/*----ENABLE Tokens----*/
#define CSL_SPI_SPIGCR1_ENABLE_DISABLE   (0x00000000u)
#define CSL_SPI_SPIGCR1_ENABLE_ENABLE    (0x00000001u)

#define CSL_SPI_SPIGCR1_LOOPBACK_MASK    (0x00010000u)
#define CSL_SPI_SPIGCR1_LOOPBACK_SHIFT   (0x00000010u)
#define CSL_SPI_SPIGCR1_LOOPBACK_RESETVAL (0x00000000u)

/*----LOOPBACK Tokens----*/
#define CSL_SPI_SPIGCR1_LOOPBACK_DISABLE (0x00000000u)
#define CSL_SPI_SPIGCR1_LOOPBACK_ENABLE  (0x00000001u)

#define CSL_SPI_SPIGCR1_CLKMOD_MASK      (0x00000002u)
#define CSL_SPI_SPIGCR1_CLKMOD_SHIFT     (0x00000001u)
#define CSL_SPI_SPIGCR1_CLKMOD_RESETVAL  (0x00000000u)

/*----CLKMOD Tokens----*/
#define CSL_SPI_SPIGCR1_CLKMOD_SLAVEMODE (0x00000000u)
#define CSL_SPI_SPIGCR1_CLKMOD_MASTERMODE (0x00000001u)

#define CSL_SPI_SPIGCR1_MASTER_MASK      (0x00000001u)
#define CSL_SPI_SPIGCR1_MASTER_SHIFT     (0x00000000u)
#define CSL_SPI_SPIGCR1_MASTER_RESETVAL  (0x00000000u)

/*----MASTER Tokens----*/
#define CSL_SPI_SPIGCR1_MASTER_NO        (0x00000000u)
#define CSL_SPI_SPIGCR1_MASTER_YES       (0x00000001u)

#define CSL_SPI_SPIGCR1_RESETVAL         (0x00000000u)

/* SPIINT0 */

#define CSL_SPI_SPIINT0_ENABLEHIGHZ_MASK (0x01000000u)
#define CSL_SPI_SPIINT0_ENABLEHIGHZ_SHIFT (0x00000018u)
#define CSL_SPI_SPIINT0_ENABLEHIGHZ_RESETVAL (0x00000000u)

/*----ENABLEHIGHZ Tokens----*/
#define CSL_SPI_SPIINT0_ENABLEHIGHZ_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_ENABLEHIGHZ_ENABLE (0x00000001u)

#define CSL_SPI_SPIINT0_DMAREQEN_MASK    (0x00010000u)
#define CSL_SPI_SPIINT0_DMAREQEN_SHIFT   (0x00000010u)
#define CSL_SPI_SPIINT0_DMAREQEN_RESETVAL (0x00000000u)

/*----DMAREQEN Tokens----*/
#define CSL_SPI_SPIINT0_DMAREQEN_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_DMAREQEN_ENABLE  (0x00000001u)

#define CSL_SPI_SPIINT0_RXINTEN_MASK     (0x00000100u)
#define CSL_SPI_SPIINT0_RXINTEN_SHIFT    (0x00000008u)
#define CSL_SPI_SPIINT0_RXINTEN_RESETVAL (0x00000000u)

/*----RXINTEN Tokens----*/
#define CSL_SPI_SPIINT0_RXINTEN_DISABLE  (0x00000000u)
#define CSL_SPI_SPIINT0_RXINTEN_ENABLE   (0x00000001u)

#define CSL_SPI_SPIINT0_OVRNINTEN_MASK   (0x00000040u)
#define CSL_SPI_SPIINT0_OVRNINTEN_SHIFT  (0x00000006u)
#define CSL_SPI_SPIINT0_OVRNINTEN_RESETVAL (0x00000000u)

/*----OVRNINTEN Tokens----*/
#define CSL_SPI_SPIINT0_OVRNINTEN_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_OVRNINTEN_ENABLE (0x00000001u)

#define CSL_SPI_SPIINT0_BITERRENA_MASK   (0x00000010u)
#define CSL_SPI_SPIINT0_BITERRENA_SHIFT  (0x00000004u)
#define CSL_SPI_SPIINT0_BITERRENA_RESETVAL (0x00000000u)

/*----BITERRENA Tokens----*/
#define CSL_SPI_SPIINT0_BITERRENA_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_BITERRENA_ENABLE (0x00000001u)

#define CSL_SPI_SPIINT0_DESYNCENA_MASK   (0x00000008u)
#define CSL_SPI_SPIINT0_DESYNCENA_SHIFT  (0x00000003u)
#define CSL_SPI_SPIINT0_DESYNCENA_RESETVAL (0x00000000u)

/*----DESYNCENA Tokens----*/
#define CSL_SPI_SPIINT0_DESYNCENA_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_DESYNCENA_ENABLE (0x00000001u)

#define CSL_SPI_SPIINT0_TIMEOUTENA_MASK  (0x00000002u)
#define CSL_SPI_SPIINT0_TIMEOUTENA_SHIFT (0x00000001u)
#define CSL_SPI_SPIINT0_TIMEOUTENA_RESETVAL (0x00000000u)

/*----TIMEOUTENA Tokens----*/
#define CSL_SPI_SPIINT0_TIMEOUTENA_DISABLE (0x00000000u)
#define CSL_SPI_SPIINT0_TIMEOUTENA_ENABLE (0x00000001u)

#define CSL_SPI_SPIINT0_RESETVAL         (0x00000000u)

/* SPILVL */

#define CSL_SPI_SPILVL_RXINTLVL_MASK     (0x00000100u)
#define CSL_SPI_SPILVL_RXINTLVL_SHIFT    (0x00000008u)
#define CSL_SPI_SPILVL_RXINTLVL_RESETVAL (0x00000000u)

/*----RXINTLVL Tokens----*/
#define CSL_SPI_SPILVL_RXINTLVL_INT0     (0x00000000u)
#define CSL_SPI_SPILVL_RXINTLVL_INT1     (0x00000001u)

#define CSL_SPI_SPILVL_OVRNINTLVL_MASK   (0x00000040u)
#define CSL_SPI_SPILVL_OVRNINTLVL_SHIFT  (0x00000006u)
#define CSL_SPI_SPILVL_OVRNINTLVL_RESETVAL (0x00000000u)

/*----OVRNINTLVL Tokens----*/
#define CSL_SPI_SPILVL_OVRNINTLVL_INT0   (0x00000000u)
#define CSL_SPI_SPILVL_OVRNINTLVL_INT1   (0x00000001u)

#define CSL_SPI_SPILVL_BITERRLVL_MASK    (0x00000010u)
#define CSL_SPI_SPILVL_BITERRLVL_SHIFT   (0x00000004u)
#define CSL_SPI_SPILVL_BITERRLVL_RESETVAL (0x00000000u)

/*----BITERRLVL Tokens----*/
#define CSL_SPI_SPILVL_BITERRLVL_INT0    (0x00000000u)
#define CSL_SPI_SPILVL_BITERRLVL_INT1    (0x00000001u)

#define CSL_SPI_SPILVL_DESYNCLVL_MASK    (0x00000008u)
#define CSL_SPI_SPILVL_DESYNCLVL_SHIFT   (0x00000003u)
#define CSL_SPI_SPILVL_DESYNCLVL_RESETVAL (0x00000000u)

/*----DESYNCLVL Tokens----*/
#define CSL_SPI_SPILVL_DESYNCLVL_INT0    (0x00000000u)
#define CSL_SPI_SPILVL_DESYNCLVL_INT1    (0x00000001u)

#define CSL_SPI_SPILVL_TIMEOUTLVL_MASK   (0x00000002u)
#define CSL_SPI_SPILVL_TIMEOUTLVL_SHIFT  (0x00000001u)
#define CSL_SPI_SPILVL_TIMEOUTLVL_RESETVAL (0x00000000u)

/*----TIMEOUTLVL Tokens----*/
#define CSL_SPI_SPILVL_TIMEOUTLVL_INT0   (0x00000000u)
#define CSL_SPI_SPILVL_TIMEOUTLVL_INT1   (0x00000001u)

#define CSL_SPI_SPILVL_RESETVAL          (0x00000000u)

/* SPIFLG */

#define CSL_SPI_SPIFLG_RXINTFLAG_MASK    (0x00000100u)
#define CSL_SPI_SPIFLG_RXINTFLAG_SHIFT   (0x00000008u)
#define CSL_SPI_SPIFLG_RXINTFLAG_RESETVAL (0x00000000u)

/*----RXINTFLAG Tokens----*/
#define CSL_SPI_SPIFLG_RXINTFLAG_NO      (0x00000000u)
#define CSL_SPI_SPIFLG_RXINTFLAG_YES     (0x00000001u)

#define CSL_SPI_SPIFLG_OVRNINTFLG_MASK   (0x00000040u)
#define CSL_SPI_SPIFLG_OVRNINTFLG_SHIFT  (0x00000006u)
#define CSL_SPI_SPIFLG_OVRNINTFLG_RESETVAL (0x00000000u)

/*----OVRNINTFLG Tokens----*/
#define CSL_SPI_SPIFLG_OVRNINTFLG_NO     (0x00000000u)
#define CSL_SPI_SPIFLG_OVRNINTFLG_YES    (0x00000001u)

#define CSL_SPI_SPIFLG_BITERRFLG_MASK    (0x00000010u)
#define CSL_SPI_SPIFLG_BITERRFLG_SHIFT   (0x00000004u)
#define CSL_SPI_SPIFLG_BITERRFLG_RESETVAL (0x00000000u)

/*----BITERRFLG Tokens----*/
#define CSL_SPI_SPIFLG_BITERRFLG_NO      (0x00000000u)
#define CSL_SPI_SPIFLG_BITERRFLG_YES     (0x00000001u)

#define CSL_SPI_SPIFLG_DESYNCFLG_MASK    (0x00000008u)
#define CSL_SPI_SPIFLG_DESYNCFLG_SHIFT   (0x00000003u)
#define CSL_SPI_SPIFLG_DESYNCFLG_RESETVAL (0x00000000u)

/*----DESYNCFLG Tokens----*/
#define CSL_SPI_SPIFLG_DESYNCFLG_NO      (0x00000000u)
#define CSL_SPI_SPIFLG_DESYNCFLG_YES     (0x00000001u)

#define CSL_SPI_SPIFLG_TIMEOUTFLG_MASK   (0x00000002u)
#define CSL_SPI_SPIFLG_TIMEOUTFLG_SHIFT  (0x00000001u)
#define CSL_SPI_SPIFLG_TIMEOUTFLG_RESETVAL (0x00000000u)

/*----TIMEOUTFLG Tokens----*/
#define CSL_SPI_SPIFLG_TIMEOUTFLG_NO     (0x00000000u)
#define CSL_SPI_SPIFLG_TIMEOUTFLG_YES    (0x00000001u)

#define CSL_SPI_SPIFLG_RESETVAL          (0x00000000u)

/* SPIPC0 */

#define CSL_SPI_SPIPC0_SOMIFUN_MASK      (0x00000800u)
#define CSL_SPI_SPIPC0_SOMIFUN_SHIFT     (0x0000000Bu)
#define CSL_SPI_SPIPC0_SOMIFUN_RESETVAL  (0x00000000u)

/*----SOMIFUN Tokens----*/
#define CSL_SPI_SPIPC0_SOMIFUN_GPIO      (0x00000000u)
#define CSL_SPI_SPIPC0_SOMIFUN_SPI       (0x00000001u)

#define CSL_SPI_SPIPC0_SIMOFUN_MASK      (0x00000400u)
#define CSL_SPI_SPIPC0_SIMOFUN_SHIFT     (0x0000000Au)
#define CSL_SPI_SPIPC0_SIMOFUN_RESETVAL  (0x00000000u)

/*----SIMOFUN Tokens----*/
#define CSL_SPI_SPIPC0_SIMOFUN_GPIO      (0x00000000u)
#define CSL_SPI_SPIPC0_SIMOFUN_SPI       (0x00000001u)

#define CSL_SPI_SPIPC0_CLKFUN_MASK       (0x00000200u)
#define CSL_SPI_SPIPC0_CLKFUN_SHIFT      (0x00000009u)
#define CSL_SPI_SPIPC0_CLKFUN_RESETVAL   (0x00000000u)

/*----CLKFUN Tokens----*/
#define CSL_SPI_SPIPC0_CLKFUN_GPIO       (0x00000000u)
#define CSL_SPI_SPIPC0_CLKFUN_SPI        (0x00000001u)

#define CSL_SPI_SPIPC0_ENABLEFUN_MASK    (0x00000100u)
#define CSL_SPI_SPIPC0_ENABLEFUN_SHIFT   (0x00000008u)
#define CSL_SPI_SPIPC0_ENABLEFUN_RESETVAL (0x00000000u)

/*----ENABLEFUN Tokens----*/
#define CSL_SPI_SPIPC0_ENABLEFUN_GPIO    (0x00000000u)
#define CSL_SPI_SPIPC0_ENABLEFUN_SPI     (0x00000001u)

#define CSL_SPI_SPIPC0_SCSFUN0_MASK      (0x00000001u)
#define CSL_SPI_SPIPC0_SCSFUN0_SHIFT     (0x00000000u)
#define CSL_SPI_SPIPC0_SCSFUN0_RESETVAL  (0x00000000u)

/*----SCSFUN0 Tokens----*/
#define CSL_SPI_SPIPC0_SCSFUN0_GPIO      (0x00000000u)
#define CSL_SPI_SPIPC0_SCSFUN0_SPI       (0x00000001u)

#define CSL_SPI_SPIPC0_RESETVAL          (0x00000000u)

/* SPIPC1 */

#define CSL_SPI_SPIPC1_SOMIDIR_MASK      (0x00000800u)
#define CSL_SPI_SPIPC1_SOMIDIR_SHIFT     (0x0000000Bu)
#define CSL_SPI_SPIPC1_SOMIDIR_RESETVAL  (0x00000000u)

/*----SOMIDIR Tokens----*/
#define CSL_SPI_SPIPC1_SOMIDIR_IN        (0x00000000u)
#define CSL_SPI_SPIPC1_SOMIDIR_OUT       (0x00000001u)

#define CSL_SPI_SPIPC1_SIMODIR_MASK      (0x00000400u)
#define CSL_SPI_SPIPC1_SIMODIR_SHIFT     (0x0000000Au)
#define CSL_SPI_SPIPC1_SIMODIR_RESETVAL  (0x00000000u)

/*----SIMODIR Tokens----*/
#define CSL_SPI_SPIPC1_SIMODIR_IN        (0x00000000u)
#define CSL_SPI_SPIPC1_SIMODIR_OUT       (0x00000001u)

#define CSL_SPI_SPIPC1_CLKDIR_MASK       (0x00000200u)
#define CSL_SPI_SPIPC1_CLKDIR_SHIFT      (0x00000009u)
#define CSL_SPI_SPIPC1_CLKDIR_RESETVAL   (0x00000000u)

/*----CLKDIR Tokens----*/
#define CSL_SPI_SPIPC1_CLKDIR_IN         (0x00000000u)
#define CSL_SPI_SPIPC1_CLKDIR_OUT        (0x00000001u)

#define CSL_SPI_SPIPC1_ENABLEDIR_MASK    (0x00000100u)
#define CSL_SPI_SPIPC1_ENABLEDIR_SHIFT   (0x00000008u)
#define CSL_SPI_SPIPC1_ENABLEDIR_RESETVAL (0x00000000u)

/*----ENABLEDIR Tokens----*/
#define CSL_SPI_SPIPC1_ENABLEDIR_IN      (0x00000000u)
#define CSL_SPI_SPIPC1_ENABLEDIR_OUT     (0x00000001u)

#define CSL_SPI_SPIPC1_SCSDIR0_MASK      (0x00000001u)
#define CSL_SPI_SPIPC1_SCSDIR0_SHIFT     (0x00000000u)
#define CSL_SPI_SPIPC1_SCSDIR0_RESETVAL  (0x00000000u)

/*----SCSDIR0 Tokens----*/
#define CSL_SPI_SPIPC1_SCSDIR0_IN        (0x00000000u)
#define CSL_SPI_SPIPC1_SCSDIR0_OUT       (0x00000001u)

#define CSL_SPI_SPIPC1_RESETVAL          (0x00000000u)

/* SPIPC2 */

#define CSL_SPI_SPIPC2_SOMIDIN_MASK      (0x00000800u)
#define CSL_SPI_SPIPC2_SOMIDIN_SHIFT     (0x0000000Bu)
#define CSL_SPI_SPIPC2_SOMIDIN_RESETVAL  (0x00000000u)

/*----SOMIDIN Tokens----*/
#define CSL_SPI_SPIPC2_SOMIDIN_LO        (0x00000000u)
#define CSL_SPI_SPIPC2_SOMIDIN_HI        (0x00000001u)

#define CSL_SPI_SPIPC2_SIMODIN_MASK      (0x00000400u)
#define CSL_SPI_SPIPC2_SIMODIN_SHIFT     (0x0000000Au)
#define CSL_SPI_SPIPC2_SIMODIN_RESETVAL  (0x00000000u)

/*----SIMODIN Tokens----*/
#define CSL_SPI_SPIPC2_SIMODIN_LO        (0x00000000u)
#define CSL_SPI_SPIPC2_SIMODIN_HI        (0x00000001u)

#define CSL_SPI_SPIPC2_CLKDIN_MASK       (0x00000200u)
#define CSL_SPI_SPIPC2_CLKDIN_SHIFT      (0x00000009u)
#define CSL_SPI_SPIPC2_CLKDIN_RESETVAL   (0x00000000u)

/*----CLKDIN Tokens----*/
#define CSL_SPI_SPIPC2_CLKDIN_LO         (0x00000000u)
#define CSL_SPI_SPIPC2_CLKDIN_HI         (0x00000001u)

#define CSL_SPI_SPIPC2_ENABLEDIN_MASK    (0x00000100u)
#define CSL_SPI_SPIPC2_ENABLEDIN_SHIFT   (0x00000008u)
#define CSL_SPI_SPIPC2_ENABLEDIN_RESETVAL (0x00000000u)

/*----ENABLEDIN Tokens----*/
#define CSL_SPI_SPIPC2_ENABLEDIN_LO      (0x00000000u)
#define CSL_SPI_SPIPC2_ENABLEDIN_HI      (0x00000001u)

#define CSL_SPI_SPIPC2_SCSDIN0_MASK      (0x00000001u)
#define CSL_SPI_SPIPC2_SCSDIN0_SHIFT     (0x00000000u)
#define CSL_SPI_SPIPC2_SCSDIN0_RESETVAL  (0x00000000u)

/*----SCSDIN0 Tokens----*/
#define CSL_SPI_SPIPC2_SCSDIN0_LO        (0x00000000u)
#define CSL_SPI_SPIPC2_SCSDIN0_HI        (0x00000001u)

#define CSL_SPI_SPIPC2_RESETVAL          (0x00000000u)

/* SPIPC3 */

#define CSL_SPI_SPIPC3_SOMIDOUT_MASK     (0x00000800u)
#define CSL_SPI_SPIPC3_SOMIDOUT_SHIFT    (0x0000000Bu)
#define CSL_SPI_SPIPC3_SOMIDOUT_RESETVAL (0x00000000u)

/*----SOMIDOUT Tokens----*/
#define CSL_SPI_SPIPC3_SOMIDOUT_LO       (0x00000000u)
#define CSL_SPI_SPIPC3_SOMIDOUT_HI       (0x00000001u)

#define CSL_SPI_SPIPC3_SIMODOUT_MASK     (0x00000400u)
#define CSL_SPI_SPIPC3_SIMODOUT_SHIFT    (0x0000000Au)
#define CSL_SPI_SPIPC3_SIMODOUT_RESETVAL (0x00000000u)

/*----SIMODOUT Tokens----*/
#define CSL_SPI_SPIPC3_SIMODOUT_LO       (0x00000000u)
#define CSL_SPI_SPIPC3_SIMODOUT_HI       (0x00000001u)

#define CSL_SPI_SPIPC3_CLKDOUT_MASK      (0x00000200u)
#define CSL_SPI_SPIPC3_CLKDOUT_SHIFT     (0x00000009u)
#define CSL_SPI_SPIPC3_CLKDOUT_RESETVAL  (0x00000000u)

/*----CLKDOUT Tokens----*/
#define CSL_SPI_SPIPC3_CLKDOUT_LO        (0x00000000u)
#define CSL_SPI_SPIPC3_CLKDOUT_HI        (0x00000001u)

#define CSL_SPI_SPIPC3_ENABLEDOUT_MASK   (0x00000100u)
#define CSL_SPI_SPIPC3_ENABLEDOUT_SHIFT  (0x00000008u)
#define CSL_SPI_SPIPC3_ENABLEDOUT_RESETVAL (0x00000000u)

/*----ENABLEDOUT Tokens----*/
#define CSL_SPI_SPIPC3_ENABLEDOUT_LO     (0x00000000u)
#define CSL_SPI_SPIPC3_ENABLEDOUT_HI     (0x00000001u)

#define CSL_SPI_SPIPC3_SCSDOUT0_MASK     (0x00000001u)
#define CSL_SPI_SPIPC3_SCSDOUT0_SHIFT    (0x00000000u)
#define CSL_SPI_SPIPC3_SCSDOUT0_RESETVAL (0x00000000u)

/*----SCSDOUT0 Tokens----*/
#define CSL_SPI_SPIPC3_SCSDOUT0_LO       (0x00000000u)
#define CSL_SPI_SPIPC3_SCSDOUT0_HI       (0x00000001u)

#define CSL_SPI_SPIPC3_RESETVAL          (0x00000000u)

/* SPIPC4 */

#define CSL_SPI_SPIPC4_SOMISET_MASK      (0x00000800u)
#define CSL_SPI_SPIPC4_SOMISET_SHIFT     (0x0000000Bu)
#define CSL_SPI_SPIPC4_SOMISET_RESETVAL  (0x00000000u)

/*----SOMISET Tokens----*/
#define CSL_SPI_SPIPC4_SOMISET_LO        (0x00000000u)
#define CSL_SPI_SPIPC4_SOMISET_HI        (0x00000001u)

#define CSL_SPI_SPIPC4_SIMOSET_MASK      (0x00000400u)
#define CSL_SPI_SPIPC4_SIMOSET_SHIFT     (0x0000000Au)
#define CSL_SPI_SPIPC4_SIMOSET_RESETVAL  (0x00000000u)

/*----SIMOSET Tokens----*/
#define CSL_SPI_SPIPC4_SIMOSET_LO        (0x00000000u)
#define CSL_SPI_SPIPC4_SIMOSET_HI        (0x00000001u)

#define CSL_SPI_SPIPC4_CLKSET_MASK       (0x00000200u)
#define CSL_SPI_SPIPC4_CLKSET_SHIFT      (0x00000009u)
#define CSL_SPI_SPIPC4_CLKSET_RESETVAL   (0x00000000u)

/*----CLKSET Tokens----*/
#define CSL_SPI_SPIPC4_CLKSET_LO         (0x00000000u)
#define CSL_SPI_SPIPC4_CLKSET_HI         (0x00000001u)

#define CSL_SPI_SPIPC4_ENABLESET_MASK    (0x00000100u)
#define CSL_SPI_SPIPC4_ENABLESET_SHIFT   (0x00000008u)
#define CSL_SPI_SPIPC4_ENABLESET_RESETVAL (0x00000000u)

/*----ENABLESET Tokens----*/
#define CSL_SPI_SPIPC4_ENABLESET_LO      (0x00000000u)
#define CSL_SPI_SPIPC4_ENABLESET_HI      (0x00000001u)

#define CSL_SPI_SPIPC4_SCSSET0_MASK      (0x00000001u)
#define CSL_SPI_SPIPC4_SCSSET0_SHIFT     (0x00000000u)
#define CSL_SPI_SPIPC4_SCSSET0_RESETVAL  (0x00000000u)

/*----SCSSET0 Tokens----*/
#define CSL_SPI_SPIPC4_SCSSET0_LO        (0x00000000u)
#define CSL_SPI_SPIPC4_SCSSET0_HI        (0x00000001u)

#define CSL_SPI_SPIPC4_RESETVAL          (0x00000000u)

/* SPIPC5 */

#define CSL_SPI_SPIPC5_SOMICLR_MASK      (0x00000800u)
#define CSL_SPI_SPIPC5_SOMICLR_SHIFT     (0x0000000Bu)
#define CSL_SPI_SPIPC5_SOMICLR_RESETVAL  (0x00000000u)

/*----SOMICLR Tokens----*/
#define CSL_SPI_SPIPC5_SOMICLR_LO        (0x00000000u)
#define CSL_SPI_SPIPC5_SOMICLR_HI        (0x00000001u)

#define CSL_SPI_SPIPC5_SIMOCLR_MASK      (0x00000400u)
#define CSL_SPI_SPIPC5_SIMOCLR_SHIFT     (0x0000000Au)
#define CSL_SPI_SPIPC5_SIMOCLR_RESETVAL  (0x00000000u)

/*----SIMOCLR Tokens----*/
#define CSL_SPI_SPIPC5_SIMOCLR_LO        (0x00000000u)
#define CSL_SPI_SPIPC5_SIMOCLR_HI        (0x00000001u)

#define CSL_SPI_SPIPC5_CLKCLR_MASK       (0x00000200u)
#define CSL_SPI_SPIPC5_CLKCLR_SHIFT      (0x00000009u)
#define CSL_SPI_SPIPC5_CLKCLR_RESETVAL   (0x00000000u)

/*----CLKCLR Tokens----*/
#define CSL_SPI_SPIPC5_CLKCLR_LO         (0x00000000u)
#define CSL_SPI_SPIPC5_CLKCLR_HI         (0x00000001u)

#define CSL_SPI_SPIPC5_ENABLECLR_MASK    (0x00000100u)
#define CSL_SPI_SPIPC5_ENABLECLR_SHIFT   (0x00000008u)
#define CSL_SPI_SPIPC5_ENABLECLR_RESETVAL (0x00000000u)

/*----ENABLECLR Tokens----*/
#define CSL_SPI_SPIPC5_ENABLECLR_LO      (0x00000000u)
#define CSL_SPI_SPIPC5_ENABLECLR_HI      (0x00000001u)

#define CSL_SPI_SPIPC5_SCSCLR0_MASK      (0x00000001u)
#define CSL_SPI_SPIPC5_SCSCLR0_SHIFT     (0x00000000u)
#define CSL_SPI_SPIPC5_SCSCLR0_RESETVAL  (0x00000000u)

/*----SCSCLR0 Tokens----*/
#define CSL_SPI_SPIPC5_SCSCLR0_LO        (0x00000000u)
#define CSL_SPI_SPIPC5_SCSCLR0_HI        (0x00000001u)

#define CSL_SPI_SPIPC5_RESETVAL          (0x00000000u)

/* SPIDAT0 */

#define CSL_SPI_SPIDAT0_SPIDAT0_MASK     (0x0000FFFFu)
#define CSL_SPI_SPIDAT0_SPIDAT0_SHIFT    (0x00000000u)
#define CSL_SPI_SPIDAT0_SPIDAT0_RESETVAL (0x00000000u)

#define CSL_SPI_SPIDAT0_RESETVAL         (0x00000000u)

/* SPIDAT1 */

#define CSL_SPI_SPIDAT1_CSHOLD_MASK      (0x10000000u)
#define CSL_SPI_SPIDAT1_CSHOLD_SHIFT     (0x0000001Cu)
#define CSL_SPI_SPIDAT1_CSHOLD_RESETVAL  (0x00000000u)

/*----CSHOLD Tokens----*/
#define CSL_SPI_SPIDAT1_CSHOLD_NO        (0x00000000u)
#define CSL_SPI_SPIDAT1_CSHOLD_YES       (0x00000001u)

#define CSL_SPI_SPIDAT1_WDEL_MASK        (0x04000000u)
#define CSL_SPI_SPIDAT1_WDEL_SHIFT       (0x0000001Au)
#define CSL_SPI_SPIDAT1_WDEL_RESETVAL    (0x00000000u)

/*----WDEL Tokens----*/
#define CSL_SPI_SPIDAT1_WDEL_NODELAY     (0x00000000u)
#define CSL_SPI_SPIDAT1_WDEL_DELAY       (0x00000001u)

#define CSL_SPI_SPIDAT1_DFSEL_MASK       (0x03000000u)
#define CSL_SPI_SPIDAT1_DFSEL_SHIFT      (0x00000018u)
#define CSL_SPI_SPIDAT1_DFSEL_RESETVAL   (0x00000000u)

/*----DFSEL Tokens----*/
#define CSL_SPI_SPIDAT1_DFSEL_FMT0       (0x00000000u)
#define CSL_SPI_SPIDAT1_DFSEL_FMT1       (0x00000001u)
#define CSL_SPI_SPIDAT1_DFSEL_FMT2       (0x00000002u)
#define CSL_SPI_SPIDAT1_DFSEL_FMT3       (0x00000003u)

#define CSL_SPI_SPIDAT1_CSNR_MASK        (0x00FF0000u)
#define CSL_SPI_SPIDAT1_CSNR_SHIFT       (0x00000010u)
#define CSL_SPI_SPIDAT1_CSNR_RESETVAL    (0x00000000u)

#define CSL_SPI_SPIDAT1_SPIDAT1_MASK     (0x0000FFFFu)
#define CSL_SPI_SPIDAT1_SPIDAT1_SHIFT    (0x00000000u)
#define CSL_SPI_SPIDAT1_SPIDAT1_RESETVAL (0x00000000u)

#define CSL_SPI_SPIDAT1_RESETVAL         (0x00000000u)

/* SPIBUF */

#define CSL_SPI_SPIBUF_RXEMPTY_MASK      (0x80000000u)
#define CSL_SPI_SPIBUF_RXEMPTY_SHIFT     (0x0000001Fu)
#define CSL_SPI_SPIBUF_RXEMPTY_RESETVAL  (0x00000001u)

/*----RXEMPTY Tokens----*/
#define CSL_SPI_SPIBUF_RXEMPTY_YES       (0x00000000u)
#define CSL_SPI_SPIBUF_RXEMPTY_NO        (0x00000001u)

#define CSL_SPI_SPIBUF_OVRNINT_MASK      (0x40000000u)
#define CSL_SPI_SPIBUF_OVRNINT_SHIFT     (0x0000001Eu)
#define CSL_SPI_SPIBUF_OVRNINT_RESETVAL  (0x00000000u)

/*----OVRNINT Tokens----*/
#define CSL_SPI_SPIBUF_OVRNINT_NO        (0x00000000u)
#define CSL_SPI_SPIBUF_OVRNINT_YES       (0x00000001u)

#define CSL_SPI_SPIBUF_TXFULL_MASK       (0x20000000u)
#define CSL_SPI_SPIBUF_TXFULL_SHIFT      (0x0000001Du)
#define CSL_SPI_SPIBUF_TXFULL_RESETVAL   (0x00000000u)

/*----TXFULL Tokens----*/
#define CSL_SPI_SPIBUF_TXFULL_NO         (0x00000000u)
#define CSL_SPI_SPIBUF_TXFULL_YES        (0x00000001u)

#define CSL_SPI_SPIBUF_BITERR_MASK       (0x10000000u)
#define CSL_SPI_SPIBUF_BITERR_SHIFT      (0x0000001Cu)
#define CSL_SPI_SPIBUF_BITERR_RESETVAL   (0x00000000u)

/*----BITERR Tokens----*/
#define CSL_SPI_SPIBUF_BITERR_NO         (0x00000000u)
#define CSL_SPI_SPIBUF_BITERR_YES        (0x00000001u)

#define CSL_SPI_SPIBUF_DESYNC_MASK       (0x08000000u)
#define CSL_SPI_SPIBUF_DESYNC_SHIFT      (0x0000001Bu)
#define CSL_SPI_SPIBUF_DESYNC_RESETVAL   (0x00000000u)

/*----DESYNC Tokens----*/
#define CSL_SPI_SPIBUF_DESYNC_NO         (0x00000000u)
#define CSL_SPI_SPIBUF_DESYNC_YES        (0x00000001u)

#define CSL_SPI_SPIBUF_TIMEOUT_MASK      (0x02000000u)
#define CSL_SPI_SPIBUF_TIMEOUT_SHIFT     (0x00000019u)
#define CSL_SPI_SPIBUF_TIMEOUT_RESETVAL  (0x00000000u)

/*----TIMEOUT Tokens----*/
#define CSL_SPI_SPIBUF_TIMEOUT_NO        (0x00000000u)
#define CSL_SPI_SPIBUF_TIMEOUT_YES       (0x00000001u)

#define CSL_SPI_SPIBUF_SPIBUF_MASK       (0x0000FFFFu)
#define CSL_SPI_SPIBUF_SPIBUF_SHIFT      (0x00000000u)
#define CSL_SPI_SPIBUF_SPIBUF_RESETVAL   (0x00000000u)

#define CSL_SPI_SPIBUF_RESETVAL          (0x80000000u)

/* SPIEMU */

#define CSL_SPI_SPIEMU_SPIEMU_MASK       (0x0000FFFFu)
#define CSL_SPI_SPIEMU_SPIEMU_SHIFT      (0x00000000u)
#define CSL_SPI_SPIEMU_SPIEMU_RESETVAL   (0x00000000u)

#define CSL_SPI_SPIEMU_RESETVAL          (0x00000000u)

/* SPIDELAY */

#define CSL_SPI_SPIDELAY_C2TDELAY_MASK   (0x1F000000u)
#define CSL_SPI_SPIDELAY_C2TDELAY_SHIFT  (0x00000018u)
#define CSL_SPI_SPIDELAY_C2TDELAY_RESETVAL (0x00000000u)

#define CSL_SPI_SPIDELAY_T2CDELAY_MASK   (0x001F0000u)
#define CSL_SPI_SPIDELAY_T2CDELAY_SHIFT  (0x00000010u)
#define CSL_SPI_SPIDELAY_T2CDELAY_RESETVAL (0x00000000u)

#define CSL_SPI_SPIDELAY_T2EDELAY_MASK   (0x0000FF00u)
#define CSL_SPI_SPIDELAY_T2EDELAY_SHIFT  (0x00000008u)
#define CSL_SPI_SPIDELAY_T2EDELAY_RESETVAL (0x00000000u)

#define CSL_SPI_SPIDELAY_C2EDELAY_MASK   (0x000000FFu)
#define CSL_SPI_SPIDELAY_C2EDELAY_SHIFT  (0x00000000u)
#define CSL_SPI_SPIDELAY_C2EDELAY_RESETVAL (0x00000000u)

#define CSL_SPI_SPIDELAY_RESETVAL        (0x00000000u)

/* SPIDEF */

#define CSL_SPI_SPIDEF_CSDEF0_MASK       (0x00000001u)
#define CSL_SPI_SPIDEF_CSDEF0_SHIFT      (0x00000000u)
#define CSL_SPI_SPIDEF_CSDEF0_RESETVAL   (0x00000001u)

#define CSL_SPI_SPIDEF_RESETVAL          (0x00000001u)

/* SPIFMT */

#define CSL_SPI_SPIFMT_WDELAY_MASK       (0x3F000000u)
#define CSL_SPI_SPIFMT_WDELAY_SHIFT      (0x00000018u)
#define CSL_SPI_SPIFMT_WDELAY_RESETVAL   (0x00000000u)

#define CSL_SPI_SPIFMT_WAITENA_MASK      (0x00200000u)
#define CSL_SPI_SPIFMT_WAITENA_SHIFT     (0x00000015u)
#define CSL_SPI_SPIFMT_WAITENA_RESETVAL  (0x00000000u)

/*----WAITENA Tokens----*/
#define CSL_SPI_SPIFMT_WAITENA_NO        (0x00000000u)
#define CSL_SPI_SPIFMT_WAITENA_YES       (0x00000001u)

#define CSL_SPI_SPIFMT_SHIFTDIR_MASK     (0x00100000u)
#define CSL_SPI_SPIFMT_SHIFTDIR_SHIFT    (0x00000014u)
#define CSL_SPI_SPIFMT_SHIFTDIR_RESETVAL (0x00000000u)

/*----SHIFTDIR Tokens----*/
#define CSL_SPI_SPIFMT_SHIFTDIR_MSBFIRST (0x00000000u)
#define CSL_SPI_SPIFMT_SHIFTDIR_LSBFIRST (0x00000001u)

#define CSL_SPI_SPIFMT_POLARITY_MASK     (0x00020000u)
#define CSL_SPI_SPIFMT_POLARITY_SHIFT    (0x00000011u)
#define CSL_SPI_SPIFMT_POLARITY_RESETVAL (0x00000000u)

/*----POLARITY Tokens----*/
#define CSL_SPI_SPIFMT_POLARITY_INACTIVELO (0x00000000u)
#define CSL_SPI_SPIFMT_POLARITY_INACTIVEHI (0x00000001u)

#define CSL_SPI_SPIFMT_PHASE_MASK        (0x00010000u)
#define CSL_SPI_SPIFMT_PHASE_SHIFT       (0x00000010u)
#define CSL_SPI_SPIFMT_PHASE_RESETVAL    (0x00000000u)

/*----PHASE Tokens----*/
#define CSL_SPI_SPIFMT_PHASE_IN          (0x00000000u)
#define CSL_SPI_SPIFMT_PHASE_OUT         (0x00000001u)

#define CSL_SPI_SPIFMT_PRESCALE_MASK     (0x0000FF00u)
#define CSL_SPI_SPIFMT_PRESCALE_SHIFT    (0x00000008u)
#define CSL_SPI_SPIFMT_PRESCALE_RESETVAL (0x00000000u)

#define CSL_SPI_SPIFMT_CHARLEN_MASK      (0x0000001Fu)
#define CSL_SPI_SPIFMT_CHARLEN_SHIFT     (0x00000000u)
#define CSL_SPI_SPIFMT_CHARLEN_RESETVAL  (0x00000000u)

#define CSL_SPI_SPIFMT_RESETVAL          (0x00000000u)

/* TGINTVECT */

#define CSL_SPI_TGINTVECT_INTVECT_MASK   (0x0000003Eu)
#define CSL_SPI_TGINTVECT_INTVECT_SHIFT  (0x00000001u)
#define CSL_SPI_TGINTVECT_INTVECT_RESETVAL (0x00000000u)

#define CSL_SPI_TGINTVECT_RESETVAL       (0x00000000u)

#endif
