/*   ==========================================================================
 *   Copyright (c) Texas Instruments Inc , 2005
 *
 *   Use of this software is controlled by the terms and conditions found
 *   in the license agreement under which this software has been supplied
 *   provided
 *   ==========================================================================
*/

/* =============================================================================
 *  Revision History
 *  ===============
 *  dd-mmm-yyyy author  created 
 *
 * =============================================================================
 */

#ifndef _SOC_H
#define _SOC_H

/*****************************************************************************/
/** \file soc.h
 *
 * \brief This file contains the Chip Description for C672x
 *
 *****************************************************************************/

#include <cslr.h>
#include <tistdtypes.h>

/*****************************************************************************\
* Include files for all the modules in the device
\*****************************************************************************/
#include "cslr_pllc.h"
#include "cslr_chip.h"
#include "cslr_emif.h"
#include "cslr_rti.h"
#include "cslr_i2c.h"
#include "cslr_spi.h"
#include "cslr_mcasp.h"
#include "cslr_uhpi.h"
#include "cslr_icache.h"
#include "cslr_dmax.h"

/*****************************************************************************\
* Peripheral Instance counts
\*****************************************************************************/
/* Interrupt Event Ids */
#define CSL_INTC_EVENTID_RESET           (0)      /**<External device Reset */
                                                  /**< watchdog Reset */
                                                  /**< Emulator Reset */
#define CSL_INTC_EVENTID_NMI             (1)      /**< Dmax nmi output*/
                                                  /**< EMIF mem_error_pls_int */
                                                  /**< timeout error */
#define CSL_INTC_EVENTID_RTI_INT_REQ0    (4)      /**< RTI_INT_REQ[0] */
#define CSL_INTC_EVENTID_RTI_INT_OVL_REQ (5)      /**<RTI_INT_REQ[1]*/
                                                  /**< RTI_INT_REQ[2]*/
                                                  /**<RTI_INT_REQ[3]*/
                                                  /**< RTI_OVL_REQ[0] */
                                                  /**<RTI_OVL_REQ[1]*/
#define CSL_INTC_EVENTID_UHPI            (6)      /**<UHPI_CPU_INT*/
#define CSL_INTC_EVENTID_DMAXEVTOUT0     (7)      /**< dMAXEVTOUT[0]*/
#define CSL_INTC_EVENTID_DMAXEVTOUT1     (8)      /**<dMAXEVTOUT[1]*/
#define CSL_INTC_EVENTID_DMAXEVTOUT2     (9)      /**<dMAXEVTOUT[2] */
#define CSL_INTC_EVENTID_DMAXEVTOUT3     (10)     /**<dMAXEVTOUT[3]*/
#define CSL_INTC_EVENTID_DMAXEVTOUT4     (11)     /**< dMAXEVTOUT[4]*/
#define CSL_INTC_EVENTID_DMAXEVTOUT5     (12)     /**<dMAXEVTOUT[5]*/
#define CSL_INTC_EVENTID_DMAXEVTOUT6     (13)     /**<dMAXEVTOUT[6]*/
#define CSL_INTC_EVENTID_I2C             (14)     /**<I2C0INTR*/
                                                  /**<I2C1INTR*/
#define CSL_INTC_EVENTID_SPI             (14)     /**< SPI0INT1*/
                                                  /**< SPI1INT0*/
                                                  /**< SPI0INT0*/
                                                  /**<SPI1INT1 */
#define CSL_INTC_EVENTID_DMAXEVTOUT7     (15)     /**<dMAXEVTOUT[7]*/
/*****************************************************************************\
* ADD Channel Instance count
\*****************************************************************************/

/*****************************************************************************\
* Peripheral Overlay Structures
\*****************************************************************************/
typedef volatile CSL_McaspRegs	         *CSL_McaspRegsOvly;
typedef volatile CSL_PllcRegs       	 *CSL_PllcRegsOvly;
typedef volatile CSL_ChipRegs            *CSL_ChipRegsOvly;
typedef volatile CSL_EmifRegs            *CSL_EmifRegsOvly;
typedef volatile CSL_RtiRegs             *CSL_RtiRegsOvly;
typedef volatile CSL_I2cRegs             *CSL_I2cRegsOvly;
typedef volatile CSL_SpiRegs             *CSL_SpiRegsOvly;
typedef volatile CSL_HpiRegs			 *CSL_UhpiRegsOvly;
typedef volatile CSL_IcacheRegs          *CSL_IcacheRegsOvly;
typedef volatile CSL_DmaxRegs			 *CSL_DmaxRegsOvly;

/*****************************************************************************\
* Peripheral Base Address
\*****************************************************************************/
#define CSL_MCASP_0_REGS                 ((CSL_McaspRegsOvly) 	0x44000000)
#define CSL_MCASP_1_REGS                 ((CSL_McaspRegsOvly) 	0x45000000)
#define CSL_MCASP_2_REGS                 ((CSL_McaspRegsOvly) 	0x46000000)
#define CSL_PLLC_0_REGS               	 ((CSL_PllcRegsOvly) 	0x41000000)
#define CSL_EMIF_0_REGS                  ((CSL_EmifRegsOvly) 	0xF0000000)
#define CSL_CHIP_0_REGS                  ((CSL_ChipRegsOvly) 	0x20000000)
#define CSL_RTI_0_REGS  				 ((CSL_RtiRegsOvly) 	0x42000000)
#define CSL_EMIF_SDRAM_SPACE			 						0x80000000
#define CSL_I2C_0_REGS  				 ((CSL_I2cRegsOvly) 	0x49000000)
#define CSL_I2C_1_REGS  				 ((CSL_I2cRegsOvly) 	0x4A000000)
#define CSL_SPI_0_REGS  				 ((CSL_SpiRegsOvly) 	0x47000000)
#define CSL_SPI_1_REGS  				 ((CSL_SpiRegsOvly) 	0x48000000)
#define CSL_UHPI_0_REGS					 ((CSL_UhpiRegsOvly)  	0x43000000)
#define CSL_ICACHE_0_REGS                ((CSL_IcacheRegsOvly) 	0x20000000)
#define CSL_DMAX_0_REGS					 ((CSL_DmaxRegsOvly)	0x60000000)

/*****************************************************************************\
* Peripheral Instance enumeration
\*****************************************************************************/
/** @brief Peripheral Instance for PLLC  */
#define CSL_PLLC                             (0) /** Instance 1 of ARMPLLC*/

/** @brief Peripheral Instance for RTI  */
#define CSL_RTI			                     (0) /** Instance 1 of RTI*/

/** @brief Peripheral Instance for EMIF     */
#define CSL_EMIF                                (0) /** Instance 1 of EMIF   */

/** @brief Peripheral Instance for Tmr0     */
#define CSL_TMR_1                               (0) /** Instance 1 of Tmr    */

/** @brief Peripheral Instance for Tmr1     */
#define CSL_TMR_2                               (1) /** Instance 2 of Tmr    */

/** @brief Peripheral Instance for Tmr2     */
#define CSL_TMR_3                               (2) /** Instance 3 of Tmr    */

/** @brief Peripheral Instance for WDT      */
#define CSL_WDT                                 (0) /** Instance of WDT      */

/** @brief Peripheral Instance for I2c0      */
#define CSL_I2C_0                                 (0) /** Instance of I2c0      */

/** @brief Peripheral Instance for I2c1      */
#define CSL_I2C_1                                 (1) /** Instance of I2c1      */

/** @brief Peripheral Instance for Spi0      */
#define CSL_SPI_0                                 (0) /** Instance of Spi0      */

/** @brief Peripheral Instance for Spi1      */
#define CSL_SPI_1                                 (1) /** Instance of Spi1      */

/** @brief Peripheral Instances for MCASP */
#define CSL_MCASP_CNT                           (3) /** Instance 1 of MCASP */

/** @brief Peripheral Instance for MCASP */
#define CSL_MCASP_0                             (0) /** Instance 1 of MCASP */

/** @brief Peripheral Instance for MCASP */
#define CSL_MCASP_1                             (1) /** Instance 2 of MCASP */

#ifndef C6722
/** @brief Peripheral Instance for MCASP */
#define CSL_MCASP_2                             (2) /** Instance 3 of MCASP */
#endif 

/** @brief Peripheral Instances for UHPI */
#define CSL_UHPI                            	(0) /** Instance 1 of UHPI */

/** @brief Peripheral Instance for L1P Cache      */
#define CSL_ICACHE                               (0) /** Instance of L1P Cache  */

/** @brief Peripheral Instance for DMAX  */
#define CSL_DMAX                                (0) /** Instance of DMAX  */

#endif

