/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found
 *   in the license agreement under which this software has been supplied.
 *  ============================================================================
 */

/*
 *  @file  _csl_intc.h
 *  
 *  Description
 *     This file comprises of declarations of private functions
 *
 *  Modification
 *  - Modified on: 14/12/2004
 *  - Reason: creation
 *
 *  @author RMathew
 *
 */
 
#ifndef __CSL_INTC_H_
#define __CSL_INTC_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <csl.h>
#include <cslr.h>
#include <cslr_intc.h>
#include <csl_intc.h>
#include <soc.h>


/*  runtime library intrinsic _lmbd() function  */
extern far Uint32 _lmbd(Uint32 src1, Uint32 src2);

/* Global pointer to the event mask indicate array */
extern CSL_BitMask16                    *_CSL_IntcEventAllocMask;

/* Global pointer to the event handler details holding array */
extern CSL_IntcEventHandlerRecord       *_CSL_intcEventHandlerRecord;

/* Global pointer to the intc context memory */
extern CSL_BitMask16                    _CSL_IntcContextFlags;

/* datatype for holding the mask value of interrupts */
typedef Uint32                          _CSL_IntcVecId;

/* gets the event handling isr */
extern interrupt void  _csl_getEventHandler(void);

/* enables the non maskable interrupt */
extern void _setNMI(void);

extern void _CSL_intcIsr0(void) ;
extern void _CSL_intcIsr1(void) ;

/* Table which holds the masks for the interrupts */
extern _CSL_IntcVecId _CSL_IntcEventTable[CSL_INTC_EVENT_CNT];



#define _CSL_INTC_EVTHANDLER_UNPLUGGED  ((CSL_IntcEventHandler) 0)

#define _CSL_INTC_EVENTMASKED     1
#define _CSL_INTC_EVENTUNMASKED   0

/* Interrupt mask */
#define CSL_INTC_INT0       0x00000001
#define CSL_INTC_INT1       0x00000002
#define CSL_INTC_INT2       0x00000004
#define CSL_INTC_INT3       0x00000008
#define CSL_INTC_INT4       0x00000010
#define CSL_INTC_INT5       0x00000020
#define CSL_INTC_INT6       0x00000040
#define CSL_INTC_INT7       0x00000080
#define CSL_INTC_INT8       0x00000100
#define CSL_INTC_INT9       0x00000200
#define CSL_INTC_INT10      0x00000400
#define CSL_INTC_INT11      0x00000800
#define CSL_INTC_INT12      0x00001000
#define CSL_INTC_INT13      0x00002000
#define CSL_INTC_INT14      0x00004000
#define CSL_INTC_INT15      0x00008000
 

         
#ifdef __cplusplus
 }
#endif

#endif /* __CSL_INTC_H_ */

