/*   ==========================================================================
 *   Copyright (c) Texas Instruments Inc , 2005
 *
 *   Use of this software is controlled by the terms and conditions found
 *   in the license agreement under which this software has been supplied
 *   provided
 *   ==========================================================================
*/

/* ---- File: <csl_error.h> ---- */
/* Error file for Hibari: ARM side */
#ifndef _CSL_ERROR_H_
#define _CSL_ERROR_H_

#include <csl_resId.h>

/* Below Error codes are Global across all CSL Modules. */
#define CSL_SOK                 (1)         /* Success */
#define CSL_ESYS_FAIL           (-1)        /* Generic failure */
#define CSL_ESYS_INUSE          (-2)        /* Peripheral resource is already in use */
#define CSL_ESYS_XIO            (-3)        /* Encountered a shared I/O(XIO) pin conflict */
#define CSL_ESYS_OVFL           (-4)        /* Encoutered CSL system resource overflow */
#define CSL_ESYS_BADHANDLE      (-5)        /* Handle passed to CSL was invalid */
#define CSL_ESYS_INVPARAMS      (-6)        /* invalid parameters */
#define CSL_ESYS_INVCMD         (-7)        /* invalid command */
#define CSL_ESYS_INVQUERY       (-8)        /* invalid query */
#define CSL_ESYS_NOTSUPPORTED   (-9)        /* action not supported */
#define CSL_ESYS_ALREADY_INITIALIZED	(-10)	/* Module already initialized */ 

/* Error codes individual to various modules. */

/* Error code for DMA, individual error would be assigned as
 * eg: #define CSL_E<Peripheral name>_<error code>  CSL_EDMA_FIRST - 1
 */


#define CSL_ELCDC_FIRST     -( ((CSL_LCDC_ID + 1) << 5 ) + 1 )
#define CSL_ELCDC_LAST      -( (CSL_LCDC_ID + 1) << 6 )

#define CSL_EPWM_FIRST      -( ((CSL_PWM_ID + 1) << 5 ) + 1 )
#define CSL_EPWM_LAST       -( (CSL_PWM_ID + 1) << 6 )

#define CSL_EUART_FIRST     -( ((CSL_UART_ID + 1) << 5 ) + 1 )
#define CSL_EUART_LAST      -( (CSL_UART_ID + 1) << 6 )

#define CSL_ESPI_FIRST      -( ((CSL_SPI_ID + 1) << 5 ) + 1 )
#define CSL_ESPI_LAST       -( (CSL_SPI_ID + 1) << 6 )

#define CSL_EATA_FIRST      -( ((CSL_ATA_ID + 1) << 5 ) + 1 )
#define CSL_EATA_LAST       -( (CSL_ATA_ID + 1) << 6 )

#define CSL_EMMCSD_FIRST    -( ((CSL_MMCSD_ID + 1) << 5 ) + 1 )
#define CSL_EMMCSD_LAST     -( (CSL_MMCSD_ID + 1) << 6 )

#define CSL_EDMA_FIRST      -( ((CSL_DMA_ID + 1) << 5 ) + 1 )
#define CSL_EDMA_LAST       -( (CSL_DMA_ID + 1) << 6 )

#define CSL_EI2C_FIRST      -( ((CSL_I2C_ID + 1) << 5 ) + 1 )
#define CSL_EI2C_LAST       -( (CSL_I2C_ID + 1) << 6 )

#define CSL_EINTC_FIRST     -( ((CSL_INTC_ID + 1) << 5 ) + 1 )
#define CSL_EINTC_LAST      -( (CSL_INTC_ID + 1) << 6 )

#define CSL_EGPIO_FIRST     -( ((CSL_GPIO_ID + 1) << 5 ) + 1 )
#define CSL_EGPIO_LAST      -( (CSL_GPIO_ID + 1) << 6 )

#define CSL_EMS_FIRST       -( ((CSL_MS_ID + 1) << 5 ) + 1 )
#define CSL_EMS_LAST        -( (CSL_MS_ID + 1) << 6 )

#define CSL_EEMIF_FIRST     -( ((CSL_EMIF_ID + 1) << 5 ) + 1 )
#define CSL_EEMIF_LAST      -( (CSL_EMIF_ID + 1) << 6 )

#define CSL_ENTSC_FIRST     -( ((CSL_NTSC_ID + 1) << 5 ) + 1 )
#define CSL_ENTSC_LAST      -( (CSL_NTSC_ID + 1) << 6 )

#define CSL_ENAND_FIRST     -( ((CSL_NAND_ID + 1) << 5 ) + 1 )
#define CSL_ENAND_LAST      -( (CSL_NAND_ID + 1) << 6 )

#endif /* _CSL_ERROR_H_ */

