#ifndef _CSL_VERSION_H_
#define _CSL_VERSION_H_

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************\
 *  Copyright 2003, Texas Instruments Incorporated.  *
 *  All rights reserved.                             *
 *  Restricted rights to use, duplicate or disclose  *
 *  this   code   are  granted   through  contract.  *
\*****************************************************/

#include <tistdtypes.h>

#define CSL_VERSION_ID          (0x03000804)    /* 0xAABBCCDD -> Arch (AA); API Changes (BB); Major (CC); Minor (DD) */
#define CSL_VERSION_STR         "@(#) CSL Revision: 3.00.08.04;"

#ifdef C6722
#define CSL_CHIP_ID             (0xC6722)
#define CSL_CHIP_STR            "TMS320C6722 PG 1.0 (C67)"
#endif

#ifdef C6726
#define CSL_CHIP_ID             (0xC6726)
#define CSL_CHIP_STR            "TMS320C6722 PG 1.0 (C67)"
#endif

#ifdef C6727
#define CSL_CHIP_ID             (0xC6727)
#define CSL_CHIP_STR            "TMS320C6726 PG 1.0 (C67)"
#endif

#ifdef DA705
#define CSL_CHIP_ID             (0xDA705)
#define CSL_CHIP_STR            "TMS320DA705 PG 1.0 (C67)"
#endif

#ifdef DA707
#define CSL_CHIP_ID             (0xDA707)
#define CSL_CHIP_STR            "TMS320DA707 PG 1.0 (C67)"
#endif

#ifdef DA708
#define CSL_CHIP_ID             (0xDA708)
#define CSL_CHIP_STR            "TMS320DA708 PG 1.0 (C67)"
#endif

#ifdef DA710
#define CSL_CHIP_ID             (0xDA710)
#define CSL_CHIP_STR            "TMS320DA710 PG 1.0 (C67)"
#endif

/**
  @brief    Retrieves the version ID
*/
Uint32
    CSL_versionGetID (
        void
);


/**
  @brief    Retrieves the version string
*/
const char *
    CSL_versionGetStr (
        void
);


#ifdef __cplusplus
}
#endif

#endif /* _CSL_VERSION_H_ */

