/*********************************************************************
 * Copyright (C) 2003-2005 Texas Instruments Incorporated. 
 * All Rights Reserved 
 *********************************************************************/
/** @file  cslr_chip.h 
 * 
 * \brief This file contains the Register Desciptions for CHIP
 * 
 *********************************************************************/
#ifndef _CSLR_CHIP_H_
#define _CSLR_CHIP_H_

#include <cslr.h>  
#include <csl_types.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
/**
 * Register Overlay structure for memory mapped chip registers
 */

typedef struct  {
    /** CFGPIN0 */
    volatile Uint32 CFGPIN0;
    /** CFGPIN1 */
    volatile Uint32 CFGPIN1;
    /** CFGHPI */
    volatile Uint32 CFGHPI;
    /** CFGHPIAMSB */
    volatile Uint32 CFGHPIAMSB;
    /** CFGHPIAUMB */
    volatile Uint32 CFGHPIAUMB;
	/** CFGRTI */
    volatile Uint32 CFGRTI;
    /** CGFMCASP0 */
    volatile Uint32 CFGMCASP0;
    /** CGFMCASP1 */
    volatile Uint32 CFGMCASP1;
    /** CGFMCASP2 */
    volatile Uint32 CFGMCASP2;
    /** CGFBRIDGE */
    volatile Uint32 CFGBRIDGE;
    volatile Uint8 RSVD0[88];
    /** IDREG */
    volatile Uint32 IDREG;
} CSL_ChipRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* CFGPIN0 */

#define CSL_CHIP_CFGPIN0_PINCAP7_MASK    (0x00000080u)
#define CSL_CHIP_CFGPIN0_PINCAP7_SHIFT   (0x00000007u)
#define CSL_CHIP_CFGPIN0_PINCAP7_RESETVAL (0x00000000u)

/*----PINCAP7 Tokens----*/
#define CSL_CHIP_CFGPIN0_PINCAP7_HIGH    (0x00000001u)
#define CSL_CHIP_CFGPIN0_PINCAP7_LOW     (0x00000000u)

#define CSL_CHIP_CFGPIN0_PINCAP6_MASK    (0x00000040u)
#define CSL_CHIP_CFGPIN0_PINCAP6_SHIFT   (0x00000006u)
#define CSL_CHIP_CFGPIN0_PINCAP6_RESETVAL (0x00000000u)

/*----PINCAP6 Tokens----*/
#define CSL_CHIP_CFGPIN0_PINCAP6_HIGH    (0x00000001u)
#define CSL_CHIP_CFGPIN0_PINCAP6_LOW     (0x00000000u)

#define CSL_CHIP_CFGPIN0_PINCAP5_MASK    (0x00000020u)
#define CSL_CHIP_CFGPIN0_PINCAP5_SHIFT   (0x00000005u)
#define CSL_CHIP_CFGPIN0_PINCAP5_RESETVAL (0x00000000u)

/*----PINCAP5 Tokens----*/
#define CSL_CHIP_CFGPIN0_PINCAP5_HIGH    (0x00000001u)
#define CSL_CHIP_CFGPIN0_PINCAP5_LOW     (0x00000000u)

#define CSL_CHIP_CFGPIN0_PINCAP4_MASK    (0x00000010u)
#define CSL_CHIP_CFGPIN0_PINCAP4_SHIFT   (0x00000004u)
#define CSL_CHIP_CFGPIN0_PINCAP4_RESETVAL (0x00000000u)

/*----PINCAP4 Tokens----*/
#define CSL_CHIP_CFGPIN0_PINCAP4_HIGH    (0x00000001u)
#define CSL_CHIP_CFGPIN0_PINCAP4_LOW     (0x00000000u)

#define CSL_CHIP_CFGPIN0_PINCAP3_MASK    (0x00000008u)
#define CSL_CHIP_CFGPIN0_PINCAP3_SHIFT   (0x00000003u)
#define CSL_CHIP_CFGPIN0_PINCAP3_RESETVAL (0x00000000u)

/*----PINCAP3 Tokens----*/
#define CSL_CHIP_CFGPIN0_PINCAP3_HIGH    (0x00000001u)
#define CSL_CHIP_CFGPIN0_PINCAP3_LOW     (0x00000000u)

#define CSL_CHIP_CFGPIN0_PINCAP2_MASK    (0x00000004u)
#define CSL_CHIP_CFGPIN0_PINCAP2_SHIFT   (0x00000002u)
#define CSL_CHIP_CFGPIN0_PINCAP2_RESETVAL (0x00000000u)

/*----PINCAP2 Tokens----*/
#define CSL_CHIP_CFGPIN0_PINCAP2_HIGH    (0x00000001u)
#define CSL_CHIP_CFGPIN0_PINCAP2_LOW     (0x00000000u)

#define CSL_CHIP_CFGPIN0_PINCAP1_MASK    (0x00000002u)
#define CSL_CHIP_CFGPIN0_PINCAP1_SHIFT   (0x00000001u)
#define CSL_CHIP_CFGPIN0_PINCAP1_RESETVAL (0x00000000u)

/*----PINCAP1 Tokens----*/
#define CSL_CHIP_CFGPIN0_PINCAP1_HIGH    (0x00000001u)
#define CSL_CHIP_CFGPIN0_PINCAP1_LOW     (0x00000000u)

#define CSL_CHIP_CFGPIN0_PINCAP0_MASK    (0x00000001u)
#define CSL_CHIP_CFGPIN0_PINCAP0_SHIFT   (0x00000000u)
#define CSL_CHIP_CFGPIN0_PINCAP0_RESETVAL (0x00000000u)

/*----PINCAP0 Tokens----*/
#define CSL_CHIP_CFGPIN0_PINCAP0_HIGH    (0x00000001u)
#define CSL_CHIP_CFGPIN0_PINCAP0_LOW     (0x00000000u)

#define CSL_CHIP_CFGPIN0_RESETVAL        (0x00000000u)

/* CFGPIN1 */

#define CSL_CHIP_CFGPIN1_PINCAP15_MASK   (0x00000080u)
#define CSL_CHIP_CFGPIN1_PINCAP15_SHIFT  (0x00000007u)
#define CSL_CHIP_CFGPIN1_PINCAP15_RESETVAL (0x00000000u)

/*----PINCAP15 Tokens----*/
#define CSL_CHIP_CFGPIN1_PINCAP15_HIGH   (0x00000001u)
#define CSL_CHIP_CFGPIN1_PINCAP15_LOW    (0x00000000u)

#define CSL_CHIP_CFGPIN1_PINCAP14_MASK   (0x00000040u)
#define CSL_CHIP_CFGPIN1_PINCAP14_SHIFT  (0x00000006u)
#define CSL_CHIP_CFGPIN1_PINCAP14_RESETVAL (0x00000000u)

/*----PINCAP14 Tokens----*/
#define CSL_CHIP_CFGPIN1_PINCAP14_HIGH   (0x00000001u)
#define CSL_CHIP_CFGPIN1_PINCAP14_LOW    (0x00000000u)

#define CSL_CHIP_CFGPIN1_PINCAP13_MASK   (0x00000020u)
#define CSL_CHIP_CFGPIN1_PINCAP13_SHIFT  (0x00000005u)
#define CSL_CHIP_CFGPIN1_PINCAP13_RESETVAL (0x00000000u)

/*----PINCAP13 Tokens----*/
#define CSL_CHIP_CFGPIN1_PINCAP13_HIGH   (0x00000001u)
#define CSL_CHIP_CFGPIN1_PINCAP13_LOW    (0x00000000u)

#define CSL_CHIP_CFGPIN1_PINCAP12_MASK   (0x00000010u)
#define CSL_CHIP_CFGPIN1_PINCAP12_SHIFT  (0x00000004u)
#define CSL_CHIP_CFGPIN1_PINCAP12_RESETVAL (0x00000000u)

/*----PINCAP12 Tokens----*/
#define CSL_CHIP_CFGPIN1_PINCAP12_HIGH   (0x00000001u)
#define CSL_CHIP_CFGPIN1_PINCAP12_LOW    (0x00000000u)

#define CSL_CHIP_CFGPIN1_PINCAP11_MASK   (0x00000008u)
#define CSL_CHIP_CFGPIN1_PINCAP11_SHIFT  (0x00000003u)
#define CSL_CHIP_CFGPIN1_PINCAP11_RESETVAL (0x00000000u)

/*----PINCAP11 Tokens----*/
#define CSL_CHIP_CFGPIN1_PINCAP11_HIGH   (0x00000001u)
#define CSL_CHIP_CFGPIN1_PINCAP11_LOW    (0x00000000u)

#define CSL_CHIP_CFGPIN1_PINCAP10_MASK   (0x00000004u)
#define CSL_CHIP_CFGPIN1_PINCAP10_SHIFT  (0x00000002u)
#define CSL_CHIP_CFGPIN1_PINCAP10_RESETVAL (0x00000000u)

/*----PINCAP10 Tokens----*/
#define CSL_CHIP_CFGPIN1_PINCAP10_HIGH   (0x00000001u)
#define CSL_CHIP_CFGPIN1_PINCAP10_LOW    (0x00000000u)

#define CSL_CHIP_CFGPIN1_PINCAP9_MASK    (0x00000002u)
#define CSL_CHIP_CFGPIN1_PINCAP9_SHIFT   (0x00000001u)
#define CSL_CHIP_CFGPIN1_PINCAP9_RESETVAL (0x00000000u)

/*----PINCAP9 Tokens----*/
#define CSL_CHIP_CFGPIN1_PINCAP9_HIGH    (0x00000001u)
#define CSL_CHIP_CFGPIN1_PINCAP9_LOW     (0x00000000u)

#define CSL_CHIP_CFGPIN1_PINCAP8_MASK    (0x00000001u)
#define CSL_CHIP_CFGPIN1_PINCAP8_SHIFT   (0x00000000u)
#define CSL_CHIP_CFGPIN1_PINCAP8_RESETVAL (0x00000000u)

/*----PINCAP8 Tokens----*/
#define CSL_CHIP_CFGPIN1_PINCAP8_HIGH    (0x00000001u)
#define CSL_CHIP_CFGPIN1_PINCAP8_LOW     (0x00000000u)

#define CSL_CHIP_CFGPIN1_RESETVAL        (0x00000000u)

/* CFGHPI */

#define CSL_CHIP_CFGHPI_BYTEAD_MASK      (0x00000010u)
#define CSL_CHIP_CFGHPI_BYTEAD_SHIFT     (0x00000004u)
#define CSL_CHIP_CFGHPI_BYTEAD_RESETVAL  (0x00000000u)

/*----BYTEAD Tokens----*/
#define CSL_CHIP_CFGHPI_BYTEAD_WADDR     (0x00000000u)
#define CSL_CHIP_CFGHPI_BYTEAD_BADDR     (0x00000001u)

#define CSL_CHIP_CFGHPI_FULL_MASK        (0x00000008u)
#define CSL_CHIP_CFGHPI_FULL_SHIFT       (0x00000003u)
#define CSL_CHIP_CFGHPI_FULL_RESETVAL    (0x00000000u)

/*----FULL Tokens----*/
#define CSL_CHIP_CFGHPI_FULL_HALF        (0x00000000u)
#define CSL_CHIP_CFGHPI_FULL_FULL        (0x00000001u)

#define CSL_CHIP_CFGHPI_NMUX_MASK        (0x00000004u)
#define CSL_CHIP_CFGHPI_NMUX_SHIFT       (0x00000002u)
#define CSL_CHIP_CFGHPI_NMUX_RESETVAL    (0x00000000u)

/*----NMUX Tokens----*/
#define CSL_CHIP_CFGHPI_NMUX_DISABLE     (0x00000000u)
#define CSL_CHIP_CFGHPI_NMUX_ENABLE      (0x00000001u)

#define CSL_CHIP_CFGHPI_PAGEM_MASK       (0x00000002u)
#define CSL_CHIP_CFGHPI_PAGEM_SHIFT      (0x00000001u)
#define CSL_CHIP_CFGHPI_PAGEM_RESETVAL   (0x00000000u)

/*----PAGEM Tokens----*/
#define CSL_CHIP_CFGHPI_PAGEM_VBUS_NOT_OVRRIDE (0x00000000u)
#define CSL_CHIP_CFGHPI_PAGEM_VBUS_OVRRIDE (0x00000001u)

#define CSL_CHIP_CFGHPI_ENA_MASK         (0x00000001u)
#define CSL_CHIP_CFGHPI_ENA_SHIFT        (0x00000000u)
#define CSL_CHIP_CFGHPI_ENA_RESETVAL     (0x00000000u)

/*----ENA Tokens----*/
#define CSL_CHIP_CFGHPI_ENA_HPIENA_CLR   (0x00000000u)
#define CSL_CHIP_CFGHPI_ENA_HPIENA_SET   (0x00000001u)

#define CSL_CHIP_CFGHPI_RESETVAL         (0x00000000u)

/* CFGHPIAMSB */

#define CSL_CHIP_CFGHPIAMSB_HPIAMSB_MASK (0x000000FFu)
#define CSL_CHIP_CFGHPIAMSB_HPIAMSB_SHIFT (0x00000000u)
#define CSL_CHIP_CFGHPIAMSB_HPIAMSB_RESETVAL (0x00000000u)

#define CSL_CHIP_CFGHPIAMSB_RESETVAL     (0x00000000u)

/* CFGHPIAUMB */

#define CSL_CHIP_CFGHPIAUMB_HPIAUMB_MASK (0x000000FFu)
#define CSL_CHIP_CFGHPIAUMB_HPIAUMB_SHIFT (0x00000000u)
#define CSL_CHIP_CFGHPIAUMB_HPIAUMB_RESETVAL (0x00000000u)

#define CSL_CHIP_CFGHPIAUMB_RESETVAL     (0x00000000u)

/* CFGRTI */

#define CSL_CHIP_CFGRTI_CAPSEL1_MASK     (0x00000070u)
#define CSL_CHIP_CFGRTI_CAPSEL1_SHIFT    (0x00000004u)
#define CSL_CHIP_CFGRTI_CAPSEL1_RESETVAL (0x00000000u)

/*----CAPSEL1 Tokens----*/
#define CSL_CHIP_CFGRTI_CAPSEL1_MCASP0_TX_DMA_RQ (0x00000000u)
#define CSL_CHIP_CFGRTI_CAPSEL1_MCASP0_RX_DMA_RQ (0x00000001u)
#define CSL_CHIP_CFGRTI_CAPSEL1_MCASP1_TX_DMA_RQ (0x00000002u)
#define CSL_CHIP_CFGRTI_CAPSEL1_MCASP1_RX_DMA_RQ (0x00000003u)
#define CSL_CHIP_CFGRTI_CAPSEL1_MCASP2_TX_DMA_RQ (0x00000004u)
#define CSL_CHIP_CFGRTI_CAPSEL1_MCASP2_RX_DMA_RQ (0x00000005u)

#define CSL_CHIP_CFGRTI_CAPSEL0_MASK     (0x00000007u)
#define CSL_CHIP_CFGRTI_CAPSEL0_SHIFT    (0x00000000u)
#define CSL_CHIP_CFGRTI_CAPSEL0_RESETVAL (0x00000000u)

/*----CAPSEL0 Tokens----*/
#define CSL_CHIP_CFGRTI_CAPSEL0_MCASP0_TX_DMA_RQ (0x00000000u)
#define CSL_CHIP_CFGRTI_CAPSEL0_MCASP0_RX_DMA_RQ (0x00000001u)
#define CSL_CHIP_CFGRTI_CAPSEL0_MCASP1_TX_DMA_RQ (0x00000002u)
#define CSL_CHIP_CFGRTI_CAPSEL0_MCASP1_RX_DMA_RQ (0x00000003u)
#define CSL_CHIP_CFGRTI_CAPSEL0_MCASP2_TX_DMA_RQ (0x00000004u)
#define CSL_CHIP_CFGRTI_CAPSEL0_MCASP2_RX_DMA_RQ (0x00000005u)

#define CSL_CHIP_CFGRTI_RESETVAL         (0x00000000u)

/* CFGMCASP0 */

#define CSL_CHIP_CFGMCASP0_AMUTEIN0_MASK (0x00000007u)
#define CSL_CHIP_CFGMCASP0_AMUTEIN0_SHIFT (0x00000000u)
#define CSL_CHIP_CFGMCASP0_AMUTEIN0_RESETVAL (0x00000000u)

/*----AMUTEIN0 Tokens----*/
#define CSL_CHIP_CFGMCASP0_AMUTEIN0_ZERO (0x00000000u)
#define CSL_CHIP_CFGMCASP0_AMUTEIN0_AXR0_7 (0x00000001u)
#define CSL_CHIP_CFGMCASP0_AMUTEIN0_AXR0_8_AXR1_5 (0x00000002u)
#define CSL_CHIP_CFGMCASP0_AMUTEIN0_AXR0_9_AXR1_4 (0x00000003u)
#define CSL_CHIP_CFGMCASP0_AMUTEIN0_AHCLKR2 (0x00000004u)
#define CSL_CHIP_CFGMCASP0_AMUTEIN0_SPI0SIMO (0x00000005u)
#define CSL_CHIP_CFGMCASP0_AMUTEIN0_SPI0SCS_SCL1 (0x00000006u)
#define CSL_CHIP_CFGMCASP0_AMUTEIN0_SPI0ENA_SDA1 (0x00000007u)

#define CSL_CHIP_CFGMCASP0_RESETVAL      (0x00000000u)

/* CFGMCASP1 */

#define CSL_CHIP_CFGMCASP1_AMUTEIN1_MASK (0x00000007u)
#define CSL_CHIP_CFGMCASP1_AMUTEIN1_SHIFT (0x00000000u)
#define CSL_CHIP_CFGMCASP1_AMUTEIN1_RESETVAL (0x00000000u)

/*----AMUTEIN1 Tokens----*/
#define CSL_CHIP_CFGMCASP1_AMUTEIN1_ZERO (0x00000000u)
#define CSL_CHIP_CFGMCASP1_AMUTEIN1_AXR0_7 (0x00000001u)
#define CSL_CHIP_CFGMCASP1_AMUTEIN1_AXR0_8_AXR1_5 (0x00000002u)
#define CSL_CHIP_CFGMCASP1_AMUTEIN1_AXR0_9_AXR1_4 (0x00000003u)
#define CSL_CHIP_CFGMCASP1_AMUTEIN1_AHCLKR2 (0x00000004u)
#define CSL_CHIP_CFGMCASP1_AMUTEIN1_SPI0SIMO (0x00000005u)
#define CSL_CHIP_CFGMCASP1_AMUTEIN1_SPI0SCS_SCL1 (0x00000006u)
#define CSL_CHIP_CFGMCASP1_AMUTEIN1_SPI0ENA_SDA1 (0x00000007u)

#define CSL_CHIP_CFGMCASP1_RESETVAL      (0x00000000u)

/* CFGMCASP2 */

#define CSL_CHIP_CFGMCASP2_AMUTEIN2_MASK (0x00000007u)
#define CSL_CHIP_CFGMCASP2_AMUTEIN2_SHIFT (0x00000000u)
#define CSL_CHIP_CFGMCASP2_AMUTEIN2_RESETVAL (0x00000000u)

/*----AMUTEIN2 Tokens----*/
#define CSL_CHIP_CFGMCASP2_AMUTEIN2_ZERO (0x00000000u)
#define CSL_CHIP_CFGMCASP2_AMUTEIN2_AXR0_7 (0x00000001u)
#define CSL_CHIP_CFGMCASP2_AMUTEIN2_AXR0_8_AXR1_5 (0x00000002u)
#define CSL_CHIP_CFGMCASP2_AMUTEIN2_AXR0_9_AXR1_4 (0x00000003u)
#define CSL_CHIP_CFGMCASP2_AMUTEIN2_AHCLKR2 (0x00000004u)
#define CSL_CHIP_CFGMCASP2_AMUTEIN2_SPI0SIMO (0x00000005u)
#define CSL_CHIP_CFGMCASP2_AMUTEIN2_SPI0SCS_SCL1 (0x00000006u)
#define CSL_CHIP_CFGMCASP2_AMUTEIN2_SPI0ENA_SDA1 (0x00000007u)

#define CSL_CHIP_CFGMCASP2_RESETVAL      (0x00000000u)

/* CFGBRIDGE */

#define CSL_CHIP_CFGBRIDGE_CSPRST_MASK   (0x00000001u)
#define CSL_CHIP_CFGBRIDGE_CSPRST_SHIFT  (0x00000000u)
#define CSL_CHIP_CFGBRIDGE_CSPRST_RESETVAL (0x00000001u)

/*----CSPRST Tokens----*/
#define CSL_CHIP_CFGBRIDGE_CSPRST_DISABLE (0x00000000u)
#define CSL_CHIP_CFGBRIDGE_CSPRST_ENABLE (0x00000001u)

#define CSL_CHIP_CFGBRIDGE_RESETVAL      (0x00000001u)

/* IDREG */

#define CSL_CHIP_IDREG_REVISION_MASK     (0xF0000000u)
#define CSL_CHIP_IDREG_REVISION_SHIFT    (0x0000001Cu)
#define CSL_CHIP_IDREG_REVISION_RESETVAL (0x00000000u)

#define CSL_CHIP_IDREG_ID_MASK           (0x0FFFFFFFu)
#define CSL_CHIP_IDREG_ID_SHIFT          (0x00000000u)
#define CSL_CHIP_IDREG_ID_RESETVAL       (0x0B6AB02Fu)

#define CSL_CHIP_IDREG_RESETVAL          (0x0B6AB02Fu)

/* AMR */

#define CSL_CHIP_AMR_BK1_MASK            (0x3E00000u)
#define CSL_CHIP_AMR_BK1_SHIFT           (0x15u)
#define CSL_CHIP_AMR_BK1_RESETVAL        (0x0u)

/*----BK1 Tokens----*/
#define CSL_CHIP_AMR_BK1_2               (0x0u)
#define CSL_CHIP_AMR_BK1_4               (0x1u)
#define CSL_CHIP_AMR_BK1_8               (0x2u)
#define CSL_CHIP_AMR_BK1_16              (0x3u)
#define CSL_CHIP_AMR_BK1_32              (0x4u)
#define CSL_CHIP_AMR_BK1_64              (0x5u)
#define CSL_CHIP_AMR_BK1_128             (0x6u)
#define CSL_CHIP_AMR_BK1_256             (0x7u)
#define CSL_CHIP_AMR_BK1_512             (0x8u)
#define CSL_CHIP_AMR_BK1_1K              (0x9u)
#define CSL_CHIP_AMR_BK1_2K              (0xAu)
#define CSL_CHIP_AMR_BK1_4K              (0xBu)
#define CSL_CHIP_AMR_BK1_8K              (0xCu)
#define CSL_CHIP_AMR_BK1_16K             (0xDu)
#define CSL_CHIP_AMR_BK1_32K             (0xEu)
#define CSL_CHIP_AMR_BK1_64K             (0xFu)
#define CSL_CHIP_AMR_BK1_128K            (0x10u)
#define CSL_CHIP_AMR_BK1_256K            (0x11u)
#define CSL_CHIP_AMR_BK1_512K            (0x12u)
#define CSL_CHIP_AMR_BK1_1M              (0x13u)
#define CSL_CHIP_AMR_BK1_2M              (0x14u)
#define CSL_CHIP_AMR_BK1_4M              (0x15u)
#define CSL_CHIP_AMR_BK1_8M              (0x16u)
#define CSL_CHIP_AMR_BK1_16M             (0x17u)
#define CSL_CHIP_AMR_BK1_32M             (0x18u)
#define CSL_CHIP_AMR_BK1_64M             (0x19u)
#define CSL_CHIP_AMR_BK1_128M            (0x1Au)
#define CSL_CHIP_AMR_BK1_256M            (0x1Bu)
#define CSL_CHIP_AMR_BK1_512M            (0x1Cu)
#define CSL_CHIP_AMR_BK1_1G              (0x1Du)
#define CSL_CHIP_AMR_BK1_2G              (0x1Eu)
#define CSL_CHIP_AMR_BK1_4G              (0x1Fu)

#define CSL_CHIP_AMR_BK0_MASK            (0x1F0000u)
#define CSL_CHIP_AMR_BK0_SHIFT           (0x10u)
#define CSL_CHIP_AMR_BK0_RESETVAL        (0x0u)

/*----BK0 Tokens----*/
#define CSL_CHIP_AMR_BK0_2               (0x0u)
#define CSL_CHIP_AMR_BK0_4               (0x1u)
#define CSL_CHIP_AMR_BK0_8               (0x2u)
#define CSL_CHIP_AMR_BK0_16              (0x3u)
#define CSL_CHIP_AMR_BK0_32              (0x4u)
#define CSL_CHIP_AMR_BK0_64              (0x5u)
#define CSL_CHIP_AMR_BK0_128             (0x6u)
#define CSL_CHIP_AMR_BK0_256             (0x7u)
#define CSL_CHIP_AMR_BK0_512             (0x8u)
#define CSL_CHIP_AMR_BK0_1K              (0x9u)
#define CSL_CHIP_AMR_BK0_2K              (0xAu)
#define CSL_CHIP_AMR_BK0_4K              (0xBu)
#define CSL_CHIP_AMR_BK0_8K              (0xCu)
#define CSL_CHIP_AMR_BK0_16K             (0xDu)
#define CSL_CHIP_AMR_BK0_32K             (0xEu)
#define CSL_CHIP_AMR_BK0_64K             (0xFu)
#define CSL_CHIP_AMR_BK0_128K            (0x10u)
#define CSL_CHIP_AMR_BK0_256K            (0x11u)
#define CSL_CHIP_AMR_BK0_512K            (0x12u)
#define CSL_CHIP_AMR_BK0_1M              (0x13u)
#define CSL_CHIP_AMR_BK0_2M              (0x14u)
#define CSL_CHIP_AMR_BK0_4M              (0x15u)
#define CSL_CHIP_AMR_BK0_8M              (0x16u)
#define CSL_CHIP_AMR_BK0_16M             (0x17u)
#define CSL_CHIP_AMR_BK0_32M             (0x18u)
#define CSL_CHIP_AMR_BK0_64M             (0x19u)
#define CSL_CHIP_AMR_BK0_128M            (0x1Au)
#define CSL_CHIP_AMR_BK0_256M            (0x1Bu)
#define CSL_CHIP_AMR_BK0_512M            (0x1Cu)
#define CSL_CHIP_AMR_BK0_1G              (0x1Du)
#define CSL_CHIP_AMR_BK0_2G              (0x1Eu)
#define CSL_CHIP_AMR_BK0_4G              (0x1Fu)

#define CSL_CHIP_AMR_B7MODE_MASK         (0xC000u)
#define CSL_CHIP_AMR_B7MODE_SHIFT        (0xEu)
#define CSL_CHIP_AMR_B7MODE_RESETVAL     (0x0u)

/*----B7MODE Tokens----*/
#define CSL_CHIP_AMR_B7MODE_LINEAR       (0x0u)
#define CSL_CHIP_AMR_B7MODE_CIRCULAR0    (0x1u)
#define CSL_CHIP_AMR_B7MODE_CIRCULAR1    (0x2u)

#define CSL_CHIP_AMR_B6MODE_MASK         (0x3000u)
#define CSL_CHIP_AMR_B6MODE_SHIFT        (0xCu)
#define CSL_CHIP_AMR_B6MODE_RESETVAL     (0x0u)

/*----B6MODE Tokens----*/
#define CSL_CHIP_AMR_B6MODE_LINEAR       (0x0u)
#define CSL_CHIP_AMR_B6MODE_CIRCULAR0    (0x1u)
#define CSL_CHIP_AMR_B6MODE_CIRCULAR1    (0x2u)

#define CSL_CHIP_AMR_B5MODE_MASK         (0xC00u)
#define CSL_CHIP_AMR_B5MODE_SHIFT        (0xAu)
#define CSL_CHIP_AMR_B5MODE_RESETVAL     (0x0u)

/*----B5MODE Tokens----*/
#define CSL_CHIP_AMR_B5MODE_LINEAR       (0x0u)
#define CSL_CHIP_AMR_B5MODE_CIRCULAR0    (0x1u)
#define CSL_CHIP_AMR_B5MODE_CIRCULAR1    (0x2u)

#define CSL_CHIP_AMR_B4MODE_MASK         (0x300u)
#define CSL_CHIP_AMR_B4MODE_SHIFT        (0x8u)
#define CSL_CHIP_AMR_B4MODE_RESETVAL     (0x0u)

/*----B4MODE Tokens----*/
#define CSL_CHIP_AMR_B4MODE_LINEAR       (0x0u)
#define CSL_CHIP_AMR_B4MODE_CIRCULAR0    (0x1u)
#define CSL_CHIP_AMR_B4MODE_CIRCULAR1    (0x2u)

#define CSL_CHIP_AMR_A7MODE_MASK         (0xC0u)
#define CSL_CHIP_AMR_A7MODE_SHIFT        (0x6u)
#define CSL_CHIP_AMR_A7MODE_RESETVAL     (0x0u)

/*----A7MODE Tokens----*/
#define CSL_CHIP_AMR_A7MODE_LINEAR       (0x0u)
#define CSL_CHIP_AMR_A7MODE_CIRCULAR0    (0x1u)
#define CSL_CHIP_AMR_A7MODE_CIRCULAR1    (0x2u)

#define CSL_CHIP_AMR_A6MODE_MASK         (0x30u)
#define CSL_CHIP_AMR_A6MODE_SHIFT        (0x4u)
#define CSL_CHIP_AMR_A6MODE_RESETVAL     (0x0u)

/*----A6MODE Tokens----*/
#define CSL_CHIP_AMR_A6MODE_LINEAR       (0x0u)
#define CSL_CHIP_AMR_A6MODE_CIRCULAR0    (0x1u)
#define CSL_CHIP_AMR_A6MODE_CIRCULAR1    (0x2u)

#define CSL_CHIP_AMR_A5MODE_MASK         (0xCu)
#define CSL_CHIP_AMR_A5MODE_SHIFT        (0x2u)
#define CSL_CHIP_AMR_A5MODE_RESETVAL     (0x0u)

/*----A5MODE Tokens----*/
#define CSL_CHIP_AMR_A5MODE_LINEAR       (0x0u)
#define CSL_CHIP_AMR_A5MODE_CIRCULAR0    (0x1u)
#define CSL_CHIP_AMR_A5MODE_CIRCULAR1    (0x2u)

#define CSL_CHIP_AMR_A4MODE_MASK         (0x3u)
#define CSL_CHIP_AMR_A4MODE_SHIFT        (0x0u)
#define CSL_CHIP_AMR_A4MODE_RESETVAL     (0x0u)

/*----A4MODE Tokens----*/
#define CSL_CHIP_AMR_A4MODE_LINEAR       (0x0u)
#define CSL_CHIP_AMR_A4MODE_CIRCULAR0    (0x1u)
#define CSL_CHIP_AMR_A4MODE_CIRCULAR1    (0x2u)

#define CSL_CHIP_AMR_RESETVAL            (0x0u)

/* CSR */

#define CSL_CHIP_CSR_CPUID_MASK          (0xFF000000u)
#define CSL_CHIP_CSR_CPUID_SHIFT         (0x18u)
#define CSL_CHIP_CSR_CPUID_RESETVAL      (0x0u)

#define CSL_CHIP_CSR_REVISIONID_MASK     (0xFF0000u)
#define CSL_CHIP_CSR_REVISIONID_SHIFT    (0x10u)
#define CSL_CHIP_CSR_REVISIONID_RESETVAL (0x0u)

#define CSL_CHIP_CSR_PWRD_MASK           (0xFC00u)
#define CSL_CHIP_CSR_PWRD_SHIFT          (0xAu)
#define CSL_CHIP_CSR_PWRD_RESETVAL       (0x0u)

#define CSL_CHIP_CSR_SAT_MASK            (0x200u)
#define CSL_CHIP_CSR_SAT_SHIFT           (0x9u)
#define CSL_CHIP_CSR_SAT_RESETVAL        (0x0u)

/*----SAT Tokens----*/
#define CSL_CHIP_CSR_SAT_CLR             (0x0u)
#define CSL_CHIP_CSR_SAT_SET             (0x1u)

#define CSL_CHIP_CSR_EN_MASK             (0x100u)
#define CSL_CHIP_CSR_EN_SHIFT            (0x8u)
#define CSL_CHIP_CSR_EN_RESETVAL         (0x1u)

/*----EN Tokens----*/
#define CSL_CHIP_CSR_EN_LITTLE           (0x1u)

#define CSL_CHIP_CSR_PCC_MASK            (0xE0u)
#define CSL_CHIP_CSR_PCC_SHIFT           (0x5u)
#define CSL_CHIP_CSR_PCC_RESETVAL        (0x0u)

/*----PCC Tokens----*/
#define CSL_CHIP_CSR_PCC_CACHE_EN        (0x2u)
#define CSL_CHIP_CSR_PCC_CACHE_FREEZE    (0x3u)
#define CSL_CHIP_CSR_PCC_CACHE_BYPASS    (0x4u)

#define CSL_CHIP_CSR_DCC_MASK            (0x1Cu)
#define CSL_CHIP_CSR_DCC_SHIFT           (0x2u)
#define CSL_CHIP_CSR_DCC_RESETVAL        (0x0u)

#define CSL_CHIP_CSR_PGIE_MASK           (0x2u)
#define CSL_CHIP_CSR_PGIE_SHIFT          (0x1u)
#define CSL_CHIP_CSR_PGIE_RESETVAL       (0x0u)

/*----PGIE Tokens----*/
#define CSL_CHIP_CSR_PGIE_DISABLE        (0x0u)
#define CSL_CHIP_CSR_PGIE_ENABLE         (0x1u)

#define CSL_CHIP_CSR_GIE_MASK            (0x1u)
#define CSL_CHIP_CSR_GIE_SHIFT           (0x0u)
#define CSL_CHIP_CSR_GIE_RESETVAL        (0x0u)

/*----GIE Tokens----*/
#define CSL_CHIP_CSR_GIE_DISABLE         (0x0u)
#define CSL_CHIP_CSR_GIE_ENABLE          (0x1u)

#define CSL_CHIP_CSR_RESETVAL            (0x100u)

/* FADCR */

#define CSL_CHIP_FADCR_L2RMODE_MASK      (0x6000000u)
#define CSL_CHIP_FADCR_L2RMODE_SHIFT     (0x19u)
#define CSL_CHIP_FADCR_L2RMODE_RESETVAL  (0x0u)

/*----L2RMODE Tokens----*/
#define CSL_CHIP_FADCR_L2RMODE_RTOFP     (0x0u)
#define CSL_CHIP_FADCR_L2RMODE_RTOZERO   (0x1u)
#define CSL_CHIP_FADCR_L2RMODE_RTOINF    (0x2u)
#define CSL_CHIP_FADCR_L2RMODE_RTONEGINF (0x3u)

#define CSL_CHIP_FADCR_L2UNDER_MASK      (0x1000000u)
#define CSL_CHIP_FADCR_L2UNDER_SHIFT     (0x18u)
#define CSL_CHIP_FADCR_L2UNDER_RESETVAL  (0x0u)

/*----L2UNDER Tokens----*/
#define CSL_CHIP_FADCR_L2UNDER_NO_UDRFLW (0x0u)
#define CSL_CHIP_FADCR_L2UNDER_UDRFLW    (0x1u)

#define CSL_CHIP_FADCR_L2INEX_MASK       (0x800000u)
#define CSL_CHIP_FADCR_L2INEX_SHIFT      (0x17u)
#define CSL_CHIP_FADCR_L2INEX_RESETVAL   (0x0u)

/*----L2INEX Tokens----*/
#define CSL_CHIP_FADCR_L2INEX_CLR        (0x0u)
#define CSL_CHIP_FADCR_L2INEX_SET        (0x1u)

#define CSL_CHIP_FADCR_L2OVER_MASK       (0x400000u)
#define CSL_CHIP_FADCR_L2OVER_SHIFT      (0x16u)
#define CSL_CHIP_FADCR_L2OVER_RESETVAL   (0x0u)

/*----L2OVER Tokens----*/
#define CSL_CHIP_FADCR_L2OVER_NO_OVRFLW  (0x0u)
#define CSL_CHIP_FADCR_L2OVER_OVRFLW     (0x1u)

#define CSL_CHIP_FADCR_L2INFO_MASK       (0x200000u)
#define CSL_CHIP_FADCR_L2INFO_SHIFT      (0x15u)
#define CSL_CHIP_FADCR_L2INFO_RESETVAL   (0x0u)

/*----L2INFO Tokens----*/
#define CSL_CHIP_FADCR_L2INFO_NO_SIGNINF (0x0u)
#define CSL_CHIP_FADCR_L2INFO_SIGNINF    (0x1u)

#define CSL_CHIP_FADCR_L2INVAL_MASK      (0x100000u)
#define CSL_CHIP_FADCR_L2INVAL_SHIFT     (0x14u)
#define CSL_CHIP_FADCR_L2INVAL_RESETVAL  (0x0u)

/*----L2INVAL Tokens----*/
#define CSL_CHIP_FADCR_L2INVAL_NAN_NOSRC (0x0u)
#define CSL_CHIP_FADCR_L2INVAL_NAN_SRC   (0x1u)

#define CSL_CHIP_FADCR_L2DEN2_MASK       (0x80000u)
#define CSL_CHIP_FADCR_L2DEN2_SHIFT      (0x13u)
#define CSL_CHIP_FADCR_L2DEN2_RESETVAL   (0x0u)

/*----L2DEN2 Tokens----*/
#define CSL_CHIP_FADCR_L2DEN2_SRC2_NODNORM (0x0u)
#define CSL_CHIP_FADCR_L2DEN2_SRC2_DNORM (0x1u)

#define CSL_CHIP_FADCR_L2DEN1_MASK       (0x40000u)
#define CSL_CHIP_FADCR_L2DEN1_SHIFT      (0x12u)
#define CSL_CHIP_FADCR_L2DEN1_RESETVAL   (0x0u)

/*----L2DEN1 Tokens----*/
#define CSL_CHIP_FADCR_L2DEN1_SRC1_NODNORM (0x0u)
#define CSL_CHIP_FADCR_L2DEN1_SRC1_DNORM (0x1u)

#define CSL_CHIP_FADCR_L2NAN2_MASK       (0x20000u)
#define CSL_CHIP_FADCR_L2NAN2_SHIFT      (0x11u)
#define CSL_CHIP_FADCR_L2NAN2_RESETVAL   (0x0u)

/*----L2NAN2 Tokens----*/
#define CSL_CHIP_FADCR_L2NAN2_SRC2_NONAN (0x0u)
#define CSL_CHIP_FADCR_L2NAN2_SRC2_NAN   (0x1u)

#define CSL_CHIP_FADCR_L2NAN1_MASK       (0x10000u)
#define CSL_CHIP_FADCR_L2NAN1_SHIFT      (0x10u)
#define CSL_CHIP_FADCR_L2NAN1_RESETVAL   (0x0u)

/*----L2NAN1 Tokens----*/
#define CSL_CHIP_FADCR_L2NAN1_SRC1_NONAN (0x0u)
#define CSL_CHIP_FADCR_L2NAN1_SRC1_NAN   (0x1u)

#define CSL_CHIP_FADCR_L1RMODE_MASK      (0x600u)
#define CSL_CHIP_FADCR_L1RMODE_SHIFT     (0x9u)
#define CSL_CHIP_FADCR_L1RMODE_RESETVAL  (0x0u)

/*----L1RMODE Tokens----*/
#define CSL_CHIP_FADCR_L1RMODE_RTOFP     (0x0u)
#define CSL_CHIP_FADCR_L1RMODE_RTOZERO   (0x1u)
#define CSL_CHIP_FADCR_L1RMODE_RTOINF    (0x2u)
#define CSL_CHIP_FADCR_L1RMODE_RTONEGINF (0x3u)

#define CSL_CHIP_FADCR_L1UNDER_MASK      (0x100u)
#define CSL_CHIP_FADCR_L1UNDER_SHIFT     (0x8u)
#define CSL_CHIP_FADCR_L1UNDER_RESETVAL  (0x0u)

/*----L1UNDER Tokens----*/
#define CSL_CHIP_FADCR_L1UNDER_NO_UDRFLW (0x0u)
#define CSL_CHIP_FADCR_L1UNDER_UDRFLW    (0x1u)

#define CSL_CHIP_FADCR_L1INEX_MASK       (0x80u)
#define CSL_CHIP_FADCR_L1INEX_SHIFT      (0x7u)
#define CSL_CHIP_FADCR_L1INEX_RESETVAL   (0x0u)

/*----L1INEX Tokens----*/
#define CSL_CHIP_FADCR_L1INEX_CLR        (0x0u)
#define CSL_CHIP_FADCR_L1INEX_SET        (0x1u)

#define CSL_CHIP_FADCR_L1OVER_MASK       (0x40u)
#define CSL_CHIP_FADCR_L1OVER_SHIFT      (0x6u)
#define CSL_CHIP_FADCR_L1OVER_RESETVAL   (0x0u)

/*----L1OVER Tokens----*/
#define CSL_CHIP_FADCR_L1OVER_NO_OVRFLW  (0x0u)
#define CSL_CHIP_FADCR_L1OVER_OVRFLW     (0x1u)

#define CSL_CHIP_FADCR_L1INFO_MASK       (0x20u)
#define CSL_CHIP_FADCR_L1INFO_SHIFT      (0x5u)
#define CSL_CHIP_FADCR_L1INFO_RESETVAL   (0x0u)

/*----L1INFO Tokens----*/
#define CSL_CHIP_FADCR_L1INFO_NO_SIGNINF (0x0u)
#define CSL_CHIP_FADCR_L1INFO_SIGNINF    (0x1u)

#define CSL_CHIP_FADCR_L1INVAL_MASK      (0x10u)
#define CSL_CHIP_FADCR_L1INVAL_SHIFT     (0x4u)
#define CSL_CHIP_FADCR_L1INVAL_RESETVAL  (0x0u)

/*----L1INVAL Tokens----*/
#define CSL_CHIP_FADCR_L1INVAL_NAN_NOSRC (0x0u)
#define CSL_CHIP_FADCR_L1INVAL_NAN_SRC   (0x1u)

#define CSL_CHIP_FADCR_L1DEN2_MASK       (0x8u)
#define CSL_CHIP_FADCR_L1DEN2_SHIFT      (0x3u)
#define CSL_CHIP_FADCR_L1DEN2_RESETVAL   (0x0u)

/*----L1DEN2 Tokens----*/
#define CSL_CHIP_FADCR_L1DEN2_SRC2_NODNORM (0x0u)
#define CSL_CHIP_FADCR_L1DEN2_SRC2_DNORM (0x1u)

#define CSL_CHIP_FADCR_L1DEN1_MASK       (0x4u)
#define CSL_CHIP_FADCR_L1DEN1_SHIFT      (0x2u)
#define CSL_CHIP_FADCR_L1DEN1_RESETVAL   (0x0u)

/*----L1DEN1 Tokens----*/
#define CSL_CHIP_FADCR_L1DEN1_SRC1_NODNORM (0x0u)
#define CSL_CHIP_FADCR_L1DEN1_SRC1_DNORM (0x1u)

#define CSL_CHIP_FADCR_L1NAN2_MASK       (0x2u)
#define CSL_CHIP_FADCR_L1NAN2_SHIFT      (0x1u)
#define CSL_CHIP_FADCR_L1NAN2_RESETVAL   (0x0u)

/*----L1NAN2 Tokens----*/
#define CSL_CHIP_FADCR_L1NAN2_SRC2_NONAN (0x0u)
#define CSL_CHIP_FADCR_L1NAN2_SRC2_NAN   (0x1u)

#define CSL_CHIP_FADCR_L1NAN1_MASK       (0x1u)
#define CSL_CHIP_FADCR_L1NAN1_SHIFT      (0x0u)
#define CSL_CHIP_FADCR_L1NAN1_RESETVAL   (0x0u)

/*----L1NAN1 Tokens----*/
#define CSL_CHIP_FADCR_L1NAN1_SRC1_NONAN (0x0u)
#define CSL_CHIP_FADCR_L1NAN1_SRC1_NAN   (0x1u)

#define CSL_CHIP_FADCR_RESETVAL          (0x0u)

/* FAUCR */

#define CSL_CHIP_FAUCR_S2DIV0_MASK       (0x4000000u)
#define CSL_CHIP_FAUCR_S2DIV0_SHIFT      (0x1Au)
#define CSL_CHIP_FAUCR_S2DIV0_RESETVAL   (0x0u)

/*----S2DIV0 Tokens----*/
#define CSL_CHIP_FAUCR_S2DIV0_ZER0       (0x0u)
#define CSL_CHIP_FAUCR_S2DIV0_NONZERO    (0x1u)

#define CSL_CHIP_FAUCR_S2UNORD_MASK      (0x2000000u)
#define CSL_CHIP_FAUCR_S2UNORD_SHIFT     (0x19u)
#define CSL_CHIP_FAUCR_S2UNORD_RESETVAL  (0x0u)

/*----S2UNORD Tokens----*/
#define CSL_CHIP_FAUCR_S2UNORD_NAN_NOSRC (0x0u)
#define CSL_CHIP_FAUCR_S2UNORD_NAN_SRC   (0x1u)

#define CSL_CHIP_FAUCR_S2UNDER_MASK      (0x1000000u)
#define CSL_CHIP_FAUCR_S2UNDER_SHIFT     (0x18u)
#define CSL_CHIP_FAUCR_S2UNDER_RESETVAL  (0x0u)

/*----S2UNDER Tokens----*/
#define CSL_CHIP_FAUCR_S2UNDER_NO_UDRFLW (0x0u)
#define CSL_CHIP_FAUCR_S2UNDER_UDRFLW    (0x1u)

#define CSL_CHIP_FAUCR_S2INEX_MASK       (0x800000u)
#define CSL_CHIP_FAUCR_S2INEX_SHIFT      (0x17u)
#define CSL_CHIP_FAUCR_S2INEX_RESETVAL   (0x0u)

/*----S2INEX Tokens----*/
#define CSL_CHIP_FAUCR_S2INEX_CLR        (0x0u)
#define CSL_CHIP_FAUCR_S2INEX_SET        (0x1u)

#define CSL_CHIP_FAUCR_S2OVER_MASK       (0x400000u)
#define CSL_CHIP_FAUCR_S2OVER_SHIFT      (0x16u)
#define CSL_CHIP_FAUCR_S2OVER_RESETVAL   (0x0u)

/*----S2OVER Tokens----*/
#define CSL_CHIP_FAUCR_S2OVER_NO_OVRFLW  (0x0u)
#define CSL_CHIP_FAUCR_S2OVER_OVRFLW     (0x1u)

#define CSL_CHIP_FAUCR_S2INFO_MASK       (0x200000u)
#define CSL_CHIP_FAUCR_S2INFO_SHIFT      (0x15u)
#define CSL_CHIP_FAUCR_S2INFO_RESETVAL   (0x0u)

/*----S2INFO Tokens----*/
#define CSL_CHIP_FAUCR_S2INFO_NO_SIGNINF (0x0u)
#define CSL_CHIP_FAUCR_S2INFO_SIGNINF    (0x1u)

#define CSL_CHIP_FAUCR_S2INVAL_MASK      (0x100000u)
#define CSL_CHIP_FAUCR_S2INVAL_SHIFT     (0x14u)
#define CSL_CHIP_FAUCR_S2INVAL_RESETVAL  (0x0u)

/*----S2INVAL Tokens----*/
#define CSL_CHIP_FAUCR_S2INVAL_NAN_NOSRC (0x0u)
#define CSL_CHIP_FAUCR_S2INVAL_NAN_SRC   (0x1u)

#define CSL_CHIP_FAUCR_S2DEN2_MASK       (0x80000u)
#define CSL_CHIP_FAUCR_S2DEN2_SHIFT      (0x13u)
#define CSL_CHIP_FAUCR_S2DEN2_RESETVAL   (0x0u)

/*----S2DEN2 Tokens----*/
#define CSL_CHIP_FAUCR_S2DEN2_SRC2_NODNORM (0x0u)
#define CSL_CHIP_FAUCR_S2DEN2_SRC2_DNORM (0x1u)

#define CSL_CHIP_FAUCR_S2DEN1_MASK       (0x40000u)
#define CSL_CHIP_FAUCR_S2DEN1_SHIFT      (0x12u)
#define CSL_CHIP_FAUCR_S2DEN1_RESETVAL   (0x0u)

/*----S2DEN1 Tokens----*/
#define CSL_CHIP_FAUCR_S2DEN1_SRC1_NODNORM (0x0u)
#define CSL_CHIP_FAUCR_S2DEN1_SRC1_DNORM (0x1u)

#define CSL_CHIP_FAUCR_S2NAN2_MASK       (0x20000u)
#define CSL_CHIP_FAUCR_S2NAN2_SHIFT      (0x11u)
#define CSL_CHIP_FAUCR_S2NAN2_RESETVAL   (0x0u)

/*----S2NAN2 Tokens----*/
#define CSL_CHIP_FAUCR_S2NAN2_SRC2_NONAN (0x0u)
#define CSL_CHIP_FAUCR_S2NAN2_SRC2_NAN   (0x1u)

#define CSL_CHIP_FAUCR_S2NAN1_MASK       (0x10000u)
#define CSL_CHIP_FAUCR_S2NAN1_SHIFT      (0x10u)
#define CSL_CHIP_FAUCR_S2NAN1_RESETVAL   (0x0u)

/*----S2NAN1 Tokens----*/
#define CSL_CHIP_FAUCR_S2NAN1_SRC1_NONAN (0x0u)
#define CSL_CHIP_FAUCR_S2NAN1_SRC1_NAN   (0x1u)

#define CSL_CHIP_FAUCR_S1DIVO_MASK       (0x400u)
#define CSL_CHIP_FAUCR_S1DIVO_SHIFT      (0xAu)
#define CSL_CHIP_FAUCR_S1DIVO_RESETVAL   (0x0u)

/*----S1DIVO Tokens----*/
#define CSL_CHIP_FAUCR_S1DIVO_ZER0       (0x0u)
#define CSL_CHIP_FAUCR_S1DIVO_NONZERO    (0x1u)

#define CSL_CHIP_FAUCR_S1UNORD_MASK      (0x200u)
#define CSL_CHIP_FAUCR_S1UNORD_SHIFT     (0x9u)
#define CSL_CHIP_FAUCR_S1UNORD_RESETVAL  (0x0u)

/*----S1UNORD Tokens----*/
#define CSL_CHIP_FAUCR_S1UNORD_NAN_NOSRC (0x0u)
#define CSL_CHIP_FAUCR_S1UNORD_NAN_SRC   (0x1u)

#define CSL_CHIP_FAUCR_S1UNDER_MASK      (0x100u)
#define CSL_CHIP_FAUCR_S1UNDER_SHIFT     (0x8u)
#define CSL_CHIP_FAUCR_S1UNDER_RESETVAL  (0x0u)

/*----S1UNDER Tokens----*/
#define CSL_CHIP_FAUCR_S1UNDER_NO_UDRFLW (0x0u)
#define CSL_CHIP_FAUCR_S1UNDER_UDRFLW    (0x1u)

#define CSL_CHIP_FAUCR_S1INEX_MASK       (0x80u)
#define CSL_CHIP_FAUCR_S1INEX_SHIFT      (0x7u)
#define CSL_CHIP_FAUCR_S1INEX_RESETVAL   (0x0u)

/*----S1INEX Tokens----*/
#define CSL_CHIP_FAUCR_S1INEX_CLR        (0x0u)
#define CSL_CHIP_FAUCR_S1INEX_SET        (0x1u)

#define CSL_CHIP_FAUCR_S1OVER_MASK       (0x40u)
#define CSL_CHIP_FAUCR_S1OVER_SHIFT      (0x6u)
#define CSL_CHIP_FAUCR_S1OVER_RESETVAL   (0x0u)

/*----S1OVER Tokens----*/
#define CSL_CHIP_FAUCR_S1OVER_NO_OVRFLW  (0x0u)
#define CSL_CHIP_FAUCR_S1OVER_OVRFLW     (0x1u)

#define CSL_CHIP_FAUCR_S1INFO_MASK       (0x20u)
#define CSL_CHIP_FAUCR_S1INFO_SHIFT      (0x5u)
#define CSL_CHIP_FAUCR_S1INFO_RESETVAL   (0x0u)

/*----S1INFO Tokens----*/
#define CSL_CHIP_FAUCR_S1INFO_NO_SIGNINF (0x0u)
#define CSL_CHIP_FAUCR_S1INFO_SIGNINF    (0x1u)

#define CSL_CHIP_FAUCR_S1INVAL_MASK      (0x10u)
#define CSL_CHIP_FAUCR_S1INVAL_SHIFT     (0x4u)
#define CSL_CHIP_FAUCR_S1INVAL_RESETVAL  (0x0u)

/*----S1INVAL Tokens----*/
#define CSL_CHIP_FAUCR_S1INVAL_NAN_NOSRC (0x0u)
#define CSL_CHIP_FAUCR_S1INVAL_NAN_SRC   (0x1u)

#define CSL_CHIP_FAUCR_S1DEN2_MASK       (0x8u)
#define CSL_CHIP_FAUCR_S1DEN2_SHIFT      (0x3u)
#define CSL_CHIP_FAUCR_S1DEN2_RESETVAL   (0x0u)

/*----S1DEN2 Tokens----*/
#define CSL_CHIP_FAUCR_S1DEN2_SRC2_NDNORM (0x0u)
#define CSL_CHIP_FAUCR_S1DEN2_SRC2_DNORM (0x1u)

#define CSL_CHIP_FAUCR_S1DEN1_MASK       (0x4u)
#define CSL_CHIP_FAUCR_S1DEN1_SHIFT      (0x2u)
#define CSL_CHIP_FAUCR_S1DEN1_RESETVAL   (0x0u)

/*----S1DEN1 Tokens----*/
#define CSL_CHIP_FAUCR_S1DEN1_SRC1_NODNORM (0x0u)
#define CSL_CHIP_FAUCR_S1DEN1_SRC1_DNORM (0x1u)

#define CSL_CHIP_FAUCR_S1NAN2_MASK       (0x2u)
#define CSL_CHIP_FAUCR_S1NAN2_SHIFT      (0x1u)
#define CSL_CHIP_FAUCR_S1NAN2_RESETVAL   (0x0u)

/*----S1NAN2 Tokens----*/
#define CSL_CHIP_FAUCR_S1NAN2_SRC2_NONAN (0x0u)
#define CSL_CHIP_FAUCR_S1NAN2_SRC2_NAN   (0x1u)

#define CSL_CHIP_FAUCR_S1NAN1_MASK       (0x1u)
#define CSL_CHIP_FAUCR_S1NAN1_SHIFT      (0x0u)
#define CSL_CHIP_FAUCR_S1NAN1_RESETVAL   (0x0u)

/*----S1NAN1 Tokens----*/
#define CSL_CHIP_FAUCR_S1NAN1_SRC1_NONAN (0x0u)
#define CSL_CHIP_FAUCR_S1NAN1_SRC1_NAN   (0x1u)

#define CSL_CHIP_FAUCR_RESETVAL          (0x0u)

/* FMCR */

#define CSL_CHIP_FMCR_M2RMODE_MASK       (0x6000000u)
#define CSL_CHIP_FMCR_M2RMODE_SHIFT      (0x19u)
#define CSL_CHIP_FMCR_M2RMODE_RESETVAL   (0x0u)

/*----M2RMODE Tokens----*/
#define CSL_CHIP_FMCR_M2RMODE_RTOFP      (0x0u)
#define CSL_CHIP_FMCR_M2RMODE_RTOZERO    (0x1u)
#define CSL_CHIP_FMCR_M2RMODE_RTOINF     (0x2u)
#define CSL_CHIP_FMCR_M2RMODE_RTONEGINF  (0x3u)

#define CSL_CHIP_FMCR_M2UNDER_MASK       (0x1000000u)
#define CSL_CHIP_FMCR_M2UNDER_SHIFT      (0x18u)
#define CSL_CHIP_FMCR_M2UNDER_RESETVAL   (0x0u)

/*----M2UNDER Tokens----*/
#define CSL_CHIP_FMCR_M2UNDER_NO_UDRFLW  (0x0u)
#define CSL_CHIP_FMCR_M2UNDER_UDRFLW     (0x1u)

#define CSL_CHIP_FMCR_M2INEX_MASK        (0x800000u)
#define CSL_CHIP_FMCR_M2INEX_SHIFT       (0x17u)
#define CSL_CHIP_FMCR_M2INEX_RESETVAL    (0x0u)

/*----M2INEX Tokens----*/
#define CSL_CHIP_FMCR_M2INEX_CLR         (0x0u)
#define CSL_CHIP_FMCR_M2INEX_SET         (0x1u)

#define CSL_CHIP_FMCR_M2OVER_MASK        (0x400000u)
#define CSL_CHIP_FMCR_M2OVER_SHIFT       (0x16u)
#define CSL_CHIP_FMCR_M2OVER_RESETVAL    (0x0u)

/*----M2OVER Tokens----*/
#define CSL_CHIP_FMCR_M2OVER_NO_OVRFLW   (0x0u)
#define CSL_CHIP_FMCR_M2OVER_OVRFLW      (0x1u)

#define CSL_CHIP_FMCR_M2INFO_MASK        (0x200000u)
#define CSL_CHIP_FMCR_M2INFO_SHIFT       (0x15u)
#define CSL_CHIP_FMCR_M2INFO_RESETVAL    (0x0u)

/*----M2INFO Tokens----*/
#define CSL_CHIP_FMCR_M2INFO_NO_SIGNINF  (0x0u)
#define CSL_CHIP_FMCR_M2INFO_SIGNINF     (0x1u)

#define CSL_CHIP_FMCR_M2INVAL_MASK       (0x100000u)
#define CSL_CHIP_FMCR_M2INVAL_SHIFT      (0x14u)
#define CSL_CHIP_FMCR_M2INVAL_RESETVAL   (0x0u)

/*----M2INVAL Tokens----*/
#define CSL_CHIP_FMCR_M2INVAL_NAN_NOSRC  (0x0u)
#define CSL_CHIP_FMCR_M2INVAL_NAN_SRC    (0x1u)

#define CSL_CHIP_FMCR_M2DEN2_MASK        (0x80000u)
#define CSL_CHIP_FMCR_M2DEN2_SHIFT       (0x13u)
#define CSL_CHIP_FMCR_M2DEN2_RESETVAL    (0x0u)

/*----M2DEN2 Tokens----*/
#define CSL_CHIP_FMCR_M2DEN2_SRC2_NODNORM (0x0u)
#define CSL_CHIP_FMCR_M2DEN2_SRC2_DNORM  (0x1u)

#define CSL_CHIP_FMCR_M2DEN1_MASK        (0x40000u)
#define CSL_CHIP_FMCR_M2DEN1_SHIFT       (0x12u)
#define CSL_CHIP_FMCR_M2DEN1_RESETVAL    (0x0u)

/*----M2DEN1 Tokens----*/
#define CSL_CHIP_FMCR_M2DEN1_SRC1_NODNORM (0x0u)
#define CSL_CHIP_FMCR_M2DEN1_SRC1_DNORM  (0x1u)

#define CSL_CHIP_FMCR_M2NAN2_MASK        (0x20000u)
#define CSL_CHIP_FMCR_M2NAN2_SHIFT       (0x11u)
#define CSL_CHIP_FMCR_M2NAN2_RESETVAL    (0x0u)

/*----M2NAN2 Tokens----*/
#define CSL_CHIP_FMCR_M2NAN2_SRC2_NONAN  (0x0u)
#define CSL_CHIP_FMCR_M2NAN2_SRC2_NAN    (0x1u)

#define CSL_CHIP_FMCR_M2NAN1_MASK        (0x10000u)
#define CSL_CHIP_FMCR_M2NAN1_SHIFT       (0x10u)
#define CSL_CHIP_FMCR_M2NAN1_RESETVAL    (0x0u)

/*----M2NAN1 Tokens----*/
#define CSL_CHIP_FMCR_M2NAN1_SRC1_NONAN  (0x0u)
#define CSL_CHIP_FMCR_M2NAN1_SRC1_NAN    (0x1u)

#define CSL_CHIP_FMCR_M1RMODE_MASK       (0x600u)
#define CSL_CHIP_FMCR_M1RMODE_SHIFT      (0x9u)
#define CSL_CHIP_FMCR_M1RMODE_RESETVAL   (0x0u)

/*----M1RMODE Tokens----*/
#define CSL_CHIP_FMCR_M1RMODE_RTOFP      (0x0u)
#define CSL_CHIP_FMCR_M1RMODE_RTOZERO    (0x1u)
#define CSL_CHIP_FMCR_M1RMODE_RTOINF     (0x2u)
#define CSL_CHIP_FMCR_M1RMODE_RTONEGINF  (0x3u)

#define CSL_CHIP_FMCR_M1UNDER_MASK       (0x100u)
#define CSL_CHIP_FMCR_M1UNDER_SHIFT      (0x8u)
#define CSL_CHIP_FMCR_M1UNDER_RESETVAL   (0x0u)

/*----M1UNDER Tokens----*/
#define CSL_CHIP_FMCR_M1UNDER_NO_UDRFLW  (0x0u)
#define CSL_CHIP_FMCR_M1UNDER_UDRFLW     (0x1u)

#define CSL_CHIP_FMCR_M1INEX_MASK        (0x80u)
#define CSL_CHIP_FMCR_M1INEX_SHIFT       (0x7u)
#define CSL_CHIP_FMCR_M1INEX_RESETVAL    (0x0u)

/*----M1INEX Tokens----*/
#define CSL_CHIP_FMCR_M1INEX_CLR         (0x0u)
#define CSL_CHIP_FMCR_M1INEX_SET         (0x1u)

#define CSL_CHIP_FMCR_M1OVER_MASK        (0x40u)
#define CSL_CHIP_FMCR_M1OVER_SHIFT       (0x6u)
#define CSL_CHIP_FMCR_M1OVER_RESETVAL    (0x0u)

/*----M1OVER Tokens----*/
#define CSL_CHIP_FMCR_M1OVER_NO_OVRFLW   (0x0u)
#define CSL_CHIP_FMCR_M1OVER_OVRFLW      (0x1u)

#define CSL_CHIP_FMCR_M1INFO_MASK        (0x20u)
#define CSL_CHIP_FMCR_M1INFO_SHIFT       (0x5u)
#define CSL_CHIP_FMCR_M1INFO_RESETVAL    (0x0u)

/*----M1INFO Tokens----*/
#define CSL_CHIP_FMCR_M1INFO_NO_SIGNINF  (0x0u)
#define CSL_CHIP_FMCR_M1INFO_SIGNINF     (0x1u)

#define CSL_CHIP_FMCR_M1INVAL_MASK       (0x10u)
#define CSL_CHIP_FMCR_M1INVAL_SHIFT      (0x4u)
#define CSL_CHIP_FMCR_M1INVAL_RESETVAL   (0x0u)

/*----M1INVAL Tokens----*/
#define CSL_CHIP_FMCR_M1INVAL_NAN_NOSRC  (0x0u)
#define CSL_CHIP_FMCR_M1INVAL_NAN_SRC    (0x1u)

#define CSL_CHIP_FMCR_M1DEN2_MASK        (0x8u)
#define CSL_CHIP_FMCR_M1DEN2_SHIFT       (0x3u)
#define CSL_CHIP_FMCR_M1DEN2_RESETVAL    (0x0u)

/*----M1DEN2 Tokens----*/
#define CSL_CHIP_FMCR_M1DEN2_SRC2_NODNORM (0x0u)
#define CSL_CHIP_FMCR_M1DEN2_SRC2_DNORM  (0x1u)

#define CSL_CHIP_FMCR_M1DEN1_MASK        (0x4u)
#define CSL_CHIP_FMCR_M1DEN1_SHIFT       (0x2u)
#define CSL_CHIP_FMCR_M1DEN1_RESETVAL    (0x0u)

/*----M1DEN1 Tokens----*/
#define CSL_CHIP_FMCR_M1DEN1_SRC1_NODNORM (0x0u)
#define CSL_CHIP_FMCR_M1DEN1_SRC1_DNORM  (0x1u)

#define CSL_CHIP_FMCR_M1NAN2_MASK        (0x2u)
#define CSL_CHIP_FMCR_M1NAN2_SHIFT       (0x1u)
#define CSL_CHIP_FMCR_M1NAN2_RESETVAL    (0x0u)

/*----M1NAN2 Tokens----*/
#define CSL_CHIP_FMCR_M1NAN2_SRC2_NONAN  (0x0u)
#define CSL_CHIP_FMCR_M1NAN2_SRC2_NAN    (0x1u)

#define CSL_CHIP_FMCR_M1NAN1_MASK        (0x1u)
#define CSL_CHIP_FMCR_M1NAN1_SHIFT       (0x0u)
#define CSL_CHIP_FMCR_M1NAN1_RESETVAL    (0x0u)

/*----M1NAN1 Tokens----*/
#define CSL_CHIP_FMCR_M1NAN1_SRC1_NONAN  (0x0u)
#define CSL_CHIP_FMCR_M1NAN1_SRC1_NAN    (0x1u)

#define CSL_CHIP_FMCR_RESETVAL           (0x0u)

#endif
