#ifndef _CSLR_DMAX_H_
#define _CSLR_DMAX_H_
/*********************************************************************
 * Copyright (C) 2003-2005 Texas Instruments Incorporated. 
 * All Rights Reserved 
 *********************************************************************/
 /** \file cslr_dmax.h
 * 
 * \brief This file contains the Register Desciptions for Dmax
 * 
 *********************************************************************/

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure for HiPriorityEventTable 
\**************************************************************************/
typedef struct  {
    volatile Uint32 EVENT0;
    volatile Uint32 EVENT1;
    volatile Uint32 EVENT2;
    volatile Uint32 EVENT3;
    volatile Uint32 EVENT4;
    volatile Uint32 EVENT5;
    volatile Uint32 EVENT6;
    volatile Uint32 EVENT7;
    volatile Uint32 EVENT8;
    volatile Uint32 EVENT9;
    volatile Uint32 EVENT10;
    volatile Uint32 EVENT11;
    volatile Uint32 EVENT12;
    volatile Uint32 EVENT13;
    volatile Uint32 EVENT14;
    volatile Uint32 EVENT15;
    volatile Uint32 EVENT16;
    volatile Uint32 EVENT17;
    volatile Uint32 EVENT18;
    volatile Uint32 EVENT19;
    volatile Uint32 EVENT20;
    volatile Uint32 EVENT21;
    volatile Uint32 EVENT22;
    volatile Uint32 EVENT23;
    volatile Uint32 EVENT24;
    volatile Uint32 EVENT25;
    volatile Uint32 EVENT26;
    volatile Uint32 EVENT27;
    volatile Uint32 EVENT28;
    volatile Uint32 EVENT29;
    volatile Uint32 EVENT30;
    volatile Uint32 EVENT31;
} CSL_DmaxHipriorityeventtableRegs;

/**************************************************************************\
* Register Overlay Structure for HiMaxPaRAM 
\**************************************************************************/
typedef struct  {
    volatile Uint32 WORD0;
    volatile Uint32 WORD1;
    volatile Uint32 WORD2;
    volatile Uint32 WORD3;
    volatile Uint32 WORD4;
    volatile Uint32 WORD5;
    volatile Uint32 WORD6;
    volatile Uint32 WORD7;
    volatile Uint32 WORD8;
    volatile Uint32 WORD9;
    volatile Uint32 WORD10;
} CSL_DmaxHimaxparamRegs;

/**************************************************************************\
* Register Overlay Structure for LoPriorityEventTable 
\**************************************************************************/
typedef struct  {
    volatile Uint32 EVENT0;
    volatile Uint32 EVENT1;
    volatile Uint32 EVENT2;
    volatile Uint32 EVENT3;
    volatile Uint32 EVENT4;
    volatile Uint32 EVENT5;
    volatile Uint32 EVENT6;
    volatile Uint32 EVENT7;
    volatile Uint32 EVENT8;
    volatile Uint32 EVENT9;
    volatile Uint32 EVENT10;
    volatile Uint32 EVENT11;
    volatile Uint32 EVENT12;
    volatile Uint32 EVENT13;
    volatile Uint32 EVENT14;
    volatile Uint32 EVENT15;
    volatile Uint32 EVENT16;
    volatile Uint32 EVENT17;
    volatile Uint32 EVENT18;
    volatile Uint32 EVENT19;
    volatile Uint32 EVENT20;
    volatile Uint32 EVENT21;
    volatile Uint32 EVENT22;
    volatile Uint32 EVENT23;
    volatile Uint32 EVENT24;
    volatile Uint32 EVENT25;
    volatile Uint32 EVENT26;
    volatile Uint32 EVENT27;
    volatile Uint32 EVENT28;
    volatile Uint32 EVENT29;
    volatile Uint32 EVENT30;
    volatile Uint32 EVENT31;
} CSL_DmaxLopriorityeventtableRegs;

/**************************************************************************\
* Register Overlay Structure for LoMaxPaRAM 
\**************************************************************************/
typedef struct  {
    volatile Uint32 WORD0;
    volatile Uint32 WORD1;
    volatile Uint32 WORD2;
    volatile Uint32 WORD3;
    volatile Uint32 WORD4;
    volatile Uint32 WORD5;
    volatile Uint32 WORD6;
    volatile Uint32 WORD7;
    volatile Uint32 WORD8;
    volatile Uint32 WORD9;
    volatile Uint32 WORD10;
} CSL_DmaxLomaxparamRegs;

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 RSVD0[2];
    volatile Uint32 DEPR;
    volatile Uint32 DEER;
    volatile Uint32 DEDR;
    volatile Uint32 DEHPR;
    volatile Uint32 DELPR;
    volatile Uint32 DEFR;
    volatile Uint32 RSVD1[8];
    volatile Uint32 DFSR0;
    volatile Uint32 RSVD2[7];
    volatile Uint32 DFSR1;
    volatile Uint32 RSVD3[7];
    volatile Uint32 DTCR0;
    volatile Uint32 RSVD4[7];
    volatile Uint32 DTCR1;
    volatile Uint32 RSVD5[4202455];
    CSL_DmaxHipriorityeventtableRegs HiPriorityEventTable;
    volatile Uint32 RSVD6[8];
    CSL_DmaxHimaxparamRegs HiMaxParam[8];
    volatile Uint32 RSVD7[4194176];
    CSL_DmaxLopriorityeventtableRegs LoPriorityEventTable;
    volatile Uint32 RSVD8[8];
    CSL_DmaxLomaxparamRegs LoMaxParam[8];
} CSL_DmaxRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* DEPR */

#define CSL_DMAX_DEPR_EP31_MASK          (0x80000000u)
#define CSL_DMAX_DEPR_EP31_SHIFT         (0x0000001Fu)
#define CSL_DMAX_DEPR_EP31_RESETVAL      (0x00000000u)

/*----EP31 Tokens----*/
#define CSL_DMAX_DEPR_EP31_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP31_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP30_MASK          (0x40000000u)
#define CSL_DMAX_DEPR_EP30_SHIFT         (0x0000001Eu)
#define CSL_DMAX_DEPR_EP30_RESETVAL      (0x00000000u)

/*----EP30 Tokens----*/
#define CSL_DMAX_DEPR_EP30_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP30_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP29_MASK          (0x20000000u)
#define CSL_DMAX_DEPR_EP29_SHIFT         (0x0000001Du)
#define CSL_DMAX_DEPR_EP29_RESETVAL      (0x00000000u)

/*----EP29 Tokens----*/
#define CSL_DMAX_DEPR_EP29_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP29_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP28_MASK          (0x10000000u)
#define CSL_DMAX_DEPR_EP28_SHIFT         (0x0000001Cu)
#define CSL_DMAX_DEPR_EP28_RESETVAL      (0x00000000u)

/*----EP28 Tokens----*/
#define CSL_DMAX_DEPR_EP28_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP28_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP27_MASK          (0x08000000u)
#define CSL_DMAX_DEPR_EP27_SHIFT         (0x0000001Bu)
#define CSL_DMAX_DEPR_EP27_RESETVAL      (0x00000000u)

/*----EP27 Tokens----*/
#define CSL_DMAX_DEPR_EP27_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP27_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP26_MASK          (0x04000000u)
#define CSL_DMAX_DEPR_EP26_SHIFT         (0x0000001Au)
#define CSL_DMAX_DEPR_EP26_RESETVAL      (0x00000000u)

/*----EP26 Tokens----*/
#define CSL_DMAX_DEPR_EP26_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP26_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP24_MASK          (0x01000000u)
#define CSL_DMAX_DEPR_EP24_SHIFT         (0x00000018u)
#define CSL_DMAX_DEPR_EP24_RESETVAL      (0x00000000u)

/*----EP24 Tokens----*/
#define CSL_DMAX_DEPR_EP24_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP24_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP23_MASK          (0x00800000u)
#define CSL_DMAX_DEPR_EP23_SHIFT         (0x00000017u)
#define CSL_DMAX_DEPR_EP23_RESETVAL      (0x00000000u)

/*----EP23 Tokens----*/
#define CSL_DMAX_DEPR_EP23_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP23_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP22_MASK          (0x00400000u)
#define CSL_DMAX_DEPR_EP22_SHIFT         (0x00000016u)
#define CSL_DMAX_DEPR_EP22_RESETVAL      (0x00000000u)

/*----EP22 Tokens----*/
#define CSL_DMAX_DEPR_EP22_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP22_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP21_MASK          (0x00200000u)
#define CSL_DMAX_DEPR_EP21_SHIFT         (0x00000015u)
#define CSL_DMAX_DEPR_EP21_RESETVAL      (0x00000000u)

/*----EP21 Tokens----*/
#define CSL_DMAX_DEPR_EP21_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP21_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP20_MASK          (0x00100000u)
#define CSL_DMAX_DEPR_EP20_SHIFT         (0x00000014u)
#define CSL_DMAX_DEPR_EP20_RESETVAL      (0x00000000u)

/*----EP20 Tokens----*/
#define CSL_DMAX_DEPR_EP20_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP20_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP19_MASK          (0x00080000u)
#define CSL_DMAX_DEPR_EP19_SHIFT         (0x00000013u)
#define CSL_DMAX_DEPR_EP19_RESETVAL      (0x00000000u)

/*----EP19 Tokens----*/
#define CSL_DMAX_DEPR_EP19_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP19_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP18_MASK          (0x00040000u)
#define CSL_DMAX_DEPR_EP18_SHIFT         (0x00000012u)
#define CSL_DMAX_DEPR_EP18_RESETVAL      (0x00000000u)

/*----EP18 Tokens----*/
#define CSL_DMAX_DEPR_EP18_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP18_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP17_MASK          (0x00020000u)
#define CSL_DMAX_DEPR_EP17_SHIFT         (0x00000011u)
#define CSL_DMAX_DEPR_EP17_RESETVAL      (0x00000000u)

/*----EP17 Tokens----*/
#define CSL_DMAX_DEPR_EP17_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP17_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP16_MASK          (0x00010000u)
#define CSL_DMAX_DEPR_EP16_SHIFT         (0x00000010u)
#define CSL_DMAX_DEPR_EP16_RESETVAL      (0x00000000u)

/*----EP16 Tokens----*/
#define CSL_DMAX_DEPR_EP16_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP16_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP15_MASK          (0x00008000u)
#define CSL_DMAX_DEPR_EP15_SHIFT         (0x0000000Fu)
#define CSL_DMAX_DEPR_EP15_RESETVAL      (0x00000000u)

/*----EP15 Tokens----*/
#define CSL_DMAX_DEPR_EP15_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP15_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP14_MASK          (0x00004000u)
#define CSL_DMAX_DEPR_EP14_SHIFT         (0x0000000Eu)
#define CSL_DMAX_DEPR_EP14_RESETVAL      (0x00000000u)

/*----EP14 Tokens----*/
#define CSL_DMAX_DEPR_EP14_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP14_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP13_MASK          (0x00002000u)
#define CSL_DMAX_DEPR_EP13_SHIFT         (0x0000000Du)
#define CSL_DMAX_DEPR_EP13_RESETVAL      (0x00000000u)

/*----EP13 Tokens----*/
#define CSL_DMAX_DEPR_EP13_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP13_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP12_MASK          (0x00001000u)
#define CSL_DMAX_DEPR_EP12_SHIFT         (0x0000000Cu)
#define CSL_DMAX_DEPR_EP12_RESETVAL      (0x00000000u)

/*----EP12 Tokens----*/
#define CSL_DMAX_DEPR_EP12_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP12_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP11_MASK          (0x00000800u)
#define CSL_DMAX_DEPR_EP11_SHIFT         (0x0000000Bu)
#define CSL_DMAX_DEPR_EP11_RESETVAL      (0x00000000u)

/*----EP11 Tokens----*/
#define CSL_DMAX_DEPR_EP11_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP11_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP10_MASK          (0x00000400u)
#define CSL_DMAX_DEPR_EP10_SHIFT         (0x0000000Au)
#define CSL_DMAX_DEPR_EP10_RESETVAL      (0x00000000u)

/*----EP10 Tokens----*/
#define CSL_DMAX_DEPR_EP10_SET_FALLING   (0x00000000u)
#define CSL_DMAX_DEPR_EP10_SET_RISING    (0x00000001u)

#define CSL_DMAX_DEPR_EP9_MASK           (0x00000200u)
#define CSL_DMAX_DEPR_EP9_SHIFT          (0x00000009u)
#define CSL_DMAX_DEPR_EP9_RESETVAL       (0x00000000u)

/*----EP9 Tokens----*/
#define CSL_DMAX_DEPR_EP9_SET_FALLING    (0x00000000u)
#define CSL_DMAX_DEPR_EP9_SET_RISING     (0x00000001u)

#define CSL_DMAX_DEPR_EP8_MASK           (0x00000100u)
#define CSL_DMAX_DEPR_EP8_SHIFT          (0x00000008u)
#define CSL_DMAX_DEPR_EP8_RESETVAL       (0x00000000u)

/*----EP8 Tokens----*/
#define CSL_DMAX_DEPR_EP8_SET_FALLING    (0x00000000u)
#define CSL_DMAX_DEPR_EP8_SET_RISING     (0x00000001u)

#define CSL_DMAX_DEPR_EP7_MASK           (0x00000080u)
#define CSL_DMAX_DEPR_EP7_SHIFT          (0x00000007u)
#define CSL_DMAX_DEPR_EP7_RESETVAL       (0x00000000u)

/*----EP7 Tokens----*/
#define CSL_DMAX_DEPR_EP7_SET_FALLING    (0x00000000u)
#define CSL_DMAX_DEPR_EP7_SET_RISING     (0x00000001u)

#define CSL_DMAX_DEPR_EP6_MASK           (0x00000040u)
#define CSL_DMAX_DEPR_EP6_SHIFT          (0x00000006u)
#define CSL_DMAX_DEPR_EP6_RESETVAL       (0x00000000u)

/*----EP6 Tokens----*/
#define CSL_DMAX_DEPR_EP6_SET_FALLING    (0x00000000u)
#define CSL_DMAX_DEPR_EP6_SET_RISING     (0x00000001u)

#define CSL_DMAX_DEPR_EP5_MASK           (0x00000020u)
#define CSL_DMAX_DEPR_EP5_SHIFT          (0x00000005u)
#define CSL_DMAX_DEPR_EP5_RESETVAL       (0x00000000u)

/*----EP5 Tokens----*/
#define CSL_DMAX_DEPR_EP5_SET_FALLING    (0x00000000u)
#define CSL_DMAX_DEPR_EP5_SET_RISING     (0x00000001u)

#define CSL_DMAX_DEPR_EP4_MASK           (0x00000010u)
#define CSL_DMAX_DEPR_EP4_SHIFT          (0x00000004u)
#define CSL_DMAX_DEPR_EP4_RESETVAL       (0x00000000u)

/*----EP4 Tokens----*/
#define CSL_DMAX_DEPR_EP4_SET_FALLING    (0x00000000u)
#define CSL_DMAX_DEPR_EP4_SET_RISING     (0x00000001u)

#define CSL_DMAX_DEPR_EP3_MASK           (0x00000008u)
#define CSL_DMAX_DEPR_EP3_SHIFT          (0x00000003u)
#define CSL_DMAX_DEPR_EP3_RESETVAL       (0x00000000u)

/*----EP3 Tokens----*/
#define CSL_DMAX_DEPR_EP3_SET_FALLING    (0x00000000u)
#define CSL_DMAX_DEPR_EP3_SET_RISING     (0x00000001u)

#define CSL_DMAX_DEPR_EP2_MASK           (0x00000004u)
#define CSL_DMAX_DEPR_EP2_SHIFT          (0x00000002u)
#define CSL_DMAX_DEPR_EP2_RESETVAL       (0x00000000u)

/*----EP2 Tokens----*/
#define CSL_DMAX_DEPR_EP2_SET_FALLING    (0x00000000u)
#define CSL_DMAX_DEPR_EP2_SET_RISING     (0x00000001u)

#define CSL_DMAX_DEPR_EP1_MASK           (0x00000002u)
#define CSL_DMAX_DEPR_EP1_SHIFT          (0x00000001u)
#define CSL_DMAX_DEPR_EP1_RESETVAL       (0x00000000u)

/*----EP1 Tokens----*/
#define CSL_DMAX_DEPR_EP1_SET_FALLING    (0x00000000u)
#define CSL_DMAX_DEPR_EP1_SET_RISING     (0x00000001u)

#define CSL_DMAX_DEPR_EP0_MASK           (0x00000001u)
#define CSL_DMAX_DEPR_EP0_SHIFT          (0x00000000u)
#define CSL_DMAX_DEPR_EP0_RESETVAL       (0x00000000u)

/*----EP0 Tokens----*/
#define CSL_DMAX_DEPR_EP0_SET_FALLING    (0x00000000u)
#define CSL_DMAX_DEPR_EP0_SET_RISING     (0x00000001u)

#define CSL_DMAX_DEPR_RESETVAL           (0x00000000u)

/* DEER */

#define CSL_DMAX_DEER_EE31_MASK          (0x80000000u)
#define CSL_DMAX_DEER_EE31_SHIFT         (0x0000001Fu)
#define CSL_DMAX_DEER_EE31_RESETVAL      (0x00000000u)

/*----EE31 Tokens----*/
#define CSL_DMAX_DEER_EE31_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE30_MASK          (0x40000000u)
#define CSL_DMAX_DEER_EE30_SHIFT         (0x0000001Eu)
#define CSL_DMAX_DEER_EE30_RESETVAL      (0x00000000u)

/*----EE30 Tokens----*/
#define CSL_DMAX_DEER_EE30_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE29_MASK          (0x20000000u)
#define CSL_DMAX_DEER_EE29_SHIFT         (0x0000001Du)
#define CSL_DMAX_DEER_EE29_RESETVAL      (0x00000000u)

/*----EE29 Tokens----*/
#define CSL_DMAX_DEER_EE29_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE28_MASK          (0x10000000u)
#define CSL_DMAX_DEER_EE28_SHIFT         (0x0000001Cu)
#define CSL_DMAX_DEER_EE28_RESETVAL      (0x00000000u)

/*----EE28 Tokens----*/
#define CSL_DMAX_DEER_EE28_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE27_MASK          (0x08000000u)
#define CSL_DMAX_DEER_EE27_SHIFT         (0x0000001Bu)
#define CSL_DMAX_DEER_EE27_RESETVAL      (0x00000000u)

/*----EE27 Tokens----*/
#define CSL_DMAX_DEER_EE27_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE26_MASK          (0x04000000u)
#define CSL_DMAX_DEER_EE26_SHIFT         (0x0000001Au)
#define CSL_DMAX_DEER_EE26_RESETVAL      (0x00000000u)

/*----EE26 Tokens----*/
#define CSL_DMAX_DEER_EE26_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE24_MASK          (0x01000000u)
#define CSL_DMAX_DEER_EE24_SHIFT         (0x00000018u)
#define CSL_DMAX_DEER_EE24_RESETVAL      (0x00000000u)

/*----EE24 Tokens----*/
#define CSL_DMAX_DEER_EE24_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE23_MASK          (0x00800000u)
#define CSL_DMAX_DEER_EE23_SHIFT         (0x00000017u)
#define CSL_DMAX_DEER_EE23_RESETVAL      (0x00000000u)

/*----EE23 Tokens----*/
#define CSL_DMAX_DEER_EE23_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE22_MASK          (0x00400000u)
#define CSL_DMAX_DEER_EE22_SHIFT         (0x00000016u)
#define CSL_DMAX_DEER_EE22_RESETVAL      (0x00000000u)

/*----EE22 Tokens----*/
#define CSL_DMAX_DEER_EE22_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE21_MASK          (0x00200000u)
#define CSL_DMAX_DEER_EE21_SHIFT         (0x00000015u)
#define CSL_DMAX_DEER_EE21_RESETVAL      (0x00000000u)

/*----EE21 Tokens----*/
#define CSL_DMAX_DEER_EE21_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE20_MASK          (0x00100000u)
#define CSL_DMAX_DEER_EE20_SHIFT         (0x00000014u)
#define CSL_DMAX_DEER_EE20_RESETVAL      (0x00000000u)

/*----EE20 Tokens----*/
#define CSL_DMAX_DEER_EE20_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE19_MASK          (0x00080000u)
#define CSL_DMAX_DEER_EE19_SHIFT         (0x00000013u)
#define CSL_DMAX_DEER_EE19_RESETVAL      (0x00000000u)

/*----EE19 Tokens----*/
#define CSL_DMAX_DEER_EE19_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE18_MASK          (0x00040000u)
#define CSL_DMAX_DEER_EE18_SHIFT         (0x00000012u)
#define CSL_DMAX_DEER_EE18_RESETVAL      (0x00000000u)

/*----EE18 Tokens----*/
#define CSL_DMAX_DEER_EE18_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE17_MASK          (0x00020000u)
#define CSL_DMAX_DEER_EE17_SHIFT         (0x00000011u)
#define CSL_DMAX_DEER_EE17_RESETVAL      (0x00000000u)

/*----EE17 Tokens----*/
#define CSL_DMAX_DEER_EE17_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE16_MASK          (0x00010000u)
#define CSL_DMAX_DEER_EE16_SHIFT         (0x00000010u)
#define CSL_DMAX_DEER_EE16_RESETVAL      (0x00000000u)

/*----EE16 Tokens----*/
#define CSL_DMAX_DEER_EE16_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE15_MASK          (0x00008000u)
#define CSL_DMAX_DEER_EE15_SHIFT         (0x0000000Fu)
#define CSL_DMAX_DEER_EE15_RESETVAL      (0x00000000u)

/*----EE15 Tokens----*/
#define CSL_DMAX_DEER_EE15_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE14_MASK          (0x00004000u)
#define CSL_DMAX_DEER_EE14_SHIFT         (0x0000000Eu)
#define CSL_DMAX_DEER_EE14_RESETVAL      (0x00000000u)

/*----EE14 Tokens----*/
#define CSL_DMAX_DEER_EE14_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE13_MASK          (0x00002000u)
#define CSL_DMAX_DEER_EE13_SHIFT         (0x0000000Du)
#define CSL_DMAX_DEER_EE13_RESETVAL      (0x00000000u)

/*----EE13 Tokens----*/
#define CSL_DMAX_DEER_EE13_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE12_MASK          (0x00001000u)
#define CSL_DMAX_DEER_EE12_SHIFT         (0x0000000Cu)
#define CSL_DMAX_DEER_EE12_RESETVAL      (0x00000000u)

/*----EE12 Tokens----*/
#define CSL_DMAX_DEER_EE12_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE11_MASK          (0x00000800u)
#define CSL_DMAX_DEER_EE11_SHIFT         (0x0000000Bu)
#define CSL_DMAX_DEER_EE11_RESETVAL      (0x00000000u)

/*----EE11 Tokens----*/
#define CSL_DMAX_DEER_EE11_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE10_MASK          (0x00000400u)
#define CSL_DMAX_DEER_EE10_SHIFT         (0x0000000Au)
#define CSL_DMAX_DEER_EE10_RESETVAL      (0x00000000u)

/*----EE10 Tokens----*/
#define CSL_DMAX_DEER_EE10_ENABLE        (0x00000001u)

#define CSL_DMAX_DEER_EE9_MASK           (0x00000200u)
#define CSL_DMAX_DEER_EE9_SHIFT          (0x00000009u)
#define CSL_DMAX_DEER_EE9_RESETVAL       (0x00000000u)

/*----EE9 Tokens----*/
#define CSL_DMAX_DEER_EE9_ENABLE         (0x00000001u)

#define CSL_DMAX_DEER_EE8_MASK           (0x00000100u)
#define CSL_DMAX_DEER_EE8_SHIFT          (0x00000008u)
#define CSL_DMAX_DEER_EE8_RESETVAL       (0x00000000u)

/*----EE8 Tokens----*/
#define CSL_DMAX_DEER_EE8_ENABLE         (0x00000001u)

#define CSL_DMAX_DEER_EE7_MASK           (0x00000080u)
#define CSL_DMAX_DEER_EE7_SHIFT          (0x00000007u)
#define CSL_DMAX_DEER_EE7_RESETVAL       (0x00000000u)

/*----EE7 Tokens----*/
#define CSL_DMAX_DEER_EE7_ENABLE         (0x00000001u)

#define CSL_DMAX_DEER_EE6_MASK           (0x00000040u)
#define CSL_DMAX_DEER_EE6_SHIFT          (0x00000006u)
#define CSL_DMAX_DEER_EE6_RESETVAL       (0x00000000u)

/*----EE6 Tokens----*/
#define CSL_DMAX_DEER_EE6_ENABLE         (0x00000001u)

#define CSL_DMAX_DEER_EE5_MASK           (0x00000020u)
#define CSL_DMAX_DEER_EE5_SHIFT          (0x00000005u)
#define CSL_DMAX_DEER_EE5_RESETVAL       (0x00000000u)

/*----EE5 Tokens----*/
#define CSL_DMAX_DEER_EE5_ENABLE         (0x00000001u)

#define CSL_DMAX_DEER_EE4_MASK           (0x00000010u)
#define CSL_DMAX_DEER_EE4_SHIFT          (0x00000004u)
#define CSL_DMAX_DEER_EE4_RESETVAL       (0x00000000u)

/*----EE4 Tokens----*/
#define CSL_DMAX_DEER_EE4_ENABLE         (0x00000001u)

#define CSL_DMAX_DEER_EE3_MASK           (0x00000008u)
#define CSL_DMAX_DEER_EE3_SHIFT          (0x00000003u)
#define CSL_DMAX_DEER_EE3_RESETVAL       (0x00000000u)

/*----EE3 Tokens----*/
#define CSL_DMAX_DEER_EE3_ENABLE         (0x00000001u)

#define CSL_DMAX_DEER_EE2_MASK           (0x00000004u)
#define CSL_DMAX_DEER_EE2_SHIFT          (0x00000002u)
#define CSL_DMAX_DEER_EE2_RESETVAL       (0x00000000u)

/*----EE2 Tokens----*/
#define CSL_DMAX_DEER_EE2_ENABLE         (0x00000001u)

#define CSL_DMAX_DEER_EE1_MASK           (0x00000002u)
#define CSL_DMAX_DEER_EE1_SHIFT          (0x00000001u)
#define CSL_DMAX_DEER_EE1_RESETVAL       (0x00000000u)

/*----EE1 Tokens----*/
#define CSL_DMAX_DEER_EE1_ENABLE         (0x00000001u)

#define CSL_DMAX_DEER_EE0_MASK           (0x00000001u)
#define CSL_DMAX_DEER_EE0_SHIFT          (0x00000000u)
#define CSL_DMAX_DEER_EE0_RESETVAL       (0x00000000u)

/*----EE0 Tokens----*/
#define CSL_DMAX_DEER_EE0_ENABLE         (0x00000001u)

#define CSL_DMAX_DEER_RESETVAL           (0x00000000u)

/* DEDR */

#define CSL_DMAX_DEDR_ED31_MASK          (0x80000000u)
#define CSL_DMAX_DEDR_ED31_SHIFT         (0x0000001Fu)
#define CSL_DMAX_DEDR_ED31_RESETVAL      (0x00000000u)

/*----ED31 Tokens----*/
#define CSL_DMAX_DEDR_ED31_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED30_MASK          (0x40000000u)
#define CSL_DMAX_DEDR_ED30_SHIFT         (0x0000001Eu)
#define CSL_DMAX_DEDR_ED30_RESETVAL      (0x00000000u)

/*----ED30 Tokens----*/
#define CSL_DMAX_DEDR_ED30_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED29_MASK          (0x20000000u)
#define CSL_DMAX_DEDR_ED29_SHIFT         (0x0000001Du)
#define CSL_DMAX_DEDR_ED29_RESETVAL      (0x00000000u)

/*----ED29 Tokens----*/
#define CSL_DMAX_DEDR_ED29_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED28_MASK          (0x10000000u)
#define CSL_DMAX_DEDR_ED28_SHIFT         (0x0000001Cu)
#define CSL_DMAX_DEDR_ED28_RESETVAL      (0x00000000u)

/*----ED28 Tokens----*/
#define CSL_DMAX_DEDR_ED28_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED27_MASK          (0x08000000u)
#define CSL_DMAX_DEDR_ED27_SHIFT         (0x0000001Bu)
#define CSL_DMAX_DEDR_ED27_RESETVAL      (0x00000000u)

/*----ED27 Tokens----*/
#define CSL_DMAX_DEDR_ED27_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED26_MASK          (0x04000000u)
#define CSL_DMAX_DEDR_ED26_SHIFT         (0x0000001Au)
#define CSL_DMAX_DEDR_ED26_RESETVAL      (0x00000000u)

/*----ED26 Tokens----*/
#define CSL_DMAX_DEDR_ED26_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED24_MASK          (0x01000000u)
#define CSL_DMAX_DEDR_ED24_SHIFT         (0x00000018u)
#define CSL_DMAX_DEDR_ED24_RESETVAL      (0x00000000u)

/*----ED24 Tokens----*/
#define CSL_DMAX_DEDR_ED24_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED23_MASK          (0x00800000u)
#define CSL_DMAX_DEDR_ED23_SHIFT         (0x00000017u)
#define CSL_DMAX_DEDR_ED23_RESETVAL      (0x00000000u)

/*----ED23 Tokens----*/
#define CSL_DMAX_DEDR_ED23_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED22_MASK          (0x00400000u)
#define CSL_DMAX_DEDR_ED22_SHIFT         (0x00000016u)
#define CSL_DMAX_DEDR_ED22_RESETVAL      (0x00000000u)

/*----ED22 Tokens----*/
#define CSL_DMAX_DEDR_ED22_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED21_MASK          (0x00200000u)
#define CSL_DMAX_DEDR_ED21_SHIFT         (0x00000015u)
#define CSL_DMAX_DEDR_ED21_RESETVAL      (0x00000000u)

/*----ED21 Tokens----*/
#define CSL_DMAX_DEDR_ED21_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED20_MASK          (0x00100000u)
#define CSL_DMAX_DEDR_ED20_SHIFT         (0x00000014u)
#define CSL_DMAX_DEDR_ED20_RESETVAL      (0x00000000u)

/*----ED20 Tokens----*/
#define CSL_DMAX_DEDR_ED20_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED19_MASK          (0x00080000u)
#define CSL_DMAX_DEDR_ED19_SHIFT         (0x00000013u)
#define CSL_DMAX_DEDR_ED19_RESETVAL      (0x00000000u)

/*----ED19 Tokens----*/
#define CSL_DMAX_DEDR_ED19_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED18_MASK          (0x00040000u)
#define CSL_DMAX_DEDR_ED18_SHIFT         (0x00000012u)
#define CSL_DMAX_DEDR_ED18_RESETVAL      (0x00000000u)

/*----ED18 Tokens----*/
#define CSL_DMAX_DEDR_ED18_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED17_MASK          (0x00020000u)
#define CSL_DMAX_DEDR_ED17_SHIFT         (0x00000011u)
#define CSL_DMAX_DEDR_ED17_RESETVAL      (0x00000000u)

/*----ED17 Tokens----*/
#define CSL_DMAX_DEDR_ED17_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED16_MASK          (0x00010000u)
#define CSL_DMAX_DEDR_ED16_SHIFT         (0x00000010u)
#define CSL_DMAX_DEDR_ED16_RESETVAL      (0x00000000u)

/*----ED16 Tokens----*/
#define CSL_DMAX_DEDR_ED16_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED15_MASK          (0x00008000u)
#define CSL_DMAX_DEDR_ED15_SHIFT         (0x0000000Fu)
#define CSL_DMAX_DEDR_ED15_RESETVAL      (0x00000000u)

/*----ED15 Tokens----*/
#define CSL_DMAX_DEDR_ED15_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED14_MASK          (0x00004000u)
#define CSL_DMAX_DEDR_ED14_SHIFT         (0x0000000Eu)
#define CSL_DMAX_DEDR_ED14_RESETVAL      (0x00000000u)

/*----ED14 Tokens----*/
#define CSL_DMAX_DEDR_ED14_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED13_MASK          (0x00002000u)
#define CSL_DMAX_DEDR_ED13_SHIFT         (0x0000000Du)
#define CSL_DMAX_DEDR_ED13_RESETVAL      (0x00000000u)

/*----ED13 Tokens----*/
#define CSL_DMAX_DEDR_ED13_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED12_MASK          (0x00001000u)
#define CSL_DMAX_DEDR_ED12_SHIFT         (0x0000000Cu)
#define CSL_DMAX_DEDR_ED12_RESETVAL      (0x00000000u)

/*----ED12 Tokens----*/
#define CSL_DMAX_DEDR_ED12_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED11_MASK          (0x00000800u)
#define CSL_DMAX_DEDR_ED11_SHIFT         (0x0000000Bu)
#define CSL_DMAX_DEDR_ED11_RESETVAL      (0x00000000u)

/*----ED11 Tokens----*/
#define CSL_DMAX_DEDR_ED11_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED10_MASK          (0x00000400u)
#define CSL_DMAX_DEDR_ED10_SHIFT         (0x0000000Au)
#define CSL_DMAX_DEDR_ED10_RESETVAL      (0x00000000u)

/*----ED10 Tokens----*/
#define CSL_DMAX_DEDR_ED10_DISABLE       (0x00000001u)

#define CSL_DMAX_DEDR_ED9_MASK           (0x00000200u)
#define CSL_DMAX_DEDR_ED9_SHIFT          (0x00000009u)
#define CSL_DMAX_DEDR_ED9_RESETVAL       (0x00000000u)

/*----ED9 Tokens----*/
#define CSL_DMAX_DEDR_ED9_DISABLE        (0x00000001u)

#define CSL_DMAX_DEDR_ED8_MASK           (0x00000100u)
#define CSL_DMAX_DEDR_ED8_SHIFT          (0x00000008u)
#define CSL_DMAX_DEDR_ED8_RESETVAL       (0x00000000u)

/*----ED8 Tokens----*/
#define CSL_DMAX_DEDR_ED8_DISABLE        (0x00000001u)

#define CSL_DMAX_DEDR_ED7_MASK           (0x00000080u)
#define CSL_DMAX_DEDR_ED7_SHIFT          (0x00000007u)
#define CSL_DMAX_DEDR_ED7_RESETVAL       (0x00000000u)

/*----ED7 Tokens----*/
#define CSL_DMAX_DEDR_ED7_DISABLE        (0x00000001u)

#define CSL_DMAX_DEDR_ED6_MASK           (0x00000040u)
#define CSL_DMAX_DEDR_ED6_SHIFT          (0x00000006u)
#define CSL_DMAX_DEDR_ED6_RESETVAL       (0x00000000u)

/*----ED6 Tokens----*/
#define CSL_DMAX_DEDR_ED6_DISABLE        (0x00000001u)

#define CSL_DMAX_DEDR_ED5_MASK           (0x00000020u)
#define CSL_DMAX_DEDR_ED5_SHIFT          (0x00000005u)
#define CSL_DMAX_DEDR_ED5_RESETVAL       (0x00000000u)

/*----ED5 Tokens----*/
#define CSL_DMAX_DEDR_ED5_DISABLE        (0x00000001u)

#define CSL_DMAX_DEDR_ED4_MASK           (0x00000010u)
#define CSL_DMAX_DEDR_ED4_SHIFT          (0x00000004u)
#define CSL_DMAX_DEDR_ED4_RESETVAL       (0x00000000u)

/*----ED4 Tokens----*/
#define CSL_DMAX_DEDR_ED4_DISABLE        (0x00000001u)

#define CSL_DMAX_DEDR_ED3_MASK           (0x00000008u)
#define CSL_DMAX_DEDR_ED3_SHIFT          (0x00000003u)
#define CSL_DMAX_DEDR_ED3_RESETVAL       (0x00000000u)

/*----ED3 Tokens----*/
#define CSL_DMAX_DEDR_ED3_DISABLE        (0x00000001u)

#define CSL_DMAX_DEDR_ED2_MASK           (0x00000004u)
#define CSL_DMAX_DEDR_ED2_SHIFT          (0x00000002u)
#define CSL_DMAX_DEDR_ED2_RESETVAL       (0x00000000u)

/*----ED2 Tokens----*/
#define CSL_DMAX_DEDR_ED2_DISABLE        (0x00000001u)

#define CSL_DMAX_DEDR_ED1_MASK           (0x00000002u)
#define CSL_DMAX_DEDR_ED1_SHIFT          (0x00000001u)
#define CSL_DMAX_DEDR_ED1_RESETVAL       (0x00000000u)

/*----ED1 Tokens----*/
#define CSL_DMAX_DEDR_ED1_DISABLE        (0x00000001u)

#define CSL_DMAX_DEDR_ED0_MASK           (0x00000001u)
#define CSL_DMAX_DEDR_ED0_SHIFT          (0x00000000u)
#define CSL_DMAX_DEDR_ED0_RESETVAL       (0x00000000u)

/*----ED0 Tokens----*/
#define CSL_DMAX_DEDR_ED0_DISABLE        (0x00000001u)

#define CSL_DMAX_DEDR_RESETVAL           (0x00000000u)

/* DEHPR */

#define CSL_DMAX_DEHPR_EHP31_MASK        (0x80000000u)
#define CSL_DMAX_DEHPR_EHP31_SHIFT       (0x0000001Fu)
#define CSL_DMAX_DEHPR_EHP31_RESETVAL    (0x00000000u)

/*----EHP31 Tokens----*/
#define CSL_DMAX_DEHPR_EHP31_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP30_MASK        (0x40000000u)
#define CSL_DMAX_DEHPR_EHP30_SHIFT       (0x0000001Eu)
#define CSL_DMAX_DEHPR_EHP30_RESETVAL    (0x00000000u)

/*----EHP30 Tokens----*/
#define CSL_DMAX_DEHPR_EHP30_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP29_MASK        (0x20000000u)
#define CSL_DMAX_DEHPR_EHP29_SHIFT       (0x0000001Du)
#define CSL_DMAX_DEHPR_EHP29_RESETVAL    (0x00000000u)

/*----EHP29 Tokens----*/
#define CSL_DMAX_DEHPR_EHP29_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP28_MASK        (0x10000000u)
#define CSL_DMAX_DEHPR_EHP28_SHIFT       (0x0000001Cu)
#define CSL_DMAX_DEHPR_EHP28_RESETVAL    (0x00000000u)

/*----EHP28 Tokens----*/
#define CSL_DMAX_DEHPR_EHP28_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP27_MASK        (0x08000000u)
#define CSL_DMAX_DEHPR_EHP27_SHIFT       (0x0000001Bu)
#define CSL_DMAX_DEHPR_EHP27_RESETVAL    (0x00000000u)

/*----EHP27 Tokens----*/
#define CSL_DMAX_DEHPR_EHP27_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP26_MASK        (0x04000000u)
#define CSL_DMAX_DEHPR_EHP26_SHIFT       (0x0000001Au)
#define CSL_DMAX_DEHPR_EHP26_RESETVAL    (0x00000000u)

/*----EHP26 Tokens----*/
#define CSL_DMAX_DEHPR_EHP26_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP24_MASK        (0x01000000u)
#define CSL_DMAX_DEHPR_EHP24_SHIFT       (0x00000018u)
#define CSL_DMAX_DEHPR_EHP24_RESETVAL    (0x00000000u)

/*----EHP24 Tokens----*/
#define CSL_DMAX_DEHPR_EHP24_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP23_MASK        (0x00800000u)
#define CSL_DMAX_DEHPR_EHP23_SHIFT       (0x00000017u)
#define CSL_DMAX_DEHPR_EHP23_RESETVAL    (0x00000000u)

/*----EHP23 Tokens----*/
#define CSL_DMAX_DEHPR_EHP23_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP22_MASK        (0x00400000u)
#define CSL_DMAX_DEHPR_EHP22_SHIFT       (0x00000016u)
#define CSL_DMAX_DEHPR_EHP22_RESETVAL    (0x00000000u)

/*----EHP22 Tokens----*/
#define CSL_DMAX_DEHPR_EHP22_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP21_MASK        (0x00200000u)
#define CSL_DMAX_DEHPR_EHP21_SHIFT       (0x00000015u)
#define CSL_DMAX_DEHPR_EHP21_RESETVAL    (0x00000000u)

/*----EHP21 Tokens----*/
#define CSL_DMAX_DEHPR_EHP21_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP20_MASK        (0x00100000u)
#define CSL_DMAX_DEHPR_EHP20_SHIFT       (0x00000014u)
#define CSL_DMAX_DEHPR_EHP20_RESETVAL    (0x00000000u)

/*----EHP20 Tokens----*/
#define CSL_DMAX_DEHPR_EHP20_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP19_MASK        (0x00080000u)
#define CSL_DMAX_DEHPR_EHP19_SHIFT       (0x00000013u)
#define CSL_DMAX_DEHPR_EHP19_RESETVAL    (0x00000000u)

/*----EHP19 Tokens----*/
#define CSL_DMAX_DEHPR_EHP19_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP18_MASK        (0x00040000u)
#define CSL_DMAX_DEHPR_EHP18_SHIFT       (0x00000012u)
#define CSL_DMAX_DEHPR_EHP18_RESETVAL    (0x00000000u)

/*----EHP18 Tokens----*/
#define CSL_DMAX_DEHPR_EHP18_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP17_MASK        (0x00020000u)
#define CSL_DMAX_DEHPR_EHP17_SHIFT       (0x00000011u)
#define CSL_DMAX_DEHPR_EHP17_RESETVAL    (0x00000000u)

/*----EHP17 Tokens----*/
#define CSL_DMAX_DEHPR_EHP17_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP16_MASK        (0x00010000u)
#define CSL_DMAX_DEHPR_EHP16_SHIFT       (0x00000010u)
#define CSL_DMAX_DEHPR_EHP16_RESETVAL    (0x00000000u)

/*----EHP16 Tokens----*/
#define CSL_DMAX_DEHPR_EHP16_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP15_MASK        (0x00008000u)
#define CSL_DMAX_DEHPR_EHP15_SHIFT       (0x0000000Fu)
#define CSL_DMAX_DEHPR_EHP15_RESETVAL    (0x00000000u)

/*----EHP15 Tokens----*/
#define CSL_DMAX_DEHPR_EHP15_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP14_MASK        (0x00004000u)
#define CSL_DMAX_DEHPR_EHP14_SHIFT       (0x0000000Eu)
#define CSL_DMAX_DEHPR_EHP14_RESETVAL    (0x00000000u)

/*----EHP14 Tokens----*/
#define CSL_DMAX_DEHPR_EHP14_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP13_MASK        (0x00002000u)
#define CSL_DMAX_DEHPR_EHP13_SHIFT       (0x0000000Du)
#define CSL_DMAX_DEHPR_EHP13_RESETVAL    (0x00000000u)

/*----EHP13 Tokens----*/
#define CSL_DMAX_DEHPR_EHP13_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP12_MASK        (0x00001000u)
#define CSL_DMAX_DEHPR_EHP12_SHIFT       (0x0000000Cu)
#define CSL_DMAX_DEHPR_EHP12_RESETVAL    (0x00000000u)

/*----EHP12 Tokens----*/
#define CSL_DMAX_DEHPR_EHP12_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP11_MASK        (0x00000800u)
#define CSL_DMAX_DEHPR_EHP11_SHIFT       (0x0000000Bu)
#define CSL_DMAX_DEHPR_EHP11_RESETVAL    (0x00000000u)

/*----EHP11 Tokens----*/
#define CSL_DMAX_DEHPR_EHP11_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP10_MASK        (0x00000400u)
#define CSL_DMAX_DEHPR_EHP10_SHIFT       (0x0000000Au)
#define CSL_DMAX_DEHPR_EHP10_RESETVAL    (0x00000000u)

/*----EHP10 Tokens----*/
#define CSL_DMAX_DEHPR_EHP10_SET         (0x00000001u)

#define CSL_DMAX_DEHPR_EHP9_MASK         (0x00000200u)
#define CSL_DMAX_DEHPR_EHP9_SHIFT        (0x00000009u)
#define CSL_DMAX_DEHPR_EHP9_RESETVAL     (0x00000000u)

/*----EHP9 Tokens----*/
#define CSL_DMAX_DEHPR_EHP9_SET          (0x00000001u)

#define CSL_DMAX_DEHPR_EHP8_MASK         (0x00000100u)
#define CSL_DMAX_DEHPR_EHP8_SHIFT        (0x00000008u)
#define CSL_DMAX_DEHPR_EHP8_RESETVAL     (0x00000000u)

/*----EHP8 Tokens----*/
#define CSL_DMAX_DEHPR_EHP8_SET          (0x00000001u)

#define CSL_DMAX_DEHPR_EHP7_MASK         (0x00000080u)
#define CSL_DMAX_DEHPR_EHP7_SHIFT        (0x00000007u)
#define CSL_DMAX_DEHPR_EHP7_RESETVAL     (0x00000000u)

/*----EHP7 Tokens----*/
#define CSL_DMAX_DEHPR_EHP7_SET          (0x00000001u)

#define CSL_DMAX_DEHPR_EHP6_MASK         (0x00000040u)
#define CSL_DMAX_DEHPR_EHP6_SHIFT        (0x00000006u)
#define CSL_DMAX_DEHPR_EHP6_RESETVAL     (0x00000000u)

/*----EHP6 Tokens----*/
#define CSL_DMAX_DEHPR_EHP6_SET          (0x00000001u)

#define CSL_DMAX_DEHPR_EHP5_MASK         (0x00000020u)
#define CSL_DMAX_DEHPR_EHP5_SHIFT        (0x00000005u)
#define CSL_DMAX_DEHPR_EHP5_RESETVAL     (0x00000000u)

/*----EHP5 Tokens----*/
#define CSL_DMAX_DEHPR_EHP5_SET          (0x00000001u)

#define CSL_DMAX_DEHPR_EHP4_MASK         (0x00000010u)
#define CSL_DMAX_DEHPR_EHP4_SHIFT        (0x00000004u)
#define CSL_DMAX_DEHPR_EHP4_RESETVAL     (0x00000000u)

/*----EHP4 Tokens----*/
#define CSL_DMAX_DEHPR_EHP4_SET          (0x00000001u)

#define CSL_DMAX_DEHPR_EHP3_MASK         (0x00000008u)
#define CSL_DMAX_DEHPR_EHP3_SHIFT        (0x00000003u)
#define CSL_DMAX_DEHPR_EHP3_RESETVAL     (0x00000000u)

/*----EHP3 Tokens----*/
#define CSL_DMAX_DEHPR_EHP3_SET          (0x00000001u)

#define CSL_DMAX_DEHPR_EHP2_MASK         (0x00000004u)
#define CSL_DMAX_DEHPR_EHP2_SHIFT        (0x00000002u)
#define CSL_DMAX_DEHPR_EHP2_RESETVAL     (0x00000000u)

/*----EHP2 Tokens----*/
#define CSL_DMAX_DEHPR_EHP2_SET          (0x00000001u)

#define CSL_DMAX_DEHPR_EHP1_MASK         (0x00000002u)
#define CSL_DMAX_DEHPR_EHP1_SHIFT        (0x00000001u)
#define CSL_DMAX_DEHPR_EHP1_RESETVAL     (0x00000000u)

/*----EHP1 Tokens----*/
#define CSL_DMAX_DEHPR_EHP1_SET          (0x00000001u)

#define CSL_DMAX_DEHPR_EHP0_MASK         (0x00000001u)
#define CSL_DMAX_DEHPR_EHP0_SHIFT        (0x00000000u)
#define CSL_DMAX_DEHPR_EHP0_RESETVAL     (0x00000000u)

/*----EHP0 Tokens----*/
#define CSL_DMAX_DEHPR_EHP0_SET          (0x00000001u)

#define CSL_DMAX_DEHPR_RESETVAL          (0x00000000u)

/* DELPR */

#define CSL_DMAX_DELPR_ELP31_MASK        (0x80000000u)
#define CSL_DMAX_DELPR_ELP31_SHIFT       (0x0000001Fu)
#define CSL_DMAX_DELPR_ELP31_RESETVAL    (0x00000000u)

/*----ELP31 Tokens----*/
#define CSL_DMAX_DELPR_ELP31_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP30_MASK        (0x40000000u)
#define CSL_DMAX_DELPR_ELP30_SHIFT       (0x0000001Eu)
#define CSL_DMAX_DELPR_ELP30_RESETVAL    (0x00000000u)

/*----ELP30 Tokens----*/
#define CSL_DMAX_DELPR_ELP30_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP29_MASK        (0x20000000u)
#define CSL_DMAX_DELPR_ELP29_SHIFT       (0x0000001Du)
#define CSL_DMAX_DELPR_ELP29_RESETVAL    (0x00000000u)

/*----ELP29 Tokens----*/
#define CSL_DMAX_DELPR_ELP29_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP28_MASK        (0x10000000u)
#define CSL_DMAX_DELPR_ELP28_SHIFT       (0x0000001Cu)
#define CSL_DMAX_DELPR_ELP28_RESETVAL    (0x00000000u)

/*----ELP28 Tokens----*/
#define CSL_DMAX_DELPR_ELP28_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP27_MASK        (0x08000000u)
#define CSL_DMAX_DELPR_ELP27_SHIFT       (0x0000001Bu)
#define CSL_DMAX_DELPR_ELP27_RESETVAL    (0x00000000u)

/*----ELP27 Tokens----*/
#define CSL_DMAX_DELPR_ELP27_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP26_MASK        (0x04000000u)
#define CSL_DMAX_DELPR_ELP26_SHIFT       (0x0000001Au)
#define CSL_DMAX_DELPR_ELP26_RESETVAL    (0x00000000u)

/*----ELP26 Tokens----*/
#define CSL_DMAX_DELPR_ELP26_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP24_MASK        (0x01000000u)
#define CSL_DMAX_DELPR_ELP24_SHIFT       (0x00000018u)
#define CSL_DMAX_DELPR_ELP24_RESETVAL    (0x00000000u)

/*----ELP24 Tokens----*/
#define CSL_DMAX_DELPR_ELP24_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP23_MASK        (0x00800000u)
#define CSL_DMAX_DELPR_ELP23_SHIFT       (0x00000017u)
#define CSL_DMAX_DELPR_ELP23_RESETVAL    (0x00000000u)

/*----ELP23 Tokens----*/
#define CSL_DMAX_DELPR_ELP23_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP22_MASK        (0x00400000u)
#define CSL_DMAX_DELPR_ELP22_SHIFT       (0x00000016u)
#define CSL_DMAX_DELPR_ELP22_RESETVAL    (0x00000000u)

/*----ELP22 Tokens----*/
#define CSL_DMAX_DELPR_ELP22_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP21_MASK        (0x00200000u)
#define CSL_DMAX_DELPR_ELP21_SHIFT       (0x00000015u)
#define CSL_DMAX_DELPR_ELP21_RESETVAL    (0x00000000u)

/*----ELP21 Tokens----*/
#define CSL_DMAX_DELPR_ELP21_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP20_MASK        (0x00100000u)
#define CSL_DMAX_DELPR_ELP20_SHIFT       (0x00000014u)
#define CSL_DMAX_DELPR_ELP20_RESETVAL    (0x00000000u)

/*----ELP20 Tokens----*/
#define CSL_DMAX_DELPR_ELP20_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP19_MASK        (0x00080000u)
#define CSL_DMAX_DELPR_ELP19_SHIFT       (0x00000013u)
#define CSL_DMAX_DELPR_ELP19_RESETVAL    (0x00000000u)

/*----ELP19 Tokens----*/
#define CSL_DMAX_DELPR_ELP19_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP18_MASK        (0x00040000u)
#define CSL_DMAX_DELPR_ELP18_SHIFT       (0x00000012u)
#define CSL_DMAX_DELPR_ELP18_RESETVAL    (0x00000000u)

/*----ELP18 Tokens----*/
#define CSL_DMAX_DELPR_ELP18_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP17_MASK        (0x00020000u)
#define CSL_DMAX_DELPR_ELP17_SHIFT       (0x00000011u)
#define CSL_DMAX_DELPR_ELP17_RESETVAL    (0x00000000u)

/*----ELP17 Tokens----*/
#define CSL_DMAX_DELPR_ELP17_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP16_MASK        (0x00010000u)
#define CSL_DMAX_DELPR_ELP16_SHIFT       (0x00000010u)
#define CSL_DMAX_DELPR_ELP16_RESETVAL    (0x00000000u)

/*----ELP16 Tokens----*/
#define CSL_DMAX_DELPR_ELP16_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP15_MASK        (0x00008000u)
#define CSL_DMAX_DELPR_ELP15_SHIFT       (0x0000000Fu)
#define CSL_DMAX_DELPR_ELP15_RESETVAL    (0x00000000u)

/*----ELP15 Tokens----*/
#define CSL_DMAX_DELPR_ELP15_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP14_MASK        (0x00004000u)
#define CSL_DMAX_DELPR_ELP14_SHIFT       (0x0000000Eu)
#define CSL_DMAX_DELPR_ELP14_RESETVAL    (0x00000000u)

/*----ELP14 Tokens----*/
#define CSL_DMAX_DELPR_ELP14_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP13_MASK        (0x00002000u)
#define CSL_DMAX_DELPR_ELP13_SHIFT       (0x0000000Du)
#define CSL_DMAX_DELPR_ELP13_RESETVAL    (0x00000000u)

/*----ELP13 Tokens----*/
#define CSL_DMAX_DELPR_ELP13_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP12_MASK        (0x00001000u)
#define CSL_DMAX_DELPR_ELP12_SHIFT       (0x0000000Cu)
#define CSL_DMAX_DELPR_ELP12_RESETVAL    (0x00000000u)

/*----ELP12 Tokens----*/
#define CSL_DMAX_DELPR_ELP12_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP11_MASK        (0x00000800u)
#define CSL_DMAX_DELPR_ELP11_SHIFT       (0x0000000Bu)
#define CSL_DMAX_DELPR_ELP11_RESETVAL    (0x00000000u)

/*----ELP11 Tokens----*/
#define CSL_DMAX_DELPR_ELP11_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP10_MASK        (0x00000400u)
#define CSL_DMAX_DELPR_ELP10_SHIFT       (0x0000000Au)
#define CSL_DMAX_DELPR_ELP10_RESETVAL    (0x00000000u)

/*----ELP10 Tokens----*/
#define CSL_DMAX_DELPR_ELP10_SET         (0x00000001u)

#define CSL_DMAX_DELPR_ELP9_MASK         (0x00000200u)
#define CSL_DMAX_DELPR_ELP9_SHIFT        (0x00000009u)
#define CSL_DMAX_DELPR_ELP9_RESETVAL     (0x00000000u)

/*----ELP9 Tokens----*/
#define CSL_DMAX_DELPR_ELP9_SET          (0x00000001u)

#define CSL_DMAX_DELPR_ELP8_MASK         (0x00000100u)
#define CSL_DMAX_DELPR_ELP8_SHIFT        (0x00000008u)
#define CSL_DMAX_DELPR_ELP8_RESETVAL     (0x00000000u)

/*----ELP8 Tokens----*/
#define CSL_DMAX_DELPR_ELP8_SET          (0x00000001u)

#define CSL_DMAX_DELPR_ELP7_MASK         (0x00000080u)
#define CSL_DMAX_DELPR_ELP7_SHIFT        (0x00000007u)
#define CSL_DMAX_DELPR_ELP7_RESETVAL     (0x00000000u)

/*----ELP7 Tokens----*/
#define CSL_DMAX_DELPR_ELP7_SET          (0x00000001u)

#define CSL_DMAX_DELPR_ELP6_MASK         (0x00000040u)
#define CSL_DMAX_DELPR_ELP6_SHIFT        (0x00000006u)
#define CSL_DMAX_DELPR_ELP6_RESETVAL     (0x00000000u)

/*----ELP6 Tokens----*/
#define CSL_DMAX_DELPR_ELP6_SET          (0x00000001u)

#define CSL_DMAX_DELPR_ELP5_MASK         (0x00000020u)
#define CSL_DMAX_DELPR_ELP5_SHIFT        (0x00000005u)
#define CSL_DMAX_DELPR_ELP5_RESETVAL     (0x00000000u)

/*----ELP5 Tokens----*/
#define CSL_DMAX_DELPR_ELP5_SET          (0x00000001u)

#define CSL_DMAX_DELPR_ELP4_MASK         (0x00000010u)
#define CSL_DMAX_DELPR_ELP4_SHIFT        (0x00000004u)
#define CSL_DMAX_DELPR_ELP4_RESETVAL     (0x00000000u)

/*----ELP4 Tokens----*/
#define CSL_DMAX_DELPR_ELP4_SET          (0x00000001u)

#define CSL_DMAX_DELPR_ELP3_MASK         (0x00000008u)
#define CSL_DMAX_DELPR_ELP3_SHIFT        (0x00000003u)
#define CSL_DMAX_DELPR_ELP3_RESETVAL     (0x00000000u)

/*----ELP3 Tokens----*/
#define CSL_DMAX_DELPR_ELP3_SET          (0x00000001u)

#define CSL_DMAX_DELPR_ELP2_MASK         (0x00000004u)
#define CSL_DMAX_DELPR_ELP2_SHIFT        (0x00000002u)
#define CSL_DMAX_DELPR_ELP2_RESETVAL     (0x00000000u)

/*----ELP2 Tokens----*/
#define CSL_DMAX_DELPR_ELP2_SET          (0x00000001u)

#define CSL_DMAX_DELPR_ELP1_MASK         (0x00000002u)
#define CSL_DMAX_DELPR_ELP1_SHIFT        (0x00000001u)
#define CSL_DMAX_DELPR_ELP1_RESETVAL     (0x00000000u)

/*----ELP1 Tokens----*/
#define CSL_DMAX_DELPR_ELP1_SET          (0x00000001u)

#define CSL_DMAX_DELPR_ELP0_MASK         (0x00000001u)
#define CSL_DMAX_DELPR_ELP0_SHIFT        (0x00000000u)
#define CSL_DMAX_DELPR_ELP0_RESETVAL     (0x00000000u)

/*----ELP0 Tokens----*/
#define CSL_DMAX_DELPR_ELP0_SET          (0x00000001u)

#define CSL_DMAX_DELPR_RESETVAL          (0x00000000u)

/* DEFR */

#define CSL_DMAX_DEFR_EF31_MASK          (0x80000000u)
#define CSL_DMAX_DEFR_EF31_SHIFT         (0x0000001Fu)
#define CSL_DMAX_DEFR_EF31_RESETVAL      (0x00000000u)

/*----EF31 Tokens----*/
#define CSL_DMAX_DEFR_EF31_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF30_MASK          (0x40000000u)
#define CSL_DMAX_DEFR_EF30_SHIFT         (0x0000001Eu)
#define CSL_DMAX_DEFR_EF30_RESETVAL      (0x00000000u)

/*----EF30 Tokens----*/
#define CSL_DMAX_DEFR_EF30_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF29_MASK          (0x20000000u)
#define CSL_DMAX_DEFR_EF29_SHIFT         (0x0000001Du)
#define CSL_DMAX_DEFR_EF29_RESETVAL      (0x00000000u)

/*----EF29 Tokens----*/
#define CSL_DMAX_DEFR_EF29_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF28_MASK          (0x10000000u)
#define CSL_DMAX_DEFR_EF28_SHIFT         (0x0000001Cu)
#define CSL_DMAX_DEFR_EF28_RESETVAL      (0x00000000u)

/*----EF28 Tokens----*/
#define CSL_DMAX_DEFR_EF28_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF27_MASK          (0x08000000u)
#define CSL_DMAX_DEFR_EF27_SHIFT         (0x0000001Bu)
#define CSL_DMAX_DEFR_EF27_RESETVAL      (0x00000000u)

/*----EF27 Tokens----*/
#define CSL_DMAX_DEFR_EF27_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF26_MASK          (0x04000000u)
#define CSL_DMAX_DEFR_EF26_SHIFT         (0x0000001Au)
#define CSL_DMAX_DEFR_EF26_RESETVAL      (0x00000000u)

/*----EF26 Tokens----*/
#define CSL_DMAX_DEFR_EF26_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF24_MASK          (0x01000000u)
#define CSL_DMAX_DEFR_EF24_SHIFT         (0x00000018u)
#define CSL_DMAX_DEFR_EF24_RESETVAL      (0x00000000u)

/*----EF24 Tokens----*/
#define CSL_DMAX_DEFR_EF24_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF23_MASK          (0x00800000u)
#define CSL_DMAX_DEFR_EF23_SHIFT         (0x00000017u)
#define CSL_DMAX_DEFR_EF23_RESETVAL      (0x00000000u)

/*----EF23 Tokens----*/
#define CSL_DMAX_DEFR_EF23_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF22_MASK          (0x00400000u)
#define CSL_DMAX_DEFR_EF22_SHIFT         (0x00000016u)
#define CSL_DMAX_DEFR_EF22_RESETVAL      (0x00000000u)

/*----EF22 Tokens----*/
#define CSL_DMAX_DEFR_EF22_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF21_MASK          (0x00200000u)
#define CSL_DMAX_DEFR_EF21_SHIFT         (0x00000015u)
#define CSL_DMAX_DEFR_EF21_RESETVAL      (0x00000000u)

/*----EF21 Tokens----*/
#define CSL_DMAX_DEFR_EF21_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF20_MASK          (0x00100000u)
#define CSL_DMAX_DEFR_EF20_SHIFT         (0x00000014u)
#define CSL_DMAX_DEFR_EF20_RESETVAL      (0x00000000u)

/*----EF20 Tokens----*/
#define CSL_DMAX_DEFR_EF20_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF19_MASK          (0x00080000u)
#define CSL_DMAX_DEFR_EF19_SHIFT         (0x00000013u)
#define CSL_DMAX_DEFR_EF19_RESETVAL      (0x00000000u)

/*----EF19 Tokens----*/
#define CSL_DMAX_DEFR_EF19_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF18_MASK          (0x00040000u)
#define CSL_DMAX_DEFR_EF18_SHIFT         (0x00000012u)
#define CSL_DMAX_DEFR_EF18_RESETVAL      (0x00000000u)

/*----EF18 Tokens----*/
#define CSL_DMAX_DEFR_EF18_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF17_MASK          (0x00020000u)
#define CSL_DMAX_DEFR_EF17_SHIFT         (0x00000011u)
#define CSL_DMAX_DEFR_EF17_RESETVAL      (0x00000000u)

/*----EF17 Tokens----*/
#define CSL_DMAX_DEFR_EF17_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF16_MASK          (0x00010000u)
#define CSL_DMAX_DEFR_EF16_SHIFT         (0x00000010u)
#define CSL_DMAX_DEFR_EF16_RESETVAL      (0x00000000u)

/*----EF16 Tokens----*/
#define CSL_DMAX_DEFR_EF16_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF15_MASK          (0x00008000u)
#define CSL_DMAX_DEFR_EF15_SHIFT         (0x0000000Fu)
#define CSL_DMAX_DEFR_EF15_RESETVAL      (0x00000000u)

/*----EF15 Tokens----*/
#define CSL_DMAX_DEFR_EF15_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF14_MASK          (0x00004000u)
#define CSL_DMAX_DEFR_EF14_SHIFT         (0x0000000Eu)
#define CSL_DMAX_DEFR_EF14_RESETVAL      (0x00000000u)

/*----EF14 Tokens----*/
#define CSL_DMAX_DEFR_EF14_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF13_MASK          (0x00002000u)
#define CSL_DMAX_DEFR_EF13_SHIFT         (0x0000000Du)
#define CSL_DMAX_DEFR_EF13_RESETVAL      (0x00000000u)

/*----EF13 Tokens----*/
#define CSL_DMAX_DEFR_EF13_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF12_MASK          (0x00001000u)
#define CSL_DMAX_DEFR_EF12_SHIFT         (0x0000000Cu)
#define CSL_DMAX_DEFR_EF12_RESETVAL      (0x00000000u)

/*----EF12 Tokens----*/
#define CSL_DMAX_DEFR_EF12_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF11_MASK          (0x00000800u)
#define CSL_DMAX_DEFR_EF11_SHIFT         (0x0000000Bu)
#define CSL_DMAX_DEFR_EF11_RESETVAL      (0x00000000u)

/*----EF11 Tokens----*/
#define CSL_DMAX_DEFR_EF11_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF10_MASK          (0x00000400u)
#define CSL_DMAX_DEFR_EF10_SHIFT         (0x0000000Au)
#define CSL_DMAX_DEFR_EF10_RESETVAL      (0x00000000u)

/*----EF10 Tokens----*/
#define CSL_DMAX_DEFR_EF10_CLEAR         (0x00000001u)

#define CSL_DMAX_DEFR_EF9_MASK           (0x00000200u)
#define CSL_DMAX_DEFR_EF9_SHIFT          (0x00000009u)
#define CSL_DMAX_DEFR_EF9_RESETVAL       (0x00000000u)

/*----EF9 Tokens----*/
#define CSL_DMAX_DEFR_EF9_CLEAR          (0x00000001u)

#define CSL_DMAX_DEFR_EF8_MASK           (0x00000100u)
#define CSL_DMAX_DEFR_EF8_SHIFT          (0x00000008u)
#define CSL_DMAX_DEFR_EF8_RESETVAL       (0x00000000u)

/*----EF8 Tokens----*/
#define CSL_DMAX_DEFR_EF8_CLEAR          (0x00000001u)

#define CSL_DMAX_DEFR_EF7_MASK           (0x00000080u)
#define CSL_DMAX_DEFR_EF7_SHIFT          (0x00000007u)
#define CSL_DMAX_DEFR_EF7_RESETVAL       (0x00000000u)

/*----EF7 Tokens----*/
#define CSL_DMAX_DEFR_EF7_CLEAR          (0x00000001u)

#define CSL_DMAX_DEFR_EF6_MASK           (0x00000040u)
#define CSL_DMAX_DEFR_EF6_SHIFT          (0x00000006u)
#define CSL_DMAX_DEFR_EF6_RESETVAL       (0x00000000u)

/*----EF6 Tokens----*/
#define CSL_DMAX_DEFR_EF6_CLEAR          (0x00000001u)

#define CSL_DMAX_DEFR_EF5_MASK           (0x00000020u)
#define CSL_DMAX_DEFR_EF5_SHIFT          (0x00000005u)
#define CSL_DMAX_DEFR_EF5_RESETVAL       (0x00000000u)

/*----EF5 Tokens----*/
#define CSL_DMAX_DEFR_EF5_CLEAR          (0x00000001u)

#define CSL_DMAX_DEFR_EF4_MASK           (0x00000010u)
#define CSL_DMAX_DEFR_EF4_SHIFT          (0x00000004u)
#define CSL_DMAX_DEFR_EF4_RESETVAL       (0x00000000u)

/*----EF4 Tokens----*/
#define CSL_DMAX_DEFR_EF4_CLEAR          (0x00000001u)

#define CSL_DMAX_DEFR_EF3_MASK           (0x00000008u)
#define CSL_DMAX_DEFR_EF3_SHIFT          (0x00000003u)
#define CSL_DMAX_DEFR_EF3_RESETVAL       (0x00000000u)

/*----EF3 Tokens----*/
#define CSL_DMAX_DEFR_EF3_CLEAR          (0x00000001u)

#define CSL_DMAX_DEFR_EF2_MASK           (0x00000004u)
#define CSL_DMAX_DEFR_EF2_SHIFT          (0x00000002u)
#define CSL_DMAX_DEFR_EF2_RESETVAL       (0x00000000u)

/*----EF2 Tokens----*/
#define CSL_DMAX_DEFR_EF2_CLEAR          (0x00000001u)

#define CSL_DMAX_DEFR_EF1_MASK           (0x00000002u)
#define CSL_DMAX_DEFR_EF1_SHIFT          (0x00000001u)
#define CSL_DMAX_DEFR_EF1_RESETVAL       (0x00000000u)

/*----EF1 Tokens----*/
#define CSL_DMAX_DEFR_EF1_CLEAR          (0x00000001u)

#define CSL_DMAX_DEFR_EF0_MASK           (0x00000001u)
#define CSL_DMAX_DEFR_EF0_SHIFT          (0x00000000u)
#define CSL_DMAX_DEFR_EF0_RESETVAL       (0x00000000u)

/*----EF0 Tokens----*/
#define CSL_DMAX_DEFR_EF0_CLEAR          (0x00000001u)

#define CSL_DMAX_DEFR_RESETVAL           (0x00000000u)

/* DFSR0 */

#define CSL_DMAX_DFSR0_FSC7_MASK         (0x00000080u)
#define CSL_DMAX_DFSR0_FSC7_SHIFT        (0x00000007u)
#define CSL_DMAX_DFSR0_FSC7_RESETVAL     (0x00000000u)

/*----FSC7 Tokens----*/
#define CSL_DMAX_DFSR0_FSC7_CLEAR        (0x00000001u)

#define CSL_DMAX_DFSR0_FSC6_MASK         (0x00000040u)
#define CSL_DMAX_DFSR0_FSC6_SHIFT        (0x00000006u)
#define CSL_DMAX_DFSR0_FSC6_RESETVAL     (0x00000000u)

/*----FSC6 Tokens----*/
#define CSL_DMAX_DFSR0_FSC6_CLEAR        (0x00000001u)

#define CSL_DMAX_DFSR0_FSC5_MASK         (0x00000020u)
#define CSL_DMAX_DFSR0_FSC5_SHIFT        (0x00000005u)
#define CSL_DMAX_DFSR0_FSC5_RESETVAL     (0x00000000u)

/*----FSC5 Tokens----*/
#define CSL_DMAX_DFSR0_FSC5_CLEAR        (0x00000001u)

#define CSL_DMAX_DFSR0_FSC4_MASK         (0x00000010u)
#define CSL_DMAX_DFSR0_FSC4_SHIFT        (0x00000004u)
#define CSL_DMAX_DFSR0_FSC4_RESETVAL     (0x00000000u)

/*----FSC4 Tokens----*/
#define CSL_DMAX_DFSR0_FSC4_CLEAR        (0x00000001u)

#define CSL_DMAX_DFSR0_FSC3_MASK         (0x00000008u)
#define CSL_DMAX_DFSR0_FSC3_SHIFT        (0x00000003u)
#define CSL_DMAX_DFSR0_FSC3_RESETVAL     (0x00000000u)

/*----FSC3 Tokens----*/
#define CSL_DMAX_DFSR0_FSC3_CLEAR        (0x00000001u)

#define CSL_DMAX_DFSR0_FSC2_MASK         (0x00000004u)
#define CSL_DMAX_DFSR0_FSC2_SHIFT        (0x00000002u)
#define CSL_DMAX_DFSR0_FSC2_RESETVAL     (0x00000000u)

/*----FSC2 Tokens----*/
#define CSL_DMAX_DFSR0_FSC2_CLEAR        (0x00000001u)

#define CSL_DMAX_DFSR0_FSC1_MASK         (0x00000002u)
#define CSL_DMAX_DFSR0_FSC1_SHIFT        (0x00000001u)
#define CSL_DMAX_DFSR0_FSC1_RESETVAL     (0x00000000u)

/*----FSC1 Tokens----*/
#define CSL_DMAX_DFSR0_FSC1_CLEAR        (0x00000001u)

#define CSL_DMAX_DFSR0_FSC0_MASK         (0x00000001u)
#define CSL_DMAX_DFSR0_FSC0_SHIFT        (0x00000000u)
#define CSL_DMAX_DFSR0_FSC0_RESETVAL     (0x00000000u)

/*----FSC0 Tokens----*/
#define CSL_DMAX_DFSR0_FSC0_CLEAR        (0x00000001u)

#define CSL_DMAX_DFSR0_RESETVAL          (0x00000000u)

/* DFSR1 */

#define CSL_DMAX_DFSR1_FSC15_MASK        (0x00000080u)
#define CSL_DMAX_DFSR1_FSC15_SHIFT       (0x00000007u)
#define CSL_DMAX_DFSR1_FSC15_RESETVAL    (0x00000000u)

/*----FSC15 Tokens----*/
#define CSL_DMAX_DFSR1_FSC15_CLEAR       (0x00000001u)

#define CSL_DMAX_DFSR1_FSC14_MASK        (0x00000040u)
#define CSL_DMAX_DFSR1_FSC14_SHIFT       (0x00000006u)
#define CSL_DMAX_DFSR1_FSC14_RESETVAL    (0x00000000u)

/*----FSC14 Tokens----*/
#define CSL_DMAX_DFSR1_FSC14_CLEAR       (0x00000001u)

#define CSL_DMAX_DFSR1_FSC13_MASK        (0x00000020u)
#define CSL_DMAX_DFSR1_FSC13_SHIFT       (0x00000005u)
#define CSL_DMAX_DFSR1_FSC13_RESETVAL    (0x00000000u)

/*----FSC13 Tokens----*/
#define CSL_DMAX_DFSR1_FSC13_CLEAR       (0x00000001u)

#define CSL_DMAX_DFSR1_FSC12_MASK        (0x00000010u)
#define CSL_DMAX_DFSR1_FSC12_SHIFT       (0x00000004u)
#define CSL_DMAX_DFSR1_FSC12_RESETVAL    (0x00000000u)

/*----FSC12 Tokens----*/
#define CSL_DMAX_DFSR1_FSC12_CLEAR       (0x00000001u)

#define CSL_DMAX_DFSR1_FSC11_MASK        (0x00000008u)
#define CSL_DMAX_DFSR1_FSC11_SHIFT       (0x00000003u)
#define CSL_DMAX_DFSR1_FSC11_RESETVAL    (0x00000000u)

/*----FSC11 Tokens----*/
#define CSL_DMAX_DFSR1_FSC11_CLEAR       (0x00000001u)

#define CSL_DMAX_DFSR1_FSC10_MASK        (0x00000004u)
#define CSL_DMAX_DFSR1_FSC10_SHIFT       (0x00000002u)
#define CSL_DMAX_DFSR1_FSC10_RESETVAL    (0x00000000u)

/*----FSC10 Tokens----*/
#define CSL_DMAX_DFSR1_FSC10_CLEAR       (0x00000001u)

#define CSL_DMAX_DFSR1_FSC9_MASK         (0x00000002u)
#define CSL_DMAX_DFSR1_FSC9_SHIFT        (0x00000001u)
#define CSL_DMAX_DFSR1_FSC9_RESETVAL     (0x00000000u)

/*----FSC9 Tokens----*/
#define CSL_DMAX_DFSR1_FSC9_CLEAR        (0x00000001u)

#define CSL_DMAX_DFSR1_FSC8_MASK         (0x00000001u)
#define CSL_DMAX_DFSR1_FSC8_SHIFT        (0x00000000u)
#define CSL_DMAX_DFSR1_FSC8_RESETVAL     (0x00000000u)

/*----FSC8 Tokens----*/
#define CSL_DMAX_DFSR1_FSC8_CLEAR        (0x00000001u)

#define CSL_DMAX_DFSR1_RESETVAL          (0x00000000u)

/* DTCR0 */

#define CSL_DMAX_DTCR0_TCC7_MASK         (0x00000080u)
#define CSL_DMAX_DTCR0_TCC7_SHIFT        (0x00000007u)
#define CSL_DMAX_DTCR0_TCC7_RESETVAL     (0x00000000u)

/*----TCC7 Tokens----*/
#define CSL_DMAX_DTCR0_TCC7_CLEAR        (0x00000001u)

#define CSL_DMAX_DTCR0_TCC6_MASK         (0x00000040u)
#define CSL_DMAX_DTCR0_TCC6_SHIFT        (0x00000006u)
#define CSL_DMAX_DTCR0_TCC6_RESETVAL     (0x00000000u)

/*----TCC6 Tokens----*/
#define CSL_DMAX_DTCR0_TCC6_CLEAR        (0x00000001u)

#define CSL_DMAX_DTCR0_TCC5_MASK         (0x00000020u)
#define CSL_DMAX_DTCR0_TCC5_SHIFT        (0x00000005u)
#define CSL_DMAX_DTCR0_TCC5_RESETVAL     (0x00000000u)

/*----TCC5 Tokens----*/
#define CSL_DMAX_DTCR0_TCC5_CLEAR        (0x00000001u)

#define CSL_DMAX_DTCR0_TCC4_MASK         (0x00000010u)
#define CSL_DMAX_DTCR0_TCC4_SHIFT        (0x00000004u)
#define CSL_DMAX_DTCR0_TCC4_RESETVAL     (0x00000000u)

/*----TCC4 Tokens----*/
#define CSL_DMAX_DTCR0_TCC4_CLEAR        (0x00000001u)

#define CSL_DMAX_DTCR0_TCC3_MASK         (0x00000008u)
#define CSL_DMAX_DTCR0_TCC3_SHIFT        (0x00000003u)
#define CSL_DMAX_DTCR0_TCC3_RESETVAL     (0x00000000u)

/*----TCC3 Tokens----*/
#define CSL_DMAX_DTCR0_TCC3_CLEAR        (0x00000001u)

#define CSL_DMAX_DTCR0_TCC2_MASK         (0x00000004u)
#define CSL_DMAX_DTCR0_TCC2_SHIFT        (0x00000002u)
#define CSL_DMAX_DTCR0_TCC2_RESETVAL     (0x00000000u)

/*----TCC2 Tokens----*/
#define CSL_DMAX_DTCR0_TCC2_CLEAR        (0x00000001u)

#define CSL_DMAX_DTCR0_TCC1_MASK         (0x00000002u)
#define CSL_DMAX_DTCR0_TCC1_SHIFT        (0x00000001u)
#define CSL_DMAX_DTCR0_TCC1_RESETVAL     (0x00000000u)

/*----TCC1 Tokens----*/
#define CSL_DMAX_DTCR0_TCC1_CLEAR        (0x00000001u)

#define CSL_DMAX_DTCR0_TCC0_MASK         (0x00000001u)
#define CSL_DMAX_DTCR0_TCC0_SHIFT        (0x00000000u)
#define CSL_DMAX_DTCR0_TCC0_RESETVAL     (0x00000000u)

/*----TCC0 Tokens----*/
#define CSL_DMAX_DTCR0_TCC0_CLEAR        (0x00000001u)

#define CSL_DMAX_DTCR0_RESETVAL          (0x00000000u)

/* DTCR1 */

#define CSL_DMAX_DTCR1_TCC15_MASK        (0x00000080u)
#define CSL_DMAX_DTCR1_TCC15_SHIFT       (0x00000007u)
#define CSL_DMAX_DTCR1_TCC15_RESETVAL    (0x00000000u)

/*----TCC15 Tokens----*/
#define CSL_DMAX_DTCR1_TCC15_CLEAR       (0x00000001u)

#define CSL_DMAX_DTCR1_TCC14_MASK        (0x00000040u)
#define CSL_DMAX_DTCR1_TCC14_SHIFT       (0x00000006u)
#define CSL_DMAX_DTCR1_TCC14_RESETVAL    (0x00000000u)

/*----TCC14 Tokens----*/
#define CSL_DMAX_DTCR1_TCC14_CLEAR       (0x00000001u)

#define CSL_DMAX_DTCR1_TCC13_MASK        (0x00000020u)
#define CSL_DMAX_DTCR1_TCC13_SHIFT       (0x00000005u)
#define CSL_DMAX_DTCR1_TCC13_RESETVAL    (0x00000000u)

/*----TCC13 Tokens----*/
#define CSL_DMAX_DTCR1_TCC13_CLEAR       (0x00000001u)

#define CSL_DMAX_DTCR1_TCC12_MASK        (0x00000010u)
#define CSL_DMAX_DTCR1_TCC12_SHIFT       (0x00000004u)
#define CSL_DMAX_DTCR1_TCC12_RESETVAL    (0x00000000u)

/*----TCC12 Tokens----*/
#define CSL_DMAX_DTCR1_TCC12_CLEAR       (0x00000001u)

#define CSL_DMAX_DTCR1_TCC11_MASK        (0x00000008u)
#define CSL_DMAX_DTCR1_TCC11_SHIFT       (0x00000003u)
#define CSL_DMAX_DTCR1_TCC11_RESETVAL    (0x00000000u)

/*----TCC11 Tokens----*/
#define CSL_DMAX_DTCR1_TCC11_CLEAR       (0x00000001u)

#define CSL_DMAX_DTCR1_TCC10_MASK        (0x00000004u)
#define CSL_DMAX_DTCR1_TCC10_SHIFT       (0x00000002u)
#define CSL_DMAX_DTCR1_TCC10_RESETVAL    (0x00000000u)

/*----TCC10 Tokens----*/
#define CSL_DMAX_DTCR1_TCC10_CLEAR       (0x00000001u)

#define CSL_DMAX_DTCR1_TCC9_MASK         (0x00000002u)
#define CSL_DMAX_DTCR1_TCC9_SHIFT        (0x00000001u)
#define CSL_DMAX_DTCR1_TCC9_RESETVAL     (0x00000000u)

/*----TCC9 Tokens----*/
#define CSL_DMAX_DTCR1_TCC9_CLEAR        (0x00000001u)

#define CSL_DMAX_DTCR1_TCC8_MASK         (0x00000001u)
#define CSL_DMAX_DTCR1_TCC8_SHIFT        (0x00000000u)
#define CSL_DMAX_DTCR1_TCC8_RESETVAL     (0x00000000u)

/*----TCC8 Tokens----*/
#define CSL_DMAX_DTCR1_TCC8_CLEAR        (0x00000001u)

#define CSL_DMAX_CPUINT8_MASK            (0x00000100u)
#define CSL_DMAX_CPUINT8_SHIFT           (0x00000008u)
#define CSL_DMAX_CPUINT8_RESETVAL        (0x00000000u)

#define CSL_DMAX_CPUINT7_MASK            (0x00000080u)
#define CSL_DMAX_CPUINT7_SHIFT           (0x00000007u)
#define CSL_DMAX_CPUINT7_RESETVAL        (0x00000000u)

#define CSL_DMAX_DTCR1_RESETVAL          (0x00000000u)

/* EVENT0 */

#define CSL_DMAX_EVENT0_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT0_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT0_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT0_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT0_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT0_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT0_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT0_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT0_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT0_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT0_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT0_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT0_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT0_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT0_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT0_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT0_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT0_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT0_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT0_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT0_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT0_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT0_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT0_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT0_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT0_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT0_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT0_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT0_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT0_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT0_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT0_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT0_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT0_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT0_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT0_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT0_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT0_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT0_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT0_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT0_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT0_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT0_WMENAB_MASK       (0x00010000u)
#define CSL_DMAX_EVENT0_WMENAB_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT0_WMENAB_RESETVAL   (0x00000000u)

#define CSL_DMAX_EVENT0_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT0_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT0_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT0_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT0_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT0_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT0_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT0_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT0_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT0_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT0_RESETVAL         (0x00000000u)

/* EVENT1 */

#define CSL_DMAX_EVENT1_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT1_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT1_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT1_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT1_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT1_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT1_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT1_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT1_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT1_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT1_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT1_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT1_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT1_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT1_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT1_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT1_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT1_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT1_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT1_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT1_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT1_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT1_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT1_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT1_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT1_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT1_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT1_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT1_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT1_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT1_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT1_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT1_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT1_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT1_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT1_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT1_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT1_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT1_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT1_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT1_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT1_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT1_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT1_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT1_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT1_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT1_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT1_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT1_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT1_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT1_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT1_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT1_RESETVAL         (0x00000000u)

/* EVENT2 */

#define CSL_DMAX_EVENT2_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT2_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT2_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT2_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT2_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT2_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT2_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT2_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT2_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT2_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT2_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT2_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT2_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT2_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT2_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT2_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT2_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT2_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT2_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT2_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT2_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT2_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT2_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT2_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT2_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT2_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT2_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT2_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT2_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT2_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT2_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT2_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT2_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT2_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT2_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT2_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT2_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT2_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT2_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT2_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT2_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT2_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT2_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT2_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT2_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT2_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT2_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT2_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT2_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT2_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT2_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT2_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT2_RESETVAL         (0x00000000u)

/* EVENT3 */

#define CSL_DMAX_EVENT3_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT3_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT3_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT3_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT3_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT3_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT3_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT3_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT3_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT3_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT3_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT3_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT3_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT3_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT3_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT3_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT3_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT3_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT3_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT3_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT3_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT3_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT3_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT3_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT3_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT3_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT3_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT3_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT3_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT3_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT3_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT3_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT3_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT3_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT3_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT3_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT3_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT3_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT3_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT3_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT3_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT3_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT3_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT3_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT3_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT3_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT3_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT3_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT3_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT3_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT3_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT3_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT3_RESETVAL         (0x00000000u)

/* EVENT4 */

#define CSL_DMAX_EVENT4_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT4_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT4_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT4_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT4_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT4_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT4_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT4_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT4_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT4_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT4_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT4_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT4_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT4_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT4_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT4_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT4_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT4_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT4_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT4_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT4_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT4_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT4_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT4_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT4_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT4_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT4_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT4_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT4_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT4_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT4_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT4_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT4_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT4_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT4_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT4_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT4_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT4_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT4_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT4_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT4_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT4_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT4_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT4_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT4_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT4_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT4_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT4_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT4_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT4_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT4_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT4_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT4_RESETVAL         (0x00000000u)

/* EVENT5 */

#define CSL_DMAX_EVENT5_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT5_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT5_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT5_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT5_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT5_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT5_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT5_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT5_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT5_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT5_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT5_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT5_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT5_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT5_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT5_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT5_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT5_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT5_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT5_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT5_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT5_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT5_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT5_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT5_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT5_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT5_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT5_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT5_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT5_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT5_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT5_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT5_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT5_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT5_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT5_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT5_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT5_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT5_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT5_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT5_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT5_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT5_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT5_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT5_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT5_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT5_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT5_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT5_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT5_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT5_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT5_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT5_RESETVAL         (0x00000000u)

/* EVENT6 */

#define CSL_DMAX_EVENT6_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT6_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT6_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT6_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT6_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT6_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT6_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT6_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT6_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT6_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT6_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT6_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT6_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT6_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT6_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT6_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT6_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT6_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT6_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT6_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT6_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT6_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT6_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT6_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT6_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT6_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT6_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT6_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT6_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT6_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT6_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT6_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT6_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT6_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT6_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT6_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT6_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT6_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT6_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT6_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT6_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT6_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT6_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT6_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT6_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT6_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT6_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT6_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT6_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT6_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT6_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT6_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT6_RESETVAL         (0x00000000u)

/* EVENT7 */

#define CSL_DMAX_EVENT7_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT7_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT7_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT7_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT7_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT7_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT7_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT7_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT7_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT7_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT7_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT7_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT7_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT7_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT7_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT7_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT7_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT7_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT7_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT7_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT7_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT7_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT7_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT7_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT7_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT7_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT7_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT7_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT7_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT7_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT7_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT7_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT7_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT7_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT7_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT7_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT7_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT7_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT7_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT7_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT7_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT7_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT7_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT7_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT7_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT7_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT7_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT7_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT7_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT7_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT7_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT7_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT7_RESETVAL         (0x00000000u)

/* EVENT8 */

#define CSL_DMAX_EVENT8_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT8_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT8_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT8_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT8_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT8_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT8_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT8_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT8_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT8_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT8_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT8_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT8_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT8_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT8_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT8_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT8_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT8_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT8_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT8_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT8_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT8_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT8_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT8_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT8_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT8_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT8_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT8_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT8_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT8_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT8_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT8_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT8_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT8_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT8_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT8_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT8_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT8_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT8_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT8_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT8_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT8_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT8_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT8_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT8_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT8_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT8_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT8_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT8_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT8_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT8_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT8_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT8_RESETVAL         (0x00000000u)

/* EVENT9 */

#define CSL_DMAX_EVENT9_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT9_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT9_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT9_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT9_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT9_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT9_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT9_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT9_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT9_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT9_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT9_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT9_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT9_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT9_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT9_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT9_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT9_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT9_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT9_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT9_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT9_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT9_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT9_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT9_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT9_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT9_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT9_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT9_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT9_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT9_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT9_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT9_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT9_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT9_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT9_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT9_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT9_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT9_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT9_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT9_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT9_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT9_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT9_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT9_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT9_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT9_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT9_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT9_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT9_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT9_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT9_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT9_RESETVAL         (0x00000000u)

/* EVENT10 */

#define CSL_DMAX_EVENT10_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT10_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT10_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT10_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT10_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT10_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT10_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT10_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT10_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT10_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT10_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT10_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT10_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT10_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT10_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT10_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT10_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT10_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT10_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT10_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT10_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT10_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT10_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT10_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT10_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT10_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT10_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT10_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT10_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT10_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT10_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT10_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT10_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT10_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT10_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT10_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT10_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT10_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT10_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT10_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT10_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT10_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT10_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT10_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT10_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT10_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT10_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT10_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT10_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT10_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT10_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT10_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT10_RESETVAL        (0x00000000u)

/* EVENT11 */

#define CSL_DMAX_EVENT11_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT11_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT11_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT11_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT11_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT11_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT11_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT11_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT11_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT11_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT11_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT11_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT11_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT11_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT11_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT11_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT11_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT11_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT11_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT11_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT11_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT11_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT11_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT11_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT11_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT11_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT11_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT11_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT11_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT11_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT11_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT11_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT11_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT11_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT11_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT11_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT11_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT11_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT11_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT11_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT11_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT11_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT11_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT11_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT11_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT11_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT11_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT11_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT11_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT11_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT11_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT11_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT11_RESETVAL        (0x00000000u)

/* EVENT12 */

#define CSL_DMAX_EVENT12_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT12_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT12_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT12_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT12_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT12_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT12_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT12_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT12_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT12_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT12_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT12_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT12_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT12_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT12_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT12_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT12_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT12_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT12_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT12_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT12_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT12_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT12_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT12_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT12_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT12_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT12_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT12_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT12_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT12_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT12_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT12_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT12_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT12_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT12_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT12_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT12_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT12_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT12_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT12_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT12_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT12_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT12_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT12_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT12_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT12_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT12_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT12_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT12_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT12_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT12_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT12_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT12_RESETVAL        (0x00000000u)

/* EVENT13 */

#define CSL_DMAX_EVENT13_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT13_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT13_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT13_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT13_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT13_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT13_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT13_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT13_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT13_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT13_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT13_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT13_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT13_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT13_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT13_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT13_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT13_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT13_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT13_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT13_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT13_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT13_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT13_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT13_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT13_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT13_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT13_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT13_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT13_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT13_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT13_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT13_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT13_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT13_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT13_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT13_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT13_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT13_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT13_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT13_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT13_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT13_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT13_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT13_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT13_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT13_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT13_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT13_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT13_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT13_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT13_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT13_RESETVAL        (0x00000000u)

/* EVENT14 */

#define CSL_DMAX_EVENT14_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT14_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT14_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT14_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT14_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT14_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT14_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT14_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT14_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT14_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT14_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT14_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT14_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT14_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT14_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT14_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT14_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT14_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT14_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT14_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT14_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT14_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT14_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT14_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT14_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT14_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT14_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT14_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT14_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT14_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT14_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT14_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT14_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT14_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT14_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT14_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT14_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT14_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT14_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT14_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT14_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT14_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT14_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT14_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT14_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT14_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT14_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT14_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT14_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT14_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT14_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT14_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT14_RESETVAL        (0x00000000u)

/* EVENT15 */

#define CSL_DMAX_EVENT15_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT15_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT15_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT15_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT15_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT15_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT15_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT15_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT15_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT15_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT15_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT15_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT15_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT15_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT15_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT15_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT15_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT15_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT15_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT15_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT15_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT15_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT15_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT15_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT15_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT15_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT15_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT15_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT15_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT15_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT15_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT15_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT15_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT15_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT15_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT15_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT15_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT15_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT15_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT15_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT15_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT15_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT15_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT15_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT15_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT15_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT15_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT15_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT15_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT15_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT15_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT15_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT15_RESETVAL        (0x00000000u)

/* EVENT16 */

#define CSL_DMAX_EVENT16_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT16_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT16_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT16_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT16_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT16_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT16_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT16_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT16_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT16_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT16_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT16_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT16_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT16_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT16_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT16_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT16_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT16_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT16_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT16_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT16_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT16_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT16_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT16_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT16_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT16_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT16_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT16_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT16_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT16_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT16_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT16_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT16_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT16_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT16_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT16_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT16_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT16_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT16_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT16_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT16_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT16_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT16_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT16_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT16_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT16_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT16_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT16_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT16_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT16_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT16_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT16_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT16_RESETVAL        (0x00000000u)

/* EVENT17 */

#define CSL_DMAX_EVENT17_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT17_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT17_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT17_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT17_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT17_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT17_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT17_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT17_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT17_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT17_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT17_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT17_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT17_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT17_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT17_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT17_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT17_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT17_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT17_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT17_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT17_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT17_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT17_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT17_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT17_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT17_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT17_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT17_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT17_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT17_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT17_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT17_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT17_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT17_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT17_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT17_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT17_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT17_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT17_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT17_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT17_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT17_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT17_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT17_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT17_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT17_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT17_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT17_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT17_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT17_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT17_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT17_RESETVAL        (0x00000000u)

/* EVENT18 */

#define CSL_DMAX_EVENT18_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT18_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT18_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT18_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT18_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT18_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT18_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT18_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT18_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT18_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT18_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT18_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT18_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT18_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT18_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT18_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT18_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT18_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT18_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT18_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT18_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT18_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT18_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT18_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT18_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT18_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT18_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT18_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT18_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT18_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT18_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT18_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT18_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT18_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT18_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT18_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT18_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT18_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT18_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT18_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT18_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT18_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT18_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT18_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT18_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT18_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT18_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT18_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT18_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT18_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT18_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT18_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT18_RESETVAL        (0x00000000u)

/* EVENT19 */

#define CSL_DMAX_EVENT19_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT19_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT19_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT19_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT19_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT19_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT19_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT19_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT19_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT19_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT19_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT19_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT19_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT19_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT19_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT19_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT19_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT19_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT19_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT19_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT19_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT19_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT19_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT19_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT19_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT19_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT19_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT19_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT19_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT19_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT19_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT19_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT19_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT19_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT19_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT19_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT19_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT19_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT19_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT19_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT19_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT19_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT19_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT19_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT19_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT19_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT19_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT19_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT19_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT19_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT19_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT19_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT19_RESETVAL        (0x00000000u)

/* EVENT20 */

#define CSL_DMAX_EVENT20_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT20_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT20_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT20_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT20_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT20_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT20_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT20_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT20_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT20_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT20_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT20_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT20_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT20_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT20_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT20_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT20_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT20_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT20_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT20_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT20_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT20_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT20_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT20_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT20_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT20_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT20_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT20_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT20_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT20_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT20_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT20_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT20_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT20_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT20_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT20_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT20_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT20_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT20_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT20_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT20_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT20_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT20_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT20_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT20_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT20_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT20_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT20_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT20_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT20_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT20_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT20_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT20_RESETVAL        (0x00000000u)

/* EVENT21 */

#define CSL_DMAX_EVENT21_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT21_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT21_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT21_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT21_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT21_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT21_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT21_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT21_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT21_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT21_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT21_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT21_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT21_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT21_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT21_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT21_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT21_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT21_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT21_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT21_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT21_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT21_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT21_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT21_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT21_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT21_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT21_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT21_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT21_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT21_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT21_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT21_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT21_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT21_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT21_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT21_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT21_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT21_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT21_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT21_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT21_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT21_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT21_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT21_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT21_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT21_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT21_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT21_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT21_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT21_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT21_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT21_RESETVAL        (0x00000000u)

/* EVENT22 */

#define CSL_DMAX_EVENT22_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT22_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT22_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT22_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT22_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT22_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT22_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT22_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT22_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT22_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT22_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT22_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT22_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT22_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT22_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT22_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT22_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT22_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT22_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT22_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT22_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT22_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT22_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT22_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT22_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT22_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT22_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT22_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT22_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT22_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT22_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT22_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT22_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT22_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT22_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT22_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT22_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT22_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT22_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT22_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT22_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT22_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT22_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT22_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT22_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT22_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT22_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT22_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT22_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT22_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT22_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT22_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT22_RESETVAL        (0x00000000u)

/* EVENT23 */

#define CSL_DMAX_EVENT23_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT23_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT23_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT23_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT23_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT23_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT23_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT23_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT23_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT23_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT23_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT23_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT23_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT23_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT23_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT23_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT23_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT23_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT23_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT23_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT23_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT23_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT23_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT23_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT23_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT23_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT23_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT23_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT23_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT23_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT23_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT23_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT23_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT23_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT23_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT23_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT23_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT23_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT23_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT23_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT23_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT23_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT23_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT23_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT23_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT23_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT23_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT23_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT23_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT23_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT23_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT23_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT23_RESETVAL        (0x00000000u)

/* EVENT24 */

#define CSL_DMAX_EVENT24_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT24_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT24_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT24_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT24_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT24_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT24_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT24_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT24_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT24_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT24_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT24_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT24_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT24_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT24_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT24_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT24_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT24_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT24_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT24_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT24_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT24_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT24_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT24_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT24_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT24_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT24_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT24_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT24_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT24_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT24_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT24_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT24_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT24_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT24_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT24_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT24_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT24_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT24_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT24_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT24_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT24_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT24_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT24_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT24_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT24_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT24_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT24_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT24_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT24_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT24_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT24_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT24_RESETVAL        (0x00000000u)

/* EVENT25 */

#define CSL_DMAX_EVENT25_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT25_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT25_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT25_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT25_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT25_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT25_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT25_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT25_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT25_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT25_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT25_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT25_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT25_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT25_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT25_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT25_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT25_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT25_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT25_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT25_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT25_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT25_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT25_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT25_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT25_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT25_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT25_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT25_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT25_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT25_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT25_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT25_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT25_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT25_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT25_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT25_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT25_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT25_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT25_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT25_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT25_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT25_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT25_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT25_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT25_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT25_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT25_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT25_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT25_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT25_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT25_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT25_RESETVAL        (0x00000000u)

/* EVENT26 */

#define CSL_DMAX_EVENT26_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT26_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT26_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT26_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT26_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT26_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT26_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT26_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT26_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT26_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT26_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT26_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT26_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT26_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT26_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT26_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT26_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT26_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT26_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT26_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT26_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT26_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT26_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT26_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT26_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT26_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT26_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT26_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT26_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT26_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT26_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT26_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT26_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT26_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT26_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT26_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT26_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT26_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT26_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT26_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT26_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT26_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT26_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT26_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT26_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT26_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT26_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT26_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT26_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT26_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT26_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT26_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT26_RESETVAL        (0x00000000u)

/* EVENT27 */

#define CSL_DMAX_EVENT27_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT27_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT27_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT27_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT27_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT27_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT27_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT27_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT27_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT27_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT27_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT27_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT27_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT27_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT27_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT27_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT27_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT27_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT27_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT27_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT27_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT27_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT27_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT27_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT27_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT27_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT27_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT27_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT27_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT27_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT27_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT27_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT27_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT27_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT27_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT27_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT27_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT27_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT27_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT27_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT27_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT27_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT27_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT27_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT27_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT27_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT27_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT27_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT27_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT27_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT27_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT27_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT27_RESETVAL        (0x00000000u)

/* EVENT28 */

#define CSL_DMAX_EVENT28_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT28_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT28_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT28_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT28_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT28_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT28_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT28_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT28_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT28_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT28_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT28_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT28_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT28_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT28_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT28_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT28_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT28_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT28_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT28_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT28_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT28_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT28_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT28_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT28_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT28_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT28_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT28_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT28_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT28_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT28_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT28_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT28_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT28_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT28_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT28_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT28_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT28_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT28_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT28_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT28_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT28_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT28_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT28_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT28_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT28_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT28_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT28_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT28_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT28_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT28_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT28_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT28_RESETVAL        (0x00000000u)

/* EVENT29 */

#define CSL_DMAX_EVENT29_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT29_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT29_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT29_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT29_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT29_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT29_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT29_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT29_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT29_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT29_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT29_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT29_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT29_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT29_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT29_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT29_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT29_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT29_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT29_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT29_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT29_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT29_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT29_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT29_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT29_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT29_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT29_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT29_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT29_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT29_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT29_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT29_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT29_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT29_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT29_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT29_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT29_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT29_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT29_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT29_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT29_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT29_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT29_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT29_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT29_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT29_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT29_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT29_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT29_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT29_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT29_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT29_RESETVAL        (0x00000000u)

/* EVENT30 */

#define CSL_DMAX_EVENT30_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT30_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT30_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT30_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT30_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT30_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT30_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT30_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT30_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT30_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT30_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT30_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT30_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT30_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT30_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT30_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT30_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT30_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT30_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT30_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT30_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT30_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT30_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT30_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT30_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT30_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT30_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT30_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT30_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT30_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT30_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT30_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT30_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT30_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT30_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT30_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT30_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT30_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT30_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT30_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT30_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT30_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT30_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT30_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT30_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT30_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT30_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT30_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT30_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT30_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT30_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT30_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT30_RESETVAL        (0x00000000u)

/* EVENT31 */

#define CSL_DMAX_EVENT31_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT31_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT31_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT31_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT31_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT31_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT31_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT31_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT31_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT31_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT31_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT31_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT31_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT31_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT31_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT31_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT31_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT31_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT31_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT31_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT31_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT31_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT31_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT31_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT31_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT31_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT31_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT31_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT31_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT31_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT31_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT31_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT31_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT31_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT31_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT31_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT31_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT31_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT31_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT31_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT31_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT31_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT31_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT31_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT31_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT31_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT31_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT31_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT31_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT31_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT31_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT31_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT31_RESETVAL        (0x00000000u)

/* WORD0 */

#define CSL_DMAX_WORD0_WORD0_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD0_WORD0_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD0_WORD0_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD0_RESETVAL          (0x00000000u)

/* WORD1 */

#define CSL_DMAX_WORD1_WORD1_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD1_WORD1_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD1_WORD1_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD1_RESETVAL          (0x00000000u)

/* WORD2 */

#define CSL_DMAX_WORD2_WORD2_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD2_WORD2_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD2_WORD2_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD2_RESETVAL          (0x00000000u)

/* WORD3 */

#define CSL_DMAX_WORD3_WORD3_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD3_WORD3_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD3_WORD3_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD3_RESETVAL          (0x00000000u)

/* WORD4 */

#define CSL_DMAX_WORD4_WORD4_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD4_WORD4_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD4_WORD4_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD4_RESETVAL          (0x00000000u)

/* WORD5 */

#define CSL_DMAX_WORD5_WORD5_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD5_WORD5_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD5_WORD5_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD5_RESETVAL          (0x00000000u)

/* WORD6 */

#define CSL_DMAX_WORD6_WORD6_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD6_WORD6_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD6_WORD6_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD6_RESETVAL          (0x00000000u)

/* WORD7 */

#define CSL_DMAX_WORD7_WORD7_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD7_WORD7_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD7_WORD7_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD7_RESETVAL          (0x00000000u)

/* WORD8 */

#define CSL_DMAX_WORD8_WORD8_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD8_WORD8_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD8_WORD8_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD8_RESETVAL          (0x00000000u)

/* WORD9 */

#define CSL_DMAX_WORD9_WORD9_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD9_WORD9_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD9_WORD9_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD9_RESETVAL          (0x00000000u)

/* WORD10 */

#define CSL_DMAX_WORD10_WORD10_MASK      (0xFFFFFFFFu)
#define CSL_DMAX_WORD10_WORD10_SHIFT     (0x00000000u)
#define CSL_DMAX_WORD10_WORD10_RESETVAL  (0x00000000u)

#define CSL_DMAX_WORD10_RESETVAL         (0x00000000u)

/* EVENT0 */

#define CSL_DMAX_EVENT0_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT0_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT0_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT0_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT0_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT0_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT0_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT0_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT0_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT0_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT0_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT0_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT0_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT0_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT0_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT0_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT0_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT0_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT0_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT0_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT0_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT0_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT0_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT0_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT0_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT0_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT0_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT0_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT0_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT0_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT0_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT0_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT0_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT0_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT0_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT0_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT0_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT0_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT0_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT0_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT0_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT0_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT0_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT0_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT0_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT0_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT0_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT0_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT0_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT0_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT0_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT0_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT0_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT0_INT_INT9		(0x00000002u)
#define CSL_DMAX_EVENT0_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT0_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT0_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT0_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT0_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT0_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT0_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT0_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT0_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT0_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT0_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT0_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT0_RESETVAL         (0x00000000u)

/* EVENT1 */

#define CSL_DMAX_EVENT1_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT1_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT1_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT1_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT1_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT1_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT1_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT1_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT1_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT1_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT1_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT1_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT1_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT1_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT1_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT1_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT1_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT1_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT1_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT1_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT1_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT1_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT1_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT1_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT1_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT1_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT1_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT1_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT1_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT1_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT1_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT1_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT1_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT1_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT1_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT1_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT1_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT1_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT1_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT1_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT1_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT1_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT1_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT1_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT1_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT1_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT1_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT1_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT1_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT1_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT1_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT1_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT1_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT1_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT1_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT1_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT1_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT1_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT1_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT1_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT1_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT1_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT1_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT1_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT1_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT1_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT1_RESETVAL         (0x00000000u)

/* EVENT2 */

#define CSL_DMAX_EVENT2_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT2_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT2_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT2_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT2_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT2_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT2_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT2_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT2_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT2_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT2_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT2_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT2_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT2_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT2_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT2_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT2_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT2_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT2_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT2_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT2_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT2_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT2_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT2_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT2_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT2_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT2_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT2_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT2_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT2_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT2_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT2_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT2_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT2_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT2_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT2_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT2_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT2_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT2_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT2_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT2_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT2_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT2_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT2_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT2_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT2_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT2_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT2_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT2_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT2_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT2_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT2_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT2_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT2_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT2_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT2_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT2_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT2_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT2_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT2_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT2_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT2_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT2_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT2_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT2_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT2_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT2_RESETVAL         (0x00000000u)

/* EVENT3 */

#define CSL_DMAX_EVENT3_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT3_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT3_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT3_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT3_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT3_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT3_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT3_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT3_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT3_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT3_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT3_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT3_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT3_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT3_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT3_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT3_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT3_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT3_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT3_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT3_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT3_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT3_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT3_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT3_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT3_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT3_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT3_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT3_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT3_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT3_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT3_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT3_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT3_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT3_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT3_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT3_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT3_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT3_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT3_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT3_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT3_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT3_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT3_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT3_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT3_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT3_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT3_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT3_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT3_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT3_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT3_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT3_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT3_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT3_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT3_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT3_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT3_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT3_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT3_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT3_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT3_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT3_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT3_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT3_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT3_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT3_RESETVAL         (0x00000000u)

/* EVENT4 */

#define CSL_DMAX_EVENT4_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT4_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT4_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT4_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT4_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT4_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT4_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT4_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT4_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT4_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT4_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT4_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT4_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT4_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT4_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT4_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT4_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT4_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT4_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT4_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT4_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT4_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT4_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT4_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT4_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT4_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT4_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT4_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT4_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT4_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT4_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT4_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT4_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT4_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT4_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT4_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT4_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT4_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT4_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT4_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT4_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT4_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT4_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT4_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT4_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT4_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT4_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT4_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT4_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT4_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT4_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT4_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT4_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT4_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT4_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT4_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT4_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT4_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT4_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT4_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT4_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT4_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT4_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT4_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT4_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT4_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT4_RESETVAL         (0x00000000u)

/* EVENT5 */

#define CSL_DMAX_EVENT5_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT5_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT5_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT5_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT5_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT5_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT5_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT5_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT5_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT5_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT5_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT5_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT5_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT5_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT5_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT5_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT5_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT5_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT5_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT5_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT5_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT5_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT5_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT5_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT5_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT5_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT5_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT5_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT5_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT5_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT5_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT5_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT5_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT5_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT5_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT5_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT5_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT5_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT5_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT5_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT5_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT5_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT5_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT5_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT5_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT5_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT5_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT5_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT5_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT5_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT5_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT5_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT5_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT5_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT5_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT5_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT5_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT5_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT5_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT5_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT5_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT5_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT5_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT5_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT5_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT5_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT5_RESETVAL         (0x00000000u)

/* EVENT6 */

#define CSL_DMAX_EVENT6_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT6_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT6_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT6_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT6_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT6_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT6_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT6_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT6_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT6_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT6_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT6_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT6_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT6_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT6_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT6_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT6_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT6_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT6_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT6_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT6_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT6_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT6_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT6_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT6_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT6_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT6_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT6_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT6_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT6_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT6_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT6_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT6_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT6_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT6_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT6_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT6_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT6_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT6_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT6_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT6_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT6_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT6_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT6_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT6_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT6_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT6_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT6_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT6_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT6_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT6_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT6_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT6_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT6_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT6_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT6_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT6_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT6_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT6_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT6_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT6_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT6_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT6_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT6_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT6_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT6_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT6_RESETVAL         (0x00000000u)

/* EVENT7 */

#define CSL_DMAX_EVENT7_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT7_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT7_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT7_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT7_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT7_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT7_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT7_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT7_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT7_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT7_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT7_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT7_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT7_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT7_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT7_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT7_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT7_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT7_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT7_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT7_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT7_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT7_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT7_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT7_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT7_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT7_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT7_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT7_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT7_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT7_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT7_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT7_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT7_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT7_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT7_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT7_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT7_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT7_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT7_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT7_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT7_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT7_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT7_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT7_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT7_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT7_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT7_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT7_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT7_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT7_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT7_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT7_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT7_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT7_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT7_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT7_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT7_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT7_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT7_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT7_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT7_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT7_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT7_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT7_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT7_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT7_RESETVAL         (0x00000000u)

/* EVENT8 */

#define CSL_DMAX_EVENT8_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT8_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT8_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT8_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT8_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT8_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT8_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT8_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT8_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT8_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT8_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT8_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT8_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT8_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT8_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT8_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT8_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT8_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT8_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT8_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT8_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT8_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT8_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT8_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT8_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT8_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT8_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT8_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT8_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT8_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT8_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT8_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT8_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT8_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT8_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT8_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT8_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT8_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT8_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT8_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT8_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT8_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT8_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT8_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT8_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT8_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT8_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT8_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT8_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT8_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT8_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT8_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT8_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT8_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT8_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT8_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT8_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT8_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT8_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT8_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT8_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT8_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT8_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT8_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT8_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT8_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT8_RESETVAL         (0x00000000u)

/* EVENT9 */

#define CSL_DMAX_EVENT9_QTSL_MASK        (0xC0000000u)
#define CSL_DMAX_EVENT9_QTSL_SHIFT       (0x0000001Eu)
#define CSL_DMAX_EVENT9_QTSL_RESETVAL    (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT9_QTSL_MOVE1_ELE   (0x00000000u)
#define CSL_DMAX_EVENT9_QTSL_MOVE4_ELE   (0x00000001u)
#define CSL_DMAX_EVENT9_QTSL_MOVE8_ELE   (0x00000002u)
#define CSL_DMAX_EVENT9_QTSL_MOVE16_ELE  (0x00000003u)

#define CSL_DMAX_EVENT9_SYNC_MASK        (0x20000000u)
#define CSL_DMAX_EVENT9_SYNC_SHIFT       (0x0000001Du)
#define CSL_DMAX_EVENT9_SYNC_RESETVAL    (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT9_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT9_SYNC_TRAN_COMPL  (0x00000001u)

#define CSL_DMAX_EVENT9_TCC_MASK         (0x0F000000u)
#define CSL_DMAX_EVENT9_TCC_SHIFT        (0x00000018u)
#define CSL_DMAX_EVENT9_TCC_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT9_ATCINT_MASK      (0x00800000u)
#define CSL_DMAX_EVENT9_ATCINT_SHIFT     (0x00000017u)
#define CSL_DMAX_EVENT9_ATCINT_RESETVAL  (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT9_ATCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT9_ATCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT9_TCINT_MASK       (0x00400000u)
#define CSL_DMAX_EVENT9_TCINT_SHIFT      (0x00000016u)
#define CSL_DMAX_EVENT9_TCINT_RESETVAL   (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT9_TCINT_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT9_TCINT_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT9_RLOAD_MASK       (0x00100000u)
#define CSL_DMAX_EVENT9_RLOAD_SHIFT      (0x00000014u)
#define CSL_DMAX_EVENT9_RLOAD_RESETVAL   (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT9_RLOAD_DISABLE    (0x00000000u)
#define CSL_DMAX_EVENT9_RLOAD_ENABLE     (0x00000001u)

#define CSL_DMAX_EVENT9_CC_MASK          (0x000C0000u)
#define CSL_DMAX_EVENT9_CC_SHIFT         (0x00000012u)
#define CSL_DMAX_EVENT9_CC_RESETVAL      (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT9_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT9_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT9_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT9_ESIZE_MASK       (0x00030000u)
#define CSL_DMAX_EVENT9_ESIZE_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT9_ESIZE_RESETVAL   (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT9_ESIZE_8BIT       (0x00000000u)
#define CSL_DMAX_EVENT9_ESIZE_16BIT      (0x00000001u)
#define CSL_DMAX_EVENT9_ESIZE_32BIT      (0x00000002u)

#define CSL_DMAX_EVENT9_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT9_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT9_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT9_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT9_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT9_PTE_MASK         (0x00007F00u)
#define CSL_DMAX_EVENT9_PTE_SHIFT        (0x00000008u)
#define CSL_DMAX_EVENT9_PTE_RESETVAL     (0x00000000u)

#define CSL_DMAX_EVENT9_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT9_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT9_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT9_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT9_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT9_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT9_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT9_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT9_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT9_ETYPE_MASK       (0x0000001Fu)
#define CSL_DMAX_EVENT9_ETYPE_SHIFT      (0x00000000u)
#define CSL_DMAX_EVENT9_ETYPE_RESETVAL   (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT9_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT9_ETYPE_FIFOWRITE  (0x00000004u)
#define CSL_DMAX_EVENT9_ETYPE_FIFOREAD   (0x00000005u)
#define CSL_DMAX_EVENT9_ETYPE_CPUINT     (0x00000007u)

#define CSL_DMAX_EVENT9_RESETVAL         (0x00000000u)

/* EVENT10 */

#define CSL_DMAX_EVENT10_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT10_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT10_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT10_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT10_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT10_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT10_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT10_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT10_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT10_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT10_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT10_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT10_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT10_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT10_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT10_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT10_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT10_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT10_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT10_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT10_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT10_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT10_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT10_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT10_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT10_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT10_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT10_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT10_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT10_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT10_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT10_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT10_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT10_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT10_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT10_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT10_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT10_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT10_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT10_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT10_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT10_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT10_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT10_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT10_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT10_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT10_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT10_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT10_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT10_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT10_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT10_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT10_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT10_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT10_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT10_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT10_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT10_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT10_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT10_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT10_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT10_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT10_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT10_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT10_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT10_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT10_RESETVAL        (0x00000000u)

/* EVENT11 */

#define CSL_DMAX_EVENT11_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT11_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT11_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT11_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT11_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT11_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT11_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT11_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT11_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT11_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT11_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT11_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT11_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT11_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT11_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT11_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT11_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT11_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT11_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT11_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT11_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT11_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT11_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT11_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT11_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT11_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT11_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT11_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT11_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT11_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT11_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT11_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT11_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT11_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT11_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT11_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT11_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT11_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT11_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT11_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT11_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT11_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT11_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT11_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT11_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT11_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT11_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT11_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT11_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT11_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT11_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT11_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT11_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT11_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT11_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT11_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT11_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT11_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT11_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT11_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT11_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT11_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT11_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT11_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT11_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT11_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT11_RESETVAL        (0x00000000u)

/* EVENT12 */

#define CSL_DMAX_EVENT12_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT12_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT12_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT12_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT12_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT12_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT12_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT12_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT12_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT12_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT12_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT12_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT12_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT12_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT12_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT12_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT12_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT12_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT12_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT12_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT12_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT12_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT12_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT12_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT12_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT12_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT12_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT12_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT12_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT12_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT12_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT12_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT12_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT12_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT12_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT12_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT12_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT12_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT12_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT12_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT12_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT12_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT12_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT12_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT12_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT12_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT12_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT12_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT12_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT12_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT12_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT12_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT12_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT12_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT12_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT12_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT12_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT12_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT12_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT12_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT12_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT12_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT12_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT12_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT12_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT12_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT12_RESETVAL        (0x00000000u)

/* EVENT13 */

#define CSL_DMAX_EVENT13_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT13_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT13_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT13_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT13_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT13_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT13_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT13_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT13_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT13_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT13_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT13_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT13_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT13_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT13_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT13_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT13_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT13_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT13_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT13_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT13_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT13_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT13_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT13_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT13_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT13_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT13_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT13_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT13_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT13_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT13_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT13_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT13_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT13_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT13_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT13_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT13_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT13_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT13_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT13_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT13_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT13_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT13_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT13_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT13_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT13_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT13_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT13_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT13_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT13_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT13_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT13_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT13_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT13_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT13_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT13_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT13_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT13_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT13_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT13_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT13_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT13_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT13_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT13_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT13_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT13_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT13_RESETVAL        (0x00000000u)

/* EVENT14 */

#define CSL_DMAX_EVENT14_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT14_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT14_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT14_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT14_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT14_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT14_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT14_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT14_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT14_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT14_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT14_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT14_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT14_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT14_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT14_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT14_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT14_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT14_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT14_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT14_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT14_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT14_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT14_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT14_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT14_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT14_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT14_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT14_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT14_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT14_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT14_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT14_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT14_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT14_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT14_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT14_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT14_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT14_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT14_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT14_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT14_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT14_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT14_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT14_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT14_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT14_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT14_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT14_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT14_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT14_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT14_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT14_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT14_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT14_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT14_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT14_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT14_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT14_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT14_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT14_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT14_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT14_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT14_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT14_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT14_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT14_RESETVAL        (0x00000000u)

/* EVENT15 */

#define CSL_DMAX_EVENT15_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT15_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT15_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT15_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT15_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT15_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT15_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT15_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT15_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT15_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT15_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT15_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT15_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT15_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT15_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT15_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT15_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT15_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT15_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT15_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT15_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT15_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT15_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT15_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT15_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT15_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT15_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT15_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT15_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT15_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT15_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT15_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT15_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT15_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT15_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT15_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT15_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT15_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT15_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT15_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT15_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT15_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT15_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT15_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT15_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT15_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT15_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT15_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT15_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT15_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT15_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT15_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT15_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT15_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT15_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT15_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT15_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT15_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT15_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT15_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT15_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT15_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT15_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT15_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT15_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT15_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT15_RESETVAL        (0x00000000u)

/* EVENT16 */

#define CSL_DMAX_EVENT16_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT16_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT16_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT16_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT16_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT16_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT16_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT16_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT16_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT16_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT16_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT16_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT16_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT16_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT16_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT16_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT16_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT16_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT16_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT16_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT16_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT16_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT16_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT16_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT16_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT16_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT16_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT16_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT16_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT16_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT16_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT16_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT16_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT16_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT16_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT16_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT16_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT16_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT16_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT16_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT16_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT16_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT16_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT16_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT16_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT16_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT16_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT16_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT16_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT16_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT16_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT16_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT16_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT16_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT16_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT16_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT16_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT16_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT16_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT16_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT16_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT16_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT16_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT16_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT16_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT16_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT16_RESETVAL        (0x00000000u)

/* EVENT17 */

#define CSL_DMAX_EVENT17_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT17_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT17_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT17_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT17_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT17_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT17_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT17_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT17_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT17_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT17_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT17_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT17_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT17_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT17_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT17_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT17_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT17_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT17_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT17_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT17_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT17_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT17_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT17_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT17_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT17_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT17_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT17_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT17_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT17_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT17_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT17_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT17_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT17_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT17_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT17_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT17_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT17_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT17_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT17_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT17_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT17_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT17_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT17_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT17_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT17_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT17_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT17_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT17_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT17_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT17_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT17_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT17_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT17_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT17_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT17_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT17_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT17_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT17_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT17_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT17_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT17_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT17_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT17_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT17_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT17_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT17_RESETVAL        (0x00000000u)

/* EVENT18 */

#define CSL_DMAX_EVENT18_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT18_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT18_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT18_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT18_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT18_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT18_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT18_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT18_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT18_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT18_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT18_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT18_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT18_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT18_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT18_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT18_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT18_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT18_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT18_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT18_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT18_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT18_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT18_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT18_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT18_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT18_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT18_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT18_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT18_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT18_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT18_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT18_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT18_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT18_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT18_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT18_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT18_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT18_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT18_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT18_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT18_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT18_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT18_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT18_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT18_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT18_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT18_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT18_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT18_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT18_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT18_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT18_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT18_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT18_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT18_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT18_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT18_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT18_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT18_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT18_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT18_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT18_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT18_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT18_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT18_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT18_RESETVAL        (0x00000000u)

/* EVENT19 */

#define CSL_DMAX_EVENT19_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT19_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT19_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT19_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT19_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT19_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT19_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT19_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT19_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT19_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT19_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT19_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT19_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT19_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT19_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT19_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT19_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT19_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT19_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT19_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT19_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT19_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT19_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT19_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT19_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT19_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT19_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT19_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT19_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT19_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT19_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT19_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT19_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT19_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT19_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT19_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT19_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT19_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT19_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT19_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT19_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT19_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT19_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT19_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT19_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT19_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT19_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT19_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT19_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT19_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT19_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT19_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT19_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT19_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT19_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT19_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT19_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT19_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT19_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT19_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT19_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT19_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT19_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT19_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT19_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT19_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT19_RESETVAL        (0x00000000u)

/* EVENT20 */

#define CSL_DMAX_EVENT20_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT20_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT20_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT20_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT20_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT20_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT20_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT20_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT20_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT20_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT20_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT20_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT20_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT20_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT20_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT20_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT20_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT20_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT20_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT20_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT20_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT20_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT20_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT20_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT20_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT20_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT20_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT20_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT20_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT20_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT20_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT20_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT20_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT20_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT20_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT20_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT20_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT20_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT20_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT20_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT20_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT20_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT20_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT20_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT20_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT20_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT20_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT20_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT20_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT20_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT20_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT20_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT20_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT20_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT20_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT20_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT20_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT20_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT20_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT20_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT20_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT20_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT20_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT20_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT20_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT20_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT20_RESETVAL        (0x00000000u)

/* EVENT21 */

#define CSL_DMAX_EVENT21_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT21_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT21_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT21_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT21_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT21_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT21_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT21_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT21_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT21_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT21_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT21_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT21_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT21_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT21_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT21_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT21_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT21_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT21_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT21_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT21_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT21_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT21_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT21_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT21_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT21_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT21_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT21_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT21_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT21_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT21_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT21_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT21_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT21_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT21_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT21_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT21_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT21_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT21_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT21_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT21_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT21_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT21_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT21_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT21_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT21_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT21_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT21_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT21_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT21_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT21_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT21_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT21_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT21_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT21_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT21_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT21_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT21_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT21_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT21_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT21_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT21_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT21_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT21_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT21_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT21_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT21_RESETVAL        (0x00000000u)

/* EVENT22 */

#define CSL_DMAX_EVENT22_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT22_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT22_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT22_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT22_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT22_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT22_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT22_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT22_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT22_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT22_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT22_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT22_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT22_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT22_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT22_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT22_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT22_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT22_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT22_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT22_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT22_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT22_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT22_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT22_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT22_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT22_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT22_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT22_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT22_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT22_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT22_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT22_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT22_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT22_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT22_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT22_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT22_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT22_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT22_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT22_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT22_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT22_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT22_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT22_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT22_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT22_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT22_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT22_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT22_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT22_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT22_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT22_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT22_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT22_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT22_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT22_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT22_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT22_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT22_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT22_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT22_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT22_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT22_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT22_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT22_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT22_RESETVAL        (0x00000000u)

/* EVENT23 */

#define CSL_DMAX_EVENT23_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT23_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT23_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT23_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT23_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT23_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT23_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT23_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT23_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT23_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT23_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT23_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT23_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT23_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT23_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT23_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT23_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT23_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT23_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT23_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT23_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT23_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT23_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT23_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT23_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT23_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT23_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT23_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT23_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT23_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT23_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT23_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT23_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT23_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT23_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT23_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT23_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT23_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT23_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT23_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT23_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT23_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT23_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT23_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT23_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT23_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT23_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT23_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT23_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT23_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT23_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT23_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT23_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT23_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT23_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT23_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT23_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT23_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT23_INT_INT15       (0x00000007u)


#define CSL_DMAX_EVENT23_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT23_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT23_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT23_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT23_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT23_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT23_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT23_RESETVAL        (0x00000000u)

/* EVENT24 */

#define CSL_DMAX_EVENT24_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT24_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT24_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT24_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT24_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT24_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT24_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT24_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT24_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT24_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT24_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT24_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT24_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT24_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT24_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT24_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT24_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT24_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT24_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT24_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT24_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT24_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT24_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT24_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT24_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT24_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT24_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT24_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT24_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT24_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT24_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT24_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT24_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT24_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT24_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT24_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT24_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT24_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT24_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT24_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT24_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT24_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT24_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT24_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT24_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT24_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT24_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT24_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT24_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT24_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT24_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT24_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT24_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT24_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT24_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT24_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT24_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT24_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT24_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT24_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT24_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT24_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT24_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT24_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT24_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT24_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT24_RESETVAL        (0x00000000u)

/* EVENT25 */

#define CSL_DMAX_EVENT25_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT25_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT25_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT25_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT25_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT25_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT25_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT25_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT25_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT25_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT25_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT25_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT25_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT25_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT25_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT25_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT25_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT25_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT25_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT25_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT25_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT25_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT25_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT25_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT25_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT25_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT25_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT25_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT25_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT25_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT25_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT25_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT25_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT25_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT25_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT25_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT25_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT25_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT25_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT25_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT25_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT25_ESIZE_32BIT     (0x00000002u)


#define CSL_DMAX_EVENT25_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT25_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT25_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT25_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT25_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT25_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT25_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT25_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT25_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT25_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT25_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT25_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT25_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT25_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT25_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT25_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT25_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT25_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT25_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT25_RESETVAL        (0x00000000u)

/* EVENT26 */

#define CSL_DMAX_EVENT26_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT26_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT26_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT26_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT26_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT26_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT26_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT26_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT26_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT26_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT26_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT26_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT26_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT26_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT26_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT26_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT26_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT26_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT26_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT26_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT26_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT26_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT26_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT26_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT26_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT26_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT26_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT26_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT26_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT26_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT26_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT26_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT26_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT26_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT26_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT26_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT26_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT26_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT26_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT26_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT26_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT26_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT26_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT26_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT26_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT26_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT26_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT26_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT26_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT26_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT26_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT26_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT26_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT26_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT26_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT26_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT26_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT26_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT26_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT26_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT26_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT26_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT26_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT26_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT26_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT26_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT26_RESETVAL        (0x00000000u)

/* EVENT27 */

#define CSL_DMAX_EVENT27_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT27_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT27_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT27_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT27_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT27_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT27_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT27_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT27_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT27_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT27_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT27_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT27_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT27_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT27_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT27_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT27_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT27_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT27_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT27_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT27_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT27_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT27_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT27_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT27_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT27_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT27_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT27_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT27_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT27_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT27_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT27_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT27_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT27_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT27_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT27_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT27_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT27_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT27_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT27_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT27_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT27_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT27_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT27_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT27_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT27_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT27_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT27_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT27_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT27_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT27_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT27_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT27_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT27_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT27_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT27_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT27_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT27_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT27_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT27_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT27_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT27_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT27_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT27_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT27_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT27_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT27_RESETVAL        (0x00000000u)

/* EVENT28 */

#define CSL_DMAX_EVENT28_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT28_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT28_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT28_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT28_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT28_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT28_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT28_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT28_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT28_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT28_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT28_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT28_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT28_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT28_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT28_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT28_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT28_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT28_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT28_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT28_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT28_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT28_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT28_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT28_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT28_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT28_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT28_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT28_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT28_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT28_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT28_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT28_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT28_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT28_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT28_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT28_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT28_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT28_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT28_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT28_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT28_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT28_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT28_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT28_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT28_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT28_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT28_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT28_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT28_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT28_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT28_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT28_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT28_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT28_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT28_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT28_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT28_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT28_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT28_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT28_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT28_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT28_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT28_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT28_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT28_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT28_RESETVAL        (0x00000000u)

/* EVENT29 */

#define CSL_DMAX_EVENT29_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT29_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT29_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT29_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT29_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT29_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT29_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT29_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT29_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT29_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT29_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT29_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT29_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT29_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT29_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT29_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT29_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT29_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT29_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT29_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT29_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT29_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT29_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT29_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT29_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT29_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT29_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT29_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT29_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT29_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT29_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT29_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT29_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT29_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT29_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT29_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT29_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT29_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT29_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT29_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT29_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT29_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT29_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT29_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT29_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT29_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT29_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT29_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT29_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT29_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT29_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT29_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT29_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT29_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT29_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT29_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT29_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT29_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT29_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT29_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT29_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT29_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT29_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT29_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT29_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT29_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT29_RESETVAL        (0x00000000u)

/* EVENT30 */

#define CSL_DMAX_EVENT30_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT30_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT30_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT30_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT30_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT30_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT30_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT30_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT30_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT30_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT30_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT30_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT30_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT30_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT30_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT30_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT30_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT30_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT30_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT30_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT30_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT30_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT30_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT30_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT30_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT30_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT30_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT30_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT30_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT30_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT30_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT30_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT30_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT30_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT30_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT30_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT30_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT30_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT30_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT30_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT30_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT30_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT30_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT30_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT30_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT30_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT30_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT30_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT30_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT30_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT30_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT30_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT30_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT30_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT30_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT30_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT30_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT30_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT30_INT_INT15       (0x00000007u)

#define CSL_DMAX_EVENT30_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT30_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT30_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT30_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT30_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT30_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT30_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT30_RESETVAL        (0x00000000u)

/* EVENT31 */

#define CSL_DMAX_EVENT31_QTSL_MASK       (0xC0000000u)
#define CSL_DMAX_EVENT31_QTSL_SHIFT      (0x0000001Eu)
#define CSL_DMAX_EVENT31_QTSL_RESETVAL   (0x00000000u)

/*----QTSL Tokens----*/
#define CSL_DMAX_EVENT31_QTSL_MOVE1_ELE  (0x00000000u)
#define CSL_DMAX_EVENT31_QTSL_MOVE4_ELE  (0x00000001u)
#define CSL_DMAX_EVENT31_QTSL_MOVE8_ELE  (0x00000002u)
#define CSL_DMAX_EVENT31_QTSL_MOVE16_ELE (0x00000003u)

#define CSL_DMAX_EVENT31_SYNC_MASK       (0x20000000u)
#define CSL_DMAX_EVENT31_SYNC_SHIFT      (0x0000001Du)
#define CSL_DMAX_EVENT31_SYNC_RESETVAL   (0x00000000u)

/*----SYNC Tokens----*/
#define CSL_DMAX_EVENT31_SYNC_TRAN_COUNT0_ELE (0x00000000u)
#define CSL_DMAX_EVENT31_SYNC_TRAN_COMPL (0x00000001u)

#define CSL_DMAX_EVENT31_TCC_MASK        (0x0F000000u)
#define CSL_DMAX_EVENT31_TCC_SHIFT       (0x00000018u)
#define CSL_DMAX_EVENT31_TCC_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT31_ATCINT_MASK     (0x00800000u)
#define CSL_DMAX_EVENT31_ATCINT_SHIFT    (0x00000017u)
#define CSL_DMAX_EVENT31_ATCINT_RESETVAL (0x00000000u)

/*----ATCINT Tokens----*/
#define CSL_DMAX_EVENT31_ATCINT_DISABLE  (0x00000000u)
#define CSL_DMAX_EVENT31_ATCINT_ENABLE   (0x00000001u)

#define CSL_DMAX_EVENT31_TCINT_MASK      (0x00400000u)
#define CSL_DMAX_EVENT31_TCINT_SHIFT     (0x00000016u)
#define CSL_DMAX_EVENT31_TCINT_RESETVAL  (0x00000000u)

/*----TCINT Tokens----*/
#define CSL_DMAX_EVENT31_TCINT_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT31_TCINT_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT31_RLOAD_MASK      (0x00100000u)
#define CSL_DMAX_EVENT31_RLOAD_SHIFT     (0x00000014u)
#define CSL_DMAX_EVENT31_RLOAD_RESETVAL  (0x00000000u)

/*----RLOAD Tokens----*/
#define CSL_DMAX_EVENT31_RLOAD_DISABLE   (0x00000000u)
#define CSL_DMAX_EVENT31_RLOAD_ENABLE    (0x00000001u)

#define CSL_DMAX_EVENT31_CC_MASK         (0x000C0000u)
#define CSL_DMAX_EVENT31_CC_SHIFT        (0x00000012u)
#define CSL_DMAX_EVENT31_CC_RESETVAL     (0x00000000u)

/*----CC Tokens----*/
#define CSL_DMAX_EVENT31_CC_COUNT2_15_COUNT1_8_COUNT0_8 (0x00000000u)
#define CSL_DMAX_EVENT31_CC_COUNT2_7_COUNT1_8_COUNT0_16 (0x00000001u)
#define CSL_DMAX_EVENT31_CC_COUNT2_7_COUNT1_16_COUNT0_8 (0x00000002u)

#define CSL_DMAX_EVENT31_ESIZE_MASK      (0x00030000u)
#define CSL_DMAX_EVENT31_ESIZE_SHIFT     (0x00000010u)
#define CSL_DMAX_EVENT31_ESIZE_RESETVAL  (0x00000000u)

/*----ESIZE Tokens----*/
#define CSL_DMAX_EVENT31_ESIZE_8BIT      (0x00000000u)
#define CSL_DMAX_EVENT31_ESIZE_16BIT     (0x00000001u)
#define CSL_DMAX_EVENT31_ESIZE_32BIT     (0x00000002u)

#define CSL_DMAX_EVENT31_EWM_MASK       (0x00010000u)
#define CSL_DMAX_EVENT31_EWM_SHIFT      (0x00000010u)
#define CSL_DMAX_EVENT31_EWM_RESETVAL   (0x00000000u)

/*------ WaterMark Enable Tokens -----*/
#define CSL_DMAX_EVENT31_EWM_ONE        (0x00000001u)
#define CSL_DMAX_EVENT31_EWM_ZERO       (0x00000000u)

#define CSL_DMAX_EVENT31_PTE_MASK        (0x00007F00u)
#define CSL_DMAX_EVENT31_PTE_SHIFT       (0x00000008u)
#define CSL_DMAX_EVENT31_PTE_RESETVAL    (0x00000000u)

#define CSL_DMAX_EVENT31_INT_MASK        (0x00070000u)
#define CSL_DMAX_EVENT31_INT_SHIFT       (0x00000010u)
#define CSL_DMAX_EVENT31_INT_RESETVAL    (0x00000000u)

/*---- INT TOKENS ----*/
#define CSL_DMAX_EVENT31_INT_INT9		 (0x00000002u)
#define CSL_DMAX_EVENT31_INT_INT10       (0x00000003u)
#define CSL_DMAX_EVENT31_INT_INT11       (0x00000004u)
#define CSL_DMAX_EVENT31_INT_INT12       (0x00000005u)
#define CSL_DMAX_EVENT31_INT_INT13       (0x00000006u)
#define CSL_DMAX_EVENT31_INT_INT15       (0x00000007u)


#define CSL_DMAX_EVENT31_ETYPE_MASK      (0x0000001Fu)
#define CSL_DMAX_EVENT31_ETYPE_SHIFT     (0x00000000u)
#define CSL_DMAX_EVENT31_ETYPE_RESETVAL  (0x00000000u)

/*----ETYPE Tokens----*/
#define CSL_DMAX_EVENT31_ETYPE_GENERALXFR (0x00000003u)
#define CSL_DMAX_EVENT31_ETYPE_FIFOWRITE (0x00000004u)
#define CSL_DMAX_EVENT31_ETYPE_FIFOREAD  (0x00000005u)
#define CSL_DMAX_EVENT31_ETYPE_CPUINT    (0x00000007u)

#define CSL_DMAX_EVENT31_RESETVAL        (0x00000000u)

/* WORD0 */

#define CSL_DMAX_WORD0_WORD0_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD0_WORD0_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD0_WORD0_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD0_RESETVAL          (0x00000000u)

/* WORD1 */

#define CSL_DMAX_WORD1_WORD1_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD1_WORD1_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD1_WORD1_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD1_RESETVAL          (0x00000000u)

/* WORD2 */

#define CSL_DMAX_WORD2_WORD2_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD2_WORD2_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD2_WORD2_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD2_RESETVAL          (0x00000000u)

/* WORD3 */

#define CSL_DMAX_WORD3_WORD3_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD3_WORD3_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD3_WORD3_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD3_RESETVAL          (0x00000000u)

/* WORD4 */

#define CSL_DMAX_WORD4_WORD4_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD4_WORD4_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD4_WORD4_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD4_RESETVAL          (0x00000000u)

/* WORD5 */

#define CSL_DMAX_WORD5_WORD5_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD5_WORD5_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD5_WORD5_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD5_RESETVAL          (0x00000000u)

/* WORD6 */

#define CSL_DMAX_WORD6_WORD6_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD6_WORD6_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD6_WORD6_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD6_RESETVAL          (0x00000000u)

/* WORD7 */

#define CSL_DMAX_WORD7_WORD7_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD7_WORD7_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD7_WORD7_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD7_RESETVAL          (0x00000000u)

/* WORD8 */

#define CSL_DMAX_WORD8_WORD8_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD8_WORD8_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD8_WORD8_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD8_RESETVAL          (0x00000000u)

/* WORD9 */

#define CSL_DMAX_WORD9_WORD9_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_WORD9_WORD9_SHIFT       (0x00000000u)
#define CSL_DMAX_WORD9_WORD9_RESETVAL    (0x00000000u)

#define CSL_DMAX_WORD9_RESETVAL          (0x00000000u)

/* WORD10 */

#define CSL_DMAX_WORD10_WORD10_MASK      (0xFFFFFFFFu)
#define CSL_DMAX_WORD10_WORD10_SHIFT     (0x00000000u)
#define CSL_DMAX_WORD10_WORD10_RESETVAL  (0x00000000u)

#define CSL_Dmax_WORD10_RESETVAL         (0x00000000u)

/*=============================================================================
* dMax Event Status Resgister Field Definitions
*/

#define CSL_DMAX_DESR_TCC15_MASK         (0x80000000u)
#define CSL_DMAX_DESR_TCC15_SHIFT        (0x0000001Fu)
#define CSL_DMAX_DESR_TCC15_RESETVAL     (0x00000000u)

#define CSL_DMAX_DESR_TCC14_MASK         (0x40000000u)
#define CSL_DMAX_DESR_TCC14_SHIFT        (0x0000001Eu)
#define CSL_DMAX_DESR_TCC14_RESETVAL     (0x00000000u)

#define CSL_DMAX_DESR_TCC13_MASK         (0x20000000u)
#define CSL_DMAX_DESR_TCC13_SHIFT        (0x0000001Du)
#define CSL_DMAX_DESR_TCC13_RESETVAL     (0x00000000u)

#define CSL_DMAX_DESR_TCC12_MASK         (0x10000000u)
#define CSL_DMAX_DESR_TCC12_SHIFT        (0x0000001Cu)
#define CSL_DMAX_DESR_TCC12_RESETVAL     (0x00000000u)

#define CSL_DMAX_DESR_TCC11_MASK         (0x08000000u)
#define CSL_DMAX_DESR_TCC11_SHIFT        (0x0000001Bu)
#define CSL_DMAX_DESR_TCC11_RESETVAL     (0x00000000u)

#define CSL_DMAX_DESR_TCC10_MASK         (0x04000000u)
#define CSL_DMAX_DESR_TCC10_SHIFT        (0x0000001Au)
#define CSL_DMAX_DESR_TCC10_RESETVAL     (0x00000000u)

#define CSL_DMAX_DESR_TCC9_MASK         (0x02000000u)
#define CSL_DMAX_DESR_TCC9_SHIFT        (0x00000019u)
#define CSL_DMAX_DESR_TCC9_RESETVAL     (0x00000000u)

#define CSL_DMAX_DESR_TCC8_MASK          (0x01000000u)
#define CSL_DMAX_DESR_TCC8_SHIFT         (0x00000018u)
#define CSL_DMAX_DESR_TCC8_RESETVAL      (0x00000000u)

#define CSL_DMAX_DESR_TCC7_MASK          (0x00008000u)
#define CSL_DMAX_DESR_TCC7_SHIFT         (0x0000000Fu)
#define CSL_DMAX_DESR_TCC7_RESETVAL      (0x00000000u)

#define CSL_DMAX_DESR_TCC6_MASK          (0x00004000u)
#define CSL_DMAX_DESR_TCC6_SHIFT         (0x0000000Eu)
#define CSL_DMAX_DESR_TCC6_RESETVAL      (0x00000000u)

#define CSL_DMAX_DESR_TCC5_MASK          (0x00002000u)
#define CSL_DMAX_DESR_TCC5_SHIFT         (0x0000000Du)
#define CSL_DMAX_DESR_TCC5_RESETVAL      (0x00000000u)

#define CSL_DMAX_DESR_TCC4_MASK          (0x00001000u)
#define CSL_DMAX_DESR_TCC4_SHIFT         (0x0000000Cu)
#define CSL_DMAX_DESR_TCC4_RESETVAL      (0x00000000u)

#define CSL_DMAX_DESR_TCC3_MASK          (0x00000800u)
#define CSL_DMAX_DESR_TCC3_SHIFT         (0x0000000Bu)
#define CSL_DMAX_DESR_TCC3_RESETVAL      (0x00000000u)

#define CSL_DMAX_DESR_TCC2_MASK          (0x00000400u)
#define CSL_DMAX_DESR_TCC2_SHIFT         (0x0000000Au)
#define CSL_DMAX_DESR_TCC2_RESETVAL      (0x00000000u)

#define CSL_DMAX_DESR_TCC1_MASK          (0x00000200u)
#define CSL_DMAX_DESR_TCC1_SHIFT         (0x00000009u)
#define CSL_DMAX_DESR_TCC1_RESETVAL      (0x00000000u)

#define CSL_DMAX_DESR_TCC0_MASK          (0x00000100u)
#define CSL_DMAX_DESR_TCC0_SHIFT         (0x00000008u)
#define CSL_DMAX_DESR_TCC0_RESETVAL      (0x00000000u)

#define CSL_DMAX_DESR_LBC_MASK           (0x00FF0000u)
#define CSL_DMAX_DESR_LBC_SHIFT          (0x00000010u)
#define CSL_DMAX_DESR_LBC_RESETVAL       (0x00000000u)

#define CSL_DMAX_DESR_HBC_MASK           (0x000000FFu)
#define CSL_DMAX_DESR_HBC_SHIFT          (0x00000000u)
#define CSL_DMAX_DESR_HBC_RESETVAL       (0x00000000u)

/*=============================================================================
* dMax Parameter Entry Field Definitions
*=============================================================================*/
#define CSL_DMAX_GENERAL_SRCADDRACTIVE_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_GENERAL_SRCADDRACTIVE_SHIFT       (0x00000000u)
#define CSL_DMAX_GENERAL_SRCADDRACTIVE_RESETVAL    (0x00000000u)

#define CSL_DMAX_GENERAL_DSTADDRACTIVE_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_GENERAL_DSTADDRACTIVE_SHIFT       (0x00000000u)
#define CSL_DMAX_GENERAL_DSTADDRACTIVE_RESETVAL    (0x00000000u)

#define CSL_DMAX_GENERAL_SRCRELOAD0_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_GENERAL_SRCRELOAD0_SHIFT       (0x00000000u)
#define CSL_DMAX_GENERAL_SRCRELOAD0_RESETVAL    (0x00000000u)

#define CSL_DMAX_GENERAL_DSTRELOAD0_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_GENERAL_DSTRELOAD0_SHIFT       (0x00000000u)
#define CSL_DMAX_GENERAL_DSTRELOAD0_RESETVAL    (0x00000000u)

#define CSL_DMAX_GENERAL_SRCRELOAD1_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_GENERAL_SRCRELOAD1_SHIFT       (0x00000000u)
#define CSL_DMAX_GENERAL_SRCRELOAD1_RESETVAL    (0x00000000u)

#define CSL_DMAX_GENERAL_DSTRELOAD1_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_GENERAL_DSTRELOAD1_SHIFT       (0x00000000u)
#define CSL_DMAX_GENERAL_DSTRELOAD1_RESETVAL    (0x00000000u)

#define CSL_DMAX_GENERAL_PP_MASK                (0x80000000u)
#define CSL_DMAX_GENERAL_PP_SHIFT               (0x0000001Fu)
#define CSL_DMAX_GENERAL_PP_RESETVAL            (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT2_CC11_MASK       (0x7F000000u)
#define CSL_DMAX_GENERAL_COUNT2_CC11_SHIFT      (0x00000018u)
#define CSL_DMAX_GENERAL_COUNT2_CC11_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT2_CC01_MASK       (0x7F000000u)
#define CSL_DMAX_GENERAL_COUNT2_CC01_SHIFT      (0x00000018u)
#define CSL_DMAX_GENERAL_COUNT2_CC01_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT2_CC10_MASK       (0x7F000000u)
#define CSL_DMAX_GENERAL_COUNT2_CC10_SHIFT      (0x00000018u)
#define CSL_DMAX_GENERAL_COUNT2_CC10_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT2_CC00_MASK       (0x7FFF0000u)
#define CSL_DMAX_GENERAL_COUNT2_CC00_SHIFT      (0x00000010u)
#define CSL_DMAX_GENERAL_COUNT2_CC00_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT1_CC01_MASK       (0x00FF0000u)
#define CSL_DMAX_GENERAL_COUNT1_CC01_SHIFT      (0x00000010u)
#define CSL_DMAX_GENERAL_COUNT1_CC01_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT1_CC10_MASK       (0x00FFFF00u)
#define CSL_DMAX_GENERAL_COUNT1_CC10_SHIFT      (0x00000008u)
#define CSL_DMAX_GENERAL_COUNT1_CC10_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT1_CC11_MASK       (0x00FF0000u)
#define CSL_DMAX_GENERAL_COUNT1_CC11_SHIFT      (0x00000010u)
#define CSL_DMAX_GENERAL_COUNT1_CC11_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT1_CC00_MASK       (0x0000FF00u)
#define CSL_DMAX_GENERAL_COUNT1_CC00_SHIFT      (0x00000008u)
#define CSL_DMAX_GENERAL_COUNT1_CC00_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT0_CC01_MASK       (0x0000FFFFu)
#define CSL_DMAX_GENERAL_COUNT0_CC01_SHIFT      (0x00000000u)
#define CSL_DMAX_GENERAL_COUNT0_CC01_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT0_CC10_MASK       (0x000000FFu)
#define CSL_DMAX_GENERAL_COUNT0_CC10_SHIFT      (0x00000000u)
#define CSL_DMAX_GENERAL_COUNT0_CC10_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT0_CC00_MASK       (0x000000FFu)
#define CSL_DMAX_GENERAL_COUNT0_CC00_SHIFT      (0x00000000u)
#define CSL_DMAX_GENERAL_COUNT0_CC00_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_COUNT0_CC11_MASK       (0x0000FFFFu)
#define CSL_DMAX_GENERAL_COUNT0_CC11_SHIFT      (0x00000000u)
#define CSL_DMAX_GENERAL_COUNT0_CC11_RESETVAL   (0x00000000u)

#define CSL_DMAX_GENERAL_SRCINDEX0_MASK          (0x0000FFFFu)
#define CSL_DMAX_GENERAL_SRCINDEX0_SHIFT         (0x00000000u)
#define CSL_DMAX_GENERAL_SRCINDEX0_RESETVAL      (0x00000000u)

#define CSL_DMAX_GENERAL_SRCINDEX1_MASK          (0x0000FFFFu)
#define CSL_DMAX_GENERAL_SRCINDEX1_SHIFT         (0x00000000u)
#define CSL_DMAX_GENERAL_SRCINDEX1_RESETVAL      (0x00000000u)

#define CSL_DMAX_GENERAL_SRCINDEX2_MASK          (0x0000FFFFu)
#define CSL_DMAX_GENERAL_SRCINDEX2_SHIFT         (0x00000000u)
#define CSL_DMAX_GENERAL_SRCINDEX2_RESETVAL      (0x00000000u)

#define CSL_DMAX_GENERAL_DSTINDEX0_MASK          (0xFFFF0000u)
#define CSL_DMAX_GENERAL_DSTINDEX0_SHIFT         (0x00000010u)
#define CSL_DMAX_GENERAL_DSTINDEX0_RESETVAL      (0x00000000u)

#define CSL_DMAX_GENERAL_DSTINDEX1_MASK          (0xFFFF0000u)
#define CSL_DMAX_GENERAL_DSTINDEX1_SHIFT         (0x00000010u)
#define CSL_DMAX_GENERAL_DSTINDEX1_RESETVAL      (0x00000000u)

#define CSL_DMAX_GENERAL_DSTINDEX2_MASK          (0xFFFF0000u)
#define CSL_DMAX_GENERAL_DSTINDEX2_SHIFT         (0x00000010u)
#define CSL_DMAX_GENERAL_DSTINDEX2_RESETVAL      (0x00000000u)

#define CSL_DMAX_FIFODESC_FIFOBASEADDR_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_FIFODESC_FIFOBASEADDR_SHIFT       (0x00000000u)
#define CSL_DMAX_FIFODESC_FIFOBASEADDR_RESETVAL    (0x00000000u)

#define CSL_DMAX_FIFODESC_FMARK_MASK         (0x0000FFFFu)
#define CSL_DMAX_FIFODESC_FMARK_SHIFT        (0x00000000u)
#define CSL_DMAX_FIFODESC_FMARK_RESETVAL     (0x00000000u)

#define CSL_DMAX_FIFODESC_FMARK_MASK         (0x0000FFFFu)
#define CSL_DMAX_FIFODESC_FMARK_SHIFT        (0x00000000u)
#define CSL_DMAX_FIFODESC_FMARK_RESETVAL     (0x00000000u)

#define CSL_DMAX_FIFODESC_FMSC_MASK          (0x0F000000u)
#define CSL_DMAX_FIFODESC_FMSC_SHIFT         (0x00000018u)
#define CSL_DMAX_FIFODESC_FMSC_RESETVAL      (0x00000000u)

#define CSL_DMAX_FIFODESC_EMSC_MASK          (0x0F000000u)
#define CSL_DMAX_FIFODESC_EMSC_SHIFT         (0x00000018u)
#define CSL_DMAX_FIFODESC_EMSC_RESETVAL      (0x00000000u)

#define CSL_DMAX_FIFODESC_FIFOSIZE_MASK      (0x000FFFFFu)
#define CSL_DMAX_FIFODESC_FIFOSIZE_SHIFT     (0x00000000u)
#define CSL_DMAX_FIFODESC_FIFOSIZE_RESETVAL  (0x00000000u)

#define CSL_DMAX_FIFODESC_EFIELD_MASK        (0x01010101u)
#define CSL_DMAX_FIFODESC_EFIELD_SHIFT       (0x00000000u)
#define CSL_DMAX_FIFODESC_EFIELD_RESETVAL    (0x00000000u)

#define CSL_DMAX_FIFODESC_ESIZE_MASK         (0x03000000u)
#define CSL_DMAX_FIFODESC_ESIZE_SHIFT        (0x00000018u)
#define CSL_DMAX_FIFODESC_ESIZE_RESETVAL     (0x00000000u)

#define CSL_DMAX_FIFODESC_ESIZE_8BITS        (0x00000000u)
#define CSL_DMAX_FIFODESC_ESIZE_16BITS       (0x00000001u)
#define CSL_DMAX_FIFODESC_ESIZE_32BITS       (0x00000002u)

#define CSL_DMAX_FIFODESC_RPTR_MASK          (0x000FFFFFu)
#define CSL_DMAX_FIFODESC_RPTR_SHIFT         (0x00000000u)
#define CSL_DMAX_FIFODESC_RPTR_RESETVAL      (0x00000000u)

#define CSL_DMAX_FIFODESC_WPTR_MASK          (0x000FFFFFu)
#define CSL_DMAX_FIFODESC_WPTR_SHIFT         (0x00000000u)
#define CSL_DMAX_FIFODESC_WPTR_RESETVAL      (0x00000000u)

#define CSL_DMAX_FIFORW_LINEARADDR_MASK      (0xFFFFFFFFu)
#define CSL_DMAX_FIFORW_LINEARADDR_SHIFT     (0x00000000u)
#define CSL_DMAX_FIFORW_LINEARADDR_RESETVAL  (0x00000000u)

#define CSL_DMAX_FIFORW_COUNT0_MASK          (0x0000FFFFu)
#define CSL_DMAX_FIFORW_COUNT0_SHIFT         (0x00000000u)
#define CSL_DMAX_FIFORW_COUNT0_RESETVAL      (0x00000000u)

#define CSL_DMAX_FIFORW_COUNT1_MASK          (0x7FFF0000u)
#define CSL_DMAX_FIFORW_COUNT1_SHIFT         (0x00000010u)
#define CSL_DMAX_FIFORW_COUNT1_RESETVAL      (0x00000000u)

#define CSL_DMAX_FIFORW_DTABPTR0_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_FIFORW_DTABPTR0_SHIFT       (0x00000000u)
#define CSL_DMAX_FIFORW_DTABPTR0_RESETVAL    (0x00000000u)

#define CSL_DMAX_FIFORW_DTABPTR1_MASK        (0xFFFFFFFFu)
#define CSL_DMAX_FIFORW_DTABPTR1_SHIFT       (0x00000000u)
#define CSL_DMAX_FIFORW_DTABPTR1_RESETVAL    (0x00000000u)

#define CSL_DMAX_FIFORW_LINEARRELOAD0_MASK     (0xFFFFFFFFu)
#define CSL_DMAX_FIFORW_LINEARRELOAD0_SHIFT    (0x00000000u)
#define CSL_DMAX_FIFORW_LINEARRELOAD0_RESETVAL (0x00000000u)

#define CSL_DMAX_FIFORW_LINEARRELOAD1_MASK     (0xFFFFFFFFu)
#define CSL_DMAX_FIFORW_LINEARRELOAD1_SHIFT    (0x00000000u)
#define CSL_DMAX_FIFORW_LINEARRELOAD1_RESETVAL (0x00000000u)


#define CSL_DMAX_HIPRIORITY_EVENT         (0x10000000u)
#define CSL_DMAX_LOPRIORITY_EVENT         (0x20000000u)

#define CSL_DMAX_HIPRIORITY_EVENT0_UID    (0x10000000u)
#define CSL_DMAX_HIPRIORITY_EVENT1_UID    (0x10100001u)

#define CSL_DMAX_HIPRIORITY_EVENT2_UID    (0x10FF0002u)
#define CSL_DMAX_HIPRIORITY_RTIREQ0_UID   (0x10FF0002u)

#define CSL_DMAX_HIPRIORITY_EVENT3_UID    (0x10FF0003u)
#define CSL_DMAX_HIPRIORITY_RTIREQ1_UID   (0x10FF0003u)

#define CSL_DMAX_HIPRIORITY_EVENT4_UID    (0x10FF0004u)
#define CSL_DMAX_HIPRIORITY_MCASP0TX_UID  (0x10FF0004u)

#define CSL_DMAX_HIPRIORITY_EVENT5_UID    (0x10FF0005u)
#define CSL_DMAX_HIPRIORITY_MCASP0RX_UID  (0x10FF0005u)

#define CSL_DMAX_HIPRIORITY_EVENT6_UID    (0x10FF0006u)
#define CSL_DMAX_HIPRIORITY_MCASP1TX_UID  (0x10FF0006u)

#define CSL_DMAX_HIPRIORITY_EVENT7_UID    (0x10FF0007u)
#define CSL_DMAX_HIPRIORITY_MCASP1RX_UID  (0x10FF0007u)

#define CSL_DMAX_HIPRIORITY_EVENT8_UID    (0x10FF0008u)
#define CSL_DMAX_HIPRIORITY_MCASP2TX_UID  (0x10FF0008u)

#define CSL_DMAX_HIPRIORITY_EVENT9_UID    (0x10FF0009u)
#define CSL_DMAX_HIPRIORITY_MCASP2RX_UID  (0x10FF0009u)

#define CSL_DMAX_HIPRIORITY_EVENT10_UID   (0x1001000Au)
#define CSL_DMAX_HIPRIORITY_EVENT11_UID   (0x1011000Bu)

#define CSL_DMAX_HIPRIORITY_EVENT12_UID   (0x10FF000Cu)
#define CSL_DMAX_HIPRIORITY_UHPIINT_UID   (0x10FF000Cu)

#define CSL_DMAX_HIPRIORITY_EVENT13_UID   (0x10FF000Du)
#define CSL_DMAX_HIPRIORITY_SPI0RX_UID    (0x10FF000Du)

#define CSL_DMAX_HIPRIORITY_EVENT14_UID   (0x10FF000Eu)
#define CSL_DMAX_HIPRIORITY_SPI1RX_UID    (0x10FF000Eu)

#define CSL_DMAX_HIPRIORITY_EVENT15_UID   (0x10FF000Fu)
#define CSL_DMAX_HIPRIORITY_RTIREQ2_UID   (0x10FF000Fu)

#define CSL_DMAX_HIPRIORITY_EVENT16_UID   (0x10FF0010u)
#define CSL_DMAX_HIPRIORITY_RTIREQ3_UID   (0x10FF0010u)


#define CSL_DMAX_HIPRIORITY_EVENT17_UID   (0x10020011u)
#define CSL_DMAX_HIPRIORITY_EVENT18_UID   (0x10120012u)

#define CSL_DMAX_HIPRIORITY_EVENT19_UID   (0x10FF0013u)
#define CSL_DMAX_HIPRIORITY_I2C0XEVT_UID  (0x10FF0013u)

#define CSL_DMAX_HIPRIORITY_EVENT20_UID   (0x10FF0014U)
#define CSL_DMAX_HIPRIORITY_I2C0REVT_UID  (0x10FF0014U)

#define CSL_DMAX_HIPRIORITY_EVENT21_UID   (0x10FF0015u)
#define CSL_DMAX_HIPRIORITY_I2C1XEVT_UID  (0x10FF0015u)


#define CSL_DMAX_HIPRIORITY_EVENT22_UID   (0x10FF0016u)
#define CSL_DMAX_HIPRIORITY_I2C1REVT_UID  (0x10FF0016u)

#define CSL_DMAX_HIPRIORITY_EVENT23_UID   (0x10030017u)
#define CSL_DMAX_HIPRIORITY_EVENT24_UID   (0x10130018u)

#define CSL_DMAX_HIPRIORITY_EVENT26_UID   (0x10FF001Au)
#define CSL_DMAX_HIPRIORITY_MCASP0ERR_UID (0x10FF001Au)

#define CSL_DMAX_HIPRIORITY_EVENT27_UID   (0x10FF001Bu)
#define CSL_DMAX_HIPRIORITY_MCASP1ERR_UID (0x10FF001Bu)

#define CSL_DMAX_HIPRIORITY_EVENT28_UID   (0x10FF001Cu)
#define CSL_DMAX_HIPRIORITY_MCASP2ERR_UID (0x10FF001Cu)

#define CSL_DMAX_HIPRIORITY_EVENT29_UID   (0x10FF001Du)
#define CSL_DMAX_HIPRIORITY_OVLREQ_UID    (0x10FF001Du)


#define CSL_DMAX_HIPRIORITY_EVENT30_UID   (0x1014001Eu)
#define CSL_DMAX_HIPRIORITY_EVENT31_UID   (0x1015001Fu)

#define CSL_DMAX_LOPRIORITY_EVENT0_UID    (0x20000000u)
#define CSL_DMAX_LOPRIORITY_EVENT1_UID    (0x20100001u)

#define CSL_DMAX_LOPRIORITY_EVENT2_UID    (0x20FF0002u)
#define CSL_DMAX_LOPRIORITY_RTIREQ0_UID   (0x20FF0002u)

#define CSL_DMAX_LOPRIORITY_EVENT3_UID    (0x20FF0003u)
#define CSL_DMAX_LOPRIORITY_RTIREQ1_UID   (0x20FF0003u)

#define CSL_DMAX_LOPRIORITY_EVENT4_UID    (0x20FF0004u)
#define CSL_DMAX_LOPRIORITY_MCASP0TX_UID  (0x20FF0004u)

#define CSL_DMAX_LOPRIORITY_EVENT5_UID    (0x20FF0005u)
#define CSL_DMAX_LOPRIORITY_MCASP0RX_UID  (0x20FF0005u)

#define CSL_DMAX_LOPRIORITY_EVENT6_UID    (0x20FF0006u)
#define CSL_DMAX_LOPRIORITY_MCASP1TX_UID  (0x20FF0006u)

#define CSL_DMAX_LOPRIORITY_EVENT7_UID    (0x20FF0007u)
#define CSL_DMAX_LOPRIORITY_MCASP1RX_UID  (0x20FF0007u)

#define CSL_DMAX_LOPRIORITY_EVENT8_UID    (0x20FF0008u)
#define CSL_DMAX_LOPRIORITY_MCASP2TX_UID  (0x20FF0008u)

#define CSL_DMAX_LOPRIORITY_EVENT9_UID    (0x20FF0009u)
#define CSL_DMAX_LOPRIORITY_MCASP2RX_UID  (0x20FF0009u)

#define CSL_DMAX_LOPRIORITY_EVENT10_UID   (0x2001000Au)
#define CSL_DMAX_LOPRIORITY_EVENT11_UID   (0x2011000Bu)

#define CSL_DMAX_LOPRIORITY_EVENT12_UID   (0x20FF000Cu)
#define CSL_DMAX_LOPRIORITY_UHPIINT_UID   (0x20FF000Cu)

#define CSL_DMAX_LOPRIORITY_EVENT13_UID   (0x20FF000Du)
#define CSL_DMAX_LOPRIORITY_SPI0RX_UID    (0x20FF000Du)

#define CSL_DMAX_LOPRIORITY_EVENT14_UID   (0x20FF000Eu)
#define CSL_DMAX_LOPRIORITY_SPI1RX_UID    (0x20FF000Eu)

#define CSL_DMAX_LOPRIORITY_EVENT15_UID   (0x20FF000Fu)
#define CSL_DMAX_LOPRIORITY_RTIREQ2_UID   (0x20FF000Fu)

#define CSL_DMAX_LOPRIORITY_EVENT16_UID   (0x20FF0010u)
#define CSL_DMAX_LOPRIORITY_RTIREQ3_UID   (0x20FF0010u)


#define CSL_DMAX_LOPRIORITY_EVENT17_UID   (0x20020011u)
#define CSL_DMAX_LOPRIORITY_EVENT18_UID   (0x20120012u)

#define CSL_DMAX_LOPRIORITY_EVENT19_UID   (0x20FF0013u)
#define CSL_DMAX_LOPRIORITY_I2C0XEVT_UID  (0x20FF0013u)

#define CSL_DMAX_LOPRIORITY_EVENT20_UID   (0x20FF0014U)
#define CSL_DMAX_LOPRIORITY_I2C0REVT_UID  (0x20FF0014U)

#define CSL_DMAX_LOPRIORITY_EVENT21_UID   (0x20FF0015u)
#define CSL_DMAX_LOPRIORITY_I2C1XEVT_UID  (0x20FF0015u)


#define CSL_DMAX_LOPRIORITY_EVENT22_UID   (0x20FF0016u)
#define CSL_DMAX_LOPRIORITY_I2C1REVT_UID  (0x20FF0016u)

#define CSL_DMAX_LOPRIORITY_EVENT23_UID   (0x20030017u)
#define CSL_DMAX_LOPRIORITY_EVENT24_UID   (0x20130018u)

#define CSL_DMAX_LOPRIORITY_EVENT26_UID   (0x20FF001Au)
#define CSL_DMAX_LOPRIORITY_MCASP0ERR_UID (0x20FF001Au)

#define CSL_DMAX_LOPRIORITY_EVENT27_UID   (0x20FF001Bu)
#define CSL_DMAX_LOPRIORITY_MCASP1ERR_UID (0x20FF001Bu)

#define CSL_DMAX_LOPRIORITY_EVENT28_UID   (0x20FF001Cu)
#define CSL_DMAX_LOPRIORITY_MCASP2ERR_UID (0x20FF001Cu)

#define CSL_DMAX_LOPRIORITY_EVENT29_UID   (0x20FF001Du)
#define CSL_DMAX_LOPRIORITY_OVLREQ_UID    (0x20FF001Du)


#define CSL_DMAX_LOPRIORITY_EVENT30_UID   (0x2014001Eu)
#define CSL_DMAX_LOPRIORITY_EVENT31_UID   (0x2015001Fu)

/* Define dMax Hi and Lo Paramter Table Entry UIDs */
#define CSL_DMAX_HIPRIORITY_PARAMETERENTRY0_UID    (0x30000000u)
#define CSL_DMAX_HIPRIORITY_PARAMETERENTRY1_UID    (0x30000001u)
#define CSL_DMAX_HIPRIORITY_PARAMETERENTRY2_UID    (0x30000002u)
#define CSL_DMAX_HIPRIORITY_PARAMETERENTRY3_UID    (0x30000003u)
#define CSL_DMAX_HIPRIORITY_PARAMETERENTRY4_UID    (0x30000004u)
#define CSL_DMAX_HIPRIORITY_PARAMETERENTRY5_UID    (0x30000005u)
#define CSL_DMAX_HIPRIORITY_PARAMETERENTRY6_UID    (0x30000006u)
#define CSL_DMAX_HIPRIORITY_PARAMETERENTRY7_UID    (0x30000007u)

#define CSL_DMAX_LOPRIORITY_PARAMETERENTRY0_UID    (0x40000000u)
#define CSL_DMAX_LOPRIORITY_PARAMETERENTRY1_UID    (0x40000001u)
#define CSL_DMAX_LOPRIORITY_PARAMETERENTRY2_UID    (0x40000002u)
#define CSL_DMAX_LOPRIORITY_PARAMETERENTRY3_UID    (0x40000003u)
#define CSL_DMAX_LOPRIORITY_PARAMETERENTRY4_UID    (0x40000004u)
#define CSL_DMAX_LOPRIORITY_PARAMETERENTRY5_UID    (0x40000005u)
#define CSL_DMAX_LOPRIORITY_PARAMETERENTRY6_UID    (0x40000006u)
#define CSL_DMAX_LOPRIORITY_PARAMETERENTRY7_UID    (0x40000007u)

#define CSL_DMAX_HIPRIORITY_EVENT_ANY				 (0x1000FFFFu)
#define CSL_DMAX_LOPRIORITY_EVENT_ANY				 (0x2000FFFFu)
#define CSL_DMAX_HIPRIORITY_PARAMETERENTRY_ANY		 (0x3000FFFFu)
#define CSL_DMAX_LOPRIORITY_PARAMETERENTRY_ANY		 (0x4000FFFFu)
#define CSL_DMAX_HI_PRIORITY                         (0x00000001u)

#endif
