#ifndef _CSLR_EMIF_H_
#define _CSLR_EMIF_H_
/*********************************************************************
 * Copyright (C) 2003-2006 Texas Instruments Incorporated. 
 * All Rights Reserved 
 *********************************************************************/
 /** \file cslr_emif.h
 * 
 * \brief This file contains the Register Desciptions for EMIF
 * 
 *********************************************************************/

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 RSVD0[1];
    volatile Uint32 AWCCR;
    volatile Uint32 SDCR;
    volatile Uint32 SDRCR;
    volatile Uint32 A1CR;
    volatile Uint32 RSVD1[3];
    volatile Uint32 SDTIMR;
    volatile Uint32 RSVD2[6];
    volatile Uint32 SDSRETR;
    volatile Uint32 EIRR;
    volatile Uint32 EIMR;
    volatile Uint32 EIMSR;
    volatile Uint32 EIMCR;
    volatile Uint32 RSVD3[4];
    volatile Uint32 NANDFCR;
    volatile Uint32 NANDFSR;
    volatile Uint32 RSVD4[2];
    volatile Uint32 NANDF1ECC;
} CSL_EmifRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* AWCCR */

#define CSL_EMIF_AWCCR_WP0_MASK          (0x10000000u)
#define CSL_EMIF_AWCCR_WP0_SHIFT         (0x0000001Cu)
#define CSL_EMIF_AWCCR_WP0_RESETVAL      (0x00000001u)

/*----WP0 Tokens----*/
#define CSL_EMIF_AWCCR_WP0_LOW           (0x00000000u)
#define CSL_EMIF_AWCCR_WP0_HIGHI         (0x00000001u)

#define CSL_EMIF_AWCCR_MEWC_MASK         (0x000000FFu)
#define CSL_EMIF_AWCCR_MEWC_SHIFT        (0x00000000u)
#define CSL_EMIF_AWCCR_MEWC_RESETVAL     (0x00000080u)

#define CSL_EMIF_AWCCR_RESETVAL          (0x10000080u)

/* SDCR */

#define CSL_EMIF_SDCR_SR_MASK            (0x80000000u)
#define CSL_EMIF_SDCR_SR_SHIFT           (0x0000001Fu)
#define CSL_EMIF_SDCR_SR_RESETVAL        (0x00000000u)

/*----SR Tokens----*/
#define CSL_EMIF_SDCR_SR_DISABLE         (0x00000000u)
#define CSL_EMIF_SDCR_SR_ENABLE          (0x00000001u)

#define CSL_EMIF_SDCR_NM_MASK            (0x00004000u)
#define CSL_EMIF_SDCR_NM_SHIFT           (0x0000000Eu)
#define CSL_EMIF_SDCR_NM_RESETVAL        (0x00000000u)

/*----NM Tokens----*/
#define CSL_EMIF_SDCR_NM_32BIT_DATA      (0x00000000u)
#define CSL_EMIF_SDCR_NM_16BIT_DATA      (0x00000001u)

#define CSL_EMIF_SDCR_CL_MASK            (0x00000E00u)
#define CSL_EMIF_SDCR_CL_SHIFT           (0x00000009u)
#define CSL_EMIF_SDCR_CL_RESETVAL        (0x00000003u)

/*----CL Tokens----*/
#define CSL_EMIF_SDCR_CL_LATENCY_2       (0x00000002u)
#define CSL_EMIF_SDCR_CL_LATENCY_3       (0x00000003u)

#define CSL_EMIF_SDCR_BIT11_9LOCK_MASK   (0x00000100u)
#define CSL_EMIF_SDCR_BIT11_9LOCK_SHIFT  (0x00000008u)
#define CSL_EMIF_SDCR_BIT11_9LOCK_RESETVAL (0x00000000u)

/*----BIT11_9LOCK Tokens----*/
#define CSL_EMIF_SDCR_BIT11_9LOCK_UNLOCK (0x00000001u)

#define CSL_EMIF_SDCR_IBANK_MASK         (0x00000070u)
#define CSL_EMIF_SDCR_IBANK_SHIFT        (0x00000004u)
#define CSL_EMIF_SDCR_IBANK_RESETVAL     (0x00000002u)

/*----IBANK Tokens----*/
#define CSL_EMIF_SDCR_IBANK_NO_OF_BANK_1 (0x00000000u)
#define CSL_EMIF_SDCR_IBANK_NO_OF_BANK_2 (0x00000001u)
#define CSL_EMIF_SDCR_IBANK_NO_OF_BANK_4 (0x00000002u)

#define CSL_EMIF_SDCR_PAGESIZE_MASK      (0x00000007u)
#define CSL_EMIF_SDCR_PAGESIZE_SHIFT     (0x00000000u)
#define CSL_EMIF_SDCR_PAGESIZE_RESETVAL  (0x00000000u)

/*----PAGESIZE Tokens----*/
#define CSL_EMIF_SDCR_PAGESIZE_256WORD_8COL_ADDR (0x00000000u)
#define CSL_EMIF_SDCR_PAGESIZE_512WORD_9COL_ADDR (0x00000001u)
#define CSL_EMIF_SDCR_PAGESIZE_1024WORD_10COL_ADDR (0x00000002u)
#define CSL_EMIF_SDCR_PAGESIZE_2048WORD_11COL_ADDR (0x00000003u)

#define CSL_EMIF_SDCR_RESETVAL           (0x00000620u)

/* SDRCR */

#define CSL_EMIF_SDRCR_RR_MASK           (0x00001FFFu)
#define CSL_EMIF_SDRCR_RR_SHIFT          (0x00000000u)
#define CSL_EMIF_SDRCR_RR_RESETVAL       (0x00000190u)

/*----RR Tokens----*/
#define CSL_EMIF_SDRCR_RR_DEFAULT        (0x00000190u)

#define CSL_EMIF_SDRCR_RESETVAL          (0x00000190u)

/* A1CR */

#define CSL_EMIF_A1CR_SS_MASK            (0x80000000u)
#define CSL_EMIF_A1CR_SS_SHIFT           (0x0000001Fu)
#define CSL_EMIF_A1CR_SS_RESETVAL        (0x00000000u)

/*----SS Tokens----*/
#define CSL_EMIF_A1CR_SS_DISABLE         (0x00000000u)
#define CSL_EMIF_A1CR_SS_ENABLE          (0x00000001u)

#define CSL_EMIF_A1CR_EW_MASK            (0x40000000u)
#define CSL_EMIF_A1CR_EW_SHIFT           (0x0000001Eu)
#define CSL_EMIF_A1CR_EW_RESETVAL        (0x00000000u)

/*----EW Tokens----*/
#define CSL_EMIF_A1CR_EW_DISABLE         (0x00000000u)
#define CSL_EMIF_A1CR_EW_ENABLE          (0x00000001u)

#define CSL_EMIF_A1CR_W_SETUP_MASK       (0x3C000000u)
#define CSL_EMIF_A1CR_W_SETUP_SHIFT      (0x0000001Au)
#define CSL_EMIF_A1CR_W_SETUP_RESETVAL   (0x0000000Fu)

#define CSL_EMIF_A1CR_W_STROBE_MASK      (0x03F00000u)
#define CSL_EMIF_A1CR_W_STROBE_SHIFT     (0x00000014u)
#define CSL_EMIF_A1CR_W_STROBE_RESETVAL  (0x0000003Fu)

#define CSL_EMIF_A1CR_W_HOLD_MASK        (0x000E0000u)
#define CSL_EMIF_A1CR_W_HOLD_SHIFT       (0x00000011u)
#define CSL_EMIF_A1CR_W_HOLD_RESETVAL    (0x00000007u)

#define CSL_EMIF_A1CR_R_SETUP_MASK       (0x0001E000u)
#define CSL_EMIF_A1CR_R_SETUP_SHIFT      (0x0000000Du)
#define CSL_EMIF_A1CR_R_SETUP_RESETVAL   (0x0000000Fu)

#define CSL_EMIF_A1CR_R_STROBE_MASK      (0x00001F80u)
#define CSL_EMIF_A1CR_R_STROBE_SHIFT     (0x00000007u)
#define CSL_EMIF_A1CR_R_STROBE_RESETVAL  (0x0000003Fu)

#define CSL_EMIF_A1CR_R_HOLD_MASK        (0x00000070u)
#define CSL_EMIF_A1CR_R_HOLD_SHIFT       (0x00000004u)
#define CSL_EMIF_A1CR_R_HOLD_RESETVAL    (0x00000007u)

#define CSL_EMIF_A1CR_TA_MASK            (0x0000000Cu)
#define CSL_EMIF_A1CR_TA_SHIFT           (0x00000002u)
#define CSL_EMIF_A1CR_TA_RESETVAL        (0x00000003u)

#define CSL_EMIF_A1CR_ASIZE_MASK         (0x00000003u)
#define CSL_EMIF_A1CR_ASIZE_SHIFT        (0x00000000u)
#define CSL_EMIF_A1CR_ASIZE_RESETVAL     (0x00000000u)

/*----ASIZE Tokens----*/
#define CSL_EMIF_A1CR_ASIZE_8_BIT        (0x00000000u)
#define CSL_EMIF_A1CR_ASIZE_16_BIT       (0x00000001u)
#define CSL_EMIF_A1CR_ASIZE_32_BIT       (0x00000002u)
#define CSL_EMIF_A1CR_ASIZE_32_BIT       (0x00000002u)

#define CSL_EMIF_A1CR_RESETVAL           (0x3FFFFFFCu)

/* SDTIMR */

#define CSL_EMIF_SDTIMR_T_RFC_MASK       (0xF8000000u)
#define CSL_EMIF_SDTIMR_T_RFC_SHIFT      (0x0000001Bu)
#define CSL_EMIF_SDTIMR_T_RFC_RESETVAL   (0x00000000u)

#define CSL_EMIF_SDTIMR_T_RP_MASK        (0x07000000u)
#define CSL_EMIF_SDTIMR_T_RP_SHIFT       (0x00000018u)
#define CSL_EMIF_SDTIMR_T_RP_RESETVAL    (0x00000000u)

#define CSL_EMIF_SDTIMR_T_RCD_MASK       (0x00700000u)
#define CSL_EMIF_SDTIMR_T_RCD_SHIFT      (0x00000014u)
#define CSL_EMIF_SDTIMR_T_RCD_RESETVAL   (0x00000002u)

#define CSL_EMIF_SDTIMR_T_WR_MASK        (0x00070000u)
#define CSL_EMIF_SDTIMR_T_WR_SHIFT       (0x00000010u)
#define CSL_EMIF_SDTIMR_T_WR_RESETVAL    (0x00000001u)

#define CSL_EMIF_SDTIMR_T_RAS_MASK       (0x0000F000u)
#define CSL_EMIF_SDTIMR_T_RAS_SHIFT      (0x0000000Cu)
#define CSL_EMIF_SDTIMR_T_RAS_RESETVAL   (0x0000000Cu)

#define CSL_EMIF_SDTIMR_T_RC_MASK        (0x00000F00u)
#define CSL_EMIF_SDTIMR_T_RC_SHIFT       (0x00000008u)
#define CSL_EMIF_SDTIMR_T_RC_RESETVAL    (0x0000000Fu)

#define CSL_EMIF_SDTIMR_T_RRD_MASK       (0x00000070u)
#define CSL_EMIF_SDTIMR_T_RRD_SHIFT      (0x00000004u)
#define CSL_EMIF_SDTIMR_T_RRD_RESETVAL   (0x00000000u)

#define CSL_EMIF_SDTIMR_RESETVAL         (0x0021CF00u)

/* SDSRETR */

#define CSL_EMIF_SDSRETR_T_XS_MASK       (0x0000001Fu)
#define CSL_EMIF_SDSRETR_T_XS_SHIFT      (0x00000000u)
#define CSL_EMIF_SDSRETR_T_XS_RESETVAL   (0x00000019u)

#define CSL_EMIF_SDSRETR_RESETVAL        (0x00000019u)

/* EIRR */

#define CSL_EMIF_EIRR_WR_MASK            (0x00000004u)
#define CSL_EMIF_EIRR_WR_SHIFT           (0x00000002u)
#define CSL_EMIF_EIRR_WR_RESETVAL        (0x00000000u)

/*----WR Tokens----*/
#define CSL_EMIF_EIRR_WR_NOT_OCCURED     (0x00000000u)
#define CSL_EMIF_EIRR_WR_OCCURED         (0x00000001u)

#define CSL_EMIF_EIRR_AT_MASK            (0x00000001u)
#define CSL_EMIF_EIRR_AT_SHIFT           (0x00000000u)
#define CSL_EMIF_EIRR_AT_RESETVAL        (0x00000000u)

/*----AT Tokens----*/
#define CSL_EMIF_EIRR_AT_NOT_OCCURED     (0x00000000u)
#define CSL_EMIF_EIRR_AT_OCCURED         (0x00000001u)

#define CSL_EMIF_EIRR_RESETVAL           (0x00000000u)

/* EIMR */

#define CSL_EMIF_EIMR_WRM_MASK           (0x00000004u)
#define CSL_EMIF_EIMR_WRM_SHIFT          (0x00000002u)
#define CSL_EMIF_EIMR_WRM_RESETVAL       (0x00000000u)

/*----WRM Tokens----*/
#define CSL_EMIF_EIMR_WRM_NOT_OCCURED    (0x00000000u)
#define CSL_EMIF_EIMR_WRM_OCCURED        (0x00000001u)

#define CSL_EMIF_EIMR_ATM_MASK           (0x00000001u)
#define CSL_EMIF_EIMR_ATM_SHIFT          (0x00000000u)
#define CSL_EMIF_EIMR_ATM_RESETVAL       (0x00000000u)

/*----ATM Tokens----*/
#define CSL_EMIF_EIMR_ATM_NOT_OCCURED    (0x00000000u)
#define CSL_EMIF_EIMR_ATM_OCCURED        (0x00000001u)

#define CSL_EMIF_EIMR_RESETVAL           (0x00000000u)

/* EIMSR */

#define CSL_EMIF_EIMSR_WRMSET_MASK       (0x00000004u)
#define CSL_EMIF_EIMSR_WRMSET_SHIFT      (0x00000002u)
#define CSL_EMIF_EIMSR_WRMSET_RESETVAL   (0x00000000u)

/*----WRMSET Tokens----*/
#define CSL_EMIF_EIMSR_WRMSET_ENABLE     (0x00000001u)
#define CSL_EMIF_EIMSR_WRMSET_DISABLE    (0x00000000u)

#define CSL_EMIF_EIMSR_ATMSET_MASK       (0x00000001u)
#define CSL_EMIF_EIMSR_ATMSET_SHIFT      (0x00000000u)
#define CSL_EMIF_EIMSR_ATMSET_RESETVAL   (0x00000000u)

/*----ATMSET Tokens----*/
#define CSL_EMIF_EIMSR_ATMSET_DISABLE    (0x00000000u)
#define CSL_EMIF_EIMSR_ATMSET_ENABLE     (0x00000001u)

#define CSL_EMIF_EIMSR_RESETVAL          (0x00000000u)

/* EIMCR */

#define CSL_EMIF_EIMCR_WRMCLEAR_MASK     (0x00000004u)
#define CSL_EMIF_EIMCR_WRMCLEAR_SHIFT    (0x00000002u)
#define CSL_EMIF_EIMCR_WRMCLEAR_RESETVAL (0x00000000u)

#define CSL_EMIF_EIMCR_ATMCLR_MASK       (0x00000001u)
#define CSL_EMIF_EIMCR_ATMCLR_SHIFT      (0x00000000u)
#define CSL_EMIF_EIMCR_ATMCLR_RESETVAL   (0x00000000u)

#define CSL_EMIF_EIMCR_RESETVAL          (0x00000000u)

/* NANDFCR */

#define CSL_EMIF_NANDFCR_CS2ECC_MASK     (0x00000100u)
#define CSL_EMIF_NANDFCR_CS2ECC_SHIFT    (0x00000008u)
#define CSL_EMIF_NANDFCR_CS2ECC_RESETVAL (0x00000000u)

/*----CS2ECC Tokens----*/
#define CSL_EMIF_NANDFCR_CS2ECC_ENABLE   (0x00000001u)
#define CSL_EMIF_NANDFCR_CS2ECC_DISABLE  (0x00000000u)

#define CSL_EMIF_NANDFCR_CS2NAND_MASK    (0x00000001u)
#define CSL_EMIF_NANDFCR_CS2NAND_SHIFT   (0x00000000u)
#define CSL_EMIF_NANDFCR_CS2NAND_RESETVAL (0x00000000u)

/*----CS2NAND Tokens----*/
#define CSL_EMIF_NANDFCR_CS2NAND_ENABLE  (0x00000001u)
#define CSL_EMIF_NANDFCR_CS2NAND_DISABLE (0x00000000u)

#define CSL_EMIF_NANDFCR_RESETVAL        (0x00000000u)

/* NANDFSR */

#define CSL_EMIF_NANDFSR_WAITST_MASK     (0x00000001u)
#define CSL_EMIF_NANDFSR_WAITST_SHIFT    (0x00000000u)
#define CSL_EMIF_NANDFSR_WAITST_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDFSR_RESETVAL        (0x00000000u)

/* NANDF1ECC */

#define CSL_EMIF_NANDF1ECC_P2048O_MASK   (0x08000000u)
#define CSL_EMIF_NANDF1ECC_P2048O_SHIFT  (0x0000001Bu)
#define CSL_EMIF_NANDF1ECC_P2048O_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P1024O_MASK   (0x04000000u)
#define CSL_EMIF_NANDF1ECC_P1024O_SHIFT  (0x0000001Au)
#define CSL_EMIF_NANDF1ECC_P1024O_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P512O_MASK    (0x02000000u)
#define CSL_EMIF_NANDF1ECC_P512O_SHIFT   (0x00000019u)
#define CSL_EMIF_NANDF1ECC_P512O_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P256O_MASK    (0x01000000u)
#define CSL_EMIF_NANDF1ECC_P256O_SHIFT   (0x00000018u)
#define CSL_EMIF_NANDF1ECC_P256O_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P128O_MASK    (0x00800000u)
#define CSL_EMIF_NANDF1ECC_P128O_SHIFT   (0x00000017u)
#define CSL_EMIF_NANDF1ECC_P128O_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P64O_MASK     (0x00400000u)
#define CSL_EMIF_NANDF1ECC_P64O_SHIFT    (0x00000016u)
#define CSL_EMIF_NANDF1ECC_P64O_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P32O_MASK     (0x00200000u)
#define CSL_EMIF_NANDF1ECC_P32O_SHIFT    (0x00000015u)
#define CSL_EMIF_NANDF1ECC_P32O_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P16O_MASK     (0x00100000u)
#define CSL_EMIF_NANDF1ECC_P16O_SHIFT    (0x00000014u)
#define CSL_EMIF_NANDF1ECC_P16O_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P8O_MASK      (0x00080000u)
#define CSL_EMIF_NANDF1ECC_P8O_SHIFT     (0x00000013u)
#define CSL_EMIF_NANDF1ECC_P8O_RESETVAL  (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P4O_MASK      (0x00040000u)
#define CSL_EMIF_NANDF1ECC_P4O_SHIFT     (0x00000012u)
#define CSL_EMIF_NANDF1ECC_P4O_RESETVAL  (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P2O_MASK      (0x00020000u)
#define CSL_EMIF_NANDF1ECC_P2O_SHIFT     (0x00000011u)
#define CSL_EMIF_NANDF1ECC_P2O_RESETVAL  (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P1O_MASK      (0x00010000u)
#define CSL_EMIF_NANDF1ECC_P1O_SHIFT     (0x00000010u)
#define CSL_EMIF_NANDF1ECC_P1O_RESETVAL  (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P2048E_MASK   (0x00000800u)
#define CSL_EMIF_NANDF1ECC_P2048E_SHIFT  (0x0000000Bu)
#define CSL_EMIF_NANDF1ECC_P2048E_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P1024E_MASK   (0x00000400u)
#define CSL_EMIF_NANDF1ECC_P1024E_SHIFT  (0x0000000Au)
#define CSL_EMIF_NANDF1ECC_P1024E_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P512E_MASK    (0x00000200u)
#define CSL_EMIF_NANDF1ECC_P512E_SHIFT   (0x00000009u)
#define CSL_EMIF_NANDF1ECC_P512E_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P256E_MASK    (0x00000100u)
#define CSL_EMIF_NANDF1ECC_P256E_SHIFT   (0x00000008u)
#define CSL_EMIF_NANDF1ECC_P256E_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P128E_MASK    (0x00000080u)
#define CSL_EMIF_NANDF1ECC_P128E_SHIFT   (0x00000007u)
#define CSL_EMIF_NANDF1ECC_P128E_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P64E_MASK     (0x00000040u)
#define CSL_EMIF_NANDF1ECC_P64E_SHIFT    (0x00000006u)
#define CSL_EMIF_NANDF1ECC_P64E_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P32E_MASK     (0x00000020u)
#define CSL_EMIF_NANDF1ECC_P32E_SHIFT    (0x00000005u)
#define CSL_EMIF_NANDF1ECC_P32E_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P16E_MASK     (0x00000010u)
#define CSL_EMIF_NANDF1ECC_P16E_SHIFT    (0x00000004u)
#define CSL_EMIF_NANDF1ECC_P16E_RESETVAL (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P8E_MASK      (0x00000008u)
#define CSL_EMIF_NANDF1ECC_P8E_SHIFT     (0x00000003u)
#define CSL_EMIF_NANDF1ECC_P8E_RESETVAL  (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P4E_MASK      (0x00000004u)
#define CSL_EMIF_NANDF1ECC_P4E_SHIFT     (0x00000002u)
#define CSL_EMIF_NANDF1ECC_P4E_RESETVAL  (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P2E_MASK      (0x00000002u)
#define CSL_EMIF_NANDF1ECC_P2E_SHIFT     (0x00000001u)
#define CSL_EMIF_NANDF1ECC_P2E_RESETVAL  (0x00000000u)

#define CSL_EMIF_NANDF1ECC_P1E_MASK      (0x00000001u)
#define CSL_EMIF_NANDF1ECC_P1E_SHIFT     (0x00000000u)
#define CSL_EMIF_NANDF1ECC_P1E_RESETVAL  (0x00000000u)

#define CSL_EMIF_NANDF1ECC_RESETVAL      (0x00000000u)

#endif
