#ifndef _CSLR_ICACHE_H_
#define _CSLR_ICACHE_H_
/*********************************************************************
 * Copyright (C) 2003-2005 Texas Instruments Incorporated. 
 * All Rights Reserved 
 *********************************************************************/
 /** \file cslr_icache.h
 * 
 * \brief This file contains the Register Desciptions for ICACHE
 * 
 *********************************************************************/

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    /** L1P Invalidate Start Address Register */
    volatile Uint32 L1PISAR;
    /** L1P Invalidate Control Register */
    volatile Uint32 L1PICR;
    /** Memory Control and Status Register */
    volatile Uint32 MEMCSR;
    volatile Uint32 RSVD0[1];
    /** Program Counter Export Register */
    volatile Uint32 PCER; 
} CSL_IcacheRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/** L1PISAR - L1P Invalidate Start Address Register */

#define CSL_ICACHE_L1PISAR_L1PISA_MASK     (0xFFFFFFFFu)
#define CSL_ICACHE_L1PISAR_L1PISA_SHIFT    (0x00000000u)
#define CSL_ICACHE_L1PISAR_L1PISA_RESETVAL (0x00000000u)

#define CSL_ICACHE_L1PISAR_RESETVAL        (0x00000000u)

/** L1PICR - L1P Invalidate Control Register */

#define CSL_ICACHE_L1PICR_IP_MASK          (0x80000000u)
#define CSL_ICACHE_L1PICR_IP_SHIFT         (0x0000001Fu)
#define CSL_ICACHE_L1PICR_IP_RESETVAL      (0x00000000u)

/**----IP Tokens----*/
#define CSL_ICACHE_L1PICR_IP_CLEAR         (0x00000000u)
#define CSL_ICACHE_L1PICR_IP_SET           (0x00000001u)

#define CSL_ICACHE_L1PICR_INV_WORDCNT_MASK (0x0000FFFFu)
#define CSL_ICACHE_L1PICR_INV_WORDCNT_SHIFT (0x00000000u)
#define CSL_ICACHE_L1PICR_INV_WORDCNT_RESETVAL (0x00000000u)

#define CSL_ICACHE_L1PICR_RESETVAL         (0x00000000u)

/** MEMCSR - Memory Control and Status Register */

#define CSL_ICACHE_MEMCSR_IFP_MASK         (0x00040000u)
#define CSL_ICACHE_MEMCSR_IFP_SHIFT        (0x00000012u)
#define CSL_ICACHE_MEMCSR_IFP_RESETVAL     (0x00000000u)

/**----IFP Tokens----*/
#define CSL_ICACHE_MEMCSR_IFP_NOERR        (0x00000000u)
#define CSL_ICACHE_MEMCSR_IFP_ERR          (0x00000001u)

#define CSL_ICACHE_MEMCSR_DWR_MASK         (0x00020000u)
#define CSL_ICACHE_MEMCSR_DWR_SHIFT        (0x00000011u)
#define CSL_ICACHE_MEMCSR_DWR_RESETVAL     (0x00000000u)

/**----DWR Tokens----*/
#define CSL_ICACHE_MEMCSR_DWR_NOWRITE      (0x00000000u)
#define CSL_ICACHE_MEMCSR_DWR_WRITE        (0x00000001u)

#define CSL_ICACHE_MEMCSR_RMA_MASK         (0x00010000u)
#define CSL_ICACHE_MEMCSR_RMA_SHIFT        (0x00000010u)
#define CSL_ICACHE_MEMCSR_RMA_RESETVAL     (0x00000000u)

/**----RMA Tokens----*/
#define CSL_ICACHE_MEMCSR_RMA_NOERR        (0x00000000u)
#define CSL_ICACHE_MEMCSR_RMA_ERR          (0x00000001u)

#define CSL_ICACHE_MEMCSR_P_MASK           (0x00000001u)
#define CSL_ICACHE_MEMCSR_P_SHIFT          (0x00000000u)
#define CSL_ICACHE_MEMCSR_P_RESETVAL       (0x00000001u)

/**----P Tokens----*/
#define CSL_ICACHE_MEMCSR_P_LP1            (0x00000000u)
#define CSL_ICACHE_MEMCSR_P_CSP            (0x00000001u)

#define CSL_ICACHE_MEMCSR_RESETVAL         (0x00000001u)

/** PCER - Program Counter Export Register */

#define CSL_ICACHE_PCER_PCE_MASK           (0xFFFFFFFFu)
#define CSL_ICACHE_PCER_PCE_SHIFT          (0x00000000u)
#define CSL_ICACHE_PCER_PCE_RESETVAL       (0x00000000u)

#define CSL_ICACHE_PCER_RESETVAL           (0x00000000u)
#endif
