/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found
 *   in the license agreement under which this software has been supplied.
 *  ============================================================================
 */
 
/**
 * @file cslr_intc.h
 * 
 * @path $(CSLPATH)\soc\C672x\c67\src\
 *
 * @brief
 *   This file contains the Register Desciptions for INTC
 *
 */
 
/** =============================================================================
 *  Revision History
 *  ===============
 *  14-Dec-2004 RMathew  creation
 * ============================================================================= 
 */
 
#ifndef _CSLR_INTC_001_H_
#define _CSLR_INTC_001_H_

#include <cslr.h>
#include <tistdtypes.h>



/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* IER */

#define CSL_INTC_IER_IE15_MASK           (0x00008000u)
#define CSL_INTC_IER_IE15_SHIFT          (0x0000000Fu)
#define CSL_INTC_IER_IE15_RESETVAL       (0x00000000u)

/*----IE15 Tokens----*/
#define CSL_INTC_IER_IE15_ENABLE         (0x00000001u)
#define CSL_INTC_IER_IE15_DISABLE        (0x00000000u)

#define CSL_INTC_IER_IE14_MASK           (0x00004000u)
#define CSL_INTC_IER_IE14_SHIFT          (0x0000000Eu)
#define CSL_INTC_IER_IE14_RESETVAL       (0x00000000u)

/*----IE14 Tokens----*/
#define CSL_INTC_IER_IE14_ENABLE         (0x00000001u)
#define CSL_INTC_IER_IE14_DISABLE        (0x00000000u)

#define CSL_INTC_IER_IE13_MASK           (0x00002000u)
#define CSL_INTC_IER_IE13_SHIFT          (0x0000000Du)
#define CSL_INTC_IER_IE13_RESETVAL       (0x00000000u)

/*----IE13 Tokens----*/
#define CSL_INTC_IER_IE13_ENABLE         (0x00000001u)
#define CSL_INTC_IER_IE13_DISABLE        (0x00000000u)

#define CSL_INTC_IER_IE12_MASK           (0x00001000u)
#define CSL_INTC_IER_IE12_SHIFT          (0x0000000Cu)
#define CSL_INTC_IER_IE12_RESETVAL       (0x00000000u)

/*----IE12 Tokens----*/
#define CSL_INTC_IER_IE12_ENABLE         (0x00000001u)
#define CSL_INTC_IER_IE12_DISABLE        (0x00000000u)

#define CSL_INTC_IER_IE11_MASK           (0x00000800u)
#define CSL_INTC_IER_IE11_SHIFT          (0x0000000Bu)
#define CSL_INTC_IER_IE11_RESETVAL       (0x00000000u)

/*----IE11 Tokens----*/
#define CSL_INTC_IER_IE11_ENABLE         (0x00000001u)
#define CSL_INTC_IER_IE11_DISABLE        (0x00000000u)

#define CSL_INTC_IER_IE10_MASK           (0x00000400u)
#define CSL_INTC_IER_IE10_SHIFT          (0x0000000Au)
#define CSL_INTC_IER_IE10_RESETVAL       (0x00000000u)

/*----IE10 Tokens----*/
#define CSL_INTC_IER_IE10_ENABLE         (0x00000001u)
#define CSL_INTC_IER_IE10_DISABLE        (0x00000000u)

#define CSL_INTC_IER_IE9_MASK            (0x00000200u)
#define CSL_INTC_IER_IE9_SHIFT           (0x00000009u)
#define CSL_INTC_IER_IE9_RESETVAL        (0x00000000u)

/*----IE9 Tokens----*/
#define CSL_INTC_IER_IE9_ENABLE          (0x00000001u)
#define CSL_INTC_IER_IE9_DISABLE         (0x00000000u)

#define CSL_INTC_IER_IE8_MASK            (0x00000100u)
#define CSL_INTC_IER_IE8_SHIFT           (0x00000008u)
#define CSL_INTC_IER_IE8_RESETVAL        (0x00000000u)

/*----IE8 Tokens----*/
#define CSL_INTC_IER_IE8_ENABLE          (0x00000001u)
#define CSL_INTC_IER_IE8_DISABLE         (0x00000000u)

#define CSL_INTC_IER_IE7_MASK            (0x00000080u)
#define CSL_INTC_IER_IE7_SHIFT           (0x00000007u)
#define CSL_INTC_IER_IE7_RESETVAL        (0x00000000u)

/*----IE7 Tokens----*/
#define CSL_INTC_IER_IE7_ENABLE          (0x00000001u)
#define CSL_INTC_IER_IE7_DISABLE         (0x00000000u)

#define CSL_INTC_IER_IE6_MASK            (0x00000040u)
#define CSL_INTC_IER_IE6_SHIFT           (0x00000006u)
#define CSL_INTC_IER_IE6_RESETVAL        (0x00000000u)

/*----IE6 Tokens----*/
#define CSL_INTC_IER_IE6_ENABLE          (0x00000001u)
#define CSL_INTC_IER_IE6_DISABLE         (0x00000000u)

#define CSL_INTC_IER_IE5_MASK            (0x00000020u)
#define CSL_INTC_IER_IE5_SHIFT           (0x00000005u)
#define CSL_INTC_IER_IE5_RESETVAL        (0x00000000u)

/*----IE5 Tokens----*/
#define CSL_INTC_IER_IE5_ENABLE          (0x00000001u)
#define CSL_INTC_IER_IE5_DISABLE         (0x00000000u)

#define CSL_INTC_IER_IE4_MASK            (0x00000010u)
#define CSL_INTC_IER_IE4_SHIFT           (0x00000004u)
#define CSL_INTC_IER_IE4_RESETVAL        (0x00000000u)

/*----IE4 Tokens----*/
#define CSL_INTC_IER_IE4_ENABLE          (0x00000001u)
#define CSL_INTC_IER_IE4_DISABLE         (0x00000000u)

#define CSL_INTC_IER_NMIE_MASK           (0x00000002u)
#define CSL_INTC_IER_NMIE_SHIFT          (0x00000001u)
#define CSL_INTC_IER_NMIE_RESETVAL       (0x00000000u)

/*----NMIE Tokens----*/
#define CSL_INTC_IER_NMIE_ENABLE         (0x00000001u)

#define CSL_INTC_IER_RESET_MASK          (0x00000001u)
#define CSL_INTC_IER_RESET_SHIFT         (0x00000000u)
#define CSL_INTC_IER_RESET_RESETVAL      (0x00000001u)

/*----RESET Tokens----*/
#define CSL_INTC_IER_RESET_ENABLE        (0x00000001u)

#define CSL_INTC_IER_RESETVAL            (0x00000001u)

/* IFR */

#define CSL_INTC_IFR_IF15_MASK           (0x00008000u)
#define CSL_INTC_IFR_IF15_SHIFT          (0x0000000Fu)
#define CSL_INTC_IFR_IF15_RESETVAL       (0x00000000u)

/*----IF15 Tokens----*/
#define CSL_INTC_IFR_IF15_CLEAR          (0x00000000u)
#define CSL_INTC_IFR_IF15_SET            (0x00000001u)

#define CSL_INTC_IFR_IF14_MASK           (0x00004000u)
#define CSL_INTC_IFR_IF14_SHIFT          (0x0000000Eu)
#define CSL_INTC_IFR_IF14_RESETVAL       (0x00000000u)

/*----IF14 Tokens----*/
#define CSL_INTC_IFR_IF14_CLEAR          (0x00000000u)
#define CSL_INTC_IFR_IF14_SET            (0x00000001u)

#define CSL_INTC_IFR_IF13_MASK           (0x00002000u)
#define CSL_INTC_IFR_IF13_SHIFT          (0x0000000Du)
#define CSL_INTC_IFR_IF13_RESETVAL       (0x00000000u)

/*----IF13 Tokens----*/
#define CSL_INTC_IFR_IF13_CLEAR          (0x00000000u)
#define CSL_INTC_IFR_IF13_SET            (0x00000001u)

#define CSL_INTC_IFR_IF12_MASK           (0x00001000u)
#define CSL_INTC_IFR_IF12_SHIFT          (0x0000000Cu)
#define CSL_INTC_IFR_IF12_RESETVAL       (0x00000000u)

/*----IF12 Tokens----*/
#define CSL_INTC_IFR_IF12_CLEAR          (0x00000000u)
#define CSL_INTC_IFR_IF12_SET            (0x00000001u)

#define CSL_INTC_IFR_IF11_MASK           (0x00000800u)
#define CSL_INTC_IFR_IF11_SHIFT          (0x0000000Bu)
#define CSL_INTC_IFR_IF11_RESETVAL       (0x00000000u)

/*----IF11 Tokens----*/
#define CSL_INTC_IFR_IF11_CLEAR          (0x00000000u)
#define CSL_INTC_IFR_IF11_SET            (0x00000001u)

#define CSL_INTC_IFR_IF10_MASK           (0x00000400u)
#define CSL_INTC_IFR_IF10_SHIFT          (0x0000000Au)
#define CSL_INTC_IFR_IF10_RESETVAL       (0x00000000u)

/*----IF10 Tokens----*/
#define CSL_INTC_IFR_IF10_CLEAR          (0x00000000u)
#define CSL_INTC_IFR_IF10_SET            (0x00000001u)

#define CSL_INTC_IFR_IF9_MASK            (0x00000200u)
#define CSL_INTC_IFR_IF9_SHIFT           (0x00000009u)
#define CSL_INTC_IFR_IF9_RESETVAL        (0x00000000u)

/*----IF9 Tokens----*/
#define CSL_INTC_IFR_IF9_CLEAR           (0x00000000u)
#define CSL_INTC_IFR_IF9_SET             (0x00000001u)

#define CSL_INTC_IFR_IF8_MASK            (0x00000100u)
#define CSL_INTC_IFR_IF8_SHIFT           (0x00000008u)
#define CSL_INTC_IFR_IF8_RESETVAL        (0x00000000u)

/*----IF8 Tokens----*/
#define CSL_INTC_IFR_IF8_CLEAR           (0x00000000u)
#define CSL_INTC_IFR_IF8_SET             (0x00000001u)

#define CSL_INTC_IFR_IF7_MASK            (0x00000080u)
#define CSL_INTC_IFR_IF7_SHIFT           (0x00000007u)
#define CSL_INTC_IFR_IF7_RESETVAL        (0x00000000u)

/*----IF7 Tokens----*/
#define CSL_INTC_IFR_IF7_CLEAR           (0x00000000u)
#define CSL_INTC_IFR_IF7_SET             (0x00000001u)

#define CSL_INTC_IFR_IF6_MASK            (0x00000040u)
#define CSL_INTC_IFR_IF6_SHIFT           (0x00000006u)
#define CSL_INTC_IFR_IF6_RESETVAL        (0x00000000u)

/*----IF6 Tokens----*/
#define CSL_INTC_IFR_IF6_CLEAR           (0x00000000u)
#define CSL_INTC_IFR_IF6_SET             (0x00000001u)

#define CSL_INTC_IFR_IF5_MASK            (0x00000020u)
#define CSL_INTC_IFR_IF5_SHIFT           (0x00000005u)
#define CSL_INTC_IFR_IF5_RESETVAL        (0x00000000u)

/*----IF5 Tokens----*/
#define CSL_INTC_IFR_IF5_CLEAR           (0x00000000u)
#define CSL_INTC_IFR_IF5_SET             (0x00000001u)

#define CSL_INTC_IFR_IF4_MASK            (0x00000010u)
#define CSL_INTC_IFR_IF4_SHIFT           (0x00000004u)
#define CSL_INTC_IFR_IF4_RESETVAL        (0x00000000u)

/*----IF4 Tokens----*/
#define CSL_INTC_IFR_IF4_CLEAR           (0x00000000u)
#define CSL_INTC_IFR_IF4_SET             (0x00000001u)

#define CSL_INTC_IFR_NMIF_MASK           (0x00000002u)
#define CSL_INTC_IFR_NMIF_SHIFT          (0x00000001u)
#define CSL_INTC_IFR_NMIF_RESETVAL       (0x00000000u)

/*----NMIF Tokens----*/
#define CSL_INTC_IFR_NMIF_CLEAR          (0x00000000u)
#define CSL_INTC_IFR_NMIF_SET            (0x00000001u)

#define CSL_INTC_IFR_RESETVAL            (0x00000000u)

/* ISR */

#define CSL_INTC_ISR_IS15_MASK           (0x00008000u)
#define CSL_INTC_ISR_IS15_SHIFT          (0x0000000Fu)
#define CSL_INTC_ISR_IS15_RESETVAL       (0x00000000u)

/*----IS15 Tokens----*/
#define CSL_INTC_ISR_IS15_CLEAR          (0x00000000u)
#define CSL_INTC_ISR_IS15_SET            (0x00000001u)

#define CSL_INTC_ISR_IS14_MASK           (0x00004000u)
#define CSL_INTC_ISR_IS14_SHIFT          (0x0000000Eu)
#define CSL_INTC_ISR_IS14_RESETVAL       (0x00000000u)

/*----IS14 Tokens----*/
#define CSL_INTC_ISR_IS14_CLEAR          (0x00000000u)
#define CSL_INTC_ISR_IS14_SET            (0x00000001u)

#define CSL_INTC_ISR_IS13_MASK           (0x00002000u)
#define CSL_INTC_ISR_IS13_SHIFT          (0x0000000Du)
#define CSL_INTC_ISR_IS13_RESETVAL       (0x00000000u)

/*----IS13 Tokens----*/
#define CSL_INTC_ISR_IS13_ICLEAR         (0x00000000u)
#define CSL_INTC_ISR_IS13_SET            (0x00000001u)

#define CSL_INTC_ISR_IS12_MASK           (0x00001000u)
#define CSL_INTC_ISR_IS12_SHIFT          (0x0000000Cu)
#define CSL_INTC_ISR_IS12_RESETVAL       (0x00000000u)

/*----IS12 Tokens----*/
#define CSL_INTC_ISR_IS12_CLEAR          (0x00000000u)
#define CSL_INTC_ISR_IS12_SET            (0x00000001u)

#define CSL_INTC_ISR_IS11_MASK           (0x00000800u)
#define CSL_INTC_ISR_IS11_SHIFT          (0x0000000Bu)
#define CSL_INTC_ISR_IS11_RESETVAL       (0x00000000u)

/*----IS11 Tokens----*/
#define CSL_INTC_ISR_IS11_CLEAR          (0x00000000u)
#define CSL_INTC_ISR_IS11_SET            (0x00000001u)

#define CSL_INTC_ISR_IS10_MASK           (0x00000400u)
#define CSL_INTC_ISR_IS10_SHIFT          (0x0000000Au)
#define CSL_INTC_ISR_IS10_RESETVAL       (0x00000000u)

/*----IS10 Tokens----*/
#define CSL_INTC_ISR_IS10_CLEAR          (0x00000000u)
#define CSL_INTC_ISR_IS10_SET            (0x00000001u)

#define CSL_INTC_ISR_IS9_MASK            (0x00000200u)
#define CSL_INTC_ISR_IS9_SHIFT           (0x00000009u)
#define CSL_INTC_ISR_IS9_RESETVAL        (0x00000000u)

/*----IS9 Tokens----*/
#define CSL_INTC_ISR_IS9_CLEAR           (0x00000000u)
#define CSL_INTC_ISR_IS9_SET             (0x00000001u)

#define CSL_INTC_ISR_IS8_MASK            (0x00000100u)
#define CSL_INTC_ISR_IS8_SHIFT           (0x00000008u)
#define CSL_INTC_ISR_IS8_RESETVAL        (0x00000000u)

/*----IS8 Tokens----*/
#define CSL_INTC_ISR_IS8_CLEAR           (0x00000000u)
#define CSL_INTC_ISR_IS8_SET             (0x00000001u)

#define CSL_INTC_ISR_IS7_MASK            (0x00000080u)
#define CSL_INTC_ISR_IS7_SHIFT           (0x00000007u)
#define CSL_INTC_ISR_IS7_RESETVAL        (0x00000000u)

/*----IS7 Tokens----*/
#define CSL_INTC_ISR_IS7_CLEAR           (0x00000000u)
#define CSL_INTC_ISR_IS7_SET             (0x00000001u)

#define CSL_INTC_ISR_IS6_MASK            (0x00000040u)
#define CSL_INTC_ISR_IS6_SHIFT           (0x00000006u)
#define CSL_INTC_ISR_IS6_RESETVAL        (0x00000000u)

/*----IS6 Tokens----*/
#define CSL_INTC_ISR_IS6_CLEAR           (0x00000000u)
#define CSL_INTC_ISR_IS6_SET             (0x00000001u)

#define CSL_INTC_ISR_IS5_MASK            (0x00000020u)
#define CSL_INTC_ISR_IS5_SHIFT           (0x00000005u)
#define CSL_INTC_ISR_IS5_RESETVAL        (0x00000000u)

/*----IS5 Tokens----*/
#define CSL_INTC_ISR_IS5_CLEAR           (0x00000000u)
#define CSL_INTC_ISR_IS5_SET             (0x00000001u)

#define CSL_INTC_ISR_IS4_MASK            (0x00000010u)
#define CSL_INTC_ISR_IS4_SHIFT           (0x00000004u)
#define CSL_INTC_ISR_IS4_RESETVAL        (0x00000000u)

/*----IS4 Tokens----*/
#define CSL_INTC_ISR_IS4_CLEAR           (0x00000000u)
#define CSL_INTC_ISR_IS4_SET             (0x00000001u)

#define CSL_INTC_ISR_RESETVAL            (0x00000000u)

/* ICR */

#define CSL_INTC_ICR_IC15_MASK           (0x00008000u)
#define CSL_INTC_ICR_IC15_SHIFT          (0x0000000Fu)
#define CSL_INTC_ICR_IC15_RESETVAL       (0x00000000u)

/*----IC15 Tokens----*/
#define CSL_INTC_ICR_IC15_CLEAR          (0x00000000u)
#define CSL_INTC_ICR_IC15_SET            (0x00000001u)

#define CSL_INTC_ICR_IC14_MASK           (0x00004000u)
#define CSL_INTC_ICR_IC14_SHIFT          (0x0000000Eu)
#define CSL_INTC_ICR_IC14_RESETVAL       (0x00000000u)

/*----IC14 Tokens----*/
#define CSL_INTC_ICR_IC14_CLEAR          (0x00000000u)
#define CSL_INTC_ICR_IC14_SET            (0x00000001u)

#define CSL_INTC_ICR_IC13_MASK           (0x00002000u)
#define CSL_INTC_ICR_IC13_SHIFT          (0x0000000Du)
#define CSL_INTC_ICR_IC13_RESETVAL       (0x00000000u)

/*----IC13 Tokens----*/
#define CSL_INTC_ICR_IC13_CLEAR          (0x00000000u)
#define CSL_INTC_ICR_IC13_SET            (0x00000001u)

#define CSL_INTC_ICR_IC12_MASK           (0x00001000u)
#define CSL_INTC_ICR_IC12_SHIFT          (0x0000000Cu)
#define CSL_INTC_ICR_IC12_RESETVAL       (0x00000000u)

/*----IC12 Tokens----*/
#define CSL_INTC_ICR_IC12_CLEAR          (0x00000000u)
#define CSL_INTC_ICR_IC12_SET            (0x00000001u)

#define CSL_INTC_ICR_IC11_MASK           (0x00000800u)
#define CSL_INTC_ICR_IC11_SHIFT          (0x0000000Bu)
#define CSL_INTC_ICR_IC11_RESETVAL       (0x00000000u)

/*----IC11 Tokens----*/
#define CSL_INTC_ICR_IC11_CLEAR          (0x00000000u)
#define CSL_INTC_ICR_IC11_SET            (0x00000001u)

#define CSL_INTC_ICR_IC10_MASK           (0x00000400u)
#define CSL_INTC_ICR_IC10_SHIFT          (0x0000000Au)
#define CSL_INTC_ICR_IC10_RESETVAL       (0x00000000u)

/*----IC10 Tokens----*/
#define CSL_INTC_ICR_IC10_CLEAR          (0x00000000u)
#define CSL_INTC_ICR_IC10_SET            (0x00000001u)

#define CSL_INTC_ICR_IC9_MASK            (0x00000200u)
#define CSL_INTC_ICR_IC9_SHIFT           (0x00000009u)
#define CSL_INTC_ICR_IC9_RESETVAL        (0x00000000u)

/*----IC9 Tokens----*/
#define CSL_INTC_ICR_IC9_CLEAR           (0x00000000u)
#define CSL_INTC_ICR_IC9_SET             (0x00000001u)

#define CSL_INTC_ICR_IC8_MASK            (0x00000100u)
#define CSL_INTC_ICR_IC8_SHIFT           (0x00000008u)
#define CSL_INTC_ICR_IC8_RESETVAL        (0x00000000u)

/*----IC8 Tokens----*/
#define CSL_INTC_ICR_IC8_CLEAR           (0x00000000u)
#define CSL_INTC_ICR_IC8_SET             (0x00000001u)

#define CSL_INTC_ICR_IC7_MASK            (0x00000080u)
#define CSL_INTC_ICR_IC7_SHIFT           (0x00000007u)
#define CSL_INTC_ICR_IC7_RESETVAL        (0x00000000u)

/*----IC7 Tokens----*/
#define CSL_INTC_ICR_IC7_CLEAR           (0x00000000u)
#define CSL_INTC_ICR_IC7_SET             (0x00000001u)

#define CSL_INTC_ICR_IC6_MASK            (0x00000040u)
#define CSL_INTC_ICR_IC6_SHIFT           (0x00000006u)
#define CSL_INTC_ICR_IC6_RESETVAL        (0x00000000u)

/*----IC6 Tokens----*/
#define CSL_INTC_ICR_IC6_CLEAR           (0x00000000u)
#define CSL_INTC_ICR_IC6_SET             (0x00000001u)

#define CSL_INTC_ICR_IC5_MASK            (0x00000020u)
#define CSL_INTC_ICR_IC5_SHIFT           (0x00000005u)
#define CSL_INTC_ICR_IC5_RESETVAL        (0x00000000u)

/*----IC5 Tokens----*/
#define CSL_INTC_ICR_IC5_CLEAR           (0x00000000u)
#define CSL_INTC_ICR_IC5_SET             (0x00000001u)

#define CSL_INTC_ICR_IC4_MASK            (0x00000010u)
#define CSL_INTC_ICR_IC4_SHIFT           (0x00000004u)
#define CSL_INTC_ICR_IC4_RESETVAL        (0x00000000u)

/*----IC4 Tokens----*/
#define CSL_INTC_ICR_IC4_CLEAR           (0x00000000u)
#define CSL_INTC_ICR_IC4_SET             (0x00000001u)

#define CSL_INTC_ICR_RESETVAL            (0x00000000u)

/* ISTP */

#define CSL_INTC_ISTP_ISTB_MASK          (0xFFFFFC00u)
#define CSL_INTC_ISTP_ISTB_SHIFT         (0x0000000Au)
#define CSL_INTC_ISTP_ISTB_RESETVAL      (0x00000000u)

#define CSL_INTC_ISTP_HPEINT_MASK        (0x000003E0u)
#define CSL_INTC_ISTP_HPEINT_SHIFT       (0x00000005u)
#define CSL_INTC_ISTP_HPEINT_RESETVAL    (0x00000000u)

/*----HPEINT Tokens----*/
#define CSL_INTC_ISTP_HPEINT_NO_PENDING  (0x00000000u)
#define CSL_INTC_ISTP_HPEINT_INT1_HIGH   (0x00000001u)
#define CSL_INTC_ISTP_HPEINT_INT2_HIGH   (0x00000010u)
#define CSL_INTC_ISTP_HPEINT_INT3_HIGH   (0x00000011u)
#define CSL_INTC_ISTP_HPEINT_INT4_HIGH   (0x00000100u)
#define CSL_INTC_ISTP_HPEINT_INT5_HIGH   (0x00000101u)
#define CSL_INTC_ISTP_HPEINT_INT6_HIGH   (0x00000110u)
#define CSL_INTC_ISTP_HPEINT_INT7_HIGH   (0x00000111u)
#define CSL_INTC_ISTP_HPEINT_INT8_HIGH   (0x00001000u)
#define CSL_INTC_ISTP_HPEINT_INT9_HIGH   (0x00001001u)
#define CSL_INTC_ISTP_HPEINT_INT10_HIGH  (0x00001010u)
#define CSL_INTC_ISTP_HPEINT_INT11_HIGH  (0x00001011u)
#define CSL_INTC_ISTP_HPEINT_INT12_HIGH  (0x00001100u)
#define CSL_INTC_ISTP_HPEINT_INT13_HIGH  (0x00001101u)
#define CSL_INTC_ISTP_HPEINT_INT14_HIGH  (0x00001110u)
#define CSL_INTC_ISTP_HPEINT_INT15_HIGH  (0x00001111u)

#define CSL_INTC_ISTP_RESETVAL           (0x00000000u)

/* NRP */

#define CSL_INTC_NRP_NRP_MASK            (0xFFFFFFFFu)
#define CSL_INTC_NRP_NRP_SHIFT           (0x00000000u)
#define CSL_INTC_NRP_NRP_RESETVAL        (0x00000000u)

#define CSL_INTC_NRP_RESETVAL            (0x00000000u)

/* IRP */

#define CSL_INTC_IRP_IRP_MASK            (0xFFFFFFFFu)
#define CSL_INTC_IRP_IRP_SHIFT           (0x00000000u)
#define CSL_INTC_IRP_IRP_RESETVAL        (0x00000000u)

#define CSL_INTC_IRP_RESETVAL            (0x00000000u)

#endif
