#ifndef _CSLR_PLLC_H_
#define _CSLR_PLLC_H_
/*********************************************************************
 * Copyright (C) 2003-2005 Texas Instruments Incorporated. 
 * All Rights Reserved 
 *********************************************************************/
 /** \file cslr_pllc.h
 * 
 * \brief This file contains the Register Desciptions for PLLC
 * 
 *********************************************************************/

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 PLLPID;
    volatile Uint32 RSVD0[63];
    volatile Uint32 PLLCSR;
    volatile Uint32 RSVD1[3];
    volatile Uint32 PLLM;
    volatile Uint32 PLLDIV0;
    volatile Uint32 PLLDIV1;
    volatile Uint32 PLLDIV2;
    volatile Uint32 PLLDIV3;
    volatile Uint32 RSVD2[5];
    volatile Uint32 PLLCMD;
    volatile Uint32 PLLSTAT;
    volatile Uint32 ALNCTL;
    volatile Uint32 RSVD3[1];
    volatile Uint32 CKEN;
    volatile Uint32 CKSTAT;
    volatile Uint32 SYSTAT;
} CSL_PllcRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* PLLPID */

#define CSL_PLLC_PLLPID_TYPE_MASK        (0x00FF0000u)
#define CSL_PLLC_PLLPID_TYPE_SHIFT       (0x00000010u)
#define CSL_PLLC_PLLPID_TYPE_RESETVAL    (0x00000001u)

#define CSL_PLLC_PLLPID_CLASS_MASK       (0x0000FF00u)
#define CSL_PLLC_PLLPID_CLASS_SHIFT      (0x00000008u)
#define CSL_PLLC_PLLPID_CLASS_RESETVAL   (0x00000008u)

#define CSL_PLLC_PLLPID_REV_MASK         (0x000000FFu)
#define CSL_PLLC_PLLPID_REV_SHIFT        (0x00000000u)
#define CSL_PLLC_PLLPID_REV_RESETVAL     (0x00000001u)

#define CSL_PLLC_PLLPID_RESETVAL         (0x00010801u)

/* PLLCSR */

#define CSL_PLLC_PLLCSR_STABLE_MASK      (0x00000040u)
#define CSL_PLLC_PLLCSR_STABLE_SHIFT     (0x00000006u)
#define CSL_PLLC_PLLCSR_STABLE_RESETVAL  (0x00000001u)

/*----STABLE Tokens----*/
#define CSL_PLLC_PLLCSR_STABLE_NOT_STABLE (0x00000000u)
#define CSL_PLLC_PLLCSR_STABLE_STABLE    (0x00000000u)

#define CSL_PLLC_PLLCSR_PLLPWRDN_MASK    (0x00000010u)
#define CSL_PLLC_PLLCSR_PLLPWRDN_SHIFT   (0x00000004u)
#define CSL_PLLC_PLLCSR_PLLPWRDN_RESETVAL (0x00000004u)

/*----PLLPWRDN Tokens----*/
#define CSL_PLLC_PLLCSR_PLLPWRDN_NO      (0x00000000u)
#define CSL_PLLC_PLLCSR_PLLPWRDN_YES      (0x00000001u)

#define CSL_PLLC_PLLCSR_PLLRST_MASK      (0x00000008u)
#define CSL_PLLC_PLLCSR_PLLRST_SHIFT     (0x00000003u)
#define CSL_PLLC_PLLCSR_PLLRST_RESETVAL  (0x00000000u)

/*----PLLRST Tokens----*/
#define CSL_PLLC_PLLCSR_PLLRST_RELEASED  (0x00000000u)
#define CSL_PLLC_PLLCSR_PLLRST_ASSERTED  (0x00000001u)

#define CSL_PLLC_PLLCSR_OSCPWRDN_MASK    (0x00000004u)
#define CSL_PLLC_PLLCSR_OSCPWRDN_SHIFT   (0x00000002u)
#define CSL_PLLC_PLLCSR_OSCPWRDN_RESETVAL (0x00000000u)

/*----OSCPWRDN Tokens----*/
#define CSL_PLLC_PLLCSR_OSCPWRDN_CMD     (0x00000001u)

#define CSL_PLLC_PLLCSR_PLLEN_MASK       (0x00000001u)
#define CSL_PLLC_PLLCSR_PLLEN_SHIFT      (0x00000000u)
#define CSL_PLLC_PLLCSR_PLLEN_RESETVAL   (0x00000000u)

/*----PLLEN Tokens----*/
#define CSL_PLLC_PLLCSR_PLLEN_BYPASS     (0x00000000u)
#define CSL_PLLC_PLLCSR_PLLEN_PLL        (0x00000001u)

#define CSL_PLLC_PLLCSR_RESETVAL         (0x00000040u)

/* PLLM */

#define CSL_PLLC_PLLM_PLLM_MASK          (0x0000003Fu)
#define CSL_PLLC_PLLM_PLLM_SHIFT         (0x00000000u)
#define CSL_PLLC_PLLM_PLLM_RESETVAL      (0x0000000Du)

#define CSL_PLLC_PLLM_RESETVAL           (0x0000000Du)

/* PLLDIV0 */

#define CSL_PLLC_PLLDIV0_D0EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV0_D0EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV0_D0EN_RESETVAL   (0x00000000u)

/*----D0EN Tokens----*/
#define CSL_PLLC_PLLDIV0_D0EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV0_D0EN_ENABLE     (0x00000001u)

#define CSL_PLLC_PLLDIV0_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV0_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV0_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_PLLDIV0_RESETVAL        (0x00000000u)

/* PLLDIV1 */

#define CSL_PLLC_PLLDIV1_D1EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV1_D1EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV1_D1EN_RESETVAL   (0x00000000u)

/*----D1EN Tokens----*/
#define CSL_PLLC_PLLDIV1_D1EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV1_D1EN_ENABLE     (0x00000001u)

#define CSL_PLLC_PLLDIV1_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV1_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV1_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_PLLDIV1_RESETVAL        (0x00000000u)

/* PLLDIV2 */

#define CSL_PLLC_PLLDIV2_D2EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV2_D2EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV2_D2EN_RESETVAL   (0x00000000u)

/*----D2EN Tokens----*/
#define CSL_PLLC_PLLDIV2_D2EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV2_D2EN_ENABLE     (0x00000001u)

#define CSL_PLLC_PLLDIV2_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV2_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV2_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_PLLDIV2_RESETVAL        (0x00000000u)

/* PLLDIV3 */

#define CSL_PLLC_PLLDIV3_D3EN_MASK       (0x00008000u)
#define CSL_PLLC_PLLDIV3_D3EN_SHIFT      (0x0000000Fu)
#define CSL_PLLC_PLLDIV3_D3EN_RESETVAL   (0x00000000u)

/*----D3EN Tokens----*/
#define CSL_PLLC_PLLDIV3_D3EN_DISABLE    (0x00000000u)
#define CSL_PLLC_PLLDIV3_D3EN_ENABLE     (0x00000001u)

#define CSL_PLLC_PLLDIV3_RATIO_MASK      (0x0000001Fu)
#define CSL_PLLC_PLLDIV3_RATIO_SHIFT     (0x00000000u)
#define CSL_PLLC_PLLDIV3_RATIO_RESETVAL  (0x00000000u)

#define CSL_PLLC_PLLDIV3_RESETVAL        (0x00000000u)

/* PLLCMD */

#define CSL_PLLC_PLLCMD_GOSET_MASK       (0x00000001u)
#define CSL_PLLC_PLLCMD_GOSET_SHIFT      (0x00000000u)
#define CSL_PLLC_PLLCMD_GOSET_RESETVAL   (0x00000000u)

/*----GOSET Tokens----*/
#define CSL_PLLC_PLLCMD_GOSET_CLRBIT     (0x00000000u)
#define CSL_PLLC_PLLCMD_GOSET_SET        (0x00000001u)

#define CSL_PLLC_PLLCMD_RESETVAL         (0x00000000u)

/* PLLSTAT */

#define CSL_PLLC_PLLSTAT_GOSTAT_MASK     (0x00000001u)
#define CSL_PLLC_PLLSTAT_GOSTAT_SHIFT    (0x00000000u)
#define CSL_PLLC_PLLSTAT_GOSTAT_RESETVAL (0x00000000u)

/*----GOSTAT Tokens----*/
#define CSL_PLLC_PLLSTAT_GOSTAT_NOT_PROGRESS (0x00000000u)
#define CSL_PLLC_PLLSTAT_GOSTAT_INPROG   (0x00000001u)

#define CSL_PLLC_PLLSTAT_RESETVAL        (0x00000000u)

/* ALNCTL */

#define CSL_PLLC_ALNCTL_ALN3_MASK        (0x00000004u)
#define CSL_PLLC_ALNCTL_ALN3_SHIFT       (0x00000002u)
#define CSL_PLLC_ALNCTL_ALN3_RESETVAL    (0x00000000u)

/*----ALN3 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN3_ALIGN       (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN2_MASK        (0x00000002u)
#define CSL_PLLC_ALNCTL_ALN2_SHIFT       (0x00000001u)
#define CSL_PLLC_ALNCTL_ALN2_RESETVAL    (0x00000000u)

/*----ALN2 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN2_ALIGN       (0x00000001u)

#define CSL_PLLC_ALNCTL_ALN1_MASK        (0x00000001u)
#define CSL_PLLC_ALNCTL_ALN1_SHIFT       (0x00000000u)
#define CSL_PLLC_ALNCTL_ALN1_RESETVAL    (0x00000000u)

/*----ALN1 Tokens----*/
#define CSL_PLLC_ALNCTL_ALN1_ALIGN       (0x00000001u)

#define CSL_PLLC_ALNCTL_RESETVAL         (0x00000000u)

/* CKEN */

#define CSL_PLLC_CKEN_AUXEN_MASK         (0x00000001u)
#define CSL_PLLC_CKEN_AUXEN_SHIFT        (0x00000000u)
#define CSL_PLLC_CKEN_AUXEN_RESETVAL     (0x00000000u)

/*----AUXEN Tokens----*/
#define CSL_PLLC_CKEN_AUXEN_DISABLE      (0x00000000u)
#define CSL_PLLC_CKEN_AUXEN_ENABLE       (0x00000001u)

#define CSL_PLLC_CKEN_RESETVAL           (0x00000004u)

/* CKSTAT */

#define CSL_PLLC_CKSTAT_AUXON_MASK       (0x00000001u)
#define CSL_PLLC_CKSTAT_AUXON_SHIFT      (0x00000000u)
#define CSL_PLLC_CKSTAT_AUXON_RESETVAL   (0x00000000u)

/*----AUXON Tokens----*/
#define CSL_PLLC_CKSTAT_AUXON_GATED      (0x00000000u)
#define CSL_PLLC_CKSTAT_AUXON_ON         (0x00000001u)

#define CSL_PLLC_CKSTAT_RESETVAL         (0x00000000u)

/* SYSTAT */

#define CSL_PLLC_SYSTAT_SYS3ON_MASK      (0x00000004u)
#define CSL_PLLC_SYSTAT_SYS3ON_SHIFT     (0x00000002u)
#define CSL_PLLC_SYSTAT_SYS3ON_RESETVAL  (0x00000000u)

/*----SYS3ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS3ON_GATED     (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS3ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS2ON_MASK      (0x00000002u)
#define CSL_PLLC_SYSTAT_SYS2ON_SHIFT     (0x00000001u)
#define CSL_PLLC_SYSTAT_SYS2ON_RESETVAL  (0x00000000u)

/*----SYS2ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS2ON_GATED     (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS2ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_SYS1ON_MASK      (0x00000001u)
#define CSL_PLLC_SYSTAT_SYS1ON_SHIFT     (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS1ON_RESETVAL  (0x00000000u)

/*----SYS1ON Tokens----*/
#define CSL_PLLC_SYSTAT_SYS1ON_GATED     (0x00000000u)
#define CSL_PLLC_SYSTAT_SYS1ON_ON        (0x00000001u)

#define CSL_PLLC_SYSTAT_RESETVAL         (0x00000000u)

#endif
