#ifndef _CSLR_HPI_H_
#define _CSLR_HPI_H_
/*********************************************************************
 * Copyright (C) 2003-2004 Texas Instruments Incorporated. 
 * All Rights Reserved 
 *********************************************************************/
 /** \file cslr_hpi.h
 * 
 * \brief This file contains the Register Desciptions for HPI
 * 
 *********************************************************************/

#include <cslr.h>

#include <tistdtypes.h>

/**************************************************************************\
* Register Overlay Structure
\**************************************************************************/
typedef struct  {
    volatile Uint32 PID;
    volatile Uint32 PWREMU_MGMT;
    volatile Uint32 GPINT_CTRL;
    volatile Uint32 GPIO_EN;
    volatile Uint32 GPIO_DIR1;
    volatile Uint32 GPIO_DAT1;
    volatile Uint32 GPIO_DIR2;
    volatile Uint32 GPIO_DAT2;
    volatile Uint32 GPIO_DIR3;
    volatile Uint32 GPIO_DAT3;
    volatile Uint32 RSVD0[2];
    volatile Uint32 HPIC;
    volatile Uint32 HPIAW;
    volatile Uint32 HPIAR;
} CSL_HpiRegs;

/**************************************************************************\
* Field Definition Macros
\**************************************************************************/

/* PID */

#define CSL_HPI_PID_TYPE_MASK            (0x00FF0000u)
#define CSL_HPI_PID_TYPE_SHIFT           (0x00000010u)
#define CSL_HPI_PID_TYPE_RESETVAL        (0x00000001u)

#define CSL_HPI_PID_CLASS_MASK           (0x0000FF00u)
#define CSL_HPI_PID_CLASS_SHIFT          (0x00000008u)
#define CSL_HPI_PID_CLASS_RESETVAL       (0x00000002u)

#define CSL_HPI_PID_REV_MASK             (0x000000FFu)
#define CSL_HPI_PID_REV_SHIFT            (0x00000000u)
#define CSL_HPI_PID_REV_RESETVAL         (0x00000002u)

#define CSL_HPI_PID_RESETVAL             (0x00010202u)

/* PWREMU_MGMT */

#define CSL_HPI_PWREMU_MGMT_SOFT_MASK    (0x00000002u)
#define CSL_HPI_PWREMU_MGMT_SOFT_SHIFT   (0x00000001u)
#define CSL_HPI_PWREMU_MGMT_SOFT_RESETVAL (0x00000000u)

/*----SOFT Tokens----*/
#define CSL_HPI_PWREMU_MGMT_SOFT_OFF     (0x00000000u)
#define CSL_HPI_PWREMU_MGMT_SOFT_ON      (0x00000001u)

#define CSL_HPI_PWREMU_MGMT_FREE_MASK    (0x00000001u)
#define CSL_HPI_PWREMU_MGMT_FREE_SHIFT   (0x00000000u)
#define CSL_HPI_PWREMU_MGMT_FREE_RESETVAL (0x00000000u)

/*----FREE Tokens----*/
#define CSL_HPI_PWREMU_MGMT_FREE_OFF     (0x00000000u)
#define CSL_HPI_PWREMU_MGMT_FREE_ON      (0x00000001u)

#define CSL_HPI_PWREMU_MGMT_RESETVAL     (0x00000000u)

/* GPINT_CTRL */

#define CSL_HPI_GPINT_CTRL_GPINT_INV2_MASK (0x00040000u)
#define CSL_HPI_GPINT_CTRL_GPINT_INV2_SHIFT (0x00000012u)
#define CSL_HPI_GPINT_CTRL_GPINT_INV2_RESETVAL (0x00000000u)

/*----GPINT_INV2 Tokens----*/
#define CSL_HPI_GPINT_CTRL_GPINT_INV2_DISABLE (0x00000000u)
#define CSL_HPI_GPINT_CTRL_GPINT_INV2_ENABLE (0x00000001u)

#define CSL_HPI_GPINT_CTRL_GPINT_INV1_MASK (0x00020000u)
#define CSL_HPI_GPINT_CTRL_GPINT_INV1_SHIFT (0x00000011u)
#define CSL_HPI_GPINT_CTRL_GPINT_INV1_RESETVAL (0x00000000u)

/*----GPINT_INV1 Tokens----*/
#define CSL_HPI_GPINT_CTRL_GPINT_INV1_DISABLE (0x00000000u)
#define CSL_HPI_GPINT_CTRL_GPINT_INV1_ENABLE (0x00000001u)

#define CSL_HPI_GPINT_CTRL_GPINT_INV0_MASK (0x00010000u)
#define CSL_HPI_GPINT_CTRL_GPINT_INV0_SHIFT (0x00000010u)
#define CSL_HPI_GPINT_CTRL_GPINT_INV0_RESETVAL (0x00000000u)

/*----GPINT_INV0 Tokens----*/
#define CSL_HPI_GPINT_CTRL_GPINT_INV0_DISABLE (0x00000000u)
#define CSL_HPI_GPINT_CTRL_GPINT_INV0_ENABLE (0x00000001u)

#define CSL_HPI_GPINT_CTRL_GPINT_EN2_MASK (0x00000004u)
#define CSL_HPI_GPINT_CTRL_GPINT_EN2_SHIFT (0x00000002u)
#define CSL_HPI_GPINT_CTRL_GPINT_EN2_RESETVAL (0x00000000u)

/*----GPINT_EN2 Tokens----*/
#define CSL_HPI_GPINT_CTRL_GPINT_EN2_DISABLE (0x00000000u)
#define CSL_HPI_GPINT_CTRL_GPINT_EN2_ENABLE (0x00000001u)

#define CSL_HPI_GPINT_CTRL_GPINT_EN1_MASK (0x00000002u)
#define CSL_HPI_GPINT_CTRL_GPINT_EN1_SHIFT (0x00000001u)
#define CSL_HPI_GPINT_CTRL_GPINT_EN1_RESETVAL (0x00000000u)

/*----GPINT_EN1 Tokens----*/
#define CSL_HPI_GPINT_CTRL_GPINT_EN1_DISABLE (0x00000000u)
#define CSL_HPI_GPINT_CTRL_GPINT_EN1_ENABLE (0x00000001u)

#define CSL_HPI_GPINT_CTRL_GPINT_EN0_MASK (0x00000001u)
#define CSL_HPI_GPINT_CTRL_GPINT_EN0_SHIFT (0x00000000u)
#define CSL_HPI_GPINT_CTRL_GPINT_EN0_RESETVAL (0x00000000u)

/*----GPINT_EN0 Tokens----*/
#define CSL_HPI_GPINT_CTRL_GPINT_EN0_DISABLE (0x00000000u)
#define CSL_HPI_GPINT_CTRL_GPINT_EN0_ENABLE (0x00000001u)

#define CSL_HPI_GPINT_CTRL_RESETVAL      (0x00000000u)

/* GPIO_EN */

#define CSL_HPI_GPIO_EN_GPIO_EN16_MASK   (0x00010000u)
#define CSL_HPI_GPIO_EN_GPIO_EN16_SHIFT  (0x00000010u)
#define CSL_HPI_GPIO_EN_GPIO_EN16_RESETVAL (0x00000000u)

/*----GPIO_EN16 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN16_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN16_ENABLE (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN15_MASK   (0x00008000u)
#define CSL_HPI_GPIO_EN_GPIO_EN15_SHIFT  (0x0000000Fu)
#define CSL_HPI_GPIO_EN_GPIO_EN15_RESETVAL (0x00000000u)

/*----GPIO_EN15 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN15_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN15_ENABLE (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN14_MASK   (0x00004000u)
#define CSL_HPI_GPIO_EN_GPIO_EN14_SHIFT  (0x0000000Eu)
#define CSL_HPI_GPIO_EN_GPIO_EN14_RESETVAL (0x00000000u)

/*----GPIO_EN14 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN14_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN14_ENABLE (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN13_MASK   (0x00002000u)
#define CSL_HPI_GPIO_EN_GPIO_EN13_SHIFT  (0x0000000Du)
#define CSL_HPI_GPIO_EN_GPIO_EN13_RESETVAL (0x00000000u)

/*----GPIO_EN13 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN13_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN13_ENABLE (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN12_MASK   (0x00001000u)
#define CSL_HPI_GPIO_EN_GPIO_EN12_SHIFT  (0x0000000Cu)
#define CSL_HPI_GPIO_EN_GPIO_EN12_RESETVAL (0x00000000u)

/*----GPIO_EN12 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN12_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN12_ENABLE (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN11_MASK   (0x00000800u)
#define CSL_HPI_GPIO_EN_GPIO_EN11_SHIFT  (0x0000000Bu)
#define CSL_HPI_GPIO_EN_GPIO_EN11_RESETVAL (0x00000000u)

/*----GPIO_EN11 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN11_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN11_ENABLE (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN10_MASK   (0x00000400u)
#define CSL_HPI_GPIO_EN_GPIO_EN10_SHIFT  (0x0000000Au)
#define CSL_HPI_GPIO_EN_GPIO_EN10_RESETVAL (0x00000000u)

/*----GPIO_EN10 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN10_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN10_ENABLE (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN9_MASK    (0x00000200u)
#define CSL_HPI_GPIO_EN_GPIO_EN9_SHIFT   (0x00000009u)
#define CSL_HPI_GPIO_EN_GPIO_EN9_RESETVAL (0x00000000u)

/*----GPIO_EN9 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN9_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN9_ENABLE  (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN8_MASK    (0x00000100u)
#define CSL_HPI_GPIO_EN_GPIO_EN8_SHIFT   (0x00000008u)
#define CSL_HPI_GPIO_EN_GPIO_EN8_RESETVAL (0x00000000u)

/*----GPIO_EN8 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN8_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN8_ENABLE  (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN7_MASK    (0x00000080u)
#define CSL_HPI_GPIO_EN_GPIO_EN7_SHIFT   (0x00000007u)
#define CSL_HPI_GPIO_EN_GPIO_EN7_RESETVAL (0x00000000u)

/*----GPIO_EN7 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN7_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN7_ENABLE  (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN6_MASK    (0x00000040u)
#define CSL_HPI_GPIO_EN_GPIO_EN6_SHIFT   (0x00000006u)
#define CSL_HPI_GPIO_EN_GPIO_EN6_RESETVAL (0x00000000u)

/*----GPIO_EN6 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN6_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN6_ENABLE  (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN5_MASK    (0x00000020u)
#define CSL_HPI_GPIO_EN_GPIO_EN5_SHIFT   (0x00000005u)
#define CSL_HPI_GPIO_EN_GPIO_EN5_RESETVAL (0x00000000u)

/*----GPIO_EN5 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN5_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN5_ENABLE  (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN4_MASK    (0x00000010u)
#define CSL_HPI_GPIO_EN_GPIO_EN4_SHIFT   (0x00000004u)
#define CSL_HPI_GPIO_EN_GPIO_EN4_RESETVAL (0x00000000u)

/*----GPIO_EN4 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN4_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN4_ENABLE  (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN3_MASK    (0x00000008u)
#define CSL_HPI_GPIO_EN_GPIO_EN3_SHIFT   (0x00000003u)
#define CSL_HPI_GPIO_EN_GPIO_EN3_RESETVAL (0x00000000u)

/*----GPIO_EN3 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN3_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN3_ENABLE  (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN2_MASK    (0x00000004u)
#define CSL_HPI_GPIO_EN_GPIO_EN2_SHIFT   (0x00000002u)
#define CSL_HPI_GPIO_EN_GPIO_EN2_RESETVAL (0x00000000u)

/*----GPIO_EN2 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN2_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN2_ENABLE  (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN1_MASK    (0x00000002u)
#define CSL_HPI_GPIO_EN_GPIO_EN1_SHIFT   (0x00000001u)
#define CSL_HPI_GPIO_EN_GPIO_EN1_RESETVAL (0x00000000u)

/*----GPIO_EN1 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN1_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN1_ENABLE  (0x00000001u)

#define CSL_HPI_GPIO_EN_GPIO_EN0_MASK    (0x00000001u)
#define CSL_HPI_GPIO_EN_GPIO_EN0_SHIFT   (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN0_RESETVAL (0x00000000u)

/*----GPIO_EN0 Tokens----*/
#define CSL_HPI_GPIO_EN_GPIO_EN0_DISABLE (0x00000000u)
#define CSL_HPI_GPIO_EN_GPIO_EN0_ENABLE  (0x00000001u)

#define CSL_HPI_GPIO_EN_RESETVAL         (0x00000000u)

/* GPIO_DIR1 */

#define CSL_HPI_GPIO_DIR1_DIR_MASK       (0xFFFFFFFFu)
#define CSL_HPI_GPIO_DIR1_DIR_SHIFT      (0x00000000u)
#define CSL_HPI_GPIO_DIR1_DIR_RESETVAL   (0x00000000u)

/*----DIR Tokens----*/
#define CSL_HPI_GPIO_DIR1_DIR_INPUT      (0x00000000u)
#define CSL_HPI_GPIO_DIR1_DIR_OUTPUT     (0x00000001u)

#define CSL_HPI_GPIO_DIR1_RESETVAL       (0x00000000u)

/* GPIO_DAT1 */

#define CSL_HPI_GPIO_DAT1_DAT_MASK       (0xFFFFFFFFu)
#define CSL_HPI_GPIO_DAT1_DAT_SHIFT      (0x00000000u)
#define CSL_HPI_GPIO_DAT1_DAT_RESETVAL   (0x00000000u)

#define CSL_HPI_GPIO_DAT1_RESETVAL       (0x00000000u)

/* GPIO_DIR2 */

#define CSL_HPI_GPIO_DIR2_DIR14_MASK     (0x00004000u)
#define CSL_HPI_GPIO_DIR2_DIR14_SHIFT    (0x0000000Eu)
#define CSL_HPI_GPIO_DIR2_DIR14_RESETVAL (0x00000000u)

/*----DIR14 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR14_INPUT    (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR14_OUTPUT   (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR13_MASK     (0x00002000u)
#define CSL_HPI_GPIO_DIR2_DIR13_SHIFT    (0x0000000Du)
#define CSL_HPI_GPIO_DIR2_DIR13_RESETVAL (0x00000000u)

/*----DIR13 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR13_INPUT    (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR13_OUTPUT   (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR12_MASK     (0x00001000u)
#define CSL_HPI_GPIO_DIR2_DIR12_SHIFT    (0x0000000Cu)
#define CSL_HPI_GPIO_DIR2_DIR12_RESETVAL (0x00000000u)

/*----DIR12 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR12_INPUT    (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR12_OUTPUT   (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR11_MASK     (0x00000800u)
#define CSL_HPI_GPIO_DIR2_DIR11_SHIFT    (0x0000000Bu)
#define CSL_HPI_GPIO_DIR2_DIR11_RESETVAL (0x00000000u)

/*----DIR11 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR11_INPUT    (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR11_OUTPUT   (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR10_MASK     (0x00000400u)
#define CSL_HPI_GPIO_DIR2_DIR10_SHIFT    (0x0000000Au)
#define CSL_HPI_GPIO_DIR2_DIR10_RESETVAL (0x00000000u)

/*----DIR10 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR10_INPUT    (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR10_OUTPUT   (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR9_MASK      (0x00000200u)
#define CSL_HPI_GPIO_DIR2_DIR9_SHIFT     (0x00000009u)
#define CSL_HPI_GPIO_DIR2_DIR9_RESETVAL  (0x00000000u)

/*----DIR9 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR9_INPUT     (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR9_OUTPUT    (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR8_MASK      (0x00000100u)
#define CSL_HPI_GPIO_DIR2_DIR8_SHIFT     (0x00000008u)
#define CSL_HPI_GPIO_DIR2_DIR8_RESETVAL  (0x00000000u)

/*----DIR8 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR8_INPUT     (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR8_OUTPUT    (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR7_MASK      (0x00000080u)
#define CSL_HPI_GPIO_DIR2_DIR7_SHIFT     (0x00000007u)
#define CSL_HPI_GPIO_DIR2_DIR7_RESETVAL  (0x00000000u)

/*----DIR7 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR7_INPUT     (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR7_OUTPUT    (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR6_MASK      (0x00000040u)
#define CSL_HPI_GPIO_DIR2_DIR6_SHIFT     (0x00000006u)
#define CSL_HPI_GPIO_DIR2_DIR6_RESETVAL  (0x00000000u)

/*----DIR6 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR6_INPUT     (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR6_OUTPUT    (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR5_MASK      (0x00000020u)
#define CSL_HPI_GPIO_DIR2_DIR5_SHIFT     (0x00000005u)
#define CSL_HPI_GPIO_DIR2_DIR5_RESETVAL  (0x00000000u)

/*----DIR5 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR5_INPUT     (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR5_OUTPUT    (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR4_MASK      (0x00000010u)
#define CSL_HPI_GPIO_DIR2_DIR4_SHIFT     (0x00000004u)
#define CSL_HPI_GPIO_DIR2_DIR4_RESETVAL  (0x00000000u)

/*----DIR4 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR4_INPUT     (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR4_OUTPUT    (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR3_MASK      (0x00000008u)
#define CSL_HPI_GPIO_DIR2_DIR3_SHIFT     (0x00000003u)
#define CSL_HPI_GPIO_DIR2_DIR3_RESETVAL  (0x00000000u)

/*----DIR3 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR3_INPUT     (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR3_OUTPUT    (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR2_MASK      (0x00000004u)
#define CSL_HPI_GPIO_DIR2_DIR2_SHIFT     (0x00000002u)
#define CSL_HPI_GPIO_DIR2_DIR2_RESETVAL  (0x00000000u)

/*----DIR2 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR2_INPUT     (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR2_OUTPUT    (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR1_MASK      (0x00000002u)
#define CSL_HPI_GPIO_DIR2_DIR1_SHIFT     (0x00000001u)
#define CSL_HPI_GPIO_DIR2_DIR1_RESETVAL  (0x00000000u)

/*----DIR1 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR1_INPUT     (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR1_OUTPUT    (0x00000001u)

#define CSL_HPI_GPIO_DIR2_DIR0_MASK      (0x00000001u)
#define CSL_HPI_GPIO_DIR2_DIR0_SHIFT     (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR0_RESETVAL  (0x00000000u)

/*----DIR0 Tokens----*/
#define CSL_HPI_GPIO_DIR2_DIR0_INPUT     (0x00000000u)
#define CSL_HPI_GPIO_DIR2_DIR0_OUTPUT    (0x00000001u)

#define CSL_HPI_GPIO_DIR2_RESETVAL       (0x00000000u)

/* GPIO_DAT2 */

#define CSL_HPI_GPIO_DAT2_DAT14_MASK     (0x00004000u)
#define CSL_HPI_GPIO_DAT2_DAT14_SHIFT    (0x0000000Eu)
#define CSL_HPI_GPIO_DAT2_DAT14_RESETVAL (0x00000000u)

/*----DAT14 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT14_DISABLE  (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT14_ENABLE   (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT13_MASK     (0x00002000u)
#define CSL_HPI_GPIO_DAT2_DAT13_SHIFT    (0x0000000Du)
#define CSL_HPI_GPIO_DAT2_DAT13_RESETVAL (0x00000000u)

/*----DAT13 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT13_DISABLE  (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT13_ENABLE   (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT12_MASK     (0x00001000u)
#define CSL_HPI_GPIO_DAT2_DAT12_SHIFT    (0x0000000Cu)
#define CSL_HPI_GPIO_DAT2_DAT12_RESETVAL (0x00000000u)

/*----DAT12 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT12_DISABLE  (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT12_ENABLE   (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT11_MASK     (0x00000800u)
#define CSL_HPI_GPIO_DAT2_DAT11_SHIFT    (0x0000000Bu)
#define CSL_HPI_GPIO_DAT2_DAT11_RESETVAL (0x00000000u)

/*----DAT11 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT11_DISABLE  (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT11_ENABLE   (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT10_MASK     (0x00000400u)
#define CSL_HPI_GPIO_DAT2_DAT10_SHIFT    (0x0000000Au)
#define CSL_HPI_GPIO_DAT2_DAT10_RESETVAL (0x00000000u)

/*----DAT10 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT10_DISABLE  (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT10_ENABLE   (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT9_MASK      (0x00000200u)
#define CSL_HPI_GPIO_DAT2_DAT9_SHIFT     (0x00000009u)
#define CSL_HPI_GPIO_DAT2_DAT9_RESETVAL  (0x00000000u)

/*----DAT9 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT9_DISABLE   (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT9_ENABLE    (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT8_MASK      (0x00000100u)
#define CSL_HPI_GPIO_DAT2_DAT8_SHIFT     (0x00000008u)
#define CSL_HPI_GPIO_DAT2_DAT8_RESETVAL  (0x00000000u)

/*----DAT8 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT8_DISABLE   (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT8_ENABLE    (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT7_MASK      (0x00000080u)
#define CSL_HPI_GPIO_DAT2_DAT7_SHIFT     (0x00000007u)
#define CSL_HPI_GPIO_DAT2_DAT7_RESETVAL  (0x00000000u)

/*----DAT7 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT7_DISABLE   (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT7_ENABLE    (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT6_MASK      (0x00000040u)
#define CSL_HPI_GPIO_DAT2_DAT6_SHIFT     (0x00000006u)
#define CSL_HPI_GPIO_DAT2_DAT6_RESETVAL  (0x00000000u)

/*----DAT6 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT6_DISABLE   (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT6_ENABLE    (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT5_MASK      (0x00000020u)
#define CSL_HPI_GPIO_DAT2_DAT5_SHIFT     (0x00000005u)
#define CSL_HPI_GPIO_DAT2_DAT5_RESETVAL  (0x00000000u)

/*----DAT5 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT5_DISABLE   (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT5_ENABLE    (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT4_MASK      (0x00000010u)
#define CSL_HPI_GPIO_DAT2_DAT4_SHIFT     (0x00000004u)
#define CSL_HPI_GPIO_DAT2_DAT4_RESETVAL  (0x00000000u)

/*----DAT4 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT4_DISABLE   (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT4_ENABLE    (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT3_MASK      (0x00000008u)
#define CSL_HPI_GPIO_DAT2_DAT3_SHIFT     (0x00000003u)
#define CSL_HPI_GPIO_DAT2_DAT3_RESETVAL  (0x00000000u)

/*----DAT3 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT3_DISABLE   (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT3_ENABLE    (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT2_MASK      (0x00000004u)
#define CSL_HPI_GPIO_DAT2_DAT2_SHIFT     (0x00000002u)
#define CSL_HPI_GPIO_DAT2_DAT2_RESETVAL  (0x00000000u)

/*----DAT2 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT2_DISABLE   (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT2_ENABLE    (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT1_MASK      (0x00000002u)
#define CSL_HPI_GPIO_DAT2_DAT1_SHIFT     (0x00000001u)
#define CSL_HPI_GPIO_DAT2_DAT1_RESETVAL  (0x00000000u)

/*----DAT1 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT1_DISABLE   (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT1_ENABLE    (0x00000001u)

#define CSL_HPI_GPIO_DAT2_DAT0_MASK      (0x00000001u)
#define CSL_HPI_GPIO_DAT2_DAT0_SHIFT     (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT0_RESETVAL  (0x00000000u)

/*----DAT0 Tokens----*/
#define CSL_HPI_GPIO_DAT2_DAT0_DISABLE   (0x00000000u)
#define CSL_HPI_GPIO_DAT2_DAT0_ENABLE    (0x00000001u)

#define CSL_HPI_GPIO_DAT2_RESETVAL       (0x00000000u)

/* GPIO_DIR3 */

#define CSL_HPI_GPIO_DIR3_DIR31_MASK     (0x80000000u)
#define CSL_HPI_GPIO_DIR3_DIR31_SHIFT    (0x0000001Fu)
#define CSL_HPI_GPIO_DIR3_DIR31_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR30_MASK     (0x40000000u)
#define CSL_HPI_GPIO_DIR3_DIR30_SHIFT    (0x0000001Eu)
#define CSL_HPI_GPIO_DIR3_DIR30_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR29_MASK     (0x20000000u)
#define CSL_HPI_GPIO_DIR3_DIR29_SHIFT    (0x0000001Du)
#define CSL_HPI_GPIO_DIR3_DIR29_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR28_MASK     (0x10000000u)
#define CSL_HPI_GPIO_DIR3_DIR28_SHIFT    (0x0000001Cu)
#define CSL_HPI_GPIO_DIR3_DIR28_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR27_MASK     (0x08000000u)
#define CSL_HPI_GPIO_DIR3_DIR27_SHIFT    (0x0000001Bu)
#define CSL_HPI_GPIO_DIR3_DIR27_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR26_MASK     (0x04000000u)
#define CSL_HPI_GPIO_DIR3_DIR26_SHIFT    (0x0000001Au)
#define CSL_HPI_GPIO_DIR3_DIR26_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR25_MASK     (0x02000000u)
#define CSL_HPI_GPIO_DIR3_DIR25_SHIFT    (0x00000019u)
#define CSL_HPI_GPIO_DIR3_DIR25_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR24_MASK     (0x01000000u)
#define CSL_HPI_GPIO_DIR3_DIR24_SHIFT    (0x00000018u)
#define CSL_HPI_GPIO_DIR3_DIR24_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR23_MASK     (0x00800000u)
#define CSL_HPI_GPIO_DIR3_DIR23_SHIFT    (0x00000017u)
#define CSL_HPI_GPIO_DIR3_DIR23_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR22_MASK     (0x00400000u)
#define CSL_HPI_GPIO_DIR3_DIR22_SHIFT    (0x00000016u)
#define CSL_HPI_GPIO_DIR3_DIR22_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR21_MASK     (0x00200000u)
#define CSL_HPI_GPIO_DIR3_DIR21_SHIFT    (0x00000015u)
#define CSL_HPI_GPIO_DIR3_DIR21_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR20_MASK     (0x00100000u)
#define CSL_HPI_GPIO_DIR3_DIR20_SHIFT    (0x00000014u)
#define CSL_HPI_GPIO_DIR3_DIR20_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR19_MASK     (0x00080000u)
#define CSL_HPI_GPIO_DIR3_DIR19_SHIFT    (0x00000013u)
#define CSL_HPI_GPIO_DIR3_DIR19_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR18_MASK     (0x00040000u)
#define CSL_HPI_GPIO_DIR3_DIR18_SHIFT    (0x00000012u)
#define CSL_HPI_GPIO_DIR3_DIR18_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR17_MASK     (0x00020000u)
#define CSL_HPI_GPIO_DIR3_DIR17_SHIFT    (0x00000011u)
#define CSL_HPI_GPIO_DIR3_DIR17_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR16_MASK     (0x00010000u)
#define CSL_HPI_GPIO_DIR3_DIR16_SHIFT    (0x00000010u)
#define CSL_HPI_GPIO_DIR3_DIR16_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR15_MASK     (0x00008000u)
#define CSL_HPI_GPIO_DIR3_DIR15_SHIFT    (0x0000000Fu)
#define CSL_HPI_GPIO_DIR3_DIR15_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR14_MASK     (0x00004000u)
#define CSL_HPI_GPIO_DIR3_DIR14_SHIFT    (0x0000000Eu)
#define CSL_HPI_GPIO_DIR3_DIR14_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR13_MASK     (0x00002000u)
#define CSL_HPI_GPIO_DIR3_DIR13_SHIFT    (0x0000000Du)
#define CSL_HPI_GPIO_DIR3_DIR13_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR12_MASK     (0x00001000u)
#define CSL_HPI_GPIO_DIR3_DIR12_SHIFT    (0x0000000Cu)
#define CSL_HPI_GPIO_DIR3_DIR12_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR11_MASK     (0x00000800u)
#define CSL_HPI_GPIO_DIR3_DIR11_SHIFT    (0x0000000Bu)
#define CSL_HPI_GPIO_DIR3_DIR11_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR10_MASK     (0x00000400u)
#define CSL_HPI_GPIO_DIR3_DIR10_SHIFT    (0x0000000Au)
#define CSL_HPI_GPIO_DIR3_DIR10_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR9_MASK      (0x00000200u)
#define CSL_HPI_GPIO_DIR3_DIR9_SHIFT     (0x00000009u)
#define CSL_HPI_GPIO_DIR3_DIR9_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR8_MASK      (0x00000100u)
#define CSL_HPI_GPIO_DIR3_DIR8_SHIFT     (0x00000008u)
#define CSL_HPI_GPIO_DIR3_DIR8_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR7_MASK      (0x00000080u)
#define CSL_HPI_GPIO_DIR3_DIR7_SHIFT     (0x00000007u)
#define CSL_HPI_GPIO_DIR3_DIR7_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR6_MASK      (0x00000040u)
#define CSL_HPI_GPIO_DIR3_DIR6_SHIFT     (0x00000006u)
#define CSL_HPI_GPIO_DIR3_DIR6_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR5_MASK      (0x00000020u)
#define CSL_HPI_GPIO_DIR3_DIR5_SHIFT     (0x00000005u)
#define CSL_HPI_GPIO_DIR3_DIR5_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR4_MASK      (0x00000010u)
#define CSL_HPI_GPIO_DIR3_DIR4_SHIFT     (0x00000004u)
#define CSL_HPI_GPIO_DIR3_DIR4_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR3_MASK      (0x00000008u)
#define CSL_HPI_GPIO_DIR3_DIR3_SHIFT     (0x00000003u)
#define CSL_HPI_GPIO_DIR3_DIR3_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR2_MASK      (0x00000004u)
#define CSL_HPI_GPIO_DIR3_DIR2_SHIFT     (0x00000002u)
#define CSL_HPI_GPIO_DIR3_DIR2_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR1_MASK      (0x00000002u)
#define CSL_HPI_GPIO_DIR3_DIR1_SHIFT     (0x00000001u)
#define CSL_HPI_GPIO_DIR3_DIR1_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DIR3_DIR0_MASK      (0x00000001u)
#define CSL_HPI_GPIO_DIR3_DIR0_SHIFT     (0x00000000u)
#define CSL_HPI_GPIO_DIR3_DIR0_RESETVAL  (0x00000000u)

/*----DIR Tokens----*/
#define CSL_HPI_GPIO_DIR3_DIR_INPUT      (0x00000000u)
#define CSL_HPI_GPIO_DIR3_DIR_OUTPUT     (0x00000001u)

#define CSL_HPI_GPIO_DIR3_RESETVAL       (0x00000000u)

/* GPIO_DAT3 */

#define CSL_HPI_GPIO_DAT3_DAT31_MASK     (0x80000000u)
#define CSL_HPI_GPIO_DAT3_DAT31_SHIFT    (0x0000001Fu)
#define CSL_HPI_GPIO_DAT3_DAT31_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT30_MASK     (0x40000000u)
#define CSL_HPI_GPIO_DAT3_DAT30_SHIFT    (0x0000001Eu)
#define CSL_HPI_GPIO_DAT3_DAT30_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT29_MASK     (0x20000000u)
#define CSL_HPI_GPIO_DAT3_DAT29_SHIFT    (0x0000001Du)
#define CSL_HPI_GPIO_DAT3_DAT29_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT28_MASK     (0x10000000u)
#define CSL_HPI_GPIO_DAT3_DAT28_SHIFT    (0x0000001Cu)
#define CSL_HPI_GPIO_DAT3_DAT28_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT27_MASK     (0x08000000u)
#define CSL_HPI_GPIO_DAT3_DAT27_SHIFT    (0x0000001Bu)
#define CSL_HPI_GPIO_DAT3_DAT27_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT26_MASK     (0x04000000u)
#define CSL_HPI_GPIO_DAT3_DAT26_SHIFT    (0x0000001Au)
#define CSL_HPI_GPIO_DAT3_DAT26_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT25_MASK     (0x02000000u)
#define CSL_HPI_GPIO_DAT3_DAT25_SHIFT    (0x00000019u)
#define CSL_HPI_GPIO_DAT3_DAT25_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT24_MASK     (0x01000000u)
#define CSL_HPI_GPIO_DAT3_DAT24_SHIFT    (0x00000018u)
#define CSL_HPI_GPIO_DAT3_DAT24_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT23_MASK     (0x00800000u)
#define CSL_HPI_GPIO_DAT3_DAT23_SHIFT    (0x00000017u)
#define CSL_HPI_GPIO_DAT3_DAT23_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT22_MASK     (0x00400000u)
#define CSL_HPI_GPIO_DAT3_DAT22_SHIFT    (0x00000016u)
#define CSL_HPI_GPIO_DAT3_DAT22_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT21_MASK     (0x00200000u)
#define CSL_HPI_GPIO_DAT3_DAT21_SHIFT    (0x00000015u)
#define CSL_HPI_GPIO_DAT3_DAT21_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT20_MASK     (0x00100000u)
#define CSL_HPI_GPIO_DAT3_DAT20_SHIFT    (0x00000014u)
#define CSL_HPI_GPIO_DAT3_DAT20_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT19_MASK     (0x00080000u)
#define CSL_HPI_GPIO_DAT3_DAT19_SHIFT    (0x00000013u)
#define CSL_HPI_GPIO_DAT3_DAT19_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT18_MASK     (0x00040000u)
#define CSL_HPI_GPIO_DAT3_DAT18_SHIFT    (0x00000012u)
#define CSL_HPI_GPIO_DAT3_DAT18_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT17_MASK     (0x00020000u)
#define CSL_HPI_GPIO_DAT3_DAT17_SHIFT    (0x00000011u)
#define CSL_HPI_GPIO_DAT3_DAT17_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT16_MASK     (0x00010000u)
#define CSL_HPI_GPIO_DAT3_DAT16_SHIFT    (0x00000010u)
#define CSL_HPI_GPIO_DAT3_DAT16_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT15_MASK     (0x00008000u)
#define CSL_HPI_GPIO_DAT3_DAT15_SHIFT    (0x0000000Fu)
#define CSL_HPI_GPIO_DAT3_DAT15_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT14_MASK     (0x00004000u)
#define CSL_HPI_GPIO_DAT3_DAT14_SHIFT    (0x0000000Eu)
#define CSL_HPI_GPIO_DAT3_DAT14_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT13_MASK     (0x00002000u)
#define CSL_HPI_GPIO_DAT3_DAT13_SHIFT    (0x0000000Du)
#define CSL_HPI_GPIO_DAT3_DAT13_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT12_MASK     (0x00001000u)
#define CSL_HPI_GPIO_DAT3_DAT12_SHIFT    (0x0000000Cu)
#define CSL_HPI_GPIO_DAT3_DAT12_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT11_MASK     (0x00000800u)
#define CSL_HPI_GPIO_DAT3_DAT11_SHIFT    (0x0000000Bu)
#define CSL_HPI_GPIO_DAT3_DAT11_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT10_MASK     (0x00000400u)
#define CSL_HPI_GPIO_DAT3_DAT10_SHIFT    (0x0000000Au)
#define CSL_HPI_GPIO_DAT3_DAT10_RESETVAL (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT9_MASK      (0x00000200u)
#define CSL_HPI_GPIO_DAT3_DAT9_SHIFT     (0x00000009u)
#define CSL_HPI_GPIO_DAT3_DAT9_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT8_MASK      (0x00000100u)
#define CSL_HPI_GPIO_DAT3_DAT8_SHIFT     (0x00000008u)
#define CSL_HPI_GPIO_DAT3_DAT8_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT7_MASK      (0x00000080u)
#define CSL_HPI_GPIO_DAT3_DAT7_SHIFT     (0x00000007u)
#define CSL_HPI_GPIO_DAT3_DAT7_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT6_MASK      (0x00000040u)
#define CSL_HPI_GPIO_DAT3_DAT6_SHIFT     (0x00000006u)
#define CSL_HPI_GPIO_DAT3_DAT6_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT5_MASK      (0x00000020u)
#define CSL_HPI_GPIO_DAT3_DAT5_SHIFT     (0x00000005u)
#define CSL_HPI_GPIO_DAT3_DAT5_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT4_MASK      (0x00000010u)
#define CSL_HPI_GPIO_DAT3_DAT4_SHIFT     (0x00000004u)
#define CSL_HPI_GPIO_DAT3_DAT4_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT3_MASK      (0x00000008u)
#define CSL_HPI_GPIO_DAT3_DAT3_SHIFT     (0x00000003u)
#define CSL_HPI_GPIO_DAT3_DAT3_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT2_MASK      (0x00000004u)
#define CSL_HPI_GPIO_DAT3_DAT2_SHIFT     (0x00000002u)
#define CSL_HPI_GPIO_DAT3_DAT2_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT1_MASK      (0x00000002u)
#define CSL_HPI_GPIO_DAT3_DAT1_SHIFT     (0x00000001u)
#define CSL_HPI_GPIO_DAT3_DAT1_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DAT3_DAT0_MASK      (0x00000001u)
#define CSL_HPI_GPIO_DAT3_DAT0_SHIFT     (0x00000000u)
#define CSL_HPI_GPIO_DAT3_DAT0_RESETVAL  (0x00000000u)

#define CSL_HPI_GPIO_DAT3_RESETVAL       (0x00000000u)

/* HPIC */

#define CSL_HPI_HPIC_HPIA_RW_SEL_MASK    (0x00000800u)
#define CSL_HPI_HPIC_HPIA_RW_SEL_SHIFT   (0x0000000Bu)
#define CSL_HPI_HPIC_HPIA_RW_SEL_RESETVAL (0x00000000u)

/*----HPIA_RW_SEL Tokens----*/
#define CSL_HPI_HPIC_HPIA_RW_SEL_HPIA_R  (0x00000000u)
#define CSL_HPI_HPIC_HPIA_RW_SEL_HPIA_W  (0x00000001u)

#define CSL_HPI_HPIC_DUAL_HPIA_MASK      (0x00000200u)
#define CSL_HPI_HPIC_DUAL_HPIA_SHIFT     (0x00000009u)
#define CSL_HPI_HPIC_DUAL_HPIA_RESETVAL  (0x00000000u)

/*----DUAL_HPIA Tokens----*/
#define CSL_HPI_HPIC_DUAL_HPIA_DISABLE   (0x00000000u)
#define CSL_HPI_HPIC_DUAL_HPIA_ENABLE    (0x00000001u)

#define CSL_HPI_HPIC_HWOB_STAT_MASK      (0x00000100u)
#define CSL_HPI_HPIC_HWOB_STAT_SHIFT     (0x00000008u)
#define CSL_HPI_HPIC_HWOB_STAT_RESETVAL  (0x00000000u)

#define CSL_HPI_HPIC_HPI_RST_MASK        (0x00000080u)
#define CSL_HPI_HPIC_HPI_RST_SHIFT       (0x00000007u)
#define CSL_HPI_HPIC_HPI_RST_RESETVAL    (0x00000001u)

#define CSL_HPI_HPIC_XHPIA_MASK          (0x00000020u)
#define CSL_HPI_HPIC_XHPIA_SHIFT         (0x00000005u)
#define CSL_HPI_HPIC_XHPIA_RESETVAL      (0x00000000u)

#define CSL_HPI_HPIC_FETCH_MASK          (0x00000010u)
#define CSL_HPI_HPIC_FETCH_SHIFT         (0x00000004u)
#define CSL_HPI_HPIC_FETCH_RESETVAL      (0x00000000u)

#define CSL_HPI_HPIC_HRDY_MASK           (0x00000008u)
#define CSL_HPI_HPIC_HRDY_SHIFT          (0x00000003u)
#define CSL_HPI_HPIC_HRDY_RESETVAL       (0x00000000u)

#define CSL_HPI_HPIC_HINT_MASK           (0x00000004u)
#define CSL_HPI_HPIC_HINT_SHIFT          (0x00000002u)
#define CSL_HPI_HPIC_HINT_RESETVAL       (0x00000000u)

/*----HINT Tokens----*/
#define CSL_HPI_HPIC_HINT_DISABLE        (0x00000001u)
#define CSL_HPI_HPIC_HINT_ENABLE         (0x00000001u)

#define CSL_HPI_HPIC_DSP_INT_MASK        (0x00000002u)
#define CSL_HPI_HPIC_DSP_INT_SHIFT       (0x00000001u)
#define CSL_HPI_HPIC_DSP_INT_RESETVAL    (0x00000000u)

/*----DSP_INT Tokens----*/
#define CSL_HPI_HPIC_DSP_INT_DISABLE     (0x00000000u)
#define CSL_HPI_HPIC_DSP_INT_ENABLE      (0x00000001u)

#define CSL_HPI_HPIC_HWOB_MASK           (0x00000001u)
#define CSL_HPI_HPIC_HWOB_SHIFT          (0x00000000u)
#define CSL_HPI_HPIC_HWOB_RESETVAL       (0x00000000u)

/*----HWOB Tokens----*/
#define CSL_HPI_HPIC_HWOB_DISABLE        (0x00000000u)
#define CSL_HPI_HPIC_HWOB_ENABLE         (0x00000001u)

#define CSL_HPI_HPIC_RESETVAL            (0x000000C0u)

/* HPIAW */

#define CSL_HPI_HPIAW_HPIAW31_MASK       (0x80000000u)
#define CSL_HPI_HPIAW_HPIAW31_SHIFT      (0x0000001Fu)
#define CSL_HPI_HPIAW_HPIAW31_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW30_MASK       (0x40000000u)
#define CSL_HPI_HPIAW_HPIAW30_SHIFT      (0x0000001Eu)
#define CSL_HPI_HPIAW_HPIAW30_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW29_MASK       (0x20000000u)
#define CSL_HPI_HPIAW_HPIAW29_SHIFT      (0x0000001Du)
#define CSL_HPI_HPIAW_HPIAW29_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW28_MASK       (0x10000000u)
#define CSL_HPI_HPIAW_HPIAW28_SHIFT      (0x0000001Cu)
#define CSL_HPI_HPIAW_HPIAW28_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW27_MASK       (0x08000000u)
#define CSL_HPI_HPIAW_HPIAW27_SHIFT      (0x0000001Bu)
#define CSL_HPI_HPIAW_HPIAW27_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW26_MASK       (0x04000000u)
#define CSL_HPI_HPIAW_HPIAW26_SHIFT      (0x0000001Au)
#define CSL_HPI_HPIAW_HPIAW26_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW25_MASK       (0x02000000u)
#define CSL_HPI_HPIAW_HPIAW25_SHIFT      (0x00000019u)
#define CSL_HPI_HPIAW_HPIAW25_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW24_MASK       (0x01000000u)
#define CSL_HPI_HPIAW_HPIAW24_SHIFT      (0x00000018u)
#define CSL_HPI_HPIAW_HPIAW24_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW23_MASK       (0x00800000u)
#define CSL_HPI_HPIAW_HPIAW23_SHIFT      (0x00000017u)
#define CSL_HPI_HPIAW_HPIAW23_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW22_MASK       (0x00400000u)
#define CSL_HPI_HPIAW_HPIAW22_SHIFT      (0x00000016u)
#define CSL_HPI_HPIAW_HPIAW22_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW21_MASK       (0x00200000u)
#define CSL_HPI_HPIAW_HPIAW21_SHIFT      (0x00000015u)
#define CSL_HPI_HPIAW_HPIAW21_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW20_MASK       (0x00100000u)
#define CSL_HPI_HPIAW_HPIAW20_SHIFT      (0x00000014u)
#define CSL_HPI_HPIAW_HPIAW20_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW19_MASK       (0x00080000u)
#define CSL_HPI_HPIAW_HPIAW19_SHIFT      (0x00000013u)
#define CSL_HPI_HPIAW_HPIAW19_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW18_MASK       (0x00040000u)
#define CSL_HPI_HPIAW_HPIAW18_SHIFT      (0x00000012u)
#define CSL_HPI_HPIAW_HPIAW18_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW17_MASK       (0x00020000u)
#define CSL_HPI_HPIAW_HPIAW17_SHIFT      (0x00000011u)
#define CSL_HPI_HPIAW_HPIAW17_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW16_MASK       (0x00010000u)
#define CSL_HPI_HPIAW_HPIAW16_SHIFT      (0x00000010u)
#define CSL_HPI_HPIAW_HPIAW16_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW15_MASK       (0x00008000u)
#define CSL_HPI_HPIAW_HPIAW15_SHIFT      (0x0000000Fu)
#define CSL_HPI_HPIAW_HPIAW15_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW14_MASK       (0x00004000u)
#define CSL_HPI_HPIAW_HPIAW14_SHIFT      (0x0000000Eu)
#define CSL_HPI_HPIAW_HPIAW14_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW13_MASK       (0x00002000u)
#define CSL_HPI_HPIAW_HPIAW13_SHIFT      (0x0000000Du)
#define CSL_HPI_HPIAW_HPIAW13_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW12_MASK       (0x00001000u)
#define CSL_HPI_HPIAW_HPIAW12_SHIFT      (0x0000000Cu)
#define CSL_HPI_HPIAW_HPIAW12_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW11_MASK       (0x00000800u)
#define CSL_HPI_HPIAW_HPIAW11_SHIFT      (0x0000000Bu)
#define CSL_HPI_HPIAW_HPIAW11_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW10_MASK       (0x00000400u)
#define CSL_HPI_HPIAW_HPIAW10_SHIFT      (0x0000000Au)
#define CSL_HPI_HPIAW_HPIAW10_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW9_MASK        (0x00000200u)
#define CSL_HPI_HPIAW_HPIAW9_SHIFT       (0x00000009u)
#define CSL_HPI_HPIAW_HPIAW9_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW8_MASK        (0x00000100u)
#define CSL_HPI_HPIAW_HPIAW8_SHIFT       (0x00000008u)
#define CSL_HPI_HPIAW_HPIAW8_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW7_MASK        (0x00000080u)
#define CSL_HPI_HPIAW_HPIAW7_SHIFT       (0x00000007u)
#define CSL_HPI_HPIAW_HPIAW7_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW6_MASK        (0x00000040u)
#define CSL_HPI_HPIAW_HPIAW6_SHIFT       (0x00000006u)
#define CSL_HPI_HPIAW_HPIAW6_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW5_MASK        (0x00000020u)
#define CSL_HPI_HPIAW_HPIAW5_SHIFT       (0x00000005u)
#define CSL_HPI_HPIAW_HPIAW5_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW4_MASK        (0x00000010u)
#define CSL_HPI_HPIAW_HPIAW4_SHIFT       (0x00000004u)
#define CSL_HPI_HPIAW_HPIAW4_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW3_MASK        (0x00000008u)
#define CSL_HPI_HPIAW_HPIAW3_SHIFT       (0x00000003u)
#define CSL_HPI_HPIAW_HPIAW3_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW2_MASK        (0x00000004u)
#define CSL_HPI_HPIAW_HPIAW2_SHIFT       (0x00000002u)
#define CSL_HPI_HPIAW_HPIAW2_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW1_MASK        (0x00000002u)
#define CSL_HPI_HPIAW_HPIAW1_SHIFT       (0x00000001u)
#define CSL_HPI_HPIAW_HPIAW1_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAW_HPIAW0_MASK        (0x00000001u)
#define CSL_HPI_HPIAW_HPIAW0_SHIFT       (0x00000000u)
#define CSL_HPI_HPIAW_HPIAW0_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAW_RESETVAL           (0x00000000u)

/* HPIAR */

#define CSL_HPI_HPIAR_HPIAR31_MASK       (0x80000000u)
#define CSL_HPI_HPIAR_HPIAR31_SHIFT      (0x0000001Fu)
#define CSL_HPI_HPIAR_HPIAR31_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR30_MASK       (0x40000000u)
#define CSL_HPI_HPIAR_HPIAR30_SHIFT      (0x0000001Eu)
#define CSL_HPI_HPIAR_HPIAR30_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR29_MASK       (0x20000000u)
#define CSL_HPI_HPIAR_HPIAR29_SHIFT      (0x0000001Du)
#define CSL_HPI_HPIAR_HPIAR29_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR28_MASK       (0x10000000u)
#define CSL_HPI_HPIAR_HPIAR28_SHIFT      (0x0000001Cu)
#define CSL_HPI_HPIAR_HPIAR28_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR27_MASK       (0x08000000u)
#define CSL_HPI_HPIAR_HPIAR27_SHIFT      (0x0000001Bu)
#define CSL_HPI_HPIAR_HPIAR27_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR26_MASK       (0x04000000u)
#define CSL_HPI_HPIAR_HPIAR26_SHIFT      (0x0000001Au)
#define CSL_HPI_HPIAR_HPIAR26_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR25_MASK       (0x02000000u)
#define CSL_HPI_HPIAR_HPIAR25_SHIFT      (0x00000019u)
#define CSL_HPI_HPIAR_HPIAR25_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR24_MASK       (0x01000000u)
#define CSL_HPI_HPIAR_HPIAR24_SHIFT      (0x00000018u)
#define CSL_HPI_HPIAR_HPIAR24_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR23_MASK       (0x00800000u)
#define CSL_HPI_HPIAR_HPIAR23_SHIFT      (0x00000017u)
#define CSL_HPI_HPIAR_HPIAR23_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR22_MASK       (0x00400000u)
#define CSL_HPI_HPIAR_HPIAR22_SHIFT      (0x00000016u)
#define CSL_HPI_HPIAR_HPIAR22_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR21_MASK       (0x00200000u)
#define CSL_HPI_HPIAR_HPIAR21_SHIFT      (0x00000015u)
#define CSL_HPI_HPIAR_HPIAR21_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR20_MASK       (0x00100000u)
#define CSL_HPI_HPIAR_HPIAR20_SHIFT      (0x00000014u)
#define CSL_HPI_HPIAR_HPIAR20_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR19_MASK       (0x00080000u)
#define CSL_HPI_HPIAR_HPIAR19_SHIFT      (0x00000013u)
#define CSL_HPI_HPIAR_HPIAR19_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR18_MASK       (0x00040000u)
#define CSL_HPI_HPIAR_HPIAR18_SHIFT      (0x00000012u)
#define CSL_HPI_HPIAR_HPIAR18_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR17_MASK       (0x00020000u)
#define CSL_HPI_HPIAR_HPIAR17_SHIFT      (0x00000011u)
#define CSL_HPI_HPIAR_HPIAR17_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR16_MASK       (0x00010000u)
#define CSL_HPI_HPIAR_HPIAR16_SHIFT      (0x00000010u)
#define CSL_HPI_HPIAR_HPIAR16_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR15_MASK       (0x00008000u)
#define CSL_HPI_HPIAR_HPIAR15_SHIFT      (0x0000000Fu)
#define CSL_HPI_HPIAR_HPIAR15_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR14_MASK       (0x00004000u)
#define CSL_HPI_HPIAR_HPIAR14_SHIFT      (0x0000000Eu)
#define CSL_HPI_HPIAR_HPIAR14_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR13_MASK       (0x00002000u)
#define CSL_HPI_HPIAR_HPIAR13_SHIFT      (0x0000000Du)
#define CSL_HPI_HPIAR_HPIAR13_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR12_MASK       (0x00001000u)
#define CSL_HPI_HPIAR_HPIAR12_SHIFT      (0x0000000Cu)
#define CSL_HPI_HPIAR_HPIAR12_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR11_MASK       (0x00000800u)
#define CSL_HPI_HPIAR_HPIAR11_SHIFT      (0x0000000Bu)
#define CSL_HPI_HPIAR_HPIAR11_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR10_MASK       (0x00000400u)
#define CSL_HPI_HPIAR_HPIAR10_SHIFT      (0x0000000Au)
#define CSL_HPI_HPIAR_HPIAR10_RESETVAL   (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR9_MASK        (0x00000200u)
#define CSL_HPI_HPIAR_HPIAR9_SHIFT       (0x00000009u)
#define CSL_HPI_HPIAR_HPIAR9_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR8_MASK        (0x00000100u)
#define CSL_HPI_HPIAR_HPIAR8_SHIFT       (0x00000008u)
#define CSL_HPI_HPIAR_HPIAR8_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR7_MASK        (0x00000080u)
#define CSL_HPI_HPIAR_HPIAR7_SHIFT       (0x00000007u)
#define CSL_HPI_HPIAR_HPIAR7_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR6_MASK        (0x00000040u)
#define CSL_HPI_HPIAR_HPIAR6_SHIFT       (0x00000006u)
#define CSL_HPI_HPIAR_HPIAR6_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR5_MASK        (0x00000020u)
#define CSL_HPI_HPIAR_HPIAR5_SHIFT       (0x00000005u)
#define CSL_HPI_HPIAR_HPIAR5_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR4_MASK        (0x00000010u)
#define CSL_HPI_HPIAR_HPIAR4_SHIFT       (0x00000004u)
#define CSL_HPI_HPIAR_HPIAR4_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR3_MASK        (0x00000008u)
#define CSL_HPI_HPIAR_HPIAR3_SHIFT       (0x00000003u)
#define CSL_HPI_HPIAR_HPIAR3_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR2_MASK        (0x00000004u)
#define CSL_HPI_HPIAR_HPIAR2_SHIFT       (0x00000002u)
#define CSL_HPI_HPIAR_HPIAR2_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR1_MASK        (0x00000002u)
#define CSL_HPI_HPIAR_HPIAR1_SHIFT       (0x00000001u)
#define CSL_HPI_HPIAR_HPIAR1_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAR_HPIAR0_MASK        (0x00000001u)
#define CSL_HPI_HPIAR_HPIAR0_SHIFT       (0x00000000u)
#define CSL_HPI_HPIAR_HPIAR0_RESETVAL    (0x00000000u)

#define CSL_HPI_HPIAR_RESETVAL           (0x00000000u)

#endif
