/** ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004, 2005
 *
 *   Use of this software is controlled by the terms and conditions found in the
 *   license agreement under which this software has been supplied.
 *   ===========================================================================
 */

/* =============================================================================
 *   @file  mcasp_example.h
 *
 *   @desc  McASP CSL API Example for LoopBack Mode.
 * =============================================================================
 */

 /* =============================================================================
  *  Revision History
  *  ===============
  *  21-Mar-2005 asr File Created.
  *
  * =============================================================================
  */

#ifndef _MCASP_EXAMPLE_H_
#define _MCASP_EXAMPLE_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include <csl_mcasp.h>
#include <csl_intc.h>
#include <csl_dmax.h>
#include <soc.h>
#include <stdio.h>
#include <string.h>

/**********************************************************************/
/* General Definition                                                 */
/**********************************************************************/
#define FILL_CONST    (0)       /* Used for memory fill functions */
#define FILL_INC      (1)
#define FILL_DEC      (2)

#define PASS          (0)       /* Used as test return flags */
#define ERROR_TEST    (1)
#define ERROR_FILL    (2)

/**********************************************************************/
/* Test-specific Definition                                           */
/**********************************************************************/

#define NUM_XMT_SERIALIZER   (8)
#define NUM_RCV_SERIALIZER   (8)
#define NUM_TDM_SLOT         (16)
#define NUM_XTDM_SLOT        (16)       /* only count the active even slots */
#define NUM_RTDM_SLOT        (16)       /* receives all slots--active and inactive */
#define TOTAL_XMT_DATA       NUM_XTDM_SLOT*1    /* transfer a total of 5 TDM frames per pin */
#define TOTAL_RCV_DATA       NUM_RTDM_SLOT*1    /* receives a total of 5 TDM frames per pin */

/* Transfer Complete success */
#define TC_PASS              0x0
/* Error in Transfer complete */
#define TC_FAIL              0x1

/*Setting the AHCLKRCTL i.e FALLING,INTERNAL & DIVIDE_RATIO */
#define HCLKRCTL_DIV_INTER_FALL 0x0000C02A

/* setting the ISTP value to base of the Vector Table */
#define ISTP_VECTOR_VALUE       0x10000000

/* Source Data buffer initialized with this value */
#define SRC_DATA_DEFAULT        0x12233445

/* Destination Data buffer initialized with this value */
#define DST_DATA_DEFAULT        0xdeaddead

/* Transfer Count0 */
#define COUNT0                  NUM_RCV_SERIALIZER

/* Transfer Count1 */
#define COUNT1                  NUM_TDM_SLOT

/* Transfer Count2 */
#define COUNT2                  0x0

/* Source Index0 */
#define TX_SRC_INDEX0           0x1

/* Destination Index0 */
#define TX_DST_INDEX0           0x0

/* Source Index1 */
#define TX_SRC_INDEX1           0x1

/* Destination Index1 */
#define TX_DST_INDEX1           0x0

/* Source Index2 */
#define TX_SRC_INDEX2           0x0

/* Destination Index2 */
#define TX_DST_INDEX2           0x0

/* Source Index0 */
#define RX_SRC_INDEX0           0x0

/* Destination Index0 */
#define RX_DST_INDEX0           0x1

/* Source Index1 */
#define RX_SRC_INDEX1           0x0

/* Destination Index1 */
#define RX_DST_INDEX1           0x1

/* Source Index2 */
#define RX_SRC_INDEX2           0x0

/* Destination Index2 */
#define RX_DST_INDEX2           0x0

/* if there is no Source address, initialize with zero */
#define SRC_ADDR1               0x0

/* if there is no destination address, initialize with zero */
#define DST_ADDR1               0x0

/* Setting the TDM slots value in Frame Sync */
#define TDM_SLOTS_VALUE         0x00000800

/**
 * ============================================================================
 *   @func   mcasp_loopback_example
 *
 *   @desc
 *      This routine will setup the values for McASP Tx and Rx in LoopBack Mode. 
 *      And verify the data once the data is transfered.
 *
 * @arg 
 *      NONE
 *
 * @return
 *      CSL_Status
 * ============================================================================
*/
extern CSL_Status mcasp_loopback_example(
    void
);

/******************************************************************************
* @func setup_Interrupts
*
* @desc Setting up the DMAX Interrupts of INT7 & INT8.
*
* @arg  
*   NONE
*
* @return
*   CSL_Status
*
*****************************************************************************00
*/
extern CSL_Status setup_Interrupts (
        void
);

/******************************************************************************
* @func intr08
*
* @desc Interrupt Service Routine, this will get triggered if the
*       data transfer is Success. This function will clear the TCC bit 
*       of the DECT0/1 register.
*
* @arg  
*   NONE
*
* @return
*   NONE
*
*****************************************************************************00
*/
extern void intr08 ();

/******************************************************************************
* @func intr07
*
* @desc Interrupt Service Routine, this will get triggered if the
*       data transfer fails
*
* @arg  
*   NONE
*
* @return
*   NONE
*
*****************************************************************************00
*/
extern void intr07 ();

/******************************************************************************
*   @func   fillMem( Uint32 start_location, Uint32 length,
*                       Uint32 fill_value, Uint8 fill_type )
*
*   @desc   Fills a memory location with a pattern as requested.
*           Beginning at 'start_location', 'length' words (32-bit) are filled,
*           starting with 'fill_value'.  After the initial value, the
*           other memory locations are filled with either a constant
*           value, incrementing values, or decrementing values.
*
*   @arg    Uint32 start_location : Memory location to start filling.
*           Uint32 length : Number of bytes to fill.
*           Uint32 fill_value : 32-bit value to start filling with.
*           Uint8 fill_type : Type of fill:
*                           FILL_CONST, FILL_INC, FILL_DEC
*
*   @return Uint32 flag : PASS for a success
*           ERROR_TEST for a failure
*******************************************************************************
*/
extern Uint32 fillMem (
        Uint32 start_location,
        Uint32 length,
        Uint32 fill_value,
        Uint32 fill_type
);

/******************************************************************************
* @func mcasp_error_exit
*
* @desc Error in executing the example. As error is occered closing the McASP
*       handle and returning.
*
* @arg  
*   NONE
*
* @return
*   NONE
******************************************************************************/
extern void mcasp_error_exit (
        void
);

#ifdef __cplusplus
}
#endif

#endif /* _MCASP_EXAMPLE_H_ */
