###############################################################################
# package........ BinFile
# created........ 03-01-2001
# last updated .. 03-01-2001
# CopyRight...... Texas Instruments 2001, All Rights Reserved
#
# This module allows you to easily work with files in binary mode.
# Currently it only supports reads.
#
# class members include:
#   $bf   = new()                       create a new instance
#           seek(position)              sets the current file position
#   $x    = tell()                      return current file position
#   $bool = eof()                       check for end of file
#           endian({"big"|"little"})    use to manually set the file endian mode
#                                       default is "big"
#   $x    = read8()                     read 8-bit binary value
#   $x    = read16()                    read 16-bit binary value
#   $x    = read32()                    read 32-bit binary value
#
# Example:
#   use BinFile;
#   $file = BinFile->new("fileName");
#   while (!$file->eof()) {
#     $x = $file->read16();
#     printf("x = 0x%04X\n",$x);
#   }
#   printf("\n");
#
###############################################################################
# /*===========================================================================*/
# /* This software is provided under the following                             */
# /* License Agreement:                                                        */
# /*===========================================================================*/
# /* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR               */
# /* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,                    */
# /* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS              */
# /* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR                    */
# /* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.                */
# /* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET                */
# /* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY                       */
# /* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR                */
# /* YOUR USE OF THE PROGRAM.                                                  */
# /*                                                                           */
# /* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,               */
# /* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY                 */
# /* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED                */
# /* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT                */
# /* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.               */
# /* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF                 */
# /* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS               */
# /* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF                 */
# /* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S                    */
# /* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF                */
# /* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS                       */
# /* (U.S.$500).                                                               */
# /*                                                                           */
# /* Unless otherwise stated, the Program written and copyrighted              */
# /* by Texas Instruments is distributed as "freeware".  You may,              */
# /* only under TI's copyright in the Program, use and modify the              */
# /* Program without any charge or restriction.  You may                       */
# /* distribute to third parties, provided that you transfer a                 */
# /* copy of this license to the third party and the third party               */
# /* agrees to these terms by its first use of the Program. You                */
# /* must reproduce the copyright notice and any other legend of               */
# /* ownership on each copy or partial copy, of the Program.                   */
# /*                                                                           */
# /* You acknowledge and agree that the Program contains                       */
# /* copyrighted material, trade secrets and other TI proprietary              */
# /* information and is protected by copyright laws,                           */
# /* international copyright treaties, and trade secret laws, as               */
# /* well as other intellectual property laws.  To protect TI's                */
# /* rights in the Program, you agree not to decompile, reverse                */
# /* engineer, disassemble or otherwise translate any object code              */
# /* versions of the Program to a human-readable form.  You agree              */
# /* that in no event will you alter, remove or destroy any                    */
# /* copyright notice included in the Program.  TI reserves all                */
# /* rights not specifically granted under this license. Except                */
# /* as specifically provided herein, nothing in this agreement                */
# /* shall be construed as conferring by implication, estoppel,                */
# /* or otherwise, upon you, any license or other right under any              */
# /* TI patents, copyrights or trade secrets.                                  */
# /*                                                                           */
# /* You may not use the Program in non-TI devices.                            */
# /*===========================================================================*/
package BinFile;
require 5.000;
use FileHandle;
use Symbol;
use File::Basename;

#******************************************************************************
sub new {
  my ($class) = shift(@_);
  my ($name)  = shift(@_);
  my ($this)  = {};
  bless($this,$class);

  $this->{"fh"} = gensym;
  $this->{"endianMode"} = "little";
  $this->{"name"} = $name;

  open($this->{"fh"}, "<$name") || die "Can't open $name!";
  binmode($this->{"fh"});

  return $this;
}

#******************************************************************************
sub DESTROY {
  my ($this) = shift(@_);
  close($this->{"fh"});
}

#******************************************************************************
sub eof {
  my ($this) = shift(@_);
  return eof($this->{"fh"});
}

#******************************************************************************
sub seek {
  my ($this) = shift(@_);
  my ($position) = shift(@_);
  seek($this->{"fh"}, $position, 0);
}

#******************************************************************************
sub tell {
  my ($this) = shift(@_);
  return tell($this->{"fh"});
}

#******************************************************************************
sub endian {
  my ($this) = shift(@_);
  my ($endian) = shift(@_);
  $this->{"endianMode"} = $endian;
}

#******************************************************************************
sub read8 {
  my ($this) = shift(@_);
  my ($fh) = $this->{"fh"};
  my ($val);
  read($fh, $val, 1);
  $val = ord($val);
  return $val;
}

#******************************************************************************
sub read16 {
  my ($this) = shift(@_);
  my ($fh) = $this->{"fh"};
  my ($endianMode) = $this->{"endianMode"};
  my ($val0,$val1,$val);
  read($fh, $val0, 1);
  read($fh, $val1, 1);
  $val0 = ord($val0);
  $val1 = ord($val1);

  if ($endianMode eq "big") {
    $val = ($val1 << 8) | $val0;
  }

  if ($endianMode eq "little") {
    $val = ($val0 << 8) | $val1;
  }

  return $val;
}

#******************************************************************************
sub read32 {
  my ($this) = shift(@_);
  my ($fh) = $this->{"fh"};
  my ($endianMode) = $this->{"endianMode"};
  my ($val0,$val1,$val2,$val3,$val);

  read($fh, $val0, 1);
  read($fh, $val1, 1);
  read($fh, $val2, 1);
  read($fh, $val3, 1);
  $val0 = ord($val0);
  $val1 = ord($val1);
  $val2 = ord($val2);
  $val3 = ord($val3);

  if ($endianMode eq "big") {
    $val = ($val3 << 24) | ($val2 << 16) | ($val1 << 8) | $val0;
  }

  if ($endianMode eq "little") {
    $val = ($val0 << 24) | ($val1 << 16) | ($val2 << 8) | $val3;
  }

  return $val;
}

#******************************************************************************

# what a hack, return 1 just so the package returns a "true value"
return 1;

###############################################################################
# End of BinFile.pm
###############################################################################

