#!/usr/local/bin/perl5.8.0
###############################################################################################
# Copyright 2004, All Rights Reserved, Texas Instruments Incorporate#
# BuildPinCfgList.pm
#
# This script is a Perl module for use with genBootCfg.pl boot mode configuration tool
# for TMS320C672x boot load.
#
# 1-Mar-2005 v000.00.01
# - Created
# 14-June-2007
# - Fixed error in assigning SET/CLEAR register values
#
###############################################################################################
# /*===========================================================================*/
# /* This software is provided under the following                             */
# /* License Agreement:                                                        */
# /*===========================================================================*/
# /* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR               */
# /* REPRESENTATIONS, EITHER EXPRESS, IMPLIED OR STATUTORY,                    */
# /* INCLUDING ANY IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS              */
# /* FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY OR                    */
# /* COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE.                */
# /* TI DISCLAIMS ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET                */
# /* POSSESSION, AND NON-INFRINGEMENT OF ANY THIRD PARTY                       */
# /* INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR                */
# /* YOUR USE OF THE PROGRAM.                                                  */
# /*                                                                           */
# /* IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL,               */
# /* CONSEQUENTIAL OR INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY                 */
# /* THEORY OF LIABILITY AND WHETHER OR NOT TI HAS BEEN ADVISED                */
# /* OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY OUT                */
# /* OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.               */
# /* EXCLUDED DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF                 */
# /* REMOVAL OR REINSTALLATION, COMPUTER TIME, LABOR COSTS, LOSS               */
# /* OF GOODWILL, LOSS OF PROFITS, LOSS OF SAVINGS, OR LOSS OF                 */
# /* USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S                    */
# /* AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF                */
# /* YOUR USE OF THE PROGRAM EXCEED FIVE HUNDRED DOLLARS                       */
# /* (U.S.$500).                                                               */
# /*                                                                           */
# /* Unless otherwise stated, the Program written and copyrighted              */
# /* by Texas Instruments is distributed as "freeware".  You may,              */
# /* only under TI's copyright in the Program, use and modify the              */
# /* Program without any charge or restriction.  You may                       */
# /* distribute to third parties, provided that you transfer a                 */
# /* copy of this license to the third party and the third party               */
# /* agrees to these terms by its first use of the Program. You                */
# /* must reproduce the copyright notice and any other legend of               */
# /* ownership on each copy or partial copy, of the Program.                   */
# /*                                                                           */
# /* You acknowledge and agree that the Program contains                       */
# /* copyrighted material, trade secrets and other TI proprietary              */
# /* information and is protected by copyright laws,                           */
# /* international copyright treaties, and trade secret laws, as               */
# /* well as other intellectual property laws.  To protect TI's                */
# /* rights in the Program, you agree not to decompile, reverse                */
# /* engineer, disassemble or otherwise translate any object code              */
# /* versions of the Program to a human-readable form.  You agree              */
# /* that in no event will you alter, remove or destroy any                    */
# /* copyright notice included in the Program.  TI reserves all                */
# /* rights not specifically granted under this license. Except                */
# /* as specifically provided herein, nothing in this agreement                */
# /* shall be construed as conferring by implication, estoppel,                */
# /* or otherwise, upon you, any license or other right under any              */
# /* TI patents, copyrights or trade secrets.                                  */
# /*                                                                           */
# /* You may not use the Program in non-TI devices.                            */
# /*===========================================================================*/


#use strict qw(subs refs);
#use warnings qw(all);


package BuildPinCfgList;
use FindBin;
use lib "$FindBin::Bin/../lib";
use PinCfg;
use Symbol;


###############################################################################
#  $pinCofiguration = new("periph", 
#                          "pinName", 
#                          pinEnableRgister,
#                          pinEnableMask,
#                          enableMaskMode,
#                          pinDirectionRegister,
#                          pinDirectionMask,
#                          directionMaskMode,
#                          pinSetRegister,
#                          pinSetMask,
#                          pinClearRegister,
#                          pinClearMask,
#                          pinDisableRegister,
#                          pinDisableMask
#                         )
###############################################################################
my %maskMode = (
                   "OR" => 1,
                   "AND" => 2,
                   "XOR" => 3,
                   "WRITE" => 4,
);



sub new {
	my($class) = shift(@_);
	
	my($this) = {};
	
	bless($this,$class);
	
	my($i) = 0;
	my($pinCount) = 0;
	my($pinName) = '';
	$this->{"version"} = 'V000.00.00';
	

    my($gpFunc) = 0x44000010;      # Pin GPIO Enable Register
    my($gpDir)  = 0x44000014;      # Pin Direction Register
    my($gpSet)  = 0x4400001C;      # Pin Set Register
    my($gpClr)  = 0x44000020;      # Pin Clear Register
	
	                       
	for($i=0;$i<=15; ++$i, ++$pinCount) {
		$pinName = sprintf("AXR0[%d]",$i);
		
        $this->{"pins"}{$pinName} = PinCfg->new( $pinName,
                       $gpFunc,   (1 << $i), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << $i), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << $i), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << $i), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1<< $i)), $maskMode{"AND"} ,#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          ); 
    }

    $this->{"pins"}{"AMUTE0"} = PinCfg->new( "AMUTE0",
                       $gpFunc,   (1 << 25), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 25), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 25), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 25), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 25)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          );   

    ++$pinCount;
    
                                    
     $this->{"pins"}{"ACLKX0"} = PinCfg->new( "ACLKX0",
                       $gpFunc,   (1 << 26), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 26), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 26), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 26), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 26)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          );   

    ++$pinCount;
   
     $this->{"pins"}{"AHCLKX0"} = PinCfg->new( "AHCLKX0",
                       $gpFunc,   (1 << 27), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 27), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 27), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 27), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 27)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          );   

    ++$pinCount;  

     $this->{"pins"}{"AFSX0"} = PinCfg->new( "AFSX0",
                       $gpFunc,   (1 << 28), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 28), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 28), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 28), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 28)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          );   

    ++$pinCount;  

     $this->{"pins"}{"ACLKR0"} = PinCfg->new( "ACLKR0",
                       $gpFunc,   (1 << 29), $maskMode{"OR"}      ,#PinEnable
                       $gpDir,    (1 << 29), $maskMode{"OR"}      ,#Pin Direction
                       $gpSet,    (1 << 29), $maskMode{"WRITE"}   ,#Pin Set
                       $gpClr,    (1 << 29), $maskMode{"WRITE"}   ,#Pin Clear
                       $gpFunc,   (~(1 << 29)), $maskMode{"AND"}  ,#Pin Disable
                       0,                                         ,#Global Setup Flag (none)
          );   

    ++$pinCount;  

    $this->{"pins"}{"AHCLKR0"} = PinCfg->new( "AHCLKR0",
                     $gpFunc,   (1 << 30), $maskMode{"OR"}     ,#PinEnable
                     $gpDir,    (1 << 30), $maskMode{"OR"}     ,#Pin Direction
                     $gpSet,    (1 << 30), $maskMode{"WRITE"}  ,#Pin Set
                     $gpClr,    (1 << 30), $maskMode{"WRITE"}  ,#Pin Clear
                     $gpFunc,   (~(1 << 30)), $maskMode{"AND"} ,#Pin Disable
                     0,                                        ,#Global Setup Flag (none)
          );   

    ++$pinCount;  
                
    $this->{"pins"}{"AFSR0"} = PinCfg->new( "AFSR0",
                     $gpFunc,   (1 << 31), $maskMode{"OR"}     ,#PinEnable
                     $gpDir,    (1 << 31), $maskMode{"OR"}     ,#Pin Direction
                     $gpSet,    (1 << 31), $maskMode{"WRITE"}  ,#Pin Set
                     $gpClr,    (1 << 31), $maskMode{"WRITE"}  ,#Pin Clear
                     $gpFunc,   (~(1 << 31)), $maskMode{"AND"} ,#Pin Disable
                     0,                                        ,#Global Setup Flag (none)
          );   

    ++$pinCount;  

    $gpFunc = 0x45000010;      # Pin GPIO Enable Register
    $gpDir  = 0x45000014;      # Pin Direction Register
    $gpSet  = 0x4500001C;      # Pin Set Register
    $gpClr  = 0x45000020;      # Pin Clear Register
    
	for($i=0;$i<=5; ++$i) {
		$pinName = sprintf("AXR1[%d]",$i);
		
        $this->{"pins"}{$pinName} = PinCfg->new( $pinName,
                       $gpFunc,   (1 << $i), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << $i), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << $i), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << $i), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1<< $i)), $maskMode{"AND"} ,#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          ); 
    }

    $this->{"pins"}{"AMUTE1"} = PinCfg->new( "AMUTE1",
                       $gpFunc,   (1 << 25), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 25), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 25), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 25), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 25)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          );   

     $this->{"pins"}{"ACLKX1"} = PinCfg->new(  "ACLKX1",
                       $gpFunc,   (1 << 26), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 26), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 26), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 26), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 26)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)                       
          );   
   
     $this->{"pins"}{"AHCLKX1"} = PinCfg->new(  "AHCLKX1",
                       $gpFunc,   (1 << 27), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 27), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 27), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 27), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 27)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          );   

     $this->{"pins"}{"AFSX1"} = PinCfg->new( "AFSX1",
                       $gpFunc,   (1 << 28), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 28), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 28), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 28), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 28)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          );   

     $this->{"pins"}{"ACLKR1"} = PinCfg->new( "ACLKR1",
                     $gpFunc,   (1 << 29), $maskMode{"OR"}      ,#PinEnable
                     $gpDir,    (1 << 29), $maskMode{"OR"}      ,#Pin Direction
                     $gpSet,    (1 << 29), $maskMode{"WRITE"}   ,#Pin Set
                     $gpClr,    (1 << 29), $maskMode{"WRITE"}   ,#Pin Clear
                     $gpFunc,   (~(1 << 29)), $maskMode{"AND"}  ,#Pin Disable
                     0,                                         ,#Global Setup Flag (none)
          );   

    $this->{"pins"}{"AHCLKR1"} = PinCfg->new( "AHCLKR1",
                     $gpFunc,   (1 << 30), $maskMode{"OR"}     ,#PinEnable
                     $gpDir,    (1 << 30), $maskMode{"OR"}     ,#Pin Direction
                     $gpSet,    (1 << 30), $maskMode{"WRITE"}  ,#Pin Set
                     $gpClr,    (1 << 30), $maskMode{"WRITE"}  ,#Pin Clear
                     $gpFunc,   (~(1 << 30)), $maskMode{"AND"} ,#Pin Disable
                     0,                                         ,#Global Setup Flag (none)
          );   
                
    $this->{"pins"}{"AFSR1"} = PinCfg->new( "AFSR1", 
                     $gpFunc,   (1 << 31), $maskMode{"OR"}     ,#PinEnable
                     $gpDir,    (1 << 31), $maskMode{"OR"}     ,#Pin Direction
                     $gpSet,    (1 << 31), $maskMode{"WRITE"}  ,#Pin Set
                     $gpClr,    (1 << 31), $maskMode{"WRITE"}  ,#Pin Clear
                     $gpFunc,   (~(1 << 31)), $maskMode{"AND"} ,#Pin Disable
                     0,                                        ,#Global Setup Flag (none)
          );  
          
          
          
    $gpFunc = 0x46000010;      # Pin GPIO Enable Register
    $gpDir  = 0x46000014;      # Pin Direction Register
    $gpSet  = 0x4600001C;      # Pin Set Register
    $gpClr  = 0x46000020;      # Pin Clear Register           
          
    
 	for($i=0;$i<=1; ++$i) {
		$pinName = sprintf("AXR2[%d]",$i);
		
        $this->{"pins"}{$pinName} = PinCfg->new( $pinName,
                       $gpFunc,   (1 << $i), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << $i), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << $i), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << $i), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1<< $i)), $maskMode{"AND"} ,#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          ); 
    }

    $this->{"pins"}{"AMUTE2"} = PinCfg->new( "AMUTE2",
                       $gpFunc,   (1 << 25), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 25), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 25), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 25), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 25)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          );   
    
                                    
     $this->{"pins"}{"ACLKX2"} = PinCfg->new(  "ACLKX2",
                       $gpFunc,   (1 << 26), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 26), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 26), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 26), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 26)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          );   
   
     $this->{"pins"}{"AHCLKX2"} = PinCfg->new(  "AHCLKX2",
                       $gpFunc,   (1 << 27), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 27), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 27), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 27), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 27)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          );   

     $this->{"pins"}{"AFSX2"} = PinCfg->new( "AFSX2",
                       $gpFunc,   (1 << 28), $maskMode{"OR"}    ,#PinEnable
                       $gpDir,    (1 << 28), $maskMode{"OR"}    ,#Pin Direction
                       $gpSet,    (1 << 28), $maskMode{"WRITE"} ,#Pin Set
                       $gpClr,    (1 << 28), $maskMode{"WRITE"} ,#Pin Clear
                       $gpFunc,   (~(1 << 28)), $maskMode{"AND"},#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          );   

     $this->{"pins"}{"ACLKR2"} = PinCfg->new( "ACLKR2",
                     $gpFunc,   (1 << 29), $maskMode{"OR"}      ,#PinEnable
                     $gpDir,    (1 << 29), $maskMode{"OR"}      ,#Pin Direction
                     $gpSet,    (1 << 29), $maskMode{"WRITE"}   ,#Pin Set
                     $gpClr,    (1 << 29), $maskMode{"WRITE"}   ,#Pin Clear
                     $gpFunc,   (~(1 << 29)), $maskMode{"AND"}  ,#Pin Disable
                     0,                                         ,#Global Setup Flag (none)
          );   

    $this->{"pins"}{"AHCLKR2"} = PinCfg->new( "AHCLKR2",
                     $gpFunc,   (1 << 30), $maskMode{"OR"}     ,#PinEnable
                     $gpDir,    (1 << 30), $maskMode{"OR"}     ,#Pin Direction
                     $gpSet,    (1 << 30), $maskMode{"WRITE"}  ,#Pin Set
                     $gpClr,    (1 << 30), $maskMode{"WRITE"}  ,#Pin Clear
                     $gpFunc,   (~(1 << 30)), $maskMode{"AND"} ,#Pin Disable
                     0,                                        ,#Global Setup Flag (none)
          );   
                
    $this->{"pins"}{"AFSR2"} = PinCfg->new(  "AFSR2",
                     $gpFunc,   (1 << 31), $maskMode{"OR"}     ,#PinEnable
                     $gpDir,    (1 << 31), $maskMode{"OR"}     ,#Pin Direction
                     $gpSet,    (1 << 31), $maskMode{"WRITE"}  ,#Pin Set
                     $gpClr,    (1 << 31), $maskMode{"WRITE"}  ,#Pin Clear
                     $gpFunc,   (~(1 << 31)), $maskMode{"AND"} ,#Pin Disable
                     0,                                        ,#Global Setup Flag (none)
          );   
   
  ##################################################################  
  # I2C0 GPIO PIN Configuration
  ##################################################################        
    my($icpfunc) = 0x49000048;      # Pin GPIO Enable Register
    my($icpdir)  = 0x4900004C;      # Pin Direction Register
    my($icpdset) = 0x49000058;      # Pin Set Register
    my($icpdclr) = 0x4900005C;      # Pin Clear Register   

    $this->{"pins"}{"I2C0_SCL"} = PinCfg->new( "I2C0_SCL",
                     $icpfunc,    0x00000001,     $maskMode{"OR"}    ,#PinEnable
                     $icpdir,     0x00000001,     $maskMode{"OR"}    ,#Pin Direction
                     $icpdset,    0x00000001,     $maskMode{"WRITE"} ,#Pin Set
                     $icpdclr,    0x00000001,     $maskMode{"WRITE"} ,#Pin Clear
                     $icpfunc,   (~(0x00000001)), $maskMode{"AND"}   ,#Pin Disable
                     0,                                              ,#Global Setup Flag (none)
          );   
    
    $this->{"pins"}{"I2C0_SDA"} = PinCfg->new( "I2C0_SDA",
                     $icpfunc,    0x00000001,     $maskMode{"OR"}    ,#PinEnable
                     $icpdir,     0x00000002,     $maskMode{"OR"}    ,#Pin Direction
                     $icpdset,    0x00000002,     $maskMode{"WRITE"} ,#Pin Set
                     $icpdclr,    0x00000002,     $maskMode{"WRITE"} ,#Pin Clear
                     $icpfunc,   (~(0x00000001)), $maskMode{"AND"}   ,#Pin Disable
                     0,                                              ,#Global Setup Flag (none)
          );   
    
          
  ##################################################################  
  # I2C1 GPIO PIN Configuration
  ##################################################################    
  
  $icpfunc = 0x4A000048;      # Pin GPIO Enable Register  
  $icpdir  = 0x4A00004C;      # Pin Direction Register
  $icpdset = 0x4A000058;      # Pin Set Register
  $icpdclr = 0x4A00005C;      # Pin Clear Register        
          
  $this->{"pins"}{"I2C1_SCL"} = PinCfg->new( "I2C1_SCL",
                     $icpfunc,    0x00000001,     $maskMode{"OR"}    ,#PinEnable
                     $icpdir,     0x00000001,     $maskMode{"OR"}    ,#Pin Direction
                     $icpdset,    0x00000001,     $maskMode{"WRITE"} ,#Pin Set
                     $icpdclr,    0x00000001,     $maskMode{"WRITE"} ,#Pin Clear
                     $icpfunc,   (~(0x00000001)), $maskMode{"AND"}   ,#Pin Disable
                     0,                                              ,#Global Setup Flag (none)
          );   
    
  $this->{"pins"}{"I2C1_SDA"} = PinCfg->new( "I2C1_SDA",
                     $icpfunc,    0x00000001,     $maskMode{"OR"}    ,#PinEnable
                     $icpdir,     0x00000002,     $maskMode{"OR"}    ,#Pin Direction
                     $icpdset,    0x00000002,     $maskMode{"WRITE"} ,#Pin Set
                     $icpdclr,    0x00000002,     $maskMode{"WRITE"} ,#Pin Clear
                     $icpfunc,   (~(0x00000001)), $maskMode{"AND"}   ,#Pin Disable
                     0,                                              ,#Global Setup Flag (none)
          );   
               
          
  ##################################################################  
  # SPI0 GPIO PIN Configuration
  ##################################################################             
          
  my($spipc0) = 0x47000014;      # Pin GPIO Enable Register
  my($spipc1) = 0x47000018;      # Pin Direction Register
  my($spipc4) = 0x47000024;      # Pin Set Register
  my($spipc5) = 0x47000028;      # Pin Clear Register 

    $this->{"pins"}{"SPI0_SOMI"} = PinCfg->new( "SPI0_SOMI",
                     $spipc0,    (~(1 << 11)), $maskMode{"AND"}         ,#PinEnable
                     $spipc1,    (1 << 11),    $maskMode{"OR"}          ,#Pin Direction
                     $spipc4,    (1 << 11),    $maskMode{"WRITE"}       ,#Pin Set
                     $spipc5,    (1 << 11),    $maskMode{"WRITE"}       ,#Pin Clear
                     $spipc0,    (1 << 11),    $maskMode{"OR"}          ,#Pin Disable
                     2,                                                 ,#Global Setup Flag
                     0x47000000, (1 << 0),    $maskMode{"OR"}           ,#Take SPI Out of Reset
                     0x47000004, ((1 << 24) | (1 << 1)), $maskMode{"OR"},#Enable SPI and Set CLK as Internal
          );   

                                    
     $this->{"pins"}{"SPI0_SIMO"} = PinCfg->new(  "SPI0_SIMO",
                     $spipc0,   (~(1 << 10)),   $maskMode{"AND"}          ,#PinEnable
                     $spipc1,    (1 << 10),   $maskMode{"OR"}           ,#Pin Direction
                     $spipc4,    (1 << 10),   $maskMode{"WRITE"}        ,#Pin Set
                     $spipc5,    (1 << 10),   $maskMode{"WRITE"}        ,#Pin Clear
                     $spipc0,    (1 << 10),   $maskMode{"OR"}           ,#Pin Disable
                     2,                                                 ,#Global Setup Flag
                     0x47000000, (1 << 0), $maskMode{"OR"}              ,#Take SPI Out of Reset
                     0x47000004, ((1 << 24) | (1 << 1)), $maskMode{"OR"},#Enable SPI and Set CLK as Internal                     
          );   
   
     $this->{"pins"}{"SPI0_CLK"} = PinCfg->new(  "SPI0_CLK",
                     $spipc0,    (~(1 << 9)),    $maskMode{"AND"}       ,#PinEnable
                     $spipc1,    (1 << 9),    $maskMode{"OR"}           ,#Pin Direction
                     $spipc4,    (1 << 9),    $maskMode{"WRITE"}        ,#Pin Set
                     $spipc5,    (1 << 9),    $maskMode{"WRITE"}        ,#Pin Clear
                     $spipc0,    (1 << 9),    $maskMode{"OR"}           ,#Pin Disable
                     2,                                                 ,#Global Setup Flag
                     0x47000000, (1 << 0), $maskMode{"OR"}              ,#Take SPI Out of Reset
                     0x47000004, ((1 << 24) | (1 << 1)), $maskMode{"OR"},#Enable SPI and Set CLK as Internal                     
          );   

     $this->{"pins"}{ "SPI0_ENA"} = PinCfg->new( "SPI0_ENA",
                     $spipc0,    (~(1 << 8)), $maskMode{"AND"}          ,#PinEnable
                     $spipc1,    (1 << 8),    $maskMode{"OR"}           ,#Pin Direction
                     $spipc4,    (1 << 8),    $maskMode{"WRITE"}        ,#Pin Set
                     $spipc5,    (1 << 8),    $maskMode{"WRITE"}        ,#Pin Clear
                     $spipc0,    (1 << 8),    $maskMode{"OR"}           ,#Pin Disable
                     2,                                                 ,#Global Setup Flag
                     0x47000000, (1 << 0),    $maskMode{"OR"}           ,#Take SPI Out of Reset
                     0x47000004, ((1 << 24) | (1 << 1)), $maskMode{"OR"},#Enable SPI and Set CLK as Internal                     
          );   

     $this->{"pins"}{"SPI0_SCS"} = PinCfg->new( "SPIO_SCS",
                   $spipc0,    (~(1 << 0)),   $maskMode{"AND"}          ,#PinEnable
                   $spipc1,    (1 << 0),      $maskMode{"OR"}           ,#Pin Direction
                   $spipc4,    (1 << 0),      $maskMode{"WRITE"}        ,#Pin Set
                   $spipc5,    (1 << 0),      $maskMode{"WRITE"}        ,#Pin Clear
                   $spipc0,    (1 << 0),      $maskMode{"OR"}           ,#Pin Disable
                   2,                                                   ,#Global Setup Flag
                   0x47000000, (1 << 0),      $maskMode{"OR"}           ,#Take SPI Out of Reset
                   0x47000004, ((1 << 24) | (1 << 1)), $maskMode{"OR"}  ,#Enable SPI and Set CLK as Internal                   
        );     
 
  ##################################################################  
  # SPI1 GPIO PIN Configuration
  ##################################################################
  
  $spipc0 = 0x48000014;      # Pin GPIO Enable Register
  $spipc1 = 0x48000018;      # Pin Direction Register
  $spipc4 = 0x48000024;      # Pin Set Register
  $spipc5 = 0x48000028;      # Pin Clear Register
   
     $this->{"pins"}{"SPI1_SOMI"} = PinCfg->new( "SPI1_SOMI",
                     $spipc0,    (~(1 << 11)),   $maskMode{"AND"}       ,#PinEnable
                     $spipc1,    (1 << 11),      $maskMode{"OR"}        ,#Pin Direction
                     $spipc4,    (1 << 11),      $maskMode{"WRITE"}     ,#Pin Set
                     $spipc5,    (1 << 11),      $maskMode{"WRITE"}     ,#Pin Clear
                     $spipc0,    (1 << 11),      $maskMode{"OR"}        ,#Pin Disable
                     2,                                                 ,#Global Setup Flag
                     0x48000000, (1 << 0),    $maskMode{"OR"}           ,#Take SPI Out of Reset
                     0x48000004, ((1 << 24) | (1 << 1)), $maskMode{"OR"},#Enable SPI and Set CLK as Internal                     
          );   
    
                                    
     $this->{"pins"}{"SPI1_SIMO"} = PinCfg->new(  "SPI1_SIMO",
                     $spipc0,    (~(1 << 10)),    $maskMode{"AND"}      ,#PinEnable
                     $spipc1,    (1 << 10),       $maskMode{"OR"}       ,#Pin Direction
                     $spipc4,    (1 << 10),       $maskMode{"WRITE"}    ,#Pin Set
                     $spipc5,    (1 << 10),       $maskMode{"WRITE"}    ,#Pin Clear
                     $spipc0,    (1 << 10),       $maskMode{"OR"}       ,#Pin Disable
                     2,                                                 ,#Global Setup Flag
                     0x48000000, (1 << 0),        $maskMode{"OR"}       ,#Take SPI Out of Reset
                     0x48000004, ((1 << 24) | (1 << 1)), $maskMode{"OR"},#Enable SPI and Set CLK as Internal                     
          );   

     $this->{"pins"}{"SPI1_CLK"} = PinCfg->new(  "SPI1_CLK",
                     $spipc0,    (~(1 << 9)),     $maskMode{"AND"}      ,#PinEnable
                     $spipc1,    (1 << 9),        $maskMode{"OR"}       ,#Pin Direction
                     $spipc4,    (1 << 9),        $maskMode{"WRITE"}    ,#Pin Set
                     $spipc5,    (1 << 9),        $maskMode{"WRITE"}    ,#Pin Clear
                     $spipc0,    (1 << 9),        $maskMode{"OR"}       ,#Pin Disable
                     2,                                                 ,#Global Setup Flag
                     0x48000000, (1 << 0),   $maskMode{"OR"}            ,#Take SPI Out of Reset
                     0x48000004, ((1 << 24) | (1 << 1)), $maskMode{"OR"},#Enable SPI and Set CLK as Internal                     
          );   


     $this->{"pins"}{ "SPI1_ENA"} = PinCfg->new( "SPI1_ENA",
                     $spipc0,    (~(1 << 8)),    $maskMode{"AND"}       ,#PinEnable
                     $spipc1,    (1 << 8),       $maskMode{"OR"}        ,#Pin Direction
                     $spipc4,    (1 << 8),       $maskMode{"WRITE"}     ,#Pin Set
                     $spipc5,    (1 << 8),       $maskMode{"WRITE"}     ,#Pin Clear
                     $spipc0,    (1 << 8),       $maskMode{"OR"}        ,#Pin Disable
                     2,                                                 ,#Global Setup Flag
                     0x48000000, (1 << 0),   $maskMode{"OR"}            ,#Take SPI Out of Reset
                     0x48000004, ((1 << 24) | (1 << 1)), $maskMode{"OR"},#Enable SPI and Set CLK as Internal                     
          );   


     $this->{"pins"}{"SPI1_SCS"} = PinCfg->new( "SPI1_SCS",
                   $spipc0,    (~(1 << 0)),     $maskMode{"AND"}        ,#PinEnable
                   $spipc1,    (1 << 0),        $maskMode{"OR"}         ,#Pin Direction
                   $spipc4,    (1 << 0),        $maskMode{"WRITE"}      ,#Pin Set
                   $spipc5,    (1 << 0),        $maskMode{"WRITE"}      ,#Pin Clear
                   $spipc0,    (1 << 0),        $maskMode{"OR"}         ,#Pin Disable
                   2,                                                   ,#Global Setup Flag
                   0x48000000, (1 << 0),   $maskMode{"OR"}              ,#Take SPI Out of Reset
                   0x48000004, ((1 << 24) | (1 << 1)), $maskMode{"OR"}  ,#Enable SPI and Set CLK as Internal                   
     );   
    
                                                         
  ##################################################################  
  # HPI GPIO PIN Configuration
  ##################################################################            
 
  my($gpioEn)   = 0x4300000c;
  my($gpioDir1) = 0x43000010;
  my($gpioDat1) = 0x43000014;
  my($gpioDir2) = 0x43000018;
  my($gpioDat2) = 0x4300001C;
  my($gpioDir3) = 0x43000020;
  my($gpioDat3) = 0x43000024;
  
  $this->{"pins"}{"/HCS"} = PinCfg->new( "/HCS",
                       $gpioEn,   0x00000001, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00000002, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00000002, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFFFFD, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFFE, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          );
          
  $this->{"pins"}{"/HDS1"} = PinCfg->new( "/HDS1",
                       $gpioEn,    0x00000001, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2,  0x00000004, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2,  0x00000004, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2,  0xFFFFFFFB, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,    0xFFFFFFFE, $maskMode{"AND"} ,#Pin Disable
                       0,                                       ,#Global Setup Flag (none)
          ); 
           
  $this->{"pins"}{"/HDS2"} = PinCfg->new( "/HDS2",
                       $gpioEn,   0x00000001, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00000008, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00000008, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFFFF7, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFFE, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          );
          
  $this->{"pins"}{"HR/W"} = PinCfg->new( "HR/W",
                       $gpioEn,   0x00000001, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00000010, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00000010, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFFFEF, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFFE, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          );  
                                       
  $this->{"pins"}{"HCNTL1"} = PinCfg->new( "HCNTL1",
                       $gpioEn,   0x00000002, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00000040, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00000040, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFFFBF, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFFD, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          ); 
           
  $this->{"pins"}{"HCNTL0"} = PinCfg->new( "HCNTL0",
                       $gpioEn,   0x00000002, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00000040, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00000040, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFFFBF, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFFD, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          ); 
          
  $this->{"pins"}{"/HAS"} = PinCfg->new(  "/HAS",
                       $gpioEn,   0x00000004, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00000001, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00000001, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFFFFE, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFFB, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          ); 
           
  $this->{"pins"}{"HBE0"} = PinCfg->new(  "HBE0",
                       $gpioEn,   0x00000008, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00000800, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00000800, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFF7FF, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFF7, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          ); 
           
  $this->{"pins"}{"HBE1"} = PinCfg->new(  "HBE1",
                       $gpioEn,   0x00000008, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00001000, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00001000, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFEFFF, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFF7, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          ); 
           
  $this->{"pins"}{"HBE2"} = PinCfg->new(  "HBE2",
                       $gpioEn,   0x00000008, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00002000, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00002000, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFDFFF, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFF7, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          ); 
             
  $this->{"pins"}{"HBE3"} = PinCfg->new(  "HBE3",
                       $gpioEn,   0x00000008, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00004000, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00004000, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFBFFF, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFF7, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          );  
              
  $this->{"pins"}{"HHWIL"} = PinCfg->new(  "HHWIL",
                       $gpioEn,   0x00000010, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00000020, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00000020, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFFFDF, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFEF, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          );  
          
  $this->{"pins"}{"HRDY"} = PinCfg->new(  "HRDY",
                       $gpioEn,   0x00000020, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00000200, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00000200, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFFDFF, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFDF, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          );  
          
  $this->{"pins"}{"/HRDY"} = PinCfg->new( "/HRDY",
                       $gpioEn, 0x00000020, $maskMode{"OR"}   ,#PinEnable
                       $gpioDir2, 0x00000400, $maskMode{"OR"} ,#Pin Direction
                       $gpioDat2, 0x00000400, $maskMode{"OR"} ,#Pin Set
                       $gpioDat2, 0xFFFFFBFF, $maskMode{"AND"},#Pin Clear
                       $gpioEn, 0xFFFFFFDF, $maskMode{"AND"}  ,#Pin Disable
                       0,                                     ,#Global Setup Flag (none)
          );
          
  $this->{"pins"}{"/HINT"} = PinCfg->new( "/HINT",
                       $gpioEn,   0x00000040, $maskMode{"OR"}  ,#PinEnable
                       $gpioDir2, 0x00000100, $maskMode{"OR"}  ,#Pin Direction
                       $gpioDat2, 0x00000100, $maskMode{"OR"}  ,#Pin Set
                       $gpioDat2, 0xFFFFFEFF, $maskMode{"AND"} ,#Pin Clear
                       $gpioEn,   0xFFFFFFBF, $maskMode{"AND"} ,#Pin Disable
                       0,                                      ,#Global Setup Flag (none)
          );

              
    ########################################################################################
    # Configure HDy PINS                                                                   #                                                              
    ########################################################################################
    for($i=0;$i<=7; ++$i) {
	    $pinName = sprintf("HD[%d]",$i);    
	    $this->{"pins"}{$pinName} = PinCfg->new( $pinName,
                       $gpioEn,    0x00000080,  $maskMode{"OR"}    ,#PinEnable
                       $gpioDir1,  (1 << $i),   $maskMode{"OR"}    ,#Pin Direction
                       $gpioDat1,  (1 << $i),   $maskMode{"OR"}    ,#Pin Set
                       $gpioDat1,  ~(1 << $i),  $maskMode{"AND"}   ,#Pin Clear
                       $gpioEn,    0xFFFFFF7F,  $maskMode{"AND"}   ,#Pin Disable
                       0,                                          ,#Global Setup Flag (none)
              ); 
    } 
     
    for($i=8;$i<=15; ++$i) {
	    $pinName = sprintf("HD[%d]",$i);    
	    $this->{"pins"}{$pinName} = PinCfg->new( $pinName,
                       $gpioEn,    0x00000100,  $maskMode{"OR"}    ,#PinEnable
                       $gpioDir1,  (1 << $i),   $maskMode{"OR"}    ,#Pin Direction
                       $gpioDat1,  (1 << $i),   $maskMode{"OR"}    ,#Pin Set
                       $gpioDat1,  ~(1 << $i),  $maskMode{"AND"}   ,#Pin Clear
                       $gpioEn,    0xFFFFFEFF,  $maskMode{"AND"}   ,#Pin Disable
                       0,                                          ,#Global Setup Flag (none)
              ); 
    }
      
    for($i=16;$i<=23; ++$i) {
	    $pinName = sprintf("HD[%d]",$i);    
	    $this->{"pins"}{$pinName} = PinCfg->new( $pinName,
                       $gpioEn,    0x00000200,  $maskMode{"OR"}   ,#PinEnable
                       $gpioDir1,  (1 << $i),   $maskMode{"OR"}   ,#Pin Direction
                       $gpioDat1,  (1 << $i),   $maskMode{"OR"}   ,#Pin Set
                       $gpioDat1,  ~(1 << $i),  $maskMode{"AND"}  ,#Pin Clear
                       $gpioEn,    0xFFFFFDFF,  $maskMode{"AND"}  ,#Pin Disable
                       0,                                         ,#Global Setup Flag (none)
              ); 
    } 
       
    for($i=24;$i<=31; ++$i) {
	    $pinName = sprintf("HD[%d]",$i);    
	    $this->{"pins"}{$pinName} = PinCfg->new( $pinName,
                       $gpioEn,    0x00000400,  $maskMode{"OR"}    ,#PinEnable
                       $gpioDir1,  (1 << $i),   $maskMode{"OR"}    ,#Pin Direction
                       $gpioDat1,  (1 << $i),   $maskMode{"OR"}    ,#Pin Set
                       $gpioDat1, ~(1 << $i),   $maskMode{"AND"}   ,#Pin Clear
                       $gpioEn,   0xFFFFFBFF,   $maskMode{"AND"}   ,#Pin Disable
                       0,                                          ,#Global Setup Flag (none)                       
              ); 
    }           
                                                                                           
    return $this;
}



#----------------------------------------------------------------------------------------
sub delete {
  undef $_[1];
}



#########################################################################################
return 1;
#########################################################################################