/*  ============================================================================
 *   Copyright (c) Texas Instruments Inc 2002, 2003, 2004
 *
 *   Use of this software is controlled by the terms and conditions found
 *   in the license agreement under which this software has been supplied.
 *  ============================================================================
 */

/* =============================================================================
 *   @file  Spi_example.h
 *
 *   @desc  Example test header file to SPI.
 * =============================================================================
 */

/* =============================================================================
 *  Revision History
 *  ===============
 *  07-Mar-2005 Ganesh K  File created.
 *
 * =============================================================================
 */

#ifndef _SPI_EXAMPLE_H_
#define _SPI_EXAMPLE_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include <csl_pllc.h>
#include <csl_spi.h>
#include <string.h>
#include <stdio.h>

/* 
 * For every error the error count variable is increased. So count will be 
 * zero when there is no error.
 */
#define SPI_TEST_PASSED             0

/*
 * The data to be transmitted through SPI
 */
#define SPI_TX_DATA					0xF0F0

#define SPI_CHK_RX_MASK				0x80
#define SPI_RX_FLG_SET				0x80

#define SPI_DATA_FMT_CHARLEN_16BIT	0x10

#define SPI_PINCTRL_SPIFUNC_3PIN	0x0E00

#define SPI_PLLC_DIV_RATIO			0x001u

#define AD0_INSTRUCTION			    0x8400
#define AD1_INSTRUCTION			    0xC400
#define AD2_INSTRUCTION			    0x9400
#define AD3_INSTRUCTION			    0xD400
#define AD4_INSTRUCTION			    0xA400
#define AD5_INSTRUCTION			    0xE400
#define AD6_INSTRUCTION			    0xB400
#define AD7_INSTRUCTION			    0xF400

typedef	 	Uint8            BYTE;
typedef 	Uint16           WORD;
typedef 	Uint32           DWORD;   
#define AD_CHANNEL_NUM  			14

#define _1US                        7
#define _2US                        16
#define _3US                        26
#define _5US                        45


#define AD_CHANNEL0_READ			(* ( Uint32 * )0x90000004)       //ADͨ0ݵַ  
#define AD_CHANNEL1_READ			(* ( Uint32 * )0x90000008)       //ADͨ1ݵַ
#define AD_CHANNEL2_READ            (* ( Uint32 * )0x9000000C)       //ADͨ2ݵַ
#define AD_CHANNEL3_READ            (* ( Uint32 * )0x90000010)       //ADͨ3ݵַ

#define TEM_CHANNEL0_READ           (* ( Uint32 * )0x90000014)       //¶0ݵַ
#define TEM_CHANNEL1_READ           (* ( Uint32 * )0x90000018)       //¶1ݵַ

#define DA_OUTPUT			    	(* ( Uint32 * )0x90000000)       //DADSPʹ

#define UART_422_verify		    	(* ( Uint32 * )0x90000000)       //DADSPʹ

#define UART_422_BAUT		    	(* ( Uint32 * )0x90000800)       //DADSPʹ

#define FIFO_WRITE			    	(* ( Uint32 * )0x90000004)       //FIFOдʹ
#define FIFO_TRANS             		(* ( Uint32 * )0x90000008)       //FIFOʹ
  
#define HDLC_READ			    	(* ( Uint32 * )0x90000000)       //DSP422ݵַ  
#define HDLC_WRITE			    	(* ( Uint32 * )0x9000000C)       //DSP422дݵַ
#define HDLC_TRANS             		(* ( Uint32 * )0x90000010)       //DSP422
 
#define TIMER_OPEN					(* ( Uint32 * )0x90000404)       //ʱʹ
#define TIMER_CLOSE					(* ( Uint32 * )0x90000408)       //ʱرʹ
#define TIMER_PRD          			(* ( Uint32 * )0x90000020)       //ʱ׼ڸıʹź

#define TOFF_ENABLE					(* ( Uint32 * )0x90000024)       //źʹ
#define TOFF_RESET		    		(* ( Uint32 * )0x90000028)       //źDSPλ
#define TOFF_CLEAR         			(* ( Uint32 * )0x9000002C)       //źű־

#define EXRESET_DIS_OPEN			(* ( Uint32 * )0x90000030)       //ⲿλ
#define EXRESET_DIS_CLOSE			(* ( Uint32 * )0x90000034)       //ⲿλر


#define YXZH_INPUT					(* ( Uint32 * )0x90000038)       //ԻDSP
#define YXZH_RESET					(* ( Uint32 * )0x9000003C)       //Իλ

#define YXYSQD_INPUT   				(* ( Uint32 * )0x90000040)       //ʱDSP
 
#define YXJS_ENABLE    				(* ( Uint32 * )0x90000044)       //ŽDSPʹ
#define YXJS_RESET     				(* ( Uint32 * )0x90000048)       //Žλ

#define AZZJ_CLEAR     				(* ( Uint32 * )0x9000004C)       //ȫװԼ־

#define YXZJJG_CLEAR   				(* ( Uint32 * )0x90000050)       //Լ־

#define YXQD_CLEAR					(* ( Uint32 * )0x90000054)       //־



#define UHPI_GPIO_DAT1	            (* ( unsigned int * )0x43000014) //General Purpose I/O Data Register 1
#define UHPI_GPIO_DAT2	            (* ( unsigned int * )0x4300001c) //General Purpose I/O Data Register 2
#define MCASP0_GPIO_DOUT	        (* ( unsigned int * )0x44000018) //General Purpose I/O Data Register 1

/*
 * =============================================================================
 *  @func   spi_csl_example_test
 *
 *  @desc
 *     This is the test routine which transmit and verify data in loop back mode
 *
 *  @arg
 *      NONE
 *  
 *  @return
 *      NONE
 * =============================================================================
*/

extern void spi1_configer (
    void
);

extern void pll_configer (
    void
);

extern void uhpi_configer (
    void
);

extern void emif_configer (
    void
);


extern void
timer_configer (
    void
);

extern void mcasp2_io_configer (
    void
);

extern void mcasp0_io_configer (
    void
);


extern void com1553_rt_configer (
    void
);



extern void mcasp1_5502_configer (
    void
);



extern void dmax_configer (
    void
);

 extern void 		data_add_test(void);

extern CSL_Status setup_Interrupts  ( 
   void
);
extern void	send_zero(void); 
extern void	send_five(void); 
extern void	FPGA_RST(void);
extern void	INT_6_RST(void);
 
extern void	Uart_send_data(Uint8 usb_data);
extern void	Uart_start_timer(void); 
extern void	Uart_stop_timer(void); 
extern void	Uart_receieve_data(void);
extern void	 Cyusb_reset_command(void);
extern void	 Cyusb_Receieve_Data(void);
extern DWORD Cyusb_Send_Data(Uint16 );
extern void	ftusb_wakeup_command(void);
extern void	ftusb_reset_command(void);
extern Uint8 Ftusb_Receieve_Data(void);
extern DWORD Ftusb_Send_Data(Uint16 );
/*
 * =============================================================================
 *  @func   spi_error_exit
 *
 *  @desc
 *     This calls the module close function in case of error 
 *
 *  @arg
 *      NONE
 *  
 *  @return
 *      NONE
 * =============================================================================
 */



extern void  
rec_1553data(
    Uint32, Uint32 
);  

extern void  
tran_1553data(
    Uint32 
);    

extern void DELAY_NUS  ( 
    Uint32
);

extern void toff( 
   void
);

 
      
extern void yxqd(
    void
);

 
     
extern void yxzjjg(
     void
);

     
           
extern void zzzj(
      void
);

                          
extern void power_24(
     void
);
    
      
     
extern void power_31(
      void
);

         
     
extern void power_active(
        void
);

 
extern void power_b(
        void
);
  

extern void intr04  ( 
   void
);


extern void intrNMI  ( 
   void
);


extern void intr06  ( 
   
);

extern void intr07  ( 
   
);


extern void intr08  ( 
   
);



extern void intr12  ( 
   
);


//extern far cregister volatile unsigned int DETR;

extern cregister volatile unsigned int ICR;

extern cregister volatile unsigned int IER;

extern cregister volatile unsigned int IRP;

extern cregister volatile unsigned int CSR;

extern cregister volatile unsigned int ISTP;

extern cregister volatile unsigned int NRP;

extern cregister volatile unsigned int IRP;

/**********************************************************************/
/* General Definition                                                 */
/**********************************************************************/
#define FILL_CONST    (0)       /* Used for memory fill functions */
#define FILL_INC      (1)
#define FILL_DEC      (2)

#define PASS          (0)       /* Used as test return flags */
#define ERROR_TEST    (1)
#define ERROR_FILL    (2)

/**********************************************************************/
/* Test-specific Definition                                           */
/**********************************************************************/

#define NUM_XMT_SERIALIZER   (8)
#define NUM_RCV_SERIALIZER   (8)
#define NUM_TDM_SLOT         (16)
#define NUM_XTDM_SLOT        (16)       /* only count the active even slots */
#define NUM_RTDM_SLOT        (16)       /* receives all slots--active and inactive */
#define TOTAL_XMT_DATA       NUM_XTDM_SLOT*1    /* transfer a total of 5 TDM frames per pin */
#define TOTAL_RCV_DATA       NUM_RTDM_SLOT*1    /* receives a total of 5 TDM frames per pin */

/* Transfer Complete success */
#define TC_PASS              0x0
/* Error in Transfer complete */
#define TC_FAIL              0x1

/*Setting the AHCLKRCTL i.e FALLING,INTERNAL & DIVIDE_RATIO */
#define HCLKRCTL_DIV_INTER_FALL 0x0000C02A

/* setting the ISTP value to base of the Vector Table */
#define ISTP_VECTOR_VALUE       0x10000000

/* Source Data buffer initialized with this value */
#define SRC_DATA_DEFAULT        0x0 

/* Destination Data buffer initialized with this value */
#define DST_DATA_DEFAULT        0x1

/* Transfer Count0 */
#define COUNT0                  NUM_RCV_SERIALIZER

/* Transfer Count1 */
#define COUNT1                  NUM_TDM_SLOT

/* Transfer Count2 */
#define COUNT2                  0x0

/* Source Index0 */
#define TX_SRC_INDEX0           0x1

/* Destination Index0 */
#define TX_DST_INDEX0           0x0

/* Source Index1 */
#define TX_SRC_INDEX1           0x1

/* Destination Index1 */
#define TX_DST_INDEX1           0x0

/* Source Index2 */
#define TX_SRC_INDEX2           0x0

/* Destination Index2 */
#define TX_DST_INDEX2           0x0

/* Source Index0 */
#define RX_SRC_INDEX0           0x0

/* Destination Index0 */
#define RX_DST_INDEX0           0x1

/* Source Index1 */
#define RX_SRC_INDEX1           0x0

/* Destination Index1 */
#define RX_DST_INDEX1           0x1

/* Source Index2 */
#define RX_SRC_INDEX2           0x0

/* Destination Index2 */
#define RX_DST_INDEX2           0x0

/* if there is no Source address, initialize with zero */
#define SRC_ADDR1               0x0

/* if there is no destination address, initialize with zero */
#define DST_ADDR1               0x0

/* Setting the TDM slots value in Frame Sync */
#define TDM_SLOTS_VALUE         0x00000800

/**
 * ============================================================================
 *   @func   mcasp_loopback_example
 *
 *   @desc
 *      This routine will setup the values for McASP Tx and Rx in LoopBack Mode. 
 *      And verify the data once the data is transfered.
 *
 * @arg 
 *      NONE
 *
 * @return
 *      CSL_Status
 * ============================================================================
*/
extern CSL_Status mcasp_loopback_example(
    void
);

/******************************************************************************
* @func setup_Interrupts
*
* @desc Setting up the DMAX Interrupts of INT7 & INT8.
*
* @arg  
*   NONE
*
* @return
*   CSL_Status
*
*****************************************************************************00
*/
extern CSL_Status setup_Interrupts (
        void
);

/******************************************************************************
* @func intr08
*
* @desc Interrupt Service Routine, this will get triggered if the
*       data transfer is Success. This function will clear the TCC bit 
*       of the DECT0/1 register.
*
* @arg  
*   NONE
*
* @return
*   NONE
*
*****************************************************************************00
*/
extern void intr08 ();

/******************************************************************************
* @func intr07
*
* @desc Interrupt Service Routine, this will get triggered if the
*       data transfer fails
*
* @arg  
*   NONE
*
* @return
*   NONE
*
*****************************************************************************00
*/
extern void intr07 ();

/******************************************************************************
*   @func   fillMem( Uint32 start_location, Uint32 length,
*                       Uint32 fill_value, Uint8 fill_type )
*
*   @desc   Fills a memory location with a pattern as requested.
*           Beginning at 'start_location', 'length' words (32-bit) are filled,
*           starting with 'fill_value'.  After the initial value, the
*           other memory locations are filled with either a constant
*           value, incrementing values, or decrementing values.
*
*   @arg    Uint32 start_location : Memory location to start filling.
*           Uint32 length : Number of bytes to fill.
*           Uint32 fill_value : 32-bit value to start filling with.
*           Uint8 fill_type : Type of fill:
*                           FILL_CONST, FILL_INC, FILL_DEC
*
*   @return Uint32 flag : PASS for a success
*           ERROR_TEST for a failure
*******************************************************************************
*/
extern void fillMem (
        Uint32 start_location,
        Uint32 length,
        Uint32 fill_value,
        Uint32 fill_type
);



#ifdef __cplusplus
}
#endif


#endif        /* _SPI_EXAMPLE_H_ */
