#include "Spi_example.h"
#include "csl_uhpi.h"
#include "csl_chip.h"
#include "csl_emif.h"
#include "csl_intc.h"
#include "csl_rti.h"
#include "csl_rtiAux.h"
#include "csl_mcasp.h"
#include "cslr_mcasp.h"
#include "csl_dmax.h"

Uint16  Read_One_Word(Uint32);
/* Handle for the SPI1 instance */
CSL_SpiHandle            hSpi;
CSL_SpiObj               spiObj;
/* Handle for the SPI0 instance */
CSL_SpiHandle            hSpi0;
CSL_SpiObj               spiObj0;
/* Handle for the uhpi instance */
CSL_UhpiHandle           hUhpi = (CSL_UhpiHandle) NULL;
CSL_UhpiObj              uhpiObj;
/* Handle for the emif instance */
CSL_EmifHandle           hEmif = NULL;
CSL_EmifObj              emifObj;
/* Handle for the timer instance */
CSL_RtiHandle            hRti;
CSL_RtiObj               rtiObj;
/* Global Handles for the mcasp0 instance*/
CSL_McaspHandle          hMcasp0;
CSL_McaspObj             mcaspObj0;
/* Global Handles for the mcasp1 instance*/
CSL_McaspHandle          hMcasp;
CSL_McaspObj             mcaspObj; 
/* Global Handles for the mcasp2 instance*/
CSL_McaspHandle          hMcasp2;
CSL_McaspObj             mcaspObj2; 
/* Global Handles for the dmax instance*/
CSL_DmaxObj                     dmaxEvent;
CSL_DmaxHandle                  hDmax;

CSL_IntcHandle              hIntc;
CSL_IntcEventEnableState    eventStat;
CSL_IntcDispatcherContext   intcDispatcherContext;

Uint32                      mainflag;              //0.5ms ʱжϱ־
Uint32                      count5502 = 0;         //5502ʼ
Uint32                      res5502 = 0;           //5502һ
Uint32                      intr_value1553 = 0;      //1553BC 
Uint32     					register1;
Uint32     					register2;

Uint32                      count422 = 0;          //422ʼ          
Uint32                      res422 = 0;            //422һ
Uint32                      tran422 = 0x0;          //422

Uint32                      tranfifo = 0x00;          //fifo

Uint32                      count1553 = 0;          //1553ʼ          
Uint32                      res1553 = 0;            //1553һ
Uint32 *                    ptr_bootram = ( Uint32 * )0x10021000 ;
Uint32 *                    ptr_subram = ( Uint32 * ) 0x00; 
Uint32                      flag1553 = 0;
//Uint32                      rec1553dat;
Uint32 					   count_time =0x00 ,fpga_rst =0x00;
Uint8					  usb_data;
Uint32         			  sensor_ch_0[5]; 
Uint32         			  sensor_ch_1[5];
Uint32         			  sensor_ch_2[5];
Uint32         			  sensor_ch_3[5];
Uint32         			  sensor_ch_4[5]; 
Uint32         			  sensor_ch_5[5];
Uint32         			  sensor_ch_6[5];
Uint32         			  sensor_ch_7[5];

Uint32         			  fog_ch_0[10]; 
Uint32         			  fog_ch_1[10];
Uint32         			  fog_ch_2[10];
Uint32         			  fog_ch_3[10];

Uint32 					  send_data[7];
//test//////////////////////////////////
Uint32               count_main = 0;
//422
Uint32               compute422 =0;
Uint32               count_intr6 = 1;
Uint32               erro422 = 0;
//ad
Int16               Ad0[101] = {0};
Int16               Ad1[101] = {0};
Int16               Ad2[101] = {0};
Int16               Ad3[101] = {0};
Uint32               count_ad = 0; 
Uint32               ad_flag = 0;               

Int32               ad0_trans = 0;
Int32               ad1_trans = 0;
Int32               ad2_trans = 0;
Int32               ad3_trans = 0;
Int32               ad0_show = 0;
Int32               ad1_show = 0;
Int32               ad2_show = 0;
Int32               ad3_show = 0;

Int32               tem0 = 0;
Int32               tem1 = 0;

float               ad0,ad1,ad2,ad3;
float               da;
Int32               da_show;
//
Uint32               power24 = 0; 
Uint32               power31 = 0;
Uint32               poweractive = 0;
Uint32               powerb = 0;
//1553
Uint32               erro1553 = 0;
Uint32               compute1553 = 0;        
//5502
Uint32               erro5502 = 0;
Uint32               compute5502 = 0;
Uint32               startdata = 0;
Uint32               enddata = 0;
Uint8				ch_0_num,ch_1_num,ch_2_num,ch_3_num;
Uint32 				fog_flag = 0;
Uint32				sensor_flag =0x00,int_num=0;

Uint32 				over_flag = 0;
Uint32               uhpi_io;      
Uint32				send_count =0, rec_count =0;
Uint8				ii=0,iii=0,aaa=0,bbb=0,CMD_X,CMD_Y,CMD_Z,CMD_A;
Uint16				frame=0,data_sensor=0;

float                ad0_offset, ad0_gain, ad1_offset, ad1_gain, ad2_offset, ad2_gain, ad3_offset, ad3_gain, da_offset, da_gain;

CSL_Status  status;
CSL_DmaxObj dmaxEvent;
CSL_DmaxHandle hDmax;
CSL_DmaxHwSetup hwSetup;
CSL_DmaxGPXFRParameterSetup gpxfPaSetup;
CSL_DmaxGPTransferEventSetup gpEventSetup;
volatile Uint32           xmtDone = 0;
#define  vlength           8
void main(void)
{
   CSL_Status  status;
   CSL_DmaxObj dmaxEvent;
   CSL_DmaxHandle hDmax;
   CSL_DmaxHwSetup hwSetup;
   CSL_DmaxGPXFRParameterSetup gpxfPaSetup;
   CSL_DmaxGPTransferEventSetup gpEventSetup;
   Uint32                    src_data[8];
   Uint32                    dst_data[8];
   Uint32 i,j=0;
   status = CSL_dmaxInit (NULL);   
   fillmen((Uint32) src_data ,vlength);
   fillmen((Uint32) dst_data ,vlength); 
   for( i = 0;i< 8;i++)   
   {
		dst_data[i] = 1;
   }
   /* Low Priority MCASP0TX */
    dmaxEvent.eventUid = CSL_DMAX_HIPRIORITY_MCASP0TX_UID;
    /* Low Priority Parameter entry0 */
    dmaxEvent.paramUid = CSL_DMAX_HIPRIORITY_PARAMETERENTRY0_UID;

    hDmax = CSL_dmaxOpen (&dmaxEvent, CSL_DMAX, NULL, &status);
    if (status != CSL_SOK || (hDmax == (CSL_DmaxHandle) CSL_DMAX_BADHANDLE)) 
    {
        //printf ("\nTEST FAILED\nERROR: damx open failed");
        return ;
     } 
    hDmax->regs->DEDR = 0xFFFFFFFF;
	DELAY_NUS (_1US);
    hDmax->regs->DFSR0 = 0xFFFFFFFF;
    DELAY_NUS (_1US);
    hDmax->regs->DFSR1 = 0xFFFFFFFF;
	DELAY_NUS (_1US);
    hDmax->regs->DTCR0 = 0x000000FF;
	DELAY_NUS (_1US);
    hDmax->regs->DTCR1 = 0x000000FF;
    DELAY_NUS (_1US); 

	hDmax->regs->DEHPR = 0x00000010;
    hDmax->regs->DEPR = 0x00000010;
	hDmax->regs->DEER = 0x00000010;
    
	hwSetup.priority = 0x01;
	hwSetup.polarity = 0x01;
	hwSetup.eventSetup = (CSL_DmaxEventSetup * ) &gpEventSetup;
    gpEventSetup.qtsl = 0x01;
    gpEventSetup.etype = 0x00000011;
	gpEventSetup.tcc = 0x00;
	gpEventSetup.atcint = 0x00;
	gpEventSetup.tcint = 0x01;
	gpEventSetup.cc = 0x00;
	gpEventSetup.esize = 0x00;
	gpEventSetup.sync = 0x01;
	gpEventSetup.rload = 0x00;
	gpEventSetup.pte = hDmax->paramPtr;
	
	gpEventSetup.paramSetup = &gpxfPaSetup;
    gpxfPaSetup.count0 = 0x0008;
    gpxfPaSetup.count1 = 0x0000;
	gpxfPaSetup.count2 = 0x0000;
	gpxfPaSetup.dstIndex0 = 0x0000;
	gpxfPaSetup.dstIndex1 = 0x0000;
	gpxfPaSetup.dstIndex2 = 0x0000;
	gpxfPaSetup.srcIndex0 = 0x0001;
	gpxfPaSetup.srcIndex1 = 0x0000;
	gpxfPaSetup.srcIndex2 = 0x0000;
	gpxfPaSetup.dstReloadAddr0 = (Uint32) dst_data;
    gpxfPaSetup.dstReloadAddr1 = (Uint32)0x00000000;
	gpxfPaSetup.srcReloadAddr0 = (Uint32) src_data;
    gpxfPaSetup.srcReloadAddr1 = (Uint32)0x00000000;

    status = CSL_dmaxHwSetup (hDmax, &hwSetup);
 
    status = CSL_dmaxHwControl(hDmax,CSL_DMAX_CMD_EVENTENABLE,NULL);

	setup_Interrupts ();
    DELAY_NUS (_3US);

    status = CSL_dmaxHwControl(hDmax,CSL_DMAX_CMD_STARTASYNCTRANSFER,NULL);

	while(xmtDone==1);

	for(i=0;i<8;i++) 
	{
		if(dst_data[i] == src_data[i])
			j=1;
	}

}

#pragma INTERRUPT (intr08);
void intr08 ()
{
	CSL_Status  status; 
    status = status;
	if(xmtDone)
	{
	//	status = CSL_dmaxHwControl(hDmaxRx,CSL_DMAX_CMD_CLEARTCC,NULL);
		hDmax->regs->DTCR0 = 0x000000FF;
		DELAY_NUS (_1US);
	    hDmax->regs->DTCR1 = 0x000000FF;
	    DELAY_NUS (_1US); 
	}
	else
	{
		//status = CSL_dmaxHwControl(hDmaxTx,CSL_DMAX_CMD_CLEARTCC,NULL);
		hDmax->regs->DTCR0 = 0x000000FF;
	    DELAY_NUS (_1US);
        hDmax->regs->DTCR1 = 0x000000FF;
        DELAY_NUS (_1US); 
		xmtDone = 1;	
	}
}

#pragma INTERRUPT (intr07);
void intr07 ()
{
	DELAY_NUS (_1US);
	return;
}


