

#include "Spi_example.h"
#include "csl_uhpi.h"
#include "csl_chip.h"
#include "csl_emif.h"
#include "csl_intc.h"
#include "csl_rti.h"
#include "csl_rtiAux.h"
#include "csl_mcasp.h"
#include "csl_dmax.h"

/* Global Handles for the mcasp1 instance*/
extern CSL_McaspHandle          hMcasp;

/* Global Handles for the dmax instance*/
extern CSL_DmaxHandle           hDmax;

/************************************************************************/
/* PROCEDURE:   Read_One_Word                                      */
/*                                                                      */
/*                                                                      */
/* Input:                                                               */
/*          Dst  flash address where to be read                         */
/*                                                                      */
/* Output:                                                              */
/*         the data which be read from flash                            */
/************************************************************************/
Uint16  Read_One_Word (Uint32 Dst)

{
    Uint32  hi_addr, temp;
    Uint16  data;

    hi_addr = Dst & 0x3fc000;
	temp = hi_addr >> 21;
    hi_addr = ( hi_addr << 11 ) | temp;

    hMcasp->regs->PDOUT = hi_addr;

    data = * ( Uint16 * ) ( 0x90000000 + Dst * 2);    // read data
                                                                     
    return data;
}




void
DELAY_NUS (
    Uint32  tim
)
{   
    while(tim--) {
	}
 
    return;        
}


