
#include "Spi_example.h"
#include "csl_uhpi.h"
#include "csl_chip.h"
#include "csl_emif.h"
#include "csl_intc.h"
#include "csl_rti.h"
#include "csl_rtiAux.h"
#include "csl_mcasp.h"
#include "csl_dmax.h"
#include "cslr_mcasp.h"

#define FILL_CONST    (0)       /* Used for memory fill functions */
#define FILL_INC      (1)
#define FILL_DEC      (2)
#define NUM_XMT_SERIALIZER   (8)
#define NUM_RCV_SERIALIZER   (8)

/* Global Handles for the mcasp1 instance*/
extern CSL_McaspHandle          hMcasp;
extern CSL_McaspObj             mcaspObj; 

/* Global Handles for the dmax instance*/
extern CSL_DmaxObj                     dmaxEvent;
extern CSL_DmaxHandle                  hDmax;
extern CSL_DmaxHwSetup                 hwSetup;

extern CSL_IntcHandle              hIntc;
extern CSL_IntcEventEnableState    eventStat;
extern CSL_IntcDispatcherContext   intcDispatcherContext;

extern Uint32                    srcdata[NUM_RCV_SERIALIZER];
extern Uint32                    dstdata[NUM_RCV_SERIALIZER];
/*
 * =============================================================================
 *  @func    pll_configer
 *
 *  
 * =============================================================================
*/

#pragma CODE_SECTION (pll_configer, "mysect")
void pll_configer (void)
{
   CSL_PllcHandle           hPllc;
   CSL_Status               status;
   CSL_PllcObj              pllcObj;
   CSL_PllcHwSetup          hwSetup = CSL_PLLC_HWSETUP_DEFAULTS;   
   Uint8 *                  ptr_sdcr = (Uint8 *)0xF000000B;
  /* 
* ʼpllc
* 
*/
    /* Intialize PLLC module */
    status = CSL_pllcInit (NULL);
    /* Intialize the PLLC obj structure to zero */
    memset (&pllcObj, 0, sizeof (CSL_PllcObj));
    /* Get handle for PLLC Module */
    hPllc = CSL_pllcOpen (&pllcObj, CSL_PLLC, NULL, &status);
    if ((status != CSL_SOK) || (hPllc == NULL)) {    
        printf ("SPI: Opening PLLC instance... Failed.\n");
        return;
    }
    else {
       printf ("SPI: Opening PLLC instance... Passed.\n");
    }
     * ptr_sdcr = 0x80;
     /* 
     * Put PLLC in pll Mode
     */
    hwSetup.pllcMode = CSL_PLLC_BYPASS;  // CSL_PLLC_PLLCSR_PLLEN_PLL;//CSL_PLLC_BYPASS;  //CSL_PLLC_PLL_MODE;
	
	hwSetup.div0Enable.divEnable = CSL_PLLC_PLLDIV_ENABLE;
    hwSetup.div0Enable.pllDivRatio = 0x0000;                        //Ƶ/1
    hwSetup.div1Enable.divEnable = CSL_PLLC_PLLDIV_ENABLE;
    hwSetup.div1Enable.pllDivRatio = 0x0001;                        //Ƶ/2
    hwSetup.div2Enable.divEnable = CSL_PLLC_PLLDIV_ENABLE;
    hwSetup.div2Enable.pllDivRatio = 0x0002;                        //Ƶ/4
	hwSetup.div3Enable.divEnable = CSL_PLLC_PLLDIV_ENABLE;
    hwSetup.div3Enable.pllDivRatio = 0x0005;                        //Ƶ/4           

    /* pllc setup */
    status = CSL_pllcHwSetup (hPllc, &hwSetup);
    if (status != CSL_SOK) {
        
        printf (" PLLC BYPASS setup ... Failed.\n");
        return;
    }
    else {
        printf (" PLLC BYPASS setup ... Passed.\n");
    }


       hPllc->regs->PLLM = 0x0011;        //0x11 for 29.4912mhz  Ƶ*20 for 24mhz                          
    
    DELAY_NUS (400);
        
    hPllc->regs->PLLCSR = 0x00000001;

    DELAY_NUS (400);


    /* Close PLLC module */
    status = CSL_pllcClose (hPllc);
    if (status != CSL_SOK) {
        
        printf ("SPI: PLLC Close instance ... Failed.\n");
        return;
    }
    else {
        printf ("SPI: PLLC Close instance ... Passed.\n");
    }

   * ptr_sdcr = 0x00;

   DELAY_NUS (_5US);
    
   return;
}     

/*
 * =============================================================================
 *  @func    setup_Interrupts
 *
 *  
 * =============================================================================
*/
#pragma CODE_SECTION (setup_Interrupts, "mysect")
CSL_Status setup_Interrupts (
    void
)
{
    /* Interrupt Object */
    CSL_IntcObj                 intcObj;
    /* Globla Bit Enable state */
    CSL_IntcGlobalEnableState   state;
    /* Event Handler which holds ISR information */
    CSL_IntcEventHandlerRecord  isrRec;
    /* Interrupt Context */
    CSL_IntcContext             intcContext;
    CSL_Status                  status;
    /* Initialize the intc CSL modules with zeros  */
    memset (&intcContext, 0, sizeof (CSL_IntcContext));
    memset (&intcDispatcherContext, 0, sizeof (CSL_IntcDispatcherContext));

    /* Interrupt Initialization */
    status = CSL_intcInit (&intcContext);
    if (status != CSL_SOK) {
      
        return status;
    }
    CSL_intcDispatcherInit (&intcDispatcherContext);

    /* Install handler for DMAX INT8 Interrupt */
    hIntc = CSL_intcOpen (&intcObj,
        CSL_INTC_EVENTID_DMAXEVTOUT1, NULL, &status);

    if ((hIntc == NULL) || (status != CSL_SOK)) {
        
        status = CSL_ESYS_BADHANDLE;
        return status;
    }
    isrRec.handler = intr08;

    /* As no arguments assigning zero(0) value */
    isrRec.arg = (void *) 0x0;

    /*Plugging ISR in Event Handler */
    CSL_intcPlugEventHandler (hIntc, &isrRec);

    /* Enabling DMAXEVTOUT1 Event */
    status = CSL_intcEventEnable (CSL_INTC_EVENTID_DMAXEVTOUT1, &eventStat);
    if (status != CSL_SOK) {
        
        return status;
    }

    /* Install handler for DMAX INT07 interrupt */
    hIntc = CSL_intcOpen (&intcObj,
        CSL_INTC_EVENTID_DMAXEVTOUT0, NULL, &status);

    if ((hIntc == NULL) || (status != CSL_SOK)) {
       
        status = CSL_ESYS_BADHANDLE;
        return status;
    }

    isrRec.handler = intr07;

    /* As no arguments assigning zero(0) value */
    isrRec.arg = (void *) 0x0;

    /* Plugging ISR in Event Handler */
    CSL_intcPlugEventHandler (hIntc, &isrRec);
    /* DMAXEVTOUT0 Event Enable */
    status = CSL_intcEventEnable (CSL_INTC_EVENTID_DMAXEVTOUT0, &eventStat);
    if (status != CSL_SOK) 
    {     
        return status;
    }
    /* Enabling Non-Maskable Interrupt */
    status = CSL_intcEventEnable (CSL_INTC_EVENTID_NMI, &eventStat);
    if (status != CSL_SOK) 
    {        
        return status;
    }
    /* Enabling Global Enable bit in Control Status Register (CSR) */
    status = CSL_intcGlobalEnable (&state);
    if (status != CSL_SOK) 
    {       
        return status;
    }

    /* Closing INTC handle */
    status = CSL_intcClose (hIntc);
    if (status != CSL_SOK) 
    {   
        return status;
    }   
    return status;
}
/*
 * =============================================================================
 *  @func  mcasp1_configer
 *
 *  @desc
 *     This calls the module close function in case of error 
 *
 *  @arg
 *      NONE
 *  
 *  @return
 *      NONE
 * =============================================================================
 */  
void mcasp1_configer(void)
{       
    	CSL_Status	             status;  
        Uint32                   flag;
        Bool                     xData = 0;           
	    /* McASP Module Initilization */
	    status = CSL_mcaspInit (NULL);
	    hMcasp = CSL_mcaspOpen (&mcaspObj, CSL_MCASP_1, NULL, &status);
	    if ((hMcasp == NULL) || (status != CSL_SOK))
	    {
	        printf ("\nTEST FAILED\nERROR:CSL_MCASP_1 open failed");
	        return ;
	    }
         hMcasp->regs->GBLCTL = 0x00000000;
   		 hMcasp->regs->PWRDEMU =0x00000000;

		 hMcasp->regs->RMASK = 0xFFFF;
         hMcasp->regs->RFMT = 0x0030;
		 hMcasp->regs->AFSRCTL = 0x00000412;
		 hMcasp->regs->AHCLKRCTL = 0x0000807d;
		 hMcasp->regs->ACLKRCTL = 0x00000020;
		 hMcasp->regs->RTDM = 0x00FF;
		 hMcasp->regs->RINTCTL = 0x00;
		 hMcasp->regs->RCLKCHK = 0x00ff000f;
		
		 hMcasp->regs->XMASK = 0xFFFF;
		 hMcasp->regs->XFMT = 0x0030;
         hMcasp->regs->AFSXCTL = 0x00000412;
		 hMcasp->regs->AHCLKXCTL = 0x0000807d;
		 hMcasp->regs->ACLKXCTL = 0x00000020;
		 hMcasp->regs->XTDM = 0x00FF;
		 hMcasp->regs->XINTCTL = 0x00;
		 hMcasp->regs->XCLKCHK = 0x00ff000f;		 
        
         hMcasp->regs->SRCTL1 = 0x00000001;
		 hMcasp->regs->SRCTL0 = 0x00000002;
		 			 
		 asm(" nop 9");
         asm(" nop 9");
         asm(" nop 9");
         asm(" nop 9");
		 asm(" nop 9");
		 asm(" nop 9");
	     asm(" nop 9");
	     asm(" nop 9");
   		 DELAY_NUS (100);
		 hMcasp->regs->PFUNC = ~(0x14000003);
		 hMcasp->regs->PDIR = 0x14000002;
		 hMcasp->regs->DITCTL = 0x00;
         hMcasp->regs->AMUTE = 0x00;
		
         hMcasp->regs->GBLCTL = 0x00000303;
         flag = hMcasp->regs->GBLCTL;
         while(flag!=0x00000303)
         {
	     	flag = hMcasp->regs->GBLCTL;
	     }

		 hMcasp->regs->XSTAT = 0xFFFF;
		 hMcasp->regs->RSTAT = 0xFFFF;

		 hMcasp->regs->GBLCTL = 0x00000707;

         flag = hMcasp->regs->GBLCTL;
         while(flag!=0x00000707)
         {
	     	flag = hMcasp->regs->GBLCTL;
         }
		
         hMcasp->regs->XBUF1 = 0x0;
		 hMcasp->regs->RBUF0 = 0x0; 

		 while (!(CSL_mcaspGetHwStatus (hMcasp, CSL_MCASP_QUERY_XSTAT_XDATA, &xData)));
   		 DELAY_NUS (_3US);
    	 DELAY_NUS (_3US);

		 hMcasp->regs->GBLCTL = 0x00001F1F;
   		 flag = hMcasp->regs->GBLCTL;
   		 while(flag!=0x00001F1F)
   		 {
			flag = hMcasp->regs->GBLCTL;
    	 } 
		 /*flag = hMcasp->regs->XSTAT;
  		 while(flag == 0x00000020)
  		 {
	  		flag = hMcasp->regs->GBLCTL;
    	 }*/		 
		 hMcasp->regs->XEVTCTL =0x00;
		 hMcasp->regs->REVTCTL =0x00;
}
/*
 * =============================================================================
 *  @func  dmax_configer
 *
 *  @desc
 *     This calls the module close function in case of error 
 *
 *  @arg
 *      NONE
 *  
 *  @return
 *      NONE
 * =============================================================================
 */ 
#pragma CODE_SECTION (dmax_configer, "mysect") 
void dmax_configer (void)
{   
   CSL_Status  status;

   /* General Purpose Transfer Event Setup */
   CSL_DmaxGPTransferEventSetup gpxfrEventSetup; 
   /* General purpose Parameter Setup */
   CSL_DmaxGPXFRParameterSetup gpxfrParameterSetup;   
   /* DMAX Initilization */
    status = CSL_dmaxInit (NULL);
    /* MCASP0 TX DMAX REQ paramters */
    dmaxEvent.eventUid = CSL_DMAX_HIPRIORITY_MCASP1TX_UID;
    dmaxEvent.paramUid = CSL_DMAX_HIPRIORITY_PARAMETERENTRY0_UID;
    /* Getting the DMAX Handle by calling CSL_dmaxOpen() */
    hDmax = CSL_dmaxOpen (&dmaxEvent, CSL_DMAX, NULL, &status);
    if (status != CSL_SOK || (hDmax == (CSL_DmaxHandle) CSL_DMAX_BADHANDLE)) 
    {      
        return ;
    }
    /* DMAX for data transfer on MCASP0TX DMA REQ - 2D General Purpose Transfer */

    /* Quantam Transfer Size Limit not more than 4 elements */
    gpxfrEventSetup.qtsl    = CSL_DMAX_EVENT2_QTSL_MOVE4_ELE; //0x00000001
    
    /* Transfer Complete Code will set in DTCR0/DTCR1 Register */
    gpxfrEventSetup.tcc     = CSL_DMAX_EVENT2_TCC_RESETVAL; //0x0
    
    /* Alternate Transfer mode Disable */
    gpxfrEventSetup.atcint  = CSL_DMAX_EVENT2_ATCINT_DISABLE; //0x0
    
    /* Transfer Complete Interrupt Enable */
    gpxfrEventSetup.tcint   = CSL_DMAX_EVENT2_TCINT_ENABLE; //0x00000001
    
    /* No Reload after transfer is completed */
    gpxfrEventSetup.rload   = CSL_DMAX_EVENT2_RLOAD_DISABLE; //0x0
    
    /* Counter Configuration */
    gpxfrEventSetup.cc      = CSL_DMAX_EVENT2_CC_COUNT2_15_COUNT1_8_COUNT0_8; //0x0
    
    /* 32-bit Element Size */
    gpxfrEventSetup.esize   = CSL_DMAX_EVENT2_ESIZE_32BIT; //0x00000002
    
    /* Pointer to Transfer Entry */
    gpxfrEventSetup.pte     = hDmax->paramPtr;
    
    /* General purpose Event Type */
    gpxfrEventSetup.etype   = CSL_DMAX_EVENT2_ETYPE_GENERALXFR; //0x00000003
    
    /* storing the parameterSetup address in the EventSetup structure
     * of paramSetup variable
     */
    gpxfrEventSetup.paramSetup = &gpxfrParameterSetup;

    /* Number of bytes of data to be transfer in 1-Dimension */
    gpxfrParameterSetup.count0 = NUM_RCV_SERIALIZER;
    
    /* Number of bytes of data to be transfer in 2-Dimension */
    gpxfrParameterSetup.count1 = 0x0;
    
    /* Number of bytes of data to be transfer in 3-Dimension */
    gpxfrParameterSetup.count2 = COUNT2; //0x0
    
    /* Source Address Index0 Increment */
    gpxfrParameterSetup.srcIndex0 = TX_SRC_INDEX0; //0x1
    
    /* Destination Address Index0 Increment */
    gpxfrParameterSetup.dstIndex0 = 0x1;//TX_DST_INDEX0; //0x0
    
    /* Source Address Index1 Increment */
    gpxfrParameterSetup.srcIndex1 = 0x0;//TX_SRC_INDEX1;  //0x1
    
    /* Destination address Index1 increment */
    gpxfrParameterSetup.dstIndex1 = TX_DST_INDEX1;  //0x0
    
    /* Source address Index2 increment */
    gpxfrParameterSetup.srcIndex2 = TX_SRC_INDEX2; //0x0
    
    /* Destination address Index2 increment */
    gpxfrParameterSetup.dstIndex2 = TX_DST_INDEX2;  //0x0
    
    /* Source Reload Address - 0 */
    gpxfrParameterSetup.srcReloadAddr0 = (Uint32) srcdata;
    
    /* Destination Reload Address - 0 */
    gpxfrParameterSetup.dstReloadAddr0 = (Uint32) MCASP1_TXBUF_ADDR;
    
    /* Source Reload Address - 1 */
    gpxfrParameterSetup.srcReloadAddr1 = (Uint32) 0x0;
    
    /* Destination Reload Address - 1 */
    gpxfrParameterSetup.dstReloadAddr1 = (Uint32) 0x0;
    
    /* Rising Edge polarity */
    hwSetup.polarity = CSL_DMAX_POLARITY_RISING_EDGE; //0x00000001u

    /* High Event priority */
    hwSetup.priority = CSL_DMAX_EVENT_HI_PRIORITY;  //0x00000001u
    
    /* storing the EventSetup address in the Handle eventsetup variable */
    hwSetup.eventSetup = (CSL_DmaxEventSetup *) & gpxfrEventSetup;
    status = CSL_dmaxHwSetup (hDmax, &hwSetup);
    if (status != CSL_SOK) 
    {       
        printf ("dmax transfer failed!\n");
        return;
    }
    /* Event Enable */
    status = CSL_dmaxHwControl (hDmax, CSL_DMAX_CMD_EVENTENABLE, NULL);
    if (status != CSL_SOK) 
    {       
       printf ("dmax transfer failed!\n");
       return;
    }
}

void fillMem (
    Uint32 start_location,
    Uint32 length,
    Uint32 fill_value,
    Uint32 fill_type
)
{
    Uint32  *loc;
    Uint32  i;

    loc = (Uint32 *) start_location;

    for (i = 0; i < length; i++) 
    {
        if (fill_type == FILL_CONST)
         {
            *loc = (Uint32) (fill_value + 0xaaaaaaa9);           
          }  
        else if (fill_type == FILL_INC) 
        {
            *loc = (Uint32) (fill_value + 0x55555555);                     
        }
        else
        {
            *loc = (Uint32) (fill_value - i);                 
        }
        loc++;
    }

}    

 








